/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.BooleanNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.TensorType;
import com.yahoo.tensor.evaluation.TypeContext;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

public class ComparisonNode
extends BooleanNode {
    private final TruthOperator operator;
    private final ExpressionNode leftCondition;
    private final ExpressionNode rightCondition;

    public ComparisonNode(ExpressionNode leftCondition, TruthOperator operator, ExpressionNode rightCondition) {
        this.leftCondition = leftCondition;
        this.operator = operator;
        this.rightCondition = rightCondition;
    }

    @Override
    public List<ExpressionNode> children() {
        ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>(2);
        children.add(this.leftCondition);
        children.add(this.rightCondition);
        return children;
    }

    public TruthOperator getOperator() {
        return this.operator;
    }

    public ExpressionNode getLeftCondition() {
        return this.leftCondition;
    }

    public ExpressionNode getRightCondition() {
        return this.rightCondition;
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return this.leftCondition.toString(context, path, this) + " " + this.operator + " " + this.rightCondition.toString(context, path, this);
    }

    @Override
    public TensorType type(TypeContext context) {
        return TensorType.empty;
    }

    @Override
    public Value evaluate(Context context) {
        Value leftValue = this.leftCondition.evaluate(context);
        Value rightValue = this.rightCondition.evaluate(context);
        return leftValue.compare(this.operator, rightValue);
    }

    @Override
    public ComparisonNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 2) {
            throw new IllegalArgumentException("A comparison test must have 2 children");
        }
        return new ComparisonNode(children.get(0), this.operator, children.get(1));
    }
}

