/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TensorFlowModel {
    private final Map<String, Signature> signatures = new HashMap<String, Signature>();
    private final Map<String, TensorType> arguments = new HashMap<String, TensorType>();
    private final Map<String, Tensor> constants = new HashMap<String, Tensor>();
    private final Map<String, RankingExpression> expressions = new HashMap<String, RankingExpression>();
    private final Map<String, RankingExpression> macros = new HashMap<String, RankingExpression>();

    void argument(String name, TensorType argumentType) {
        this.arguments.put(name, argumentType);
    }

    void constant(String name, Tensor constant) {
        this.constants.put(name, constant);
    }

    void expression(String name, RankingExpression expression) {
        this.expressions.put(name, expression);
    }

    void macro(String name, RankingExpression expression) {
        this.macros.put(name, expression);
    }

    Signature signature(String name) {
        return this.signatures.computeIfAbsent(name, n -> new Signature((String)n));
    }

    public Map<String, TensorType> arguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public Map<String, Tensor> constants() {
        return Collections.unmodifiableMap(this.constants);
    }

    public Map<String, RankingExpression> expressions() {
        return Collections.unmodifiableMap(this.expressions);
    }

    public Map<String, RankingExpression> macros() {
        return Collections.unmodifiableMap(this.macros);
    }

    public Map<String, Signature> signatures() {
        return Collections.unmodifiableMap(this.signatures);
    }

    public class Signature {
        private final String name;
        private final Map<String, String> inputs = new HashMap<String, String>();
        private final Map<String, String> outputs = new HashMap<String, String>();
        private final Map<String, String> skippedOutputs = new HashMap<String, String>();
        private final List<String> importWarnings = new ArrayList<String>();

        Signature(String name) {
            this.name = name;
        }

        void input(String inputName, String argumentName) {
            this.inputs.put(inputName, argumentName);
        }

        void output(String name, String expressionName) {
            this.outputs.put(name, expressionName);
        }

        void skippedOutput(String name, String reason) {
            this.skippedOutputs.put(name, reason);
        }

        void importWarning(String warning) {
            this.importWarnings.add(warning);
        }

        public String name() {
            return this.name;
        }

        TensorFlowModel owner() {
            return TensorFlowModel.this;
        }

        public Map<String, String> inputs() {
            return Collections.unmodifiableMap(this.inputs);
        }

        public TensorType inputArgument(String inputName) {
            return this.owner().arguments().get(this.inputs.get(inputName));
        }

        public Map<String, String> outputs() {
            return Collections.unmodifiableMap(this.outputs);
        }

        public Map<String, String> skippedOutputs() {
            return Collections.unmodifiableMap(this.skippedOutputs);
        }

        public List<String> importWarnings() {
            return Collections.unmodifiableList(this.importWarnings);
        }

        public RankingExpression outputExpression(String outputName) {
            return this.owner().expressions().get(this.outputs.get(outputName));
        }

        public String toString() {
            return "signature '" + this.name + "'";
        }
    }
}

