/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.treenet.rule;

import com.yahoo.searchlib.treenet.rule.Tree;
import java.util.Map;

public class TreeNet {
    private String begin;
    private final Map<String, Tree> trees;

    public TreeNet(String begin, Map<String, Tree> trees) {
        this.begin = begin;
        this.trees = trees;
        for (Tree tree : this.trees.values()) {
            tree.setParent(this);
        }
    }

    public String getBegin() {
        return this.begin;
    }

    public Map<String, Tree> getTrees() {
        return this.trees;
    }

    public String toRankingExpression() {
        StringBuilder ret = new StringBuilder();
        String next = this.begin;
        while (next != null) {
            Tree tree = this.trees.get(next);
            if (tree.getBegin() != null) {
                if (ret.length() > 0) {
                    ret.append(" + \n");
                }
                ret.append(tree.toRankingExpression());
            }
            next = tree.getNext();
        }
        return ret.toString();
    }
}

