/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.evaluation.BooleanValue;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;

public abstract class DoubleCompatibleValue
extends Value {
    @Override
    public boolean hasDouble() {
        return true;
    }

    @Override
    public Tensor asTensor() {
        return this.doubleAsTensor(this.asDouble());
    }

    @Override
    public Value negate() {
        return new DoubleValue(-this.asDouble());
    }

    @Override
    public Value add(Value value) {
        return new DoubleValue(this.asDouble() + value.asDouble());
    }

    @Override
    public Value subtract(Value value) {
        return new DoubleValue(this.asDouble() - value.asDouble());
    }

    @Override
    public Value multiply(Value value) {
        return new DoubleValue(this.asDouble() * value.asDouble());
    }

    @Override
    public Value divide(Value value) {
        return new DoubleValue(this.asDouble() / value.asDouble());
    }

    @Override
    public Value modulo(Value value) {
        return new DoubleValue(this.asDouble() % value.asDouble());
    }

    @Override
    public Value and(Value value) {
        return new BooleanValue(this.asBoolean() && value.asBoolean());
    }

    @Override
    public Value or(Value value) {
        return new BooleanValue(this.asBoolean() || value.asBoolean());
    }

    @Override
    public Value not() {
        return new BooleanValue(!this.asBoolean());
    }

    @Override
    public Value power(Value value) {
        return new DoubleValue(Function.pow.evaluate(this.asDouble(), value.asDouble()));
    }

    @Override
    public Value compare(TruthOperator operator, Value value) {
        return new BooleanValue(operator.evaluate(this.asDouble(), value.asDouble()));
    }

    @Override
    public Value function(Function function, Value value) {
        return new DoubleValue(function.evaluate(this.asDouble(), value.asDouble()));
    }
}

