/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.integration.tensorflow;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ImportResult {
    private final List<RankingExpression> expressions = new ArrayList<RankingExpression>();
    private final Map<String, Tensor> constants = new HashMap<String, Tensor>();
    private final Map<String, TensorType> arguments = new HashMap<String, TensorType>();
    private final List<String> warnings = new ArrayList<String>();

    void add(RankingExpression expression) {
        this.expressions.add(expression);
    }

    void set(String name, Tensor constant) {
        this.constants.put(name, constant);
    }

    void set(String name, TensorType argument) {
        this.arguments.put(name, argument);
    }

    void warn(String warning) {
        this.warnings.add(warning);
    }

    public List<RankingExpression> expressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public Map<String, Tensor> constants() {
        return Collections.unmodifiableMap(this.constants);
    }

    public Map<String, TensorType> arguments() {
        return Collections.unmodifiableMap(this.arguments);
    }

    public List<String> warnings() {
        return this.warnings.stream().sorted().collect(Collectors.toList());
    }
}

