/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.javacc.UnicodeUtilities;
import com.yahoo.searchlib.rankingexpression.evaluation.BooleanValue;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.StringValue;
import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;

public abstract class Value {
    private boolean frozen = false;

    public abstract double asDouble();

    public DoubleValue asDoubleValue() {
        return new DoubleValue(this.asDouble());
    }

    public abstract boolean hasDouble();

    public abstract boolean asBoolean();

    public abstract Value negate();

    public abstract Value add(Value var1);

    public abstract Value subtract(Value var1);

    public abstract Value multiply(Value var1);

    public abstract Value divide(Value var1);

    public abstract Value modulo(Value var1);

    public abstract Value and(Value var1);

    public abstract Value or(Value var1);

    public abstract Value not();

    public abstract Value power(Value var1);

    public abstract Value compare(TruthOperator var1, Value var2);

    public abstract Value function(Function var1, Value var2);

    public Value freeze() {
        this.frozen = true;
        return this;
    }

    public final boolean isFrozen() {
        return this.frozen;
    }

    public abstract Value asMutable();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public static Value parse(String value) {
        if (value.equals("true")) {
            return new BooleanValue(true);
        }
        if (value.equals("false")) {
            return new BooleanValue(false);
        }
        if (value.startsWith("\"") || value.startsWith("'")) {
            return new StringValue(UnicodeUtilities.unquote((String)value));
        }
        if (value.startsWith("{")) {
            return new TensorValue(Tensor.from((String)value));
        }
        return new DoubleValue(Double.parseDouble(value));
    }
}

