/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.transform;

import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticNode;
import com.yahoo.searchlib.rankingexpression.rule.ArithmeticOperator;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.EmbracedNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.IfNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.util.ArrayList;
import java.util.List;

public class Simplifier
extends ExpressionTransformer {
    @Override
    public ExpressionNode transform(ExpressionNode node) {
        if (node instanceof CompositeNode) {
            node = this.transformChildren((CompositeNode)node);
        }
        if (node instanceof IfNode) {
            node = this.transformIf((IfNode)node);
        }
        if (node instanceof EmbracedNode && this.hasSingleUndividableChild((EmbracedNode)node)) {
            node = ((EmbracedNode)node).children().get(0);
        }
        if (node instanceof ArithmeticNode) {
            node = this.transformArithmetic((ArithmeticNode)node);
        }
        return node;
    }

    private boolean hasSingleUndividableChild(EmbracedNode node) {
        if (node.children().size() > 1) {
            return false;
        }
        return !(node.children().get(0) instanceof ArithmeticNode);
    }

    private ExpressionNode transformArithmetic(ArithmeticNode node) {
        if (node.children().size() > 1) {
            ArrayList<ExpressionNode> children = new ArrayList<ExpressionNode>(node.children());
            ArrayList<ArithmeticOperator> operators = new ArrayList<ArithmeticOperator>(node.operators());
            for (ArithmeticOperator operator : ArithmeticOperator.operatorsByPrecedence) {
                this.transform(operator, children, operators);
            }
            node = new ArithmeticNode(children, operators);
        }
        if (this.isConstant(node)) {
            return new ConstantNode(node.evaluate(null));
        }
        if (this.allMultiplicationOrDivision(node) && this.hasZero(node)) {
            return new ConstantNode(new DoubleValue(0.0));
        }
        return node;
    }

    private void transform(ArithmeticOperator operator, List<ExpressionNode> children, List<ArithmeticOperator> operators) {
        int i = 0;
        while (i < children.size() - 1) {
            if (!operators.get(i).equals((Object)operator)) {
                ++i;
                continue;
            }
            ExpressionNode child1 = children.get(i);
            ExpressionNode child2 = children.get(i + 1);
            if (this.isConstant(child1) && this.isConstant(child2) && this.hasPrecedence(operators, i)) {
                Value evaluated = new ArithmeticNode(child1, operators.remove(i), child2).evaluate(null);
                children.set(i, new ConstantNode(evaluated.freeze()));
                children.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    private boolean hasPrecedence(List<ArithmeticOperator> operators, int i) {
        if (i > 0 && operators.get(i - 1).hasPrecedenceOver(operators.get(i))) {
            return false;
        }
        return i >= operators.size() - 1 || !operators.get(i + 1).hasPrecedenceOver(operators.get(i));
    }

    private ExpressionNode transformIf(IfNode node) {
        if (!this.isConstant(node.getCondition())) {
            return node;
        }
        if (node.getCondition().evaluate(null).asBoolean()) {
            return node.getTrueExpression();
        }
        return node.getFalseExpression();
    }

    private boolean allMultiplicationOrDivision(ArithmeticNode node) {
        for (ArithmeticOperator o : node.operators()) {
            if (o != ArithmeticOperator.PLUS && o != ArithmeticOperator.MINUS) continue;
            return false;
        }
        return true;
    }

    private boolean hasZero(ArithmeticNode node) {
        for (ExpressionNode child : node.children()) {
            if (!(child instanceof ConstantNode)) continue;
            ConstantNode constant = (ConstantNode)child;
            if (!constant.getValue().hasDouble()) {
                return false;
            }
            if (constant.getValue().asDouble() != 0.0) continue;
            return true;
        }
        return false;
    }

    private boolean isConstant(ExpressionNode node) {
        if (node instanceof ConstantNode) {
            return true;
        }
        if (node instanceof ReferenceNode) {
            return false;
        }
        if (!(node instanceof CompositeNode)) {
            return false;
        }
        for (ExpressionNode child : ((CompositeNode)node).children()) {
            if (this.isConstant(child)) continue;
            return false;
        }
        return true;
    }
}

