/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.google.common.collect.ImmutableList;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.MapContext;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class LambdaFunctionNode
extends CompositeNode {
    private final ImmutableList<String> arguments;
    private final ExpressionNode functionExpression;

    public LambdaFunctionNode(List<String> arguments, ExpressionNode functionExpression) {
        this.arguments = ImmutableList.copyOf(arguments);
        this.functionExpression = functionExpression;
    }

    @Override
    public List<ExpressionNode> children() {
        return Collections.singletonList(this.functionExpression);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("A lambda function must have a single child expression");
        }
        return new LambdaFunctionNode((List<String>)this.arguments, children.get(0));
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return "f(" + this.commaSeparated((List<String>)this.arguments) + ")(" + this.functionExpression.toString(context, path, this) + ")";
    }

    private String commaSeparated(List<String> list) {
        StringBuilder b = new StringBuilder();
        for (String element : list) {
            b.append(element).append(",");
        }
        if (b.length() > 0) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    @Override
    public Value evaluate(Context context) {
        return this.functionExpression.evaluate(context);
    }

    public DoubleUnaryOperator asDoubleUnaryOperator() {
        if (this.arguments.size() > 1) {
            throw new IllegalStateException("Cannot apply " + this + " as a DoubleUnaryOperator: Must have at most one argument  but has " + this.arguments);
        }
        return new DoubleUnaryLambda();
    }

    public DoubleBinaryOperator asDoubleBinaryOperator() {
        if (this.arguments.size() > 2) {
            throw new IllegalStateException("Cannot apply " + this + " as a DoubleBinaryOperator: Must have at most two argument  but has " + this.arguments);
        }
        return new DoubleBinaryLambda();
    }

    private class DoubleBinaryLambda
    implements DoubleBinaryOperator {
        private DoubleBinaryLambda() {
        }

        @Override
        public double applyAsDouble(double left, double right) {
            MapContext context = new MapContext();
            if (LambdaFunctionNode.this.arguments.size() > 0) {
                context.put((String)LambdaFunctionNode.this.arguments.get(0), left);
            }
            if (LambdaFunctionNode.this.arguments.size() > 1) {
                context.put((String)LambdaFunctionNode.this.arguments.get(1), right);
            }
            return LambdaFunctionNode.this.evaluate(context).asDouble();
        }

        public String toString() {
            return LambdaFunctionNode.this.toString();
        }
    }

    private class DoubleUnaryLambda
    implements DoubleUnaryOperator {
        private DoubleUnaryLambda() {
        }

        @Override
        public double applyAsDouble(double operand) {
            MapContext context = new MapContext();
            if (LambdaFunctionNode.this.arguments.size() > 0) {
                context.put((String)LambdaFunctionNode.this.arguments.get(0), operand);
            }
            return LambdaFunctionNode.this.evaluate(context).asDouble();
        }

        public String toString() {
            return LambdaFunctionNode.this.toString();
        }
    }
}

