/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import java.util.Collections;
import java.util.Deque;
import java.util.List;

public final class EmbracedNode
extends CompositeNode {
    private final ExpressionNode value;

    public EmbracedNode(ExpressionNode value) {
        this.value = value;
    }

    public ExpressionNode getValue() {
        return this.value;
    }

    @Override
    public List<ExpressionNode> children() {
        return Collections.singletonList(this.value);
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        String expression = this.value.toString(context, path, this);
        if (this.value instanceof ReferenceNode) {
            return expression;
        }
        return "(" + expression + ")";
    }

    @Override
    public Value evaluate(Context context) {
        return this.value.evaluate(context);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("Expected 1 child but got " + newChildren.size());
        }
        return new EmbracedNode(newChildren.get(0));
    }
}

