/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.google.common.collect.ImmutableMap;
import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractArrayContext
extends Context
implements Cloneable {
    private final boolean ignoreUnknownValues;
    private final ImmutableMap<String, Integer> nameToIndex;
    private double[] doubleValues;
    private final String rankingExpressionName;

    protected AbstractArrayContext(RankingExpression expression) {
        this(expression, false);
    }

    protected AbstractArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        this.ignoreUnknownValues = ignoreUnknownValues;
        this.rankingExpressionName = expression.getName();
        LinkedHashSet<String> variables = new LinkedHashSet<String>();
        this.extractVariables(expression.getRoot(), variables);
        this.doubleValues = new double[variables.size()];
        int i = 0;
        ImmutableMap.Builder nameToIndexBuilder = new ImmutableMap.Builder();
        for (String variable : variables) {
            nameToIndexBuilder.put((Object)variable, (Object)i++);
        }
        this.nameToIndex = nameToIndexBuilder.build();
    }

    private void extractVariables(ExpressionNode node, Set<String> variables) {
        if (node instanceof ReferenceNode) {
            ReferenceNode fNode = (ReferenceNode)node;
            if (fNode.getArguments().expressions().size() > 0) {
                throw new UnsupportedOperationException("Array lookup is not supported with features having arguments)");
            }
            variables.add(fNode.toString());
        } else if (node instanceof CompositeNode) {
            CompositeNode cNode = (CompositeNode)node;
            for (ExpressionNode child : cNode.children()) {
                this.extractVariables(child, variables);
            }
        }
    }

    protected final Map<String, Integer> nameToIndex() {
        return this.nameToIndex;
    }

    protected final double[] doubleValues() {
        return this.doubleValues;
    }

    protected final boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public AbstractArrayContext clone() {
        try {
            AbstractArrayContext clone = (AbstractArrayContext)super.clone();
            clone.doubleValues = new double[this.nameToIndex.size()];
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Programming error");
        }
    }

    @Override
    public Set<String> names() {
        return this.nameToIndex.keySet();
    }

    public final int getIndex(String name) {
        return (Integer)this.nameToIndex.get((Object)name);
    }

    public int size() {
        return this.doubleValues.length;
    }

    @Override
    public double getDouble(int index) {
        return this.doubleValues[index];
    }

    public String toString() {
        return "fast lookup context for ranking expression '" + this.rankingExpressionName + "' [" + this.doubleValues.length + " variables]";
    }
}

