/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.RankingExpression;
import com.yahoo.searchlib.rankingexpression.evaluation.AbstractArrayContext;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.Arrays;

public class ArrayContext
extends AbstractArrayContext
implements Cloneable {
    private Value[] values = new Value[this.doubleValues().length];
    private static DoubleValue constantZero = DoubleValue.frozen(0.0);

    public ArrayContext(RankingExpression expression) {
        this(expression, false);
    }

    public ArrayContext(RankingExpression expression, boolean ignoreUnknownValues) {
        super(expression, ignoreUnknownValues);
        Arrays.fill(this.values, DoubleValue.zero);
    }

    @Override
    public final void put(String name, Value value) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            if (this.ignoreUnknownValues()) {
                return;
            }
            throw new IllegalArgumentException("Value '" + name + "' is not known to " + this);
        }
        this.put((int)index, value);
    }

    public final void put(int index, double value) {
        this.put(index, (Value)DoubleValue.frozen(value));
    }

    public final void put(int index, Value value) {
        this.values[index] = value.freeze();
        try {
            this.doubleValues()[index] = value.asDouble();
        }
        catch (UnsupportedOperationException e) {
            this.doubleValues()[index] = Double.NaN;
        }
    }

    @Override
    public Value get(String name) {
        Integer index = this.nameToIndex().get(name);
        if (index == null) {
            return DoubleValue.zero;
        }
        return this.values[index];
    }

    @Override
    public final Value get(int index) {
        return this.values[index];
    }

    @Override
    public final double getDouble(int index) {
        double value = this.doubleValues()[index];
        if (value == Double.NaN) {
            throw new UnsupportedOperationException("Value at " + index + " has no double representation");
        }
        return value;
    }

    @Override
    public ArrayContext clone() {
        ArrayContext clone = (ArrayContext)super.clone();
        clone.values = new Value[this.nameToIndex().size()];
        Arrays.fill(this.values, constantZero);
        return clone;
    }
}

