/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.transform;

import com.yahoo.searchlib.rankingexpression.evaluation.TensorValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ConstantNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import com.yahoo.searchlib.rankingexpression.transform.ExpressionTransformer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConstantDereferencer
extends ExpressionTransformer {
    private final Map<String, Value> constants;

    public ConstantDereferencer(Map<String, Value> constants) {
        this.constants = constants;
    }

    @Override
    public ExpressionNode transform(ExpressionNode node) {
        if (node instanceof ReferenceNode) {
            return this.transformFeature((ReferenceNode)node);
        }
        if (node instanceof CompositeNode) {
            return this.transformChildren((CompositeNode)node);
        }
        return node;
    }

    private ExpressionNode transformFeature(ReferenceNode node) {
        if (!node.getArguments().isEmpty()) {
            return this.transformArguments(node);
        }
        return this.transformConstantReference(node);
    }

    private ExpressionNode transformArguments(ReferenceNode node) {
        List<ExpressionNode> arguments = node.getArguments().expressions();
        ArrayList<ExpressionNode> transformedArguments = new ArrayList<ExpressionNode>(arguments.size());
        for (ExpressionNode argument : arguments) {
            transformedArguments.add(this.transform(argument));
        }
        return node.setArguments(transformedArguments);
    }

    private ExpressionNode transformConstantReference(ReferenceNode node) {
        Value value = this.constants.get(node.getName());
        if (value == null || value instanceof TensorValue) {
            return node;
        }
        return new ConstantNode(value.freeze());
    }
}

