/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.rule;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.MapContext;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import com.yahoo.tensor.TensorType;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.function.Function;

public class GeneratorLambdaFunctionNode
extends CompositeNode {
    private final TensorType type;
    private final ExpressionNode generator;

    public GeneratorLambdaFunctionNode(TensorType type, ExpressionNode generator) {
        if (!type.dimensions().stream().allMatch(d -> d.size().isPresent())) {
            throw new IllegalArgumentException("A tensor generator function can only generate tensors with bound dimensions, but tried to generate " + type);
        }
        this.type = type;
        this.generator = generator;
    }

    @Override
    public List<ExpressionNode> children() {
        return Collections.singletonList(this.generator);
    }

    @Override
    public CompositeNode setChildren(List<ExpressionNode> children) {
        if (children.size() != 1) {
            throw new IllegalArgumentException("A lambda function must have a single child expression");
        }
        return new GeneratorLambdaFunctionNode(this.type, children.get(0));
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return this.generator.toString(context, path, this);
    }

    @Override
    public Value evaluate(Context context) {
        return this.generator.evaluate(context);
    }

    public IntegerListToDoubleLambda asIntegerListToDoubleOperator() {
        return new IntegerListToDoubleLambda();
    }

    private class IntegerListToDoubleLambda
    implements Function<List<Integer>, Double> {
        private IntegerListToDoubleLambda() {
        }

        @Override
        public Double apply(List<Integer> arguments) {
            MapContext context = new MapContext();
            for (int i = 0; i < GeneratorLambdaFunctionNode.this.type.dimensions().size(); ++i) {
                context.put(((TensorType.Dimension)GeneratorLambdaFunctionNode.this.type.dimensions().get(i)).name(), arguments.get(i).intValue());
            }
            return GeneratorLambdaFunctionNode.this.evaluate(context).asDouble();
        }

        public String toString() {
            return GeneratorLambdaFunctionNode.this.toString();
        }
    }
}

