/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.google.common.annotations.Beta;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.rule.Function;
import com.yahoo.searchlib.rankingexpression.rule.TruthOperator;
import com.yahoo.tensor.Tensor;
import com.yahoo.tensor.TensorAddress;

@Beta
public class TensorValue
extends Value {
    private final Tensor value;

    public TensorValue(Tensor value) {
        this.value = value;
    }

    @Override
    public double asDouble() {
        if (this.hasDouble()) {
            return this.value.get(TensorAddress.of((int[])new int[0]));
        }
        throw new UnsupportedOperationException("Requires a double value, but " + this.value + " cannot be used as a double");
    }

    @Override
    public boolean hasDouble() {
        return this.value.type().dimensions().isEmpty() && !this.value.isEmpty();
    }

    @Override
    public boolean asBoolean() {
        throw new UnsupportedOperationException("A tensor does not have a boolean value");
    }

    @Override
    public Value negate() {
        return new TensorValue(this.value.map(value -> -value));
    }

    @Override
    public Value add(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.add(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value + argument.asDouble()));
    }

    @Override
    public Value subtract(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.subtract(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value - argument.asDouble()));
    }

    @Override
    public Value multiply(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.multiply(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value * argument.asDouble()));
    }

    @Override
    public Value divide(Value argument) {
        if (argument instanceof TensorValue) {
            return new TensorValue(this.value.divide(((TensorValue)argument).value));
        }
        return new TensorValue(this.value.map(value -> value / argument.asDouble()));
    }

    private Tensor asTensor(Value value, String operationName) {
        if (!(value instanceof TensorValue)) {
            throw new UnsupportedOperationException("Could not perform " + operationName + ": The second argument must be a tensor but was " + value);
        }
        return ((TensorValue)value).value;
    }

    public Tensor asTensor() {
        return this.value;
    }

    @Override
    public Value compare(TruthOperator operator, Value argument) {
        return new TensorValue(this.compareTensor(operator, this.asTensor(argument, operator.toString())));
    }

    private Tensor compareTensor(TruthOperator operator, Tensor argument) {
        switch (operator) {
            case LARGER: {
                return this.value.larger(argument);
            }
            case LARGEREQUAL: {
                return this.value.largerOrEqual(argument);
            }
            case SMALLER: {
                return this.value.smaller(argument);
            }
            case SMALLEREQUAL: {
                return this.value.smallerOrEqual(argument);
            }
            case EQUAL: {
                return this.value.equal(argument);
            }
            case NOTEQUAL: {
                return this.value.notEqual(argument);
            }
        }
        throw new UnsupportedOperationException("Tensors cannot be compared with " + operator);
    }

    @Override
    public Value function(Function function, Value arg) {
        if (arg instanceof TensorValue) {
            return new TensorValue(this.functionOnTensor(function, this.asTensor(arg, function.toString())));
        }
        return new TensorValue(this.value.map(value -> function.evaluate(value, arg.asDouble())));
    }

    private Tensor functionOnTensor(Function function, Tensor argument) {
        switch (function) {
            case min: {
                return this.value.min(argument);
            }
            case max: {
                return this.value.max(argument);
            }
            case atan2: {
                return this.value.atan2(argument);
            }
        }
        throw new UnsupportedOperationException("Cannot combine two tensors using " + function);
    }

    @Override
    public Value asMutable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TensorValue other = (TensorValue)o;
        return this.value.equals((Object)other.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }
}

