/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapContext
extends Context {
    private Map<String, Value> bindings = new HashMap<String, Value>();
    private boolean frozen = false;

    public MapContext() {
    }

    public MapContext freeze() {
        if (!this.frozen) {
            this.bindings = Collections.unmodifiableMap(this.bindings);
        }
        return this;
    }

    public MapContext(Map<String, Value> bindings) {
        this.bindings = bindings;
        for (Value boundValue : bindings.values()) {
            boundValue.freeze();
        }
    }

    @Override
    public Value get(String key) {
        Value value = this.bindings.get(key);
        if (value == null) {
            return DoubleValue.zero;
        }
        return value;
    }

    @Override
    public void put(String key, Value value) {
        this.bindings.put(key, value.freeze());
    }

    public Map<String, Value> bindings() {
        if (this.frozen) {
            return this.bindings;
        }
        return Collections.unmodifiableMap(this.bindings);
    }

    public MapContext thawedCopy() {
        return new MapContext(new HashMap<String, Value>(this.bindings));
    }

    @Override
    public Set<String> names() {
        if (this.frozen) {
            return this.bindings.keySet();
        }
        return Collections.unmodifiableMap(this.bindings).keySet();
    }

    public String toString() {
        return "a map context [" + this.bindings.size() + " bindings]";
    }

    public static MapContext fromString(String contextString) {
        MapContext mapContext = new MapContext();
        for (String keyValueString : contextString.split(",")) {
            String[] strings = keyValueString.trim().split(":");
            mapContext.put(strings[0].trim(), Value.parse(strings[1].trim()));
        }
        return mapContext;
    }
}

