/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization;

import com.yahoo.searchlib.rankingexpression.evaluation.Context;
import com.yahoo.searchlib.rankingexpression.evaluation.DoubleValue;
import com.yahoo.searchlib.rankingexpression.evaluation.Value;
import com.yahoo.searchlib.rankingexpression.evaluation.gbdtoptimization.GBDTNode;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.SerializationContext;
import java.util.Deque;

public class GBDTForestNode
extends ExpressionNode {
    private final double[] values;

    public GBDTForestNode(double[] values) {
        this.values = values;
    }

    @Override
    public final Value evaluate(Context context) {
        int nextTree;
        double treeSum = 0.0;
        for (int pc = 0; pc < this.values.length; pc += nextTree) {
            nextTree = (int)this.values[pc++];
            treeSum += GBDTNode.evaluate(this.values, pc, context);
        }
        return new DoubleValue(treeSum);
    }

    @Override
    public String toString(SerializationContext context, Deque<String> path, CompositeNode parent) {
        return "(optimized sum of condition trees of size " + this.values.length * 8 + " bytes)";
    }
}

