/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.LongNode;
import com.yahoo.config.Node;
import com.yahoo.config.ReferenceNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ProtonConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "f8d879504455da0b292f8772e51e3f7a";
    public static final String CONFIG_DEF_NAME = "proton";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "basedir string default=\".\" restart", "rpcport int default=8004 restart", "httpport int default=0 restart", "clustername string default=\"\" restart", "distributionkey int default=-1", "rpc.transportthreads int default=0 restart", "search.async bool default=true", "docsum.async bool default=true", "numsearcherthreads int default=64 restart", "numthreadspersearch int default=1 restart", "numsummarythreads int default=16 restart", "validate_and_sanitize_docstore enum {NO, YES} default = NO", "flush.maxconcurrent int default=2 restart", "flush.idleinterval double default=10.0 restart", "flush.strategy enum {SIMPLE, MEMORY} default=MEMORY restart", "flush.memory.maxmemory long default=4294967296", "flush.memory.diskbloatfactor double default=0.25", "flush.memory.maxtlssize long default=21474836480", "flush.memory.each.maxmemory long default=1073741824", "flush.memory.each.diskbloatfactor double default=0.25", "flush.memory.maxage.time double default=111600.0", "flush.memory.conservative.memorylimitfactor double default=0.5", "flush.memory.conservative.disklimitfactor double default=0.5", "flush.memory.conservative.highwatermarkfactor double default=0.95", "flush.memory.conservative.lowwatermarkfactor double default=0.9", "flush.preparerestart.replaycost double default=8.0", "flush.preparerestart.replayoperationcost double default=3000.0", "flush.preparerestart.writecost double default=1.0", "indexing.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO restart", "indexing.read.io enum {NORMAL, DIRECTIO} default=DIRECTIO restart", "indexing.threads int default=1 restart", "indexing.optimize enum {LATENCY, THROUGHPUT, ADAPTIVE} default=THROUGHPUT restart", "indexing.tasklimit int default=1000", "indexing.semiunboundtasklimit int default = 1000", "indexing.kind_of_watermark int default = 0 restart", "indexing.reactiontime double default = 0.001 restart", "index.warmup.time double default=0.0 restart", "index.warmup.unpack bool default=false restart", "index.maxflushed int default=2", "index.maxflushedretired int default=20", "index.cache.size long default=0 restart", "attribute.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO restart", "search.mmap.options[] enum {POPULATE, HUGETLB} restart", "search.mmap.advise enum {NORMAL, RANDOM, SEQUENTIAL} default=NORMAL restart", "search.memory.limiter.maxthreads int default=0", "search.memory.limiter.mincoverage double default=1.0", "search.memory.limiter.minhits int default=1000000", "grouping.sessionmanager.maxentries int default=500 restart", "grouping.sessionmanager.pruning.interval double default=1.0", "distribution.redundancy long default=1", "distribution.searchablecopies long default=1", "summary.cache.maxbytes long default=-4", "summary.cache.allowvisitcaching bool default=true", "summary.cache.initialentries long default=0 restart", "summary.cache.compression.type enum {NONE, LZ4, ZSTD} default=LZ4", "summary.cache.compression.level int default=6", "summary.cache.update_strategy enum {INVALIDATE, UPDATE} default=INVALIDATE", "summary.log.compact.compression.type enum {NONE, LZ4, ZSTD} default=ZSTD", "summary.log.compact.compression.level int default=9", "summary.log.chunk.compression.type enum {NONE, LZ4, ZSTD} default=ZSTD", "summary.log.chunk.compression.level int default=9", "summary.log.chunk.maxbytes int default=65536", "summary.log.chunk.skipcrconread bool default=false", "summary.log.maxfilesize long default=1000000000", "summary.log.maxnumlids int default=40000000", "summary.log.maxdiskbloatfactor double default=0.1", "summary.log.maxbucketspread double default=2.5", "summary.log.minfilesizefactor double default=0.2", "summary.write.io enum {NORMAL, OSYNC, DIRECTIO} default=DIRECTIO", "summary.read.io enum {NORMAL, DIRECTIO, MMAP } default=MMAP restart", "summary.read.mmap.options[] enum {POPULATE, HUGETLB} restart", "summary.read.mmap.advise enum {NORMAL, RANDOM, SEQUENTIAL} default=NORMAL restart", "documentdb[].inputdoctypename string", "documentdb[].mode enum {INDEX, STREAMING, STORE_ONLY} default=INDEX", "documentdb[].configid string", "documentdb[].visibilitydelay double default=0.0", "documentdb[].global bool default=false", "documentdb[].feeding.concurrency double default=0.2", "documentdb[].allocation.initialnumdocs long default=1024", "documentdb[].allocation.growfactor double default=0.2", "documentdb[].allocation.growbias int default=1", "documentdb[].allocation.amortizecount int default=10000", "documentdb[].allocation.multivaluegrowfactor double default=0.2", "documentdb[].allocation.max_dead_bytes_ratio double default=0.05", "documentdb[].allocation.max_dead_address_space_ratio double default=0.2", "documentdb[].allocation.max_compact_buffers int default=1", "documentdb[].allocation.active_buffers_ratio double default=0.1", "periodic.interval double default=3600.0", "tlsspec string default=\"tcp/localhost:13700\" restart", "tlsconfigid string default=\"\" restart", "slobrokconfigid string default=\"\" restart", "routingconfigid string default=\"\" restart", "filedistributor.configid reference default=\"\" restart", "pruneremoveddocumentsinterval double default=0.0", "pruneremoveddocumentsage double default=1209600.0", "packetcompresslimit int default=1024", "packetcompresslevel int default=3", "packetcompresstype enum {NONE, LZ4} default=LZ4", "lidspacecompaction.interval double default=10.0", "lidspacecompaction.allowedlidbloat int default=1", "lidspacecompaction.allowedlidbloatfactor double default=0.01", "lidspacecompaction.removebatchblockdelay double default=2.0", "lidspacecompaction.removebatchblockrate double default=0.5", "lidspacecompaction.removeblockrate double default=100.0", "bucketmove.maxdocstomoveperbucket int default=1", "maxvisibilitydelay double default=1.0", "visit.defaultserializedsize long default=1", "visit.ignoremaxbytes bool default=true", "initialize.threads int default = 0", "writefilter.attribute.address_space_limit double default = 0.92", "writefilter.memorylimit double default = 0.8", "writefilter.disklimit double default = 0.8", "writefilter.sampleinterval double default = 10.0", "hwinfo.disk.size long default = 0 restart", "hwinfo.disk.shared bool default = false restart", "hwinfo.disk.writespeed double default = 200.0 restart", "hwinfo.disk.samplewritesize long default = 1073741824 restart", "hwinfo.disk.slowwritespeedlimit double default = 100.0 restart", "hwinfo.memory.size long default = 0 restart", "hwinfo.cpu.cores int default = 0 restart", "feeding.concurrency double default = 0.2 restart", "feeding.shared_field_writer_executor enum {NONE, INDEX, INDEX_AND_ATTRIBUTE, DOCUMENT_DB} default = NONE restart", "feeding.master_task_limit int default = 1000", "maintenancejobs.resourcelimitfactor double default = 1.05", "maintenancejobs.maxoutstandingmoveops int default=100", "bucketdb.checksumtype enum {LEGACY, XXHASH64} default = LEGACY restart", "tensor_implementation enum {TENSOR_ENGINE, FAST_VALUE} default = FAST_VALUE", "forward_issues bool default = true", "replay_throttling_policy.type enum { UNLIMITED, DYNAMIC } default=UNLIMITED", "replay_throttling_policy.min_window_size int default=100", "replay_throttling_policy.max_window_size int default=10000", "replay_throttling_policy.window_size_increment int default=20"};
    private final StringNode basedir;
    private final IntegerNode rpcport;
    private final IntegerNode httpport;
    private final StringNode clustername;
    private final IntegerNode distributionkey;
    private final Rpc rpc;
    private final Search search;
    private final Docsum docsum;
    private final IntegerNode numsearcherthreads;
    private final IntegerNode numthreadspersearch;
    private final IntegerNode numsummarythreads;
    private final Validate_and_sanitize_docstore validate_and_sanitize_docstore;
    private final Flush flush;
    private final Indexing indexing;
    private final Index index;
    private final Attribute attribute;
    private final Grouping grouping;
    private final Distribution distribution;
    private final Summary summary;
    private final InnerNodeVector<Documentdb> documentdb;
    private final Periodic periodic;
    private final StringNode tlsspec;
    private final StringNode tlsconfigid;
    private final StringNode slobrokconfigid;
    private final StringNode routingconfigid;
    private final Filedistributor filedistributor;
    private final DoubleNode pruneremoveddocumentsinterval;
    private final DoubleNode pruneremoveddocumentsage;
    private final IntegerNode packetcompresslimit;
    private final IntegerNode packetcompresslevel;
    private final Packetcompresstype packetcompresstype;
    private final Lidspacecompaction lidspacecompaction;
    private final Bucketmove bucketmove;
    private final DoubleNode maxvisibilitydelay;
    private final Visit visit;
    private final Initialize initialize;
    private final Writefilter writefilter;
    private final Hwinfo hwinfo;
    private final Feeding feeding;
    private final Maintenancejobs maintenancejobs;
    private final Bucketdb bucketdb;
    private final Tensor_implementation tensor_implementation;
    private final BooleanNode forward_issues;
    private final Replay_throttling_policy replay_throttling_policy;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ProtonConfig(Builder builder) {
        this(builder, true);
    }

    private ProtonConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for proton must be initialized: " + builder.__uninitialized);
        }
        this.basedir = builder.basedir == null ? new StringNode(".") : new StringNode(builder.basedir);
        this.rpcport = builder.rpcport == null ? new IntegerNode(8004) : new IntegerNode(builder.rpcport.intValue());
        this.httpport = builder.httpport == null ? new IntegerNode(0) : new IntegerNode(builder.httpport.intValue());
        this.clustername = builder.clustername == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.clustername);
        this.distributionkey = builder.distributionkey == null ? new IntegerNode(-1) : new IntegerNode(builder.distributionkey.intValue());
        this.rpc = new Rpc(builder.rpc, throwIfUninitialized);
        this.search = new Search(builder.search, throwIfUninitialized);
        this.docsum = new Docsum(builder.docsum, throwIfUninitialized);
        this.numsearcherthreads = builder.numsearcherthreads == null ? new IntegerNode(64) : new IntegerNode(builder.numsearcherthreads.intValue());
        this.numthreadspersearch = builder.numthreadspersearch == null ? new IntegerNode(1) : new IntegerNode(builder.numthreadspersearch.intValue());
        this.numsummarythreads = builder.numsummarythreads == null ? new IntegerNode(16) : new IntegerNode(builder.numsummarythreads.intValue());
        this.validate_and_sanitize_docstore = builder.validate_and_sanitize_docstore == null ? new Validate_and_sanitize_docstore(Validate_and_sanitize_docstore.NO) : new Validate_and_sanitize_docstore(builder.validate_and_sanitize_docstore);
        this.flush = new Flush(builder.flush, throwIfUninitialized);
        this.indexing = new Indexing(builder.indexing, throwIfUninitialized);
        this.index = new Index(builder.index, throwIfUninitialized);
        this.attribute = new Attribute(builder.attribute, throwIfUninitialized);
        this.grouping = new Grouping(builder.grouping, throwIfUninitialized);
        this.distribution = new Distribution(builder.distribution, throwIfUninitialized);
        this.summary = new Summary(builder.summary, throwIfUninitialized);
        this.documentdb = Documentdb.createVector(builder.documentdb);
        this.periodic = new Periodic(builder.periodic, throwIfUninitialized);
        this.tlsspec = builder.tlsspec == null ? new StringNode("tcp/localhost:13700") : new StringNode(builder.tlsspec);
        this.tlsconfigid = builder.tlsconfigid == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.tlsconfigid);
        this.slobrokconfigid = builder.slobrokconfigid == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.slobrokconfigid);
        this.routingconfigid = builder.routingconfigid == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.routingconfigid);
        this.filedistributor = new Filedistributor(builder.filedistributor, throwIfUninitialized);
        this.pruneremoveddocumentsinterval = builder.pruneremoveddocumentsinterval == null ? new DoubleNode(0.0) : new DoubleNode(builder.pruneremoveddocumentsinterval.doubleValue());
        this.pruneremoveddocumentsage = builder.pruneremoveddocumentsage == null ? new DoubleNode(1209600.0) : new DoubleNode(builder.pruneremoveddocumentsage.doubleValue());
        this.packetcompresslimit = builder.packetcompresslimit == null ? new IntegerNode(1024) : new IntegerNode(builder.packetcompresslimit.intValue());
        this.packetcompresslevel = builder.packetcompresslevel == null ? new IntegerNode(3) : new IntegerNode(builder.packetcompresslevel.intValue());
        this.packetcompresstype = builder.packetcompresstype == null ? new Packetcompresstype(Packetcompresstype.LZ4) : new Packetcompresstype(builder.packetcompresstype);
        this.lidspacecompaction = new Lidspacecompaction(builder.lidspacecompaction, throwIfUninitialized);
        this.bucketmove = new Bucketmove(builder.bucketmove, throwIfUninitialized);
        this.maxvisibilitydelay = builder.maxvisibilitydelay == null ? new DoubleNode(1.0) : new DoubleNode(builder.maxvisibilitydelay.doubleValue());
        this.visit = new Visit(builder.visit, throwIfUninitialized);
        this.initialize = new Initialize(builder.initialize, throwIfUninitialized);
        this.writefilter = new Writefilter(builder.writefilter, throwIfUninitialized);
        this.hwinfo = new Hwinfo(builder.hwinfo, throwIfUninitialized);
        this.feeding = new Feeding(builder.feeding, throwIfUninitialized);
        this.maintenancejobs = new Maintenancejobs(builder.maintenancejobs, throwIfUninitialized);
        this.bucketdb = new Bucketdb(builder.bucketdb, throwIfUninitialized);
        this.tensor_implementation = builder.tensor_implementation == null ? new Tensor_implementation(Tensor_implementation.FAST_VALUE) : new Tensor_implementation(builder.tensor_implementation);
        this.forward_issues = builder.forward_issues == null ? new BooleanNode(true) : new BooleanNode(builder.forward_issues.booleanValue());
        this.replay_throttling_policy = new Replay_throttling_policy(builder.replay_throttling_policy, throwIfUninitialized);
    }

    public String basedir() {
        return this.basedir.value();
    }

    public int rpcport() {
        return this.rpcport.value();
    }

    public int httpport() {
        return this.httpport.value();
    }

    public String clustername() {
        return this.clustername.value();
    }

    public int distributionkey() {
        return this.distributionkey.value();
    }

    public Rpc rpc() {
        return this.rpc;
    }

    public Search search() {
        return this.search;
    }

    public Docsum docsum() {
        return this.docsum;
    }

    public int numsearcherthreads() {
        return this.numsearcherthreads.value();
    }

    public int numthreadspersearch() {
        return this.numthreadspersearch.value();
    }

    public int numsummarythreads() {
        return this.numsummarythreads.value();
    }

    public Validate_and_sanitize_docstore.Enum validate_and_sanitize_docstore() {
        return (Validate_and_sanitize_docstore.Enum)((Object)this.validate_and_sanitize_docstore.value());
    }

    public Flush flush() {
        return this.flush;
    }

    public Indexing indexing() {
        return this.indexing;
    }

    public Index index() {
        return this.index;
    }

    public Attribute attribute() {
        return this.attribute;
    }

    public Grouping grouping() {
        return this.grouping;
    }

    public Distribution distribution() {
        return this.distribution;
    }

    public Summary summary() {
        return this.summary;
    }

    public List<Documentdb> documentdb() {
        return this.documentdb;
    }

    public Documentdb documentdb(int i) {
        return (Documentdb)((Object)this.documentdb.get(i));
    }

    public Periodic periodic() {
        return this.periodic;
    }

    public String tlsspec() {
        return this.tlsspec.value();
    }

    public String tlsconfigid() {
        return this.tlsconfigid.value();
    }

    public String slobrokconfigid() {
        return this.slobrokconfigid.value();
    }

    public String routingconfigid() {
        return this.routingconfigid.value();
    }

    public Filedistributor filedistributor() {
        return this.filedistributor;
    }

    public double pruneremoveddocumentsinterval() {
        return this.pruneremoveddocumentsinterval.value();
    }

    public double pruneremoveddocumentsage() {
        return this.pruneremoveddocumentsage.value();
    }

    public int packetcompresslimit() {
        return this.packetcompresslimit.value();
    }

    public int packetcompresslevel() {
        return this.packetcompresslevel.value();
    }

    public Packetcompresstype.Enum packetcompresstype() {
        return (Packetcompresstype.Enum)((Object)this.packetcompresstype.value());
    }

    public Lidspacecompaction lidspacecompaction() {
        return this.lidspacecompaction;
    }

    public Bucketmove bucketmove() {
        return this.bucketmove;
    }

    public double maxvisibilitydelay() {
        return this.maxvisibilitydelay.value();
    }

    public Visit visit() {
        return this.visit;
    }

    public Initialize initialize() {
        return this.initialize;
    }

    public Writefilter writefilter() {
        return this.writefilter;
    }

    public Hwinfo hwinfo() {
        return this.hwinfo;
    }

    public Feeding feeding() {
        return this.feeding;
    }

    public Maintenancejobs maintenancejobs() {
        return this.maintenancejobs;
    }

    public Bucketdb bucketdb() {
        return this.bucketdb;
    }

    public Tensor_implementation.Enum tensor_implementation() {
        return (Tensor_implementation.Enum)((Object)this.tensor_implementation.value());
    }

    public boolean forward_issues() {
        return this.forward_issues.value();
    }

    public Replay_throttling_policy replay_throttling_policy() {
        return this.replay_throttling_policy;
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ProtonConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.basedir, (Node)newConfig.basedir, "basedir", "Base directory. The default is ignored as it is assigned by the model");
        changes.compare((Node)this.rpcport, (Node)newConfig.rpcport, "rpcport", "Port to use for the rpcserver.");
        changes.compare((Node)this.httpport, (Node)newConfig.httpport, "httpport", "Port to use for the web server");
        changes.compare((Node)this.clustername, (Node)newConfig.clustername, "clustername", "Cluster name");
        changes.mergeChanges("rpc", this.rpc.getChangesRequiringRestart(newConfig.rpc));
        changes.mergeChanges("search", this.search.getChangesRequiringRestart(newConfig.search));
        changes.compare((Node)this.numsearcherthreads, (Node)newConfig.numsearcherthreads, "numsearcherthreads", "Num searcher threads");
        changes.compare((Node)this.numthreadspersearch, (Node)newConfig.numthreadspersearch, "numthreadspersearch", "Number of threads used per search");
        changes.compare((Node)this.numsummarythreads, (Node)newConfig.numsummarythreads, "numsummarythreads", "Num summary threads");
        changes.mergeChanges("flush", this.flush.getChangesRequiringRestart(newConfig.flush));
        changes.mergeChanges("indexing", this.indexing.getChangesRequiringRestart(newConfig.indexing));
        changes.mergeChanges("index", this.index.getChangesRequiringRestart(newConfig.index));
        changes.mergeChanges("attribute", this.attribute.getChangesRequiringRestart(newConfig.attribute));
        changes.mergeChanges("grouping", this.grouping.getChangesRequiringRestart(newConfig.grouping));
        changes.mergeChanges("summary", this.summary.getChangesRequiringRestart(newConfig.summary));
        changes.compare((Node)this.tlsspec, (Node)newConfig.tlsspec, "tlsspec", "Connect spec for transactionlog server.");
        changes.compare((Node)this.tlsconfigid, (Node)newConfig.tlsconfigid, "tlsconfigid", "ConfigId for transactionlogserver");
        changes.compare((Node)this.slobrokconfigid, (Node)newConfig.slobrokconfigid, "slobrokconfigid", "Slobrok configid");
        changes.compare((Node)this.routingconfigid, (Node)newConfig.routingconfigid, "routingconfigid", "Routing configid");
        changes.mergeChanges("filedistributor", this.filedistributor.getChangesRequiringRestart(newConfig.filedistributor));
        changes.mergeChanges("hwinfo", this.hwinfo.getChangesRequiringRestart(newConfig.hwinfo));
        changes.mergeChanges("feeding", this.feeding.getChangesRequiringRestart(newConfig.feeding));
        changes.mergeChanges("bucketdb", this.bucketdb.getChangesRequiringRestart(newConfig.bucketdb));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Replay_throttling_policy
    extends InnerNode {
        private final Type type;
        private final IntegerNode min_window_size;
        private final IntegerNode max_window_size;
        private final IntegerNode window_size_increment;

        public Replay_throttling_policy(Builder builder) {
            this(builder, true);
        }

        private Replay_throttling_policy(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.replay_throttling_policy must be initialized: " + builder.__uninitialized);
            }
            this.type = builder.type == null ? new Type(Type.UNLIMITED) : new Type(builder.type);
            this.min_window_size = builder.min_window_size == null ? new IntegerNode(100) : new IntegerNode(builder.min_window_size.intValue());
            this.max_window_size = builder.max_window_size == null ? new IntegerNode(10000) : new IntegerNode(builder.max_window_size.intValue());
            this.window_size_increment = builder.window_size_increment == null ? new IntegerNode(20) : new IntegerNode(builder.window_size_increment.intValue());
        }

        public Type.Enum type() {
            return (Type.Enum)((Object)this.type.value());
        }

        public int min_window_size() {
            return this.min_window_size.value();
        }

        public int max_window_size() {
            return this.max_window_size.value();
        }

        public int window_size_increment() {
            return this.window_size_increment.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Replay_throttling_policy newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("replay_throttling_policy");
            return changes;
        }

        public static final class Type
        extends EnumNode<Enum> {
            public static final Enum UNLIMITED = Enum.UNLIMITED;
            public static final Enum DYNAMIC = Enum.DYNAMIC;

            public Type() {
                this.value = null;
            }

            public Type(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                UNLIMITED,
                DYNAMIC;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Type.Enum type = null;
            private Integer min_window_size = null;
            private Integer max_window_size = null;
            private Integer window_size_increment = null;

            public Builder() {
            }

            public Builder(Replay_throttling_policy config) {
                this.type(config.type());
                this.min_window_size(config.min_window_size());
                this.max_window_size(config.max_window_size());
                this.window_size_increment(config.window_size_increment());
            }

            private Builder override(Builder __superior) {
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                if (__superior.min_window_size != null) {
                    this.min_window_size(__superior.min_window_size);
                }
                if (__superior.max_window_size != null) {
                    this.max_window_size(__superior.max_window_size);
                }
                if (__superior.window_size_increment != null) {
                    this.window_size_increment(__superior.window_size_increment);
                }
                return this;
            }

            public Builder type(Type.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                return this;
            }

            private Builder type(String __value) {
                return this.type(Type.Enum.valueOf(__value));
            }

            public Builder min_window_size(int __value) {
                this.min_window_size = __value;
                return this;
            }

            private Builder min_window_size(String __value) {
                return this.min_window_size(Integer.valueOf(__value));
            }

            public Builder max_window_size(int __value) {
                this.max_window_size = __value;
                return this;
            }

            private Builder max_window_size(String __value) {
                return this.max_window_size(Integer.valueOf(__value));
            }

            public Builder window_size_increment(int __value) {
                this.window_size_increment = __value;
                return this;
            }

            private Builder window_size_increment(String __value) {
                return this.window_size_increment(Integer.valueOf(__value));
            }

            public Replay_throttling_policy build() {
                return new Replay_throttling_policy(this);
            }
        }
    }

    public static final class Tensor_implementation
    extends EnumNode<Enum> {
        public static final Enum TENSOR_ENGINE = Enum.TENSOR_ENGINE;
        public static final Enum FAST_VALUE = Enum.FAST_VALUE;

        public Tensor_implementation() {
            this.value = null;
        }

        public Tensor_implementation(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            TENSOR_ENGINE,
            FAST_VALUE;

        }
    }

    public static final class Bucketdb
    extends InnerNode {
        private final Checksumtype checksumtype;

        public Bucketdb(Builder builder) {
            this(builder, true);
        }

        private Bucketdb(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.bucketdb must be initialized: " + builder.__uninitialized);
            }
            this.checksumtype = builder.checksumtype == null ? new Checksumtype(Checksumtype.LEGACY) : new Checksumtype(builder.checksumtype);
        }

        public Checksumtype.Enum checksumtype() {
            return (Checksumtype.Enum)((Object)this.checksumtype.value());
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Bucketdb newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("bucketdb");
            changes.compare((Node)this.checksumtype, (Node)newConfig.checksumtype, "checksumtype", "Controls the type of bucket checksum used. Do not change unless\nin depth understanding is present.");
            return changes;
        }

        public static final class Checksumtype
        extends EnumNode<Enum> {
            public static final Enum LEGACY = Enum.LEGACY;
            public static final Enum XXHASH64 = Enum.XXHASH64;

            public Checksumtype() {
                this.value = null;
            }

            public Checksumtype(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                LEGACY,
                XXHASH64;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Checksumtype.Enum checksumtype = null;

            public Builder() {
            }

            public Builder(Bucketdb config) {
                this.checksumtype(config.checksumtype());
            }

            private Builder override(Builder __superior) {
                if (__superior.checksumtype != null) {
                    this.checksumtype(__superior.checksumtype);
                }
                return this;
            }

            public Builder checksumtype(Checksumtype.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.checksumtype = __value;
                return this;
            }

            private Builder checksumtype(String __value) {
                return this.checksumtype(Checksumtype.Enum.valueOf(__value));
            }

            public Bucketdb build() {
                return new Bucketdb(this);
            }
        }
    }

    public static final class Maintenancejobs
    extends InnerNode {
        private final DoubleNode resourcelimitfactor;
        private final IntegerNode maxoutstandingmoveops;

        public Maintenancejobs(Builder builder) {
            this(builder, true);
        }

        private Maintenancejobs(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.maintenancejobs must be initialized: " + builder.__uninitialized);
            }
            this.resourcelimitfactor = builder.resourcelimitfactor == null ? new DoubleNode(1.05) : new DoubleNode(builder.resourcelimitfactor.doubleValue());
            this.maxoutstandingmoveops = builder.maxoutstandingmoveops == null ? new IntegerNode(100) : new IntegerNode(builder.maxoutstandingmoveops.intValue());
        }

        public double resourcelimitfactor() {
            return this.resourcelimitfactor.value();
        }

        public int maxoutstandingmoveops() {
            return this.maxoutstandingmoveops.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Maintenancejobs newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("maintenancejobs");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double resourcelimitfactor = null;
            private Integer maxoutstandingmoveops = null;

            public Builder() {
            }

            public Builder(Maintenancejobs config) {
                this.resourcelimitfactor(config.resourcelimitfactor());
                this.maxoutstandingmoveops(config.maxoutstandingmoveops());
            }

            private Builder override(Builder __superior) {
                if (__superior.resourcelimitfactor != null) {
                    this.resourcelimitfactor(__superior.resourcelimitfactor);
                }
                if (__superior.maxoutstandingmoveops != null) {
                    this.maxoutstandingmoveops(__superior.maxoutstandingmoveops);
                }
                return this;
            }

            public Builder resourcelimitfactor(double __value) {
                this.resourcelimitfactor = __value;
                return this;
            }

            private Builder resourcelimitfactor(String __value) {
                return this.resourcelimitfactor(Double.valueOf(__value));
            }

            public Builder maxoutstandingmoveops(int __value) {
                this.maxoutstandingmoveops = __value;
                return this;
            }

            private Builder maxoutstandingmoveops(String __value) {
                return this.maxoutstandingmoveops(Integer.valueOf(__value));
            }

            public Maintenancejobs build() {
                return new Maintenancejobs(this);
            }
        }
    }

    public static final class Feeding
    extends InnerNode {
        private final DoubleNode concurrency;
        private final Shared_field_writer_executor shared_field_writer_executor;
        private final IntegerNode master_task_limit;

        public Feeding(Builder builder) {
            this(builder, true);
        }

        private Feeding(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.feeding must be initialized: " + builder.__uninitialized);
            }
            this.concurrency = builder.concurrency == null ? new DoubleNode(0.2) : new DoubleNode(builder.concurrency.doubleValue());
            this.shared_field_writer_executor = builder.shared_field_writer_executor == null ? new Shared_field_writer_executor(Shared_field_writer_executor.NONE) : new Shared_field_writer_executor(builder.shared_field_writer_executor);
            this.master_task_limit = builder.master_task_limit == null ? new IntegerNode(1000) : new IntegerNode(builder.master_task_limit.intValue());
        }

        public double concurrency() {
            return this.concurrency.value();
        }

        public Shared_field_writer_executor.Enum shared_field_writer_executor() {
            return (Shared_field_writer_executor.Enum)((Object)this.shared_field_writer_executor.value());
        }

        public int master_task_limit() {
            return this.master_task_limit.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Feeding newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("feeding");
            changes.compare((Node)this.concurrency, (Node)newConfig.concurrency, "concurrency", "A number between 0.0 and 1.0 that specifies the concurrency when handling feed operations.\nWhen set to 1.0 all cores on the cpu is utilized.\n \n4 thread pools used for various aspect of feeding are configured based on this setting:\n1) Compressing and compacting documents\n2) Writing changes to attribute fields\n3) Inverting index fields\n4) Writing changes to index fields\n \nThe number of threads in pool 1 is calculated as:\nmax(ceil(hwinfo.cpu.cores * feeding.concurrency), summary.log.numthreads)\nThe number of threads in each of pools 2-4 is calculated as:\nmax(ceil((hwinfo.cpu.cores * feeding.concurrency)/3), indexing.threads)\nDeprecated -> Use documentdb.feeding.concurrency");
            changes.compare((Node)this.shared_field_writer_executor, (Node)newConfig.shared_field_writer_executor, "shared_field_writer_executor", "Whether we should use a shared field writer executor in the document db threading service:\n \nNONE: Don't use a shared executor.\nINDEX: Use a shared executor for index field inverter and index field writer.\nINDEX_AND_ATTRIBUTE: Use a shared executor for index field inverter, index field writer, and attribute field writer.\nDOCUMENT_DB: Use a shared executor for index field inverter, index field writer, and attribute field writer among all document dbs.\n \nTODO: Remove this when a shared executor is the default.");
            return changes;
        }

        public static final class Shared_field_writer_executor
        extends EnumNode<Enum> {
            public static final Enum NONE = Enum.NONE;
            public static final Enum INDEX = Enum.INDEX;
            public static final Enum INDEX_AND_ATTRIBUTE = Enum.INDEX_AND_ATTRIBUTE;
            public static final Enum DOCUMENT_DB = Enum.DOCUMENT_DB;

            public Shared_field_writer_executor() {
                this.value = null;
            }

            public Shared_field_writer_executor(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                NONE,
                INDEX,
                INDEX_AND_ATTRIBUTE,
                DOCUMENT_DB;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double concurrency = null;
            private Shared_field_writer_executor.Enum shared_field_writer_executor = null;
            private Integer master_task_limit = null;

            public Builder() {
            }

            public Builder(Feeding config) {
                this.concurrency(config.concurrency());
                this.shared_field_writer_executor(config.shared_field_writer_executor());
                this.master_task_limit(config.master_task_limit());
            }

            private Builder override(Builder __superior) {
                if (__superior.concurrency != null) {
                    this.concurrency(__superior.concurrency);
                }
                if (__superior.shared_field_writer_executor != null) {
                    this.shared_field_writer_executor(__superior.shared_field_writer_executor);
                }
                if (__superior.master_task_limit != null) {
                    this.master_task_limit(__superior.master_task_limit);
                }
                return this;
            }

            public Builder concurrency(double __value) {
                this.concurrency = __value;
                return this;
            }

            private Builder concurrency(String __value) {
                return this.concurrency(Double.valueOf(__value));
            }

            public Builder shared_field_writer_executor(Shared_field_writer_executor.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.shared_field_writer_executor = __value;
                return this;
            }

            private Builder shared_field_writer_executor(String __value) {
                return this.shared_field_writer_executor(Shared_field_writer_executor.Enum.valueOf(__value));
            }

            public Builder master_task_limit(int __value) {
                this.master_task_limit = __value;
                return this;
            }

            private Builder master_task_limit(String __value) {
                return this.master_task_limit(Integer.valueOf(__value));
            }

            public Feeding build() {
                return new Feeding(this);
            }
        }
    }

    public static final class Hwinfo
    extends InnerNode {
        private final Disk disk;
        private final Memory memory;
        private final Cpu cpu;

        public Hwinfo(Builder builder) {
            this(builder, true);
        }

        private Hwinfo(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.hwinfo must be initialized: " + builder.__uninitialized);
            }
            this.disk = new Disk(builder.disk, throwIfUninitialized);
            this.memory = new Memory(builder.memory, throwIfUninitialized);
            this.cpu = new Cpu(builder.cpu, throwIfUninitialized);
        }

        public Disk disk() {
            return this.disk;
        }

        public Memory memory() {
            return this.memory;
        }

        public Cpu cpu() {
            return this.cpu;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Hwinfo newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("hwinfo");
            changes.mergeChanges("disk", this.disk.getChangesRequiringRestart(newConfig.disk));
            changes.mergeChanges("memory", this.memory.getChangesRequiringRestart(newConfig.memory));
            changes.mergeChanges("cpu", this.cpu.getChangesRequiringRestart(newConfig.cpu));
            return changes;
        }

        public static final class Cpu
        extends InnerNode {
            private final IntegerNode cores;

            public Cpu(Builder builder) {
                this(builder, true);
            }

            private Cpu(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.hwinfo.cpu must be initialized: " + builder.__uninitialized);
                }
                this.cores = builder.cores == null ? new IntegerNode(0) : new IntegerNode(builder.cores.intValue());
            }

            public int cores() {
                return this.cores.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Cpu newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("cpu");
                changes.compare((Node)this.cores, (Node)newConfig.cores, "cores", "The number of cores on the cpu.\nIf set to 0, this is sampled by using std::thread::hardware_concurrency().");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer cores = null;

                public Builder() {
                }

                public Builder(Cpu config) {
                    this.cores(config.cores());
                }

                private Builder override(Builder __superior) {
                    if (__superior.cores != null) {
                        this.cores(__superior.cores);
                    }
                    return this;
                }

                public Builder cores(int __value) {
                    this.cores = __value;
                    return this;
                }

                private Builder cores(String __value) {
                    return this.cores(Integer.valueOf(__value));
                }

                public Cpu build() {
                    return new Cpu(this);
                }
            }
        }

        public static final class Memory
        extends InnerNode {
            private final LongNode size;

            public Memory(Builder builder) {
                this(builder, true);
            }

            private Memory(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.hwinfo.memory must be initialized: " + builder.__uninitialized);
                }
                this.size = builder.size == null ? new LongNode(0L) : new LongNode(builder.size.longValue());
            }

            public long size() {
                return this.size.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
                changes.compare((Node)this.size, (Node)newConfig.size, "size", "The size of physical memory (in bytes) available to proton.\nIf set to 0, the memory size is sampled as _SC_PHYS_PAGES * _SC_PAGESIZE by using sysconf to do the lookup.\nThe memory size is used when determining if feed should be blocked in writefilter.");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long size = null;

                public Builder() {
                }

                public Builder(Memory config) {
                    this.size(config.size());
                }

                private Builder override(Builder __superior) {
                    if (__superior.size != null) {
                        this.size(__superior.size);
                    }
                    return this;
                }

                public Builder size(long __value) {
                    this.size = __value;
                    return this;
                }

                private Builder size(String __value) {
                    return this.size(Long.valueOf(__value));
                }

                public Memory build() {
                    return new Memory(this);
                }
            }
        }

        public static final class Disk
        extends InnerNode {
            private final LongNode size;
            private final BooleanNode shared;
            private final DoubleNode writespeed;
            private final LongNode samplewritesize;
            private final DoubleNode slowwritespeedlimit;

            public Disk(Builder builder) {
                this(builder, true);
            }

            private Disk(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.hwinfo.disk must be initialized: " + builder.__uninitialized);
                }
                this.size = builder.size == null ? new LongNode(0L) : new LongNode(builder.size.longValue());
                this.shared = builder.shared == null ? new BooleanNode(false) : new BooleanNode(builder.shared.booleanValue());
                this.writespeed = builder.writespeed == null ? new DoubleNode(200.0) : new DoubleNode(builder.writespeed.doubleValue());
                this.samplewritesize = builder.samplewritesize == null ? new LongNode(0x40000000L) : new LongNode(builder.samplewritesize.longValue());
                this.slowwritespeedlimit = builder.slowwritespeedlimit == null ? new DoubleNode(100.0) : new DoubleNode(builder.slowwritespeedlimit.doubleValue());
            }

            public long size() {
                return this.size.value();
            }

            public boolean shared() {
                return this.shared.value();
            }

            public double writespeed() {
                return this.writespeed.value();
            }

            public long samplewritesize() {
                return this.samplewritesize.value();
            }

            public double slowwritespeedlimit() {
                return this.slowwritespeedlimit.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Disk newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("disk");
                changes.compare((Node)this.size, (Node)newConfig.size, "size", "The size of the disk partition (in bytes) on which proton basedir is located.\nIf set to 0, the disk size is sampled by looking at the filesystem space info.\nThe disk size is used when determining if feed should be blocked in writefilter.");
                changes.compare((Node)this.shared, (Node)newConfig.shared, "shared", "Whether the disk partition is shared among several instances of proton (e.g. when using docker).\nIf shared, disk usage is sampled by doing a recursive directory scan in proton basedir.\nIf not, disk usage is sampled by looking at the filesystem space info.");
                changes.compare((Node)this.writespeed, (Node)newConfig.writespeed, "writespeed", "Override for disk write speed, measured in MiB/s. When zero, the\nactual disk write speed is sampled by writing data to a temporary file.");
                changes.compare((Node)this.samplewritesize, (Node)newConfig.samplewritesize, "samplewritesize", "Amount of data to write to temporary file when sampling disk write speed.\nDefault is 1 GiB.");
                changes.compare((Node)this.slowwritespeedlimit, (Node)newConfig.slowwritespeedlimit, "slowwritespeedlimit", "Minimum write speed needed to avoid disk being considered slow.\nUnit is MiB/s, default is 100.0 MiB/s.");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long size = null;
                private Boolean shared = null;
                private Double writespeed = null;
                private Long samplewritesize = null;
                private Double slowwritespeedlimit = null;

                public Builder() {
                }

                public Builder(Disk config) {
                    this.size(config.size());
                    this.shared(config.shared());
                    this.writespeed(config.writespeed());
                    this.samplewritesize(config.samplewritesize());
                    this.slowwritespeedlimit(config.slowwritespeedlimit());
                }

                private Builder override(Builder __superior) {
                    if (__superior.size != null) {
                        this.size(__superior.size);
                    }
                    if (__superior.shared != null) {
                        this.shared(__superior.shared);
                    }
                    if (__superior.writespeed != null) {
                        this.writespeed(__superior.writespeed);
                    }
                    if (__superior.samplewritesize != null) {
                        this.samplewritesize(__superior.samplewritesize);
                    }
                    if (__superior.slowwritespeedlimit != null) {
                        this.slowwritespeedlimit(__superior.slowwritespeedlimit);
                    }
                    return this;
                }

                public Builder size(long __value) {
                    this.size = __value;
                    return this;
                }

                private Builder size(String __value) {
                    return this.size(Long.valueOf(__value));
                }

                public Builder shared(boolean __value) {
                    this.shared = __value;
                    return this;
                }

                private Builder shared(String __value) {
                    return this.shared(Boolean.valueOf(__value));
                }

                public Builder writespeed(double __value) {
                    this.writespeed = __value;
                    return this;
                }

                private Builder writespeed(String __value) {
                    return this.writespeed(Double.valueOf(__value));
                }

                public Builder samplewritesize(long __value) {
                    this.samplewritesize = __value;
                    return this;
                }

                private Builder samplewritesize(String __value) {
                    return this.samplewritesize(Long.valueOf(__value));
                }

                public Builder slowwritespeedlimit(double __value) {
                    this.slowwritespeedlimit = __value;
                    return this;
                }

                private Builder slowwritespeedlimit(String __value) {
                    return this.slowwritespeedlimit(Double.valueOf(__value));
                }

                public Disk build() {
                    return new Disk(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Disk.Builder disk = new Disk.Builder();
            public Memory.Builder memory = new Memory.Builder();
            public Cpu.Builder cpu = new Cpu.Builder();

            public Builder() {
            }

            public Builder(Hwinfo config) {
                this.disk(new Disk.Builder(config.disk()));
                this.memory(new Memory.Builder(config.memory()));
                this.cpu(new Cpu.Builder(config.cpu()));
            }

            private Builder override(Builder __superior) {
                this.disk(this.disk.override(__superior.disk));
                this.memory(this.memory.override(__superior.memory));
                this.cpu(this.cpu.override(__superior.cpu));
                return this;
            }

            public Builder disk(Disk.Builder __builder) {
                this.disk = __builder;
                return this;
            }

            public Builder disk(Consumer<Disk.Builder> __func) {
                Disk.Builder __inner = new Disk.Builder();
                __func.accept(__inner);
                this.disk = __inner;
                return this;
            }

            public Builder memory(Memory.Builder __builder) {
                this.memory = __builder;
                return this;
            }

            public Builder memory(Consumer<Memory.Builder> __func) {
                Memory.Builder __inner = new Memory.Builder();
                __func.accept(__inner);
                this.memory = __inner;
                return this;
            }

            public Builder cpu(Cpu.Builder __builder) {
                this.cpu = __builder;
                return this;
            }

            public Builder cpu(Consumer<Cpu.Builder> __func) {
                Cpu.Builder __inner = new Cpu.Builder();
                __func.accept(__inner);
                this.cpu = __inner;
                return this;
            }

            public Hwinfo build() {
                return new Hwinfo(this);
            }
        }
    }

    public static final class Writefilter
    extends InnerNode {
        private final Attribute attribute;
        private final DoubleNode memorylimit;
        private final DoubleNode disklimit;
        private final DoubleNode sampleinterval;

        public Writefilter(Builder builder) {
            this(builder, true);
        }

        private Writefilter(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.writefilter must be initialized: " + builder.__uninitialized);
            }
            this.attribute = new Attribute(builder.attribute, throwIfUninitialized);
            this.memorylimit = builder.memorylimit == null ? new DoubleNode(0.8) : new DoubleNode(builder.memorylimit.doubleValue());
            this.disklimit = builder.disklimit == null ? new DoubleNode(0.8) : new DoubleNode(builder.disklimit.doubleValue());
            this.sampleinterval = builder.sampleinterval == null ? new DoubleNode(10.0) : new DoubleNode(builder.sampleinterval.doubleValue());
        }

        public Attribute attribute() {
            return this.attribute;
        }

        public double memorylimit() {
            return this.memorylimit.value();
        }

        public double disklimit() {
            return this.disklimit.value();
        }

        public double sampleinterval() {
            return this.sampleinterval.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Writefilter newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("writefilter");
            return changes;
        }

        public static final class Attribute
        extends InnerNode {
            private final DoubleNode address_space_limit;

            public Attribute(Builder builder) {
                this(builder, true);
            }

            private Attribute(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.writefilter.attribute must be initialized: " + builder.__uninitialized);
                }
                this.address_space_limit = builder.address_space_limit == null ? new DoubleNode(0.92) : new DoubleNode(builder.address_space_limit.doubleValue());
            }

            public double address_space_limit() {
                return this.address_space_limit.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double address_space_limit = null;

                public Builder() {
                }

                public Builder(Attribute config) {
                    this.address_space_limit(config.address_space_limit());
                }

                private Builder override(Builder __superior) {
                    if (__superior.address_space_limit != null) {
                        this.address_space_limit(__superior.address_space_limit);
                    }
                    return this;
                }

                public Builder address_space_limit(double __value) {
                    this.address_space_limit = __value;
                    return this;
                }

                private Builder address_space_limit(String __value) {
                    return this.address_space_limit(Double.valueOf(__value));
                }

                public Attribute build() {
                    return new Attribute(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Attribute.Builder attribute = new Attribute.Builder();
            private Double memorylimit = null;
            private Double disklimit = null;
            private Double sampleinterval = null;

            public Builder() {
            }

            public Builder(Writefilter config) {
                this.attribute(new Attribute.Builder(config.attribute()));
                this.memorylimit(config.memorylimit());
                this.disklimit(config.disklimit());
                this.sampleinterval(config.sampleinterval());
            }

            private Builder override(Builder __superior) {
                this.attribute(this.attribute.override(__superior.attribute));
                if (__superior.memorylimit != null) {
                    this.memorylimit(__superior.memorylimit);
                }
                if (__superior.disklimit != null) {
                    this.disklimit(__superior.disklimit);
                }
                if (__superior.sampleinterval != null) {
                    this.sampleinterval(__superior.sampleinterval);
                }
                return this;
            }

            public Builder attribute(Attribute.Builder __builder) {
                this.attribute = __builder;
                return this;
            }

            public Builder attribute(Consumer<Attribute.Builder> __func) {
                Attribute.Builder __inner = new Attribute.Builder();
                __func.accept(__inner);
                this.attribute = __inner;
                return this;
            }

            public Builder memorylimit(double __value) {
                this.memorylimit = __value;
                return this;
            }

            private Builder memorylimit(String __value) {
                return this.memorylimit(Double.valueOf(__value));
            }

            public Builder disklimit(double __value) {
                this.disklimit = __value;
                return this;
            }

            private Builder disklimit(String __value) {
                return this.disklimit(Double.valueOf(__value));
            }

            public Builder sampleinterval(double __value) {
                this.sampleinterval = __value;
                return this;
            }

            private Builder sampleinterval(String __value) {
                return this.sampleinterval(Double.valueOf(__value));
            }

            public Writefilter build() {
                return new Writefilter(this);
            }
        }
    }

    public static final class Initialize
    extends InnerNode {
        private final IntegerNode threads;

        public Initialize(Builder builder) {
            this(builder, true);
        }

        private Initialize(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.initialize must be initialized: " + builder.__uninitialized);
            }
            this.threads = builder.threads == null ? new IntegerNode(0) : new IntegerNode(builder.threads.intValue());
        }

        public int threads() {
            return this.threads.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Initialize newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("initialize");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer threads = null;

            public Builder() {
            }

            public Builder(Initialize config) {
                this.threads(config.threads());
            }

            private Builder override(Builder __superior) {
                if (__superior.threads != null) {
                    this.threads(__superior.threads);
                }
                return this;
            }

            public Builder threads(int __value) {
                this.threads = __value;
                return this;
            }

            private Builder threads(String __value) {
                return this.threads(Integer.valueOf(__value));
            }

            public Initialize build() {
                return new Initialize(this);
            }
        }
    }

    public static final class Visit
    extends InnerNode {
        private final LongNode defaultserializedsize;
        private final BooleanNode ignoremaxbytes;

        public Visit(Builder builder) {
            this(builder, true);
        }

        private Visit(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.visit must be initialized: " + builder.__uninitialized);
            }
            this.defaultserializedsize = builder.defaultserializedsize == null ? new LongNode(1L) : new LongNode(builder.defaultserializedsize.longValue());
            this.ignoremaxbytes = builder.ignoremaxbytes == null ? new BooleanNode(true) : new BooleanNode(builder.ignoremaxbytes.booleanValue());
        }

        public long defaultserializedsize() {
            return this.defaultserializedsize.value();
        }

        public boolean ignoremaxbytes() {
            return this.ignoremaxbytes.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Visit newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("visit");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Long defaultserializedsize = null;
            private Boolean ignoremaxbytes = null;

            public Builder() {
            }

            public Builder(Visit config) {
                this.defaultserializedsize(config.defaultserializedsize());
                this.ignoremaxbytes(config.ignoremaxbytes());
            }

            private Builder override(Builder __superior) {
                if (__superior.defaultserializedsize != null) {
                    this.defaultserializedsize(__superior.defaultserializedsize);
                }
                if (__superior.ignoremaxbytes != null) {
                    this.ignoremaxbytes(__superior.ignoremaxbytes);
                }
                return this;
            }

            public Builder defaultserializedsize(long __value) {
                this.defaultserializedsize = __value;
                return this;
            }

            private Builder defaultserializedsize(String __value) {
                return this.defaultserializedsize(Long.valueOf(__value));
            }

            public Builder ignoremaxbytes(boolean __value) {
                this.ignoremaxbytes = __value;
                return this;
            }

            private Builder ignoremaxbytes(String __value) {
                return this.ignoremaxbytes(Boolean.valueOf(__value));
            }

            public Visit build() {
                return new Visit(this);
            }
        }
    }

    public static final class Bucketmove
    extends InnerNode {
        private final IntegerNode maxdocstomoveperbucket;

        public Bucketmove(Builder builder) {
            this(builder, true);
        }

        private Bucketmove(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.bucketmove must be initialized: " + builder.__uninitialized);
            }
            this.maxdocstomoveperbucket = builder.maxdocstomoveperbucket == null ? new IntegerNode(1) : new IntegerNode(builder.maxdocstomoveperbucket.intValue());
        }

        public int maxdocstomoveperbucket() {
            return this.maxdocstomoveperbucket.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Bucketmove newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("bucketmove");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer maxdocstomoveperbucket = null;

            public Builder() {
            }

            public Builder(Bucketmove config) {
                this.maxdocstomoveperbucket(config.maxdocstomoveperbucket());
            }

            private Builder override(Builder __superior) {
                if (__superior.maxdocstomoveperbucket != null) {
                    this.maxdocstomoveperbucket(__superior.maxdocstomoveperbucket);
                }
                return this;
            }

            public Builder maxdocstomoveperbucket(int __value) {
                this.maxdocstomoveperbucket = __value;
                return this;
            }

            private Builder maxdocstomoveperbucket(String __value) {
                return this.maxdocstomoveperbucket(Integer.valueOf(__value));
            }

            public Bucketmove build() {
                return new Bucketmove(this);
            }
        }
    }

    public static final class Lidspacecompaction
    extends InnerNode {
        private final DoubleNode interval;
        private final IntegerNode allowedlidbloat;
        private final DoubleNode allowedlidbloatfactor;
        private final DoubleNode removebatchblockdelay;
        private final DoubleNode removebatchblockrate;
        private final DoubleNode removeblockrate;

        public Lidspacecompaction(Builder builder) {
            this(builder, true);
        }

        private Lidspacecompaction(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.lidspacecompaction must be initialized: " + builder.__uninitialized);
            }
            this.interval = builder.interval == null ? new DoubleNode(10.0) : new DoubleNode(builder.interval.doubleValue());
            this.allowedlidbloat = builder.allowedlidbloat == null ? new IntegerNode(1) : new IntegerNode(builder.allowedlidbloat.intValue());
            this.allowedlidbloatfactor = builder.allowedlidbloatfactor == null ? new DoubleNode(0.01) : new DoubleNode(builder.allowedlidbloatfactor.doubleValue());
            this.removebatchblockdelay = builder.removebatchblockdelay == null ? new DoubleNode(2.0) : new DoubleNode(builder.removebatchblockdelay.doubleValue());
            this.removebatchblockrate = builder.removebatchblockrate == null ? new DoubleNode(0.5) : new DoubleNode(builder.removebatchblockrate.doubleValue());
            this.removeblockrate = builder.removeblockrate == null ? new DoubleNode(100.0) : new DoubleNode(builder.removeblockrate.doubleValue());
        }

        public double interval() {
            return this.interval.value();
        }

        public int allowedlidbloat() {
            return this.allowedlidbloat.value();
        }

        public double allowedlidbloatfactor() {
            return this.allowedlidbloatfactor.value();
        }

        public double removebatchblockdelay() {
            return this.removebatchblockdelay.value();
        }

        public double removebatchblockrate() {
            return this.removebatchblockrate.value();
        }

        public double removeblockrate() {
            return this.removeblockrate.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Lidspacecompaction newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("lidspacecompaction");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double interval = null;
            private Integer allowedlidbloat = null;
            private Double allowedlidbloatfactor = null;
            private Double removebatchblockdelay = null;
            private Double removebatchblockrate = null;
            private Double removeblockrate = null;

            public Builder() {
            }

            public Builder(Lidspacecompaction config) {
                this.interval(config.interval());
                this.allowedlidbloat(config.allowedlidbloat());
                this.allowedlidbloatfactor(config.allowedlidbloatfactor());
                this.removebatchblockdelay(config.removebatchblockdelay());
                this.removebatchblockrate(config.removebatchblockrate());
                this.removeblockrate(config.removeblockrate());
            }

            private Builder override(Builder __superior) {
                if (__superior.interval != null) {
                    this.interval(__superior.interval);
                }
                if (__superior.allowedlidbloat != null) {
                    this.allowedlidbloat(__superior.allowedlidbloat);
                }
                if (__superior.allowedlidbloatfactor != null) {
                    this.allowedlidbloatfactor(__superior.allowedlidbloatfactor);
                }
                if (__superior.removebatchblockdelay != null) {
                    this.removebatchblockdelay(__superior.removebatchblockdelay);
                }
                if (__superior.removebatchblockrate != null) {
                    this.removebatchblockrate(__superior.removebatchblockrate);
                }
                if (__superior.removeblockrate != null) {
                    this.removeblockrate(__superior.removeblockrate);
                }
                return this;
            }

            public Builder interval(double __value) {
                this.interval = __value;
                return this;
            }

            private Builder interval(String __value) {
                return this.interval(Double.valueOf(__value));
            }

            public Builder allowedlidbloat(int __value) {
                this.allowedlidbloat = __value;
                return this;
            }

            private Builder allowedlidbloat(String __value) {
                return this.allowedlidbloat(Integer.valueOf(__value));
            }

            public Builder allowedlidbloatfactor(double __value) {
                this.allowedlidbloatfactor = __value;
                return this;
            }

            private Builder allowedlidbloatfactor(String __value) {
                return this.allowedlidbloatfactor(Double.valueOf(__value));
            }

            public Builder removebatchblockdelay(double __value) {
                this.removebatchblockdelay = __value;
                return this;
            }

            private Builder removebatchblockdelay(String __value) {
                return this.removebatchblockdelay(Double.valueOf(__value));
            }

            public Builder removebatchblockrate(double __value) {
                this.removebatchblockrate = __value;
                return this;
            }

            private Builder removebatchblockrate(String __value) {
                return this.removebatchblockrate(Double.valueOf(__value));
            }

            public Builder removeblockrate(double __value) {
                this.removeblockrate = __value;
                return this;
            }

            private Builder removeblockrate(String __value) {
                return this.removeblockrate(Double.valueOf(__value));
            }

            public Lidspacecompaction build() {
                return new Lidspacecompaction(this);
            }
        }
    }

    public static final class Packetcompresstype
    extends EnumNode<Enum> {
        public static final Enum NONE = Enum.NONE;
        public static final Enum LZ4 = Enum.LZ4;

        public Packetcompresstype() {
            this.value = null;
        }

        public Packetcompresstype(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            NONE,
            LZ4;

        }
    }

    public static final class Filedistributor
    extends InnerNode {
        private final ReferenceNode configid;

        public Filedistributor(Builder builder) {
            this(builder, true);
        }

        private Filedistributor(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.filedistributor must be initialized: " + builder.__uninitialized);
            }
            this.configid = builder.configid == null ? new ReferenceNode(ProtonConfig.CONFIG_DEF_VERSION) : new ReferenceNode(builder.configid);
        }

        public String configid() {
            return this.configid.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Filedistributor newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("filedistributor");
            changes.compare((Node)this.configid, (Node)newConfig.configid, "configid", "filedistributor rpc configuration");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String configid = null;

            public Builder() {
            }

            public Builder(Filedistributor config) {
                this.configid(config.configid());
            }

            private Builder override(Builder __superior) {
                if (__superior.configid != null) {
                    this.configid(__superior.configid);
                }
                return this;
            }

            public Builder configid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configid = __value;
                return this;
            }

            public Filedistributor build() {
                return new Filedistributor(this);
            }
        }
    }

    public static final class Periodic
    extends InnerNode {
        private final DoubleNode interval;

        public Periodic(Builder builder) {
            this(builder, true);
        }

        private Periodic(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.periodic must be initialized: " + builder.__uninitialized);
            }
            this.interval = builder.interval == null ? new DoubleNode(3600.0) : new DoubleNode(builder.interval.doubleValue());
        }

        public double interval() {
            return this.interval.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Periodic newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("periodic");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Double interval = null;

            public Builder() {
            }

            public Builder(Periodic config) {
                this.interval(config.interval());
            }

            private Builder override(Builder __superior) {
                if (__superior.interval != null) {
                    this.interval(__superior.interval);
                }
                return this;
            }

            public Builder interval(double __value) {
                this.interval = __value;
                return this;
            }

            private Builder interval(String __value) {
                return this.interval(Double.valueOf(__value));
            }

            public Periodic build() {
                return new Periodic(this);
            }
        }
    }

    public static final class Documentdb
    extends InnerNode {
        private final StringNode inputdoctypename;
        private final Mode mode;
        private final StringNode configid;
        private final DoubleNode visibilitydelay;
        private final BooleanNode global;
        private final Feeding feeding;
        private final Allocation allocation;

        public Documentdb(Builder builder) {
            this(builder, true);
        }

        private Documentdb(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.documentdb[] must be initialized: " + builder.__uninitialized);
            }
            this.inputdoctypename = builder.inputdoctypename == null ? new StringNode() : new StringNode(builder.inputdoctypename);
            this.mode = builder.mode == null ? new Mode(Mode.INDEX) : new Mode(builder.mode);
            this.configid = builder.configid == null ? new StringNode() : new StringNode(builder.configid);
            this.visibilitydelay = builder.visibilitydelay == null ? new DoubleNode(0.0) : new DoubleNode(builder.visibilitydelay.doubleValue());
            this.global = builder.global == null ? new BooleanNode(false) : new BooleanNode(builder.global.booleanValue());
            this.feeding = new Feeding(builder.feeding, throwIfUninitialized);
            this.allocation = new Allocation(builder.allocation, throwIfUninitialized);
        }

        public String inputdoctypename() {
            return this.inputdoctypename.value();
        }

        public Mode.Enum mode() {
            return (Mode.Enum)((Object)this.mode.value());
        }

        public String configid() {
            return this.configid.value();
        }

        public double visibilitydelay() {
            return this.visibilitydelay.value();
        }

        public boolean global() {
            return this.global.value();
        }

        public Feeding feeding() {
            return this.feeding;
        }

        public Allocation allocation() {
            return this.allocation;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Documentdb newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("documentdb");
            return changes;
        }

        private static InnerNodeVector<Documentdb> createVector(List<Builder> builders) {
            ArrayList<Documentdb> elems = new ArrayList<Documentdb>();
            for (Builder b : builders) {
                elems.add(new Documentdb(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Allocation
        extends InnerNode {
            private final LongNode initialnumdocs;
            private final DoubleNode growfactor;
            private final IntegerNode growbias;
            private final IntegerNode amortizecount;
            private final DoubleNode multivaluegrowfactor;
            private final DoubleNode max_dead_bytes_ratio;
            private final DoubleNode max_dead_address_space_ratio;
            private final IntegerNode max_compact_buffers;
            private final DoubleNode active_buffers_ratio;

            public Allocation(Builder builder) {
                this(builder, true);
            }

            private Allocation(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.documentdb[].allocation must be initialized: " + builder.__uninitialized);
                }
                this.initialnumdocs = builder.initialnumdocs == null ? new LongNode(1024L) : new LongNode(builder.initialnumdocs.longValue());
                this.growfactor = builder.growfactor == null ? new DoubleNode(0.2) : new DoubleNode(builder.growfactor.doubleValue());
                this.growbias = builder.growbias == null ? new IntegerNode(1) : new IntegerNode(builder.growbias.intValue());
                this.amortizecount = builder.amortizecount == null ? new IntegerNode(10000) : new IntegerNode(builder.amortizecount.intValue());
                this.multivaluegrowfactor = builder.multivaluegrowfactor == null ? new DoubleNode(0.2) : new DoubleNode(builder.multivaluegrowfactor.doubleValue());
                this.max_dead_bytes_ratio = builder.max_dead_bytes_ratio == null ? new DoubleNode(0.05) : new DoubleNode(builder.max_dead_bytes_ratio.doubleValue());
                this.max_dead_address_space_ratio = builder.max_dead_address_space_ratio == null ? new DoubleNode(0.2) : new DoubleNode(builder.max_dead_address_space_ratio.doubleValue());
                this.max_compact_buffers = builder.max_compact_buffers == null ? new IntegerNode(1) : new IntegerNode(builder.max_compact_buffers.intValue());
                this.active_buffers_ratio = builder.active_buffers_ratio == null ? new DoubleNode(0.1) : new DoubleNode(builder.active_buffers_ratio.doubleValue());
            }

            public long initialnumdocs() {
                return this.initialnumdocs.value();
            }

            public double growfactor() {
                return this.growfactor.value();
            }

            public int growbias() {
                return this.growbias.value();
            }

            public int amortizecount() {
                return this.amortizecount.value();
            }

            public double multivaluegrowfactor() {
                return this.multivaluegrowfactor.value();
            }

            public double max_dead_bytes_ratio() {
                return this.max_dead_bytes_ratio.value();
            }

            public double max_dead_address_space_ratio() {
                return this.max_dead_address_space_ratio.value();
            }

            public int max_compact_buffers() {
                return this.max_compact_buffers.value();
            }

            public double active_buffers_ratio() {
                return this.active_buffers_ratio.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Allocation newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("allocation");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long initialnumdocs = null;
                private Double growfactor = null;
                private Integer growbias = null;
                private Integer amortizecount = null;
                private Double multivaluegrowfactor = null;
                private Double max_dead_bytes_ratio = null;
                private Double max_dead_address_space_ratio = null;
                private Integer max_compact_buffers = null;
                private Double active_buffers_ratio = null;

                public Builder() {
                }

                public Builder(Allocation config) {
                    this.initialnumdocs(config.initialnumdocs());
                    this.growfactor(config.growfactor());
                    this.growbias(config.growbias());
                    this.amortizecount(config.amortizecount());
                    this.multivaluegrowfactor(config.multivaluegrowfactor());
                    this.max_dead_bytes_ratio(config.max_dead_bytes_ratio());
                    this.max_dead_address_space_ratio(config.max_dead_address_space_ratio());
                    this.max_compact_buffers(config.max_compact_buffers());
                    this.active_buffers_ratio(config.active_buffers_ratio());
                }

                private Builder override(Builder __superior) {
                    if (__superior.initialnumdocs != null) {
                        this.initialnumdocs(__superior.initialnumdocs);
                    }
                    if (__superior.growfactor != null) {
                        this.growfactor(__superior.growfactor);
                    }
                    if (__superior.growbias != null) {
                        this.growbias(__superior.growbias);
                    }
                    if (__superior.amortizecount != null) {
                        this.amortizecount(__superior.amortizecount);
                    }
                    if (__superior.multivaluegrowfactor != null) {
                        this.multivaluegrowfactor(__superior.multivaluegrowfactor);
                    }
                    if (__superior.max_dead_bytes_ratio != null) {
                        this.max_dead_bytes_ratio(__superior.max_dead_bytes_ratio);
                    }
                    if (__superior.max_dead_address_space_ratio != null) {
                        this.max_dead_address_space_ratio(__superior.max_dead_address_space_ratio);
                    }
                    if (__superior.max_compact_buffers != null) {
                        this.max_compact_buffers(__superior.max_compact_buffers);
                    }
                    if (__superior.active_buffers_ratio != null) {
                        this.active_buffers_ratio(__superior.active_buffers_ratio);
                    }
                    return this;
                }

                public Builder initialnumdocs(long __value) {
                    this.initialnumdocs = __value;
                    return this;
                }

                private Builder initialnumdocs(String __value) {
                    return this.initialnumdocs(Long.valueOf(__value));
                }

                public Builder growfactor(double __value) {
                    this.growfactor = __value;
                    return this;
                }

                private Builder growfactor(String __value) {
                    return this.growfactor(Double.valueOf(__value));
                }

                public Builder growbias(int __value) {
                    this.growbias = __value;
                    return this;
                }

                private Builder growbias(String __value) {
                    return this.growbias(Integer.valueOf(__value));
                }

                public Builder amortizecount(int __value) {
                    this.amortizecount = __value;
                    return this;
                }

                private Builder amortizecount(String __value) {
                    return this.amortizecount(Integer.valueOf(__value));
                }

                public Builder multivaluegrowfactor(double __value) {
                    this.multivaluegrowfactor = __value;
                    return this;
                }

                private Builder multivaluegrowfactor(String __value) {
                    return this.multivaluegrowfactor(Double.valueOf(__value));
                }

                public Builder max_dead_bytes_ratio(double __value) {
                    this.max_dead_bytes_ratio = __value;
                    return this;
                }

                private Builder max_dead_bytes_ratio(String __value) {
                    return this.max_dead_bytes_ratio(Double.valueOf(__value));
                }

                public Builder max_dead_address_space_ratio(double __value) {
                    this.max_dead_address_space_ratio = __value;
                    return this;
                }

                private Builder max_dead_address_space_ratio(String __value) {
                    return this.max_dead_address_space_ratio(Double.valueOf(__value));
                }

                public Builder max_compact_buffers(int __value) {
                    this.max_compact_buffers = __value;
                    return this;
                }

                private Builder max_compact_buffers(String __value) {
                    return this.max_compact_buffers(Integer.valueOf(__value));
                }

                public Builder active_buffers_ratio(double __value) {
                    this.active_buffers_ratio = __value;
                    return this;
                }

                private Builder active_buffers_ratio(String __value) {
                    return this.active_buffers_ratio(Double.valueOf(__value));
                }

                public Allocation build() {
                    return new Allocation(this);
                }
            }
        }

        public static final class Feeding
        extends InnerNode {
            private final DoubleNode concurrency;

            public Feeding(Builder builder) {
                this(builder, true);
            }

            private Feeding(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.documentdb[].feeding must be initialized: " + builder.__uninitialized);
                }
                this.concurrency = builder.concurrency == null ? new DoubleNode(0.2) : new DoubleNode(builder.concurrency.doubleValue());
            }

            public double concurrency() {
                return this.concurrency.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Feeding newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("feeding");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double concurrency = null;

                public Builder() {
                }

                public Builder(Feeding config) {
                    this.concurrency(config.concurrency());
                }

                private Builder override(Builder __superior) {
                    if (__superior.concurrency != null) {
                        this.concurrency(__superior.concurrency);
                    }
                    return this;
                }

                public Builder concurrency(double __value) {
                    this.concurrency = __value;
                    return this;
                }

                private Builder concurrency(String __value) {
                    return this.concurrency(Double.valueOf(__value));
                }

                public Feeding build() {
                    return new Feeding(this);
                }
            }
        }

        public static final class Mode
        extends EnumNode<Enum> {
            public static final Enum INDEX = Enum.INDEX;
            public static final Enum STREAMING = Enum.STREAMING;
            public static final Enum STORE_ONLY = Enum.STORE_ONLY;

            public Mode() {
                this.value = null;
            }

            public Mode(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                INDEX,
                STREAMING,
                STORE_ONLY;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("inputdoctypename", "configid"));
            private String inputdoctypename = null;
            private Mode.Enum mode = null;
            private String configid = null;
            private Double visibilitydelay = null;
            private Boolean global = null;
            public Feeding.Builder feeding = new Feeding.Builder();
            public Allocation.Builder allocation = new Allocation.Builder();

            public Builder() {
            }

            public Builder(Documentdb config) {
                this.inputdoctypename(config.inputdoctypename());
                this.mode(config.mode());
                this.configid(config.configid());
                this.visibilitydelay(config.visibilitydelay());
                this.global(config.global());
                this.feeding(new Feeding.Builder(config.feeding()));
                this.allocation(new Allocation.Builder(config.allocation()));
            }

            private Builder override(Builder __superior) {
                if (__superior.inputdoctypename != null) {
                    this.inputdoctypename(__superior.inputdoctypename);
                }
                if (__superior.mode != null) {
                    this.mode(__superior.mode);
                }
                if (__superior.configid != null) {
                    this.configid(__superior.configid);
                }
                if (__superior.visibilitydelay != null) {
                    this.visibilitydelay(__superior.visibilitydelay);
                }
                if (__superior.global != null) {
                    this.global(__superior.global);
                }
                this.feeding(this.feeding.override(__superior.feeding));
                this.allocation(this.allocation.override(__superior.allocation));
                return this;
            }

            public Builder inputdoctypename(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.inputdoctypename = __value;
                this.__uninitialized.remove("inputdoctypename");
                return this;
            }

            public Builder mode(Mode.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.mode = __value;
                return this;
            }

            private Builder mode(String __value) {
                return this.mode(Mode.Enum.valueOf(__value));
            }

            public Builder configid(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.configid = __value;
                this.__uninitialized.remove("configid");
                return this;
            }

            public Builder visibilitydelay(double __value) {
                this.visibilitydelay = __value;
                return this;
            }

            private Builder visibilitydelay(String __value) {
                return this.visibilitydelay(Double.valueOf(__value));
            }

            public Builder global(boolean __value) {
                this.global = __value;
                return this;
            }

            private Builder global(String __value) {
                return this.global(Boolean.valueOf(__value));
            }

            public Builder feeding(Feeding.Builder __builder) {
                this.feeding = __builder;
                return this;
            }

            public Builder feeding(Consumer<Feeding.Builder> __func) {
                Feeding.Builder __inner = new Feeding.Builder();
                __func.accept(__inner);
                this.feeding = __inner;
                return this;
            }

            public Builder allocation(Allocation.Builder __builder) {
                this.allocation = __builder;
                return this;
            }

            public Builder allocation(Consumer<Allocation.Builder> __func) {
                Allocation.Builder __inner = new Allocation.Builder();
                __func.accept(__inner);
                this.allocation = __inner;
                return this;
            }

            public Documentdb build() {
                return new Documentdb(this);
            }
        }
    }

    public static final class Summary
    extends InnerNode {
        private final Cache cache;
        private final Log log;
        private final Write write;
        private final Read read;

        public Summary(Builder builder) {
            this(builder, true);
        }

        private Summary(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.summary must be initialized: " + builder.__uninitialized);
            }
            this.cache = new Cache(builder.cache, throwIfUninitialized);
            this.log = new Log(builder.log, throwIfUninitialized);
            this.write = new Write(builder.write, throwIfUninitialized);
            this.read = new Read(builder.read, throwIfUninitialized);
        }

        public Cache cache() {
            return this.cache;
        }

        public Log log() {
            return this.log;
        }

        public Write write() {
            return this.write;
        }

        public Read read() {
            return this.read;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Summary newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("summary");
            changes.mergeChanges("cache", this.cache.getChangesRequiringRestart(newConfig.cache));
            changes.mergeChanges("read", this.read.getChangesRequiringRestart(newConfig.read));
            return changes;
        }

        public static final class Read
        extends InnerNode {
            private final Io io;
            private final Mmap mmap;

            public Read(Builder builder) {
                this(builder, true);
            }

            private Read(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.summary.read must be initialized: " + builder.__uninitialized);
                }
                this.io = builder.io == null ? new Io(Io.MMAP) : new Io(builder.io);
                this.mmap = new Mmap(builder.mmap, throwIfUninitialized);
            }

            public Io.Enum io() {
                return (Io.Enum)((Object)this.io.value());
            }

            public Mmap mmap() {
                return this.mmap;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Read newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("read");
                changes.compare((Node)this.io, (Node)newConfig.io, "io", "Control io options during read of stored documents.\nAll summary.read options will take effect immediately on new files written.\nOn old files it will take effect either upon compact or on restart.");
                changes.mergeChanges("mmap", this.mmap.getChangesRequiringRestart(newConfig.mmap));
                return changes;
            }

            public static final class Mmap
            extends InnerNode {
                private final LeafNodeVector<Options.Enum, Options> options;
                private final Advise advise;

                public Mmap(Builder builder) {
                    this(builder, true);
                }

                private Mmap(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.summary.read.mmap must be initialized: " + builder.__uninitialized);
                    }
                    this.options = new LeafNodeVector(builder.options, (LeafNode)new Options());
                    this.advise = builder.advise == null ? new Advise(Advise.NORMAL) : new Advise(builder.advise);
                }

                public List<Options.Enum> options() {
                    return this.options.asList();
                }

                public Options.Enum options(int i) {
                    return (Options.Enum)((Object)((Options)((Object)this.options.get(i))).value());
                }

                public Advise.Enum advise() {
                    return (Advise.Enum)((Object)this.advise.value());
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Mmap newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("mmap");
                    changes.compareArray(this.options, newConfig.options, "options", "Multiple optional options for use with mmap", (a, b) -> new ChangesRequiringRestart("options").compare(a, b, ProtonConfig.CONFIG_DEF_VERSION, "Multiple optional options for use with mmap"));
                    changes.compare((Node)this.advise, (Node)newConfig.advise, "advise", "Advise to give to os when mapping memory.");
                    return changes;
                }

                public static final class Advise
                extends EnumNode<Enum> {
                    public static final Enum NORMAL = Enum.NORMAL;
                    public static final Enum RANDOM = Enum.RANDOM;
                    public static final Enum SEQUENTIAL = Enum.SEQUENTIAL;

                    public Advise() {
                        this.value = null;
                    }

                    public Advise(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        NORMAL,
                        RANDOM,
                        SEQUENTIAL;

                    }
                }

                public static final class Options
                extends EnumNode<Enum> {
                    public static final Enum POPULATE = Enum.POPULATE;
                    public static final Enum HUGETLB = Enum.HUGETLB;

                    public Options() {
                        this.value = null;
                    }

                    public Options(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        POPULATE,
                        HUGETLB;

                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public List<Options.Enum> options = new ArrayList<Options.Enum>();
                    private Advise.Enum advise = null;

                    public Builder() {
                    }

                    public Builder(Mmap config) {
                        this.options(config.options());
                        this.advise(config.advise());
                    }

                    private Builder override(Builder __superior) {
                        if (!__superior.options.isEmpty()) {
                            this.options.addAll(__superior.options);
                        }
                        if (__superior.advise != null) {
                            this.advise(__superior.advise);
                        }
                        return this;
                    }

                    public Builder options(Options.Enum __value) {
                        this.options.add(__value);
                        return this;
                    }

                    public Builder options(Collection<Options.Enum> __values) {
                        this.options.addAll(__values);
                        return this;
                    }

                    private Builder options(String __value) {
                        return this.options(Options.Enum.valueOf(__value));
                    }

                    public Builder advise(Advise.Enum __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.advise = __value;
                        return this;
                    }

                    private Builder advise(String __value) {
                        return this.advise(Advise.Enum.valueOf(__value));
                    }

                    public Mmap build() {
                        return new Mmap(this);
                    }
                }
            }

            public static final class Io
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum DIRECTIO = Enum.DIRECTIO;
                public static final Enum MMAP = Enum.MMAP;

                public Io() {
                    this.value = null;
                }

                public Io(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    DIRECTIO,
                    MMAP;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Io.Enum io = null;
                public Mmap.Builder mmap = new Mmap.Builder();

                public Builder() {
                }

                public Builder(Read config) {
                    this.io(config.io());
                    this.mmap(new Mmap.Builder(config.mmap()));
                }

                private Builder override(Builder __superior) {
                    if (__superior.io != null) {
                        this.io(__superior.io);
                    }
                    this.mmap(this.mmap.override(__superior.mmap));
                    return this;
                }

                public Builder io(Io.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.io = __value;
                    return this;
                }

                private Builder io(String __value) {
                    return this.io(Io.Enum.valueOf(__value));
                }

                public Builder mmap(Mmap.Builder __builder) {
                    this.mmap = __builder;
                    return this;
                }

                public Builder mmap(Consumer<Mmap.Builder> __func) {
                    Mmap.Builder __inner = new Mmap.Builder();
                    __func.accept(__inner);
                    this.mmap = __inner;
                    return this;
                }

                public Read build() {
                    return new Read(this);
                }
            }
        }

        public static final class Write
        extends InnerNode {
            private final Io io;

            public Write(Builder builder) {
                this(builder, true);
            }

            private Write(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.summary.write must be initialized: " + builder.__uninitialized);
                }
                this.io = builder.io == null ? new Io(Io.DIRECTIO) : new Io(builder.io);
            }

            public Io.Enum io() {
                return (Io.Enum)((Object)this.io.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
                return changes;
            }

            public static final class Io
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum OSYNC = Enum.OSYNC;
                public static final Enum DIRECTIO = Enum.DIRECTIO;

                public Io() {
                    this.value = null;
                }

                public Io(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    OSYNC,
                    DIRECTIO;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Io.Enum io = null;

                public Builder() {
                }

                public Builder(Write config) {
                    this.io(config.io());
                }

                private Builder override(Builder __superior) {
                    if (__superior.io != null) {
                        this.io(__superior.io);
                    }
                    return this;
                }

                public Builder io(Io.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.io = __value;
                    return this;
                }

                private Builder io(String __value) {
                    return this.io(Io.Enum.valueOf(__value));
                }

                public Write build() {
                    return new Write(this);
                }
            }
        }

        public static final class Log
        extends InnerNode {
            private final Compact compact;
            private final Chunk chunk;
            private final LongNode maxfilesize;
            private final IntegerNode maxnumlids;
            private final DoubleNode maxdiskbloatfactor;
            private final DoubleNode maxbucketspread;
            private final DoubleNode minfilesizefactor;

            public Log(Builder builder) {
                this(builder, true);
            }

            private Log(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.summary.log must be initialized: " + builder.__uninitialized);
                }
                this.compact = new Compact(builder.compact, throwIfUninitialized);
                this.chunk = new Chunk(builder.chunk, throwIfUninitialized);
                this.maxfilesize = builder.maxfilesize == null ? new LongNode(1000000000L) : new LongNode(builder.maxfilesize.longValue());
                this.maxnumlids = builder.maxnumlids == null ? new IntegerNode(40000000) : new IntegerNode(builder.maxnumlids.intValue());
                this.maxdiskbloatfactor = builder.maxdiskbloatfactor == null ? new DoubleNode(0.1) : new DoubleNode(builder.maxdiskbloatfactor.doubleValue());
                this.maxbucketspread = builder.maxbucketspread == null ? new DoubleNode(2.5) : new DoubleNode(builder.maxbucketspread.doubleValue());
                this.minfilesizefactor = builder.minfilesizefactor == null ? new DoubleNode(0.2) : new DoubleNode(builder.minfilesizefactor.doubleValue());
            }

            public Compact compact() {
                return this.compact;
            }

            public Chunk chunk() {
                return this.chunk;
            }

            public long maxfilesize() {
                return this.maxfilesize.value();
            }

            public int maxnumlids() {
                return this.maxnumlids.value();
            }

            public double maxdiskbloatfactor() {
                return this.maxdiskbloatfactor.value();
            }

            public double maxbucketspread() {
                return this.maxbucketspread.value();
            }

            public double minfilesizefactor() {
                return this.minfilesizefactor.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Log newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("log");
                return changes;
            }

            public static final class Chunk
            extends InnerNode {
                private final Compression compression;
                private final IntegerNode maxbytes;
                private final BooleanNode skipcrconread;

                public Chunk(Builder builder) {
                    this(builder, true);
                }

                private Chunk(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.summary.log.chunk must be initialized: " + builder.__uninitialized);
                    }
                    this.compression = new Compression(builder.compression, throwIfUninitialized);
                    this.maxbytes = builder.maxbytes == null ? new IntegerNode(65536) : new IntegerNode(builder.maxbytes.intValue());
                    this.skipcrconread = builder.skipcrconread == null ? new BooleanNode(false) : new BooleanNode(builder.skipcrconread.booleanValue());
                }

                public Compression compression() {
                    return this.compression;
                }

                public int maxbytes() {
                    return this.maxbytes.value();
                }

                public boolean skipcrconread() {
                    return this.skipcrconread.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Chunk newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("chunk");
                    return changes;
                }

                public static final class Compression
                extends InnerNode {
                    private final Type type;
                    private final IntegerNode level;

                    public Compression(Builder builder) {
                        this(builder, true);
                    }

                    private Compression(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for proton.summary.log.chunk.compression must be initialized: " + builder.__uninitialized);
                        }
                        this.type = builder.type == null ? new Type(Type.ZSTD) : new Type(builder.type);
                        this.level = builder.level == null ? new IntegerNode(9) : new IntegerNode(builder.level.intValue());
                    }

                    public Type.Enum type() {
                        return (Type.Enum)((Object)this.type.value());
                    }

                    public int level() {
                        return this.level.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
                        return changes;
                    }

                    public static final class Type
                    extends EnumNode<Enum> {
                        public static final Enum NONE = Enum.NONE;
                        public static final Enum LZ4 = Enum.LZ4;
                        public static final Enum ZSTD = Enum.ZSTD;

                        public Type() {
                            this.value = null;
                        }

                        public Type(Enum enumValue) {
                            super(enumValue != null);
                            this.value = enumValue;
                        }

                        protected boolean doSetValue(String name) {
                            try {
                                this.value = Enum.valueOf(name);
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return false;
                            }
                        }

                        public static enum Enum {
                            NONE,
                            LZ4,
                            ZSTD;

                        }
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Type.Enum type = null;
                        private Integer level = null;

                        public Builder() {
                        }

                        public Builder(Compression config) {
                            this.type(config.type());
                            this.level(config.level());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.type != null) {
                                this.type(__superior.type);
                            }
                            if (__superior.level != null) {
                                this.level(__superior.level);
                            }
                            return this;
                        }

                        public Builder type(Type.Enum __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.type = __value;
                            return this;
                        }

                        private Builder type(String __value) {
                            return this.type(Type.Enum.valueOf(__value));
                        }

                        public Builder level(int __value) {
                            this.level = __value;
                            return this;
                        }

                        private Builder level(String __value) {
                            return this.level(Integer.valueOf(__value));
                        }

                        public Compression build() {
                            return new Compression(this);
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Compression.Builder compression = new Compression.Builder();
                    private Integer maxbytes = null;
                    private Boolean skipcrconread = null;

                    public Builder() {
                    }

                    public Builder(Chunk config) {
                        this.compression(new Compression.Builder(config.compression()));
                        this.maxbytes(config.maxbytes());
                        this.skipcrconread(config.skipcrconread());
                    }

                    private Builder override(Builder __superior) {
                        this.compression(this.compression.override(__superior.compression));
                        if (__superior.maxbytes != null) {
                            this.maxbytes(__superior.maxbytes);
                        }
                        if (__superior.skipcrconread != null) {
                            this.skipcrconread(__superior.skipcrconread);
                        }
                        return this;
                    }

                    public Builder compression(Compression.Builder __builder) {
                        this.compression = __builder;
                        return this;
                    }

                    public Builder compression(Consumer<Compression.Builder> __func) {
                        Compression.Builder __inner = new Compression.Builder();
                        __func.accept(__inner);
                        this.compression = __inner;
                        return this;
                    }

                    public Builder maxbytes(int __value) {
                        this.maxbytes = __value;
                        return this;
                    }

                    private Builder maxbytes(String __value) {
                        return this.maxbytes(Integer.valueOf(__value));
                    }

                    public Builder skipcrconread(boolean __value) {
                        this.skipcrconread = __value;
                        return this;
                    }

                    private Builder skipcrconread(String __value) {
                        return this.skipcrconread(Boolean.valueOf(__value));
                    }

                    public Chunk build() {
                        return new Chunk(this);
                    }
                }
            }

            public static final class Compact
            extends InnerNode {
                private final Compression compression;

                public Compact(Builder builder) {
                    this(builder, true);
                }

                private Compact(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.summary.log.compact must be initialized: " + builder.__uninitialized);
                    }
                    this.compression = new Compression(builder.compression, throwIfUninitialized);
                }

                public Compression compression() {
                    return this.compression;
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Compact newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("compact");
                    return changes;
                }

                public static final class Compression
                extends InnerNode {
                    private final Type type;
                    private final IntegerNode level;

                    public Compression(Builder builder) {
                        this(builder, true);
                    }

                    private Compression(Builder builder, boolean throwIfUninitialized) {
                        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                            throw new IllegalArgumentException("The following builder parameters for proton.summary.log.compact.compression must be initialized: " + builder.__uninitialized);
                        }
                        this.type = builder.type == null ? new Type(Type.ZSTD) : new Type(builder.type);
                        this.level = builder.level == null ? new IntegerNode(9) : new IntegerNode(builder.level.intValue());
                    }

                    public Type.Enum type() {
                        return (Type.Enum)((Object)this.type.value());
                    }

                    public int level() {
                        return this.level.value();
                    }

                    private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
                        ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
                        return changes;
                    }

                    public static final class Type
                    extends EnumNode<Enum> {
                        public static final Enum NONE = Enum.NONE;
                        public static final Enum LZ4 = Enum.LZ4;
                        public static final Enum ZSTD = Enum.ZSTD;

                        public Type() {
                            this.value = null;
                        }

                        public Type(Enum enumValue) {
                            super(enumValue != null);
                            this.value = enumValue;
                        }

                        protected boolean doSetValue(String name) {
                            try {
                                this.value = Enum.valueOf(name);
                                return true;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return false;
                            }
                        }

                        public static enum Enum {
                            NONE,
                            LZ4,
                            ZSTD;

                        }
                    }

                    public static class Builder
                    implements ConfigBuilder {
                        private Set<String> __uninitialized = new HashSet<String>();
                        private Type.Enum type = null;
                        private Integer level = null;

                        public Builder() {
                        }

                        public Builder(Compression config) {
                            this.type(config.type());
                            this.level(config.level());
                        }

                        private Builder override(Builder __superior) {
                            if (__superior.type != null) {
                                this.type(__superior.type);
                            }
                            if (__superior.level != null) {
                                this.level(__superior.level);
                            }
                            return this;
                        }

                        public Builder type(Type.Enum __value) {
                            if (__value == null) {
                                throw new IllegalArgumentException("Null value is not allowed.");
                            }
                            this.type = __value;
                            return this;
                        }

                        private Builder type(String __value) {
                            return this.type(Type.Enum.valueOf(__value));
                        }

                        public Builder level(int __value) {
                            this.level = __value;
                            return this;
                        }

                        private Builder level(String __value) {
                            return this.level(Integer.valueOf(__value));
                        }

                        public Compression build() {
                            return new Compression(this);
                        }
                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    public Compression.Builder compression = new Compression.Builder();

                    public Builder() {
                    }

                    public Builder(Compact config) {
                        this.compression(new Compression.Builder(config.compression()));
                    }

                    private Builder override(Builder __superior) {
                        this.compression(this.compression.override(__superior.compression));
                        return this;
                    }

                    public Builder compression(Compression.Builder __builder) {
                        this.compression = __builder;
                        return this;
                    }

                    public Builder compression(Consumer<Compression.Builder> __func) {
                        Compression.Builder __inner = new Compression.Builder();
                        __func.accept(__inner);
                        this.compression = __inner;
                        return this;
                    }

                    public Compact build() {
                        return new Compact(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public Compact.Builder compact = new Compact.Builder();
                public Chunk.Builder chunk = new Chunk.Builder();
                private Long maxfilesize = null;
                private Integer maxnumlids = null;
                private Double maxdiskbloatfactor = null;
                private Double maxbucketspread = null;
                private Double minfilesizefactor = null;

                public Builder() {
                }

                public Builder(Log config) {
                    this.compact(new Compact.Builder(config.compact()));
                    this.chunk(new Chunk.Builder(config.chunk()));
                    this.maxfilesize(config.maxfilesize());
                    this.maxnumlids(config.maxnumlids());
                    this.maxdiskbloatfactor(config.maxdiskbloatfactor());
                    this.maxbucketspread(config.maxbucketspread());
                    this.minfilesizefactor(config.minfilesizefactor());
                }

                private Builder override(Builder __superior) {
                    this.compact(this.compact.override(__superior.compact));
                    this.chunk(this.chunk.override(__superior.chunk));
                    if (__superior.maxfilesize != null) {
                        this.maxfilesize(__superior.maxfilesize);
                    }
                    if (__superior.maxnumlids != null) {
                        this.maxnumlids(__superior.maxnumlids);
                    }
                    if (__superior.maxdiskbloatfactor != null) {
                        this.maxdiskbloatfactor(__superior.maxdiskbloatfactor);
                    }
                    if (__superior.maxbucketspread != null) {
                        this.maxbucketspread(__superior.maxbucketspread);
                    }
                    if (__superior.minfilesizefactor != null) {
                        this.minfilesizefactor(__superior.minfilesizefactor);
                    }
                    return this;
                }

                public Builder compact(Compact.Builder __builder) {
                    this.compact = __builder;
                    return this;
                }

                public Builder compact(Consumer<Compact.Builder> __func) {
                    Compact.Builder __inner = new Compact.Builder();
                    __func.accept(__inner);
                    this.compact = __inner;
                    return this;
                }

                public Builder chunk(Chunk.Builder __builder) {
                    this.chunk = __builder;
                    return this;
                }

                public Builder chunk(Consumer<Chunk.Builder> __func) {
                    Chunk.Builder __inner = new Chunk.Builder();
                    __func.accept(__inner);
                    this.chunk = __inner;
                    return this;
                }

                public Builder maxfilesize(long __value) {
                    this.maxfilesize = __value;
                    return this;
                }

                private Builder maxfilesize(String __value) {
                    return this.maxfilesize(Long.valueOf(__value));
                }

                public Builder maxnumlids(int __value) {
                    this.maxnumlids = __value;
                    return this;
                }

                private Builder maxnumlids(String __value) {
                    return this.maxnumlids(Integer.valueOf(__value));
                }

                public Builder maxdiskbloatfactor(double __value) {
                    this.maxdiskbloatfactor = __value;
                    return this;
                }

                private Builder maxdiskbloatfactor(String __value) {
                    return this.maxdiskbloatfactor(Double.valueOf(__value));
                }

                public Builder maxbucketspread(double __value) {
                    this.maxbucketspread = __value;
                    return this;
                }

                private Builder maxbucketspread(String __value) {
                    return this.maxbucketspread(Double.valueOf(__value));
                }

                public Builder minfilesizefactor(double __value) {
                    this.minfilesizefactor = __value;
                    return this;
                }

                private Builder minfilesizefactor(String __value) {
                    return this.minfilesizefactor(Double.valueOf(__value));
                }

                public Log build() {
                    return new Log(this);
                }
            }
        }

        public static final class Cache
        extends InnerNode {
            private final LongNode maxbytes;
            private final BooleanNode allowvisitcaching;
            private final LongNode initialentries;
            private final Compression compression;
            private final Update_strategy update_strategy;

            public Cache(Builder builder) {
                this(builder, true);
            }

            private Cache(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.summary.cache must be initialized: " + builder.__uninitialized);
                }
                this.maxbytes = builder.maxbytes == null ? new LongNode(-4L) : new LongNode(builder.maxbytes.longValue());
                this.allowvisitcaching = builder.allowvisitcaching == null ? new BooleanNode(true) : new BooleanNode(builder.allowvisitcaching.booleanValue());
                this.initialentries = builder.initialentries == null ? new LongNode(0L) : new LongNode(builder.initialentries.longValue());
                this.compression = new Compression(builder.compression, throwIfUninitialized);
                this.update_strategy = builder.update_strategy == null ? new Update_strategy(Update_strategy.INVALIDATE) : new Update_strategy(builder.update_strategy);
            }

            public long maxbytes() {
                return this.maxbytes.value();
            }

            public boolean allowvisitcaching() {
                return this.allowvisitcaching.value();
            }

            public long initialentries() {
                return this.initialentries.value();
            }

            public Compression compression() {
                return this.compression;
            }

            public Update_strategy.Enum update_strategy() {
                return (Update_strategy.Enum)((Object)this.update_strategy.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Cache newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("cache");
                changes.compare((Node)this.initialentries, (Node)newConfig.initialentries, "initialentries", "Control number of cache entries preallocated.\nDefault is no preallocation.\nCan be set to a higher number to avoid resizing.");
                return changes;
            }

            public static final class Update_strategy
            extends EnumNode<Enum> {
                public static final Enum INVALIDATE = Enum.INVALIDATE;
                public static final Enum UPDATE = Enum.UPDATE;

                public Update_strategy() {
                    this.value = null;
                }

                public Update_strategy(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    INVALIDATE,
                    UPDATE;

                }
            }

            public static final class Compression
            extends InnerNode {
                private final Type type;
                private final IntegerNode level;

                public Compression(Builder builder) {
                    this(builder, true);
                }

                private Compression(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.summary.cache.compression must be initialized: " + builder.__uninitialized);
                    }
                    this.type = builder.type == null ? new Type(Type.LZ4) : new Type(builder.type);
                    this.level = builder.level == null ? new IntegerNode(6) : new IntegerNode(builder.level.intValue());
                }

                public Type.Enum type() {
                    return (Type.Enum)((Object)this.type.value());
                }

                public int level() {
                    return this.level.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Compression newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("compression");
                    return changes;
                }

                public static final class Type
                extends EnumNode<Enum> {
                    public static final Enum NONE = Enum.NONE;
                    public static final Enum LZ4 = Enum.LZ4;
                    public static final Enum ZSTD = Enum.ZSTD;

                    public Type() {
                        this.value = null;
                    }

                    public Type(Enum enumValue) {
                        super(enumValue != null);
                        this.value = enumValue;
                    }

                    protected boolean doSetValue(String name) {
                        try {
                            this.value = Enum.valueOf(name);
                            return true;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            return false;
                        }
                    }

                    public static enum Enum {
                        NONE,
                        LZ4,
                        ZSTD;

                    }
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Type.Enum type = null;
                    private Integer level = null;

                    public Builder() {
                    }

                    public Builder(Compression config) {
                        this.type(config.type());
                        this.level(config.level());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.type != null) {
                            this.type(__superior.type);
                        }
                        if (__superior.level != null) {
                            this.level(__superior.level);
                        }
                        return this;
                    }

                    public Builder type(Type.Enum __value) {
                        if (__value == null) {
                            throw new IllegalArgumentException("Null value is not allowed.");
                        }
                        this.type = __value;
                        return this;
                    }

                    private Builder type(String __value) {
                        return this.type(Type.Enum.valueOf(__value));
                    }

                    public Builder level(int __value) {
                        this.level = __value;
                        return this;
                    }

                    private Builder level(String __value) {
                        return this.level(Integer.valueOf(__value));
                    }

                    public Compression build() {
                        return new Compression(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long maxbytes = null;
                private Boolean allowvisitcaching = null;
                private Long initialentries = null;
                public Compression.Builder compression = new Compression.Builder();
                private Update_strategy.Enum update_strategy = null;

                public Builder() {
                }

                public Builder(Cache config) {
                    this.maxbytes(config.maxbytes());
                    this.allowvisitcaching(config.allowvisitcaching());
                    this.initialentries(config.initialentries());
                    this.compression(new Compression.Builder(config.compression()));
                    this.update_strategy(config.update_strategy());
                }

                private Builder override(Builder __superior) {
                    if (__superior.maxbytes != null) {
                        this.maxbytes(__superior.maxbytes);
                    }
                    if (__superior.allowvisitcaching != null) {
                        this.allowvisitcaching(__superior.allowvisitcaching);
                    }
                    if (__superior.initialentries != null) {
                        this.initialentries(__superior.initialentries);
                    }
                    this.compression(this.compression.override(__superior.compression));
                    if (__superior.update_strategy != null) {
                        this.update_strategy(__superior.update_strategy);
                    }
                    return this;
                }

                public Builder maxbytes(long __value) {
                    this.maxbytes = __value;
                    return this;
                }

                private Builder maxbytes(String __value) {
                    return this.maxbytes(Long.valueOf(__value));
                }

                public Builder allowvisitcaching(boolean __value) {
                    this.allowvisitcaching = __value;
                    return this;
                }

                private Builder allowvisitcaching(String __value) {
                    return this.allowvisitcaching(Boolean.valueOf(__value));
                }

                public Builder initialentries(long __value) {
                    this.initialentries = __value;
                    return this;
                }

                private Builder initialentries(String __value) {
                    return this.initialentries(Long.valueOf(__value));
                }

                public Builder compression(Compression.Builder __builder) {
                    this.compression = __builder;
                    return this;
                }

                public Builder compression(Consumer<Compression.Builder> __func) {
                    Compression.Builder __inner = new Compression.Builder();
                    __func.accept(__inner);
                    this.compression = __inner;
                    return this;
                }

                public Builder update_strategy(Update_strategy.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.update_strategy = __value;
                    return this;
                }

                private Builder update_strategy(String __value) {
                    return this.update_strategy(Update_strategy.Enum.valueOf(__value));
                }

                public Cache build() {
                    return new Cache(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Cache.Builder cache = new Cache.Builder();
            public Log.Builder log = new Log.Builder();
            public Write.Builder write = new Write.Builder();
            public Read.Builder read = new Read.Builder();

            public Builder() {
            }

            public Builder(Summary config) {
                this.cache(new Cache.Builder(config.cache()));
                this.log(new Log.Builder(config.log()));
                this.write(new Write.Builder(config.write()));
                this.read(new Read.Builder(config.read()));
            }

            private Builder override(Builder __superior) {
                this.cache(this.cache.override(__superior.cache));
                this.log(this.log.override(__superior.log));
                this.write(this.write.override(__superior.write));
                this.read(this.read.override(__superior.read));
                return this;
            }

            public Builder cache(Cache.Builder __builder) {
                this.cache = __builder;
                return this;
            }

            public Builder cache(Consumer<Cache.Builder> __func) {
                Cache.Builder __inner = new Cache.Builder();
                __func.accept(__inner);
                this.cache = __inner;
                return this;
            }

            public Builder log(Log.Builder __builder) {
                this.log = __builder;
                return this;
            }

            public Builder log(Consumer<Log.Builder> __func) {
                Log.Builder __inner = new Log.Builder();
                __func.accept(__inner);
                this.log = __inner;
                return this;
            }

            public Builder write(Write.Builder __builder) {
                this.write = __builder;
                return this;
            }

            public Builder write(Consumer<Write.Builder> __func) {
                Write.Builder __inner = new Write.Builder();
                __func.accept(__inner);
                this.write = __inner;
                return this;
            }

            public Builder read(Read.Builder __builder) {
                this.read = __builder;
                return this;
            }

            public Builder read(Consumer<Read.Builder> __func) {
                Read.Builder __inner = new Read.Builder();
                __func.accept(__inner);
                this.read = __inner;
                return this;
            }

            public Summary build() {
                return new Summary(this);
            }
        }
    }

    public static final class Distribution
    extends InnerNode {
        private final LongNode redundancy;
        private final LongNode searchablecopies;

        public Distribution(Builder builder) {
            this(builder, true);
        }

        private Distribution(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.distribution must be initialized: " + builder.__uninitialized);
            }
            this.redundancy = builder.redundancy == null ? new LongNode(1L) : new LongNode(builder.redundancy.longValue());
            this.searchablecopies = builder.searchablecopies == null ? new LongNode(1L) : new LongNode(builder.searchablecopies.longValue());
        }

        public long redundancy() {
            return this.redundancy.value();
        }

        public long searchablecopies() {
            return this.searchablecopies.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Distribution newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("distribution");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Long redundancy = null;
            private Long searchablecopies = null;

            public Builder() {
            }

            public Builder(Distribution config) {
                this.redundancy(config.redundancy());
                this.searchablecopies(config.searchablecopies());
            }

            private Builder override(Builder __superior) {
                if (__superior.redundancy != null) {
                    this.redundancy(__superior.redundancy);
                }
                if (__superior.searchablecopies != null) {
                    this.searchablecopies(__superior.searchablecopies);
                }
                return this;
            }

            public Builder redundancy(long __value) {
                this.redundancy = __value;
                return this;
            }

            private Builder redundancy(String __value) {
                return this.redundancy(Long.valueOf(__value));
            }

            public Builder searchablecopies(long __value) {
                this.searchablecopies = __value;
                return this;
            }

            private Builder searchablecopies(String __value) {
                return this.searchablecopies(Long.valueOf(__value));
            }

            public Distribution build() {
                return new Distribution(this);
            }
        }
    }

    public static final class Grouping
    extends InnerNode {
        private final Sessionmanager sessionmanager;

        public Grouping(Builder builder) {
            this(builder, true);
        }

        private Grouping(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.grouping must be initialized: " + builder.__uninitialized);
            }
            this.sessionmanager = new Sessionmanager(builder.sessionmanager, throwIfUninitialized);
        }

        public Sessionmanager sessionmanager() {
            return this.sessionmanager;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Grouping newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("grouping");
            changes.mergeChanges("sessionmanager", this.sessionmanager.getChangesRequiringRestart(newConfig.sessionmanager));
            return changes;
        }

        public static final class Sessionmanager
        extends InnerNode {
            private final IntegerNode maxentries;
            private final Pruning pruning;

            public Sessionmanager(Builder builder) {
                this(builder, true);
            }

            private Sessionmanager(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.grouping.sessionmanager must be initialized: " + builder.__uninitialized);
                }
                this.maxentries = builder.maxentries == null ? new IntegerNode(500) : new IntegerNode(builder.maxentries.intValue());
                this.pruning = new Pruning(builder.pruning, throwIfUninitialized);
            }

            public int maxentries() {
                return this.maxentries.value();
            }

            public Pruning pruning() {
                return this.pruning;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Sessionmanager newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("sessionmanager");
                changes.compare((Node)this.maxentries, (Node)newConfig.maxentries, "maxentries", "Control of grouping session manager entries");
                return changes;
            }

            public static final class Pruning
            extends InnerNode {
                private final DoubleNode interval;

                public Pruning(Builder builder) {
                    this(builder, true);
                }

                private Pruning(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.grouping.sessionmanager.pruning must be initialized: " + builder.__uninitialized);
                    }
                    this.interval = builder.interval == null ? new DoubleNode(1.0) : new DoubleNode(builder.interval.doubleValue());
                }

                public double interval() {
                    return this.interval.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Pruning newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("pruning");
                    return changes;
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Double interval = null;

                    public Builder() {
                    }

                    public Builder(Pruning config) {
                        this.interval(config.interval());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.interval != null) {
                            this.interval(__superior.interval);
                        }
                        return this;
                    }

                    public Builder interval(double __value) {
                        this.interval = __value;
                        return this;
                    }

                    private Builder interval(String __value) {
                        return this.interval(Double.valueOf(__value));
                    }

                    public Pruning build() {
                        return new Pruning(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Integer maxentries = null;
                public Pruning.Builder pruning = new Pruning.Builder();

                public Builder() {
                }

                public Builder(Sessionmanager config) {
                    this.maxentries(config.maxentries());
                    this.pruning(new Pruning.Builder(config.pruning()));
                }

                private Builder override(Builder __superior) {
                    if (__superior.maxentries != null) {
                        this.maxentries(__superior.maxentries);
                    }
                    this.pruning(this.pruning.override(__superior.pruning));
                    return this;
                }

                public Builder maxentries(int __value) {
                    this.maxentries = __value;
                    return this;
                }

                private Builder maxentries(String __value) {
                    return this.maxentries(Integer.valueOf(__value));
                }

                public Builder pruning(Pruning.Builder __builder) {
                    this.pruning = __builder;
                    return this;
                }

                public Builder pruning(Consumer<Pruning.Builder> __func) {
                    Pruning.Builder __inner = new Pruning.Builder();
                    __func.accept(__inner);
                    this.pruning = __inner;
                    return this;
                }

                public Sessionmanager build() {
                    return new Sessionmanager(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Sessionmanager.Builder sessionmanager = new Sessionmanager.Builder();

            public Builder() {
            }

            public Builder(Grouping config) {
                this.sessionmanager(new Sessionmanager.Builder(config.sessionmanager()));
            }

            private Builder override(Builder __superior) {
                this.sessionmanager(this.sessionmanager.override(__superior.sessionmanager));
                return this;
            }

            public Builder sessionmanager(Sessionmanager.Builder __builder) {
                this.sessionmanager = __builder;
                return this;
            }

            public Builder sessionmanager(Consumer<Sessionmanager.Builder> __func) {
                Sessionmanager.Builder __inner = new Sessionmanager.Builder();
                __func.accept(__inner);
                this.sessionmanager = __inner;
                return this;
            }

            public Grouping build() {
                return new Grouping(this);
            }
        }
    }

    public static final class Attribute
    extends InnerNode {
        private final Write write;

        public Attribute(Builder builder) {
            this(builder, true);
        }

        private Attribute(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.attribute must be initialized: " + builder.__uninitialized);
            }
            this.write = new Write(builder.write, throwIfUninitialized);
        }

        public Write write() {
            return this.write;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Attribute newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("attribute");
            changes.mergeChanges("write", this.write.getChangesRequiringRestart(newConfig.write));
            return changes;
        }

        public static final class Write
        extends InnerNode {
            private final Io io;

            public Write(Builder builder) {
                this(builder, true);
            }

            private Write(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.attribute.write must be initialized: " + builder.__uninitialized);
                }
                this.io = builder.io == null ? new Io(Io.DIRECTIO) : new Io(builder.io);
            }

            public Io.Enum io() {
                return (Io.Enum)((Object)this.io.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
                changes.compare((Node)this.io, (Node)newConfig.io, "io", "Control io options during flushing of attributes.");
                return changes;
            }

            public static final class Io
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum OSYNC = Enum.OSYNC;
                public static final Enum DIRECTIO = Enum.DIRECTIO;

                public Io() {
                    this.value = null;
                }

                public Io(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    OSYNC,
                    DIRECTIO;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Io.Enum io = null;

                public Builder() {
                }

                public Builder(Write config) {
                    this.io(config.io());
                }

                private Builder override(Builder __superior) {
                    if (__superior.io != null) {
                        this.io(__superior.io);
                    }
                    return this;
                }

                public Builder io(Io.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.io = __value;
                    return this;
                }

                private Builder io(String __value) {
                    return this.io(Io.Enum.valueOf(__value));
                }

                public Write build() {
                    return new Write(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Write.Builder write = new Write.Builder();

            public Builder() {
            }

            public Builder(Attribute config) {
                this.write(new Write.Builder(config.write()));
            }

            private Builder override(Builder __superior) {
                this.write(this.write.override(__superior.write));
                return this;
            }

            public Builder write(Write.Builder __builder) {
                this.write = __builder;
                return this;
            }

            public Builder write(Consumer<Write.Builder> __func) {
                Write.Builder __inner = new Write.Builder();
                __func.accept(__inner);
                this.write = __inner;
                return this;
            }

            public Attribute build() {
                return new Attribute(this);
            }
        }
    }

    public static final class Index
    extends InnerNode {
        private final Warmup warmup;
        private final IntegerNode maxflushed;
        private final IntegerNode maxflushedretired;
        private final Cache cache;

        public Index(Builder builder) {
            this(builder, true);
        }

        private Index(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.index must be initialized: " + builder.__uninitialized);
            }
            this.warmup = new Warmup(builder.warmup, throwIfUninitialized);
            this.maxflushed = builder.maxflushed == null ? new IntegerNode(2) : new IntegerNode(builder.maxflushed.intValue());
            this.maxflushedretired = builder.maxflushedretired == null ? new IntegerNode(20) : new IntegerNode(builder.maxflushedretired.intValue());
            this.cache = new Cache(builder.cache, throwIfUninitialized);
        }

        public Warmup warmup() {
            return this.warmup;
        }

        public int maxflushed() {
            return this.maxflushed.value();
        }

        public int maxflushedretired() {
            return this.maxflushedretired.value();
        }

        public Cache cache() {
            return this.cache;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Index newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("index");
            changes.mergeChanges("warmup", this.warmup.getChangesRequiringRestart(newConfig.warmup));
            changes.mergeChanges("cache", this.cache.getChangesRequiringRestart(newConfig.cache));
            return changes;
        }

        public static final class Cache
        extends InnerNode {
            private final LongNode size;

            public Cache(Builder builder) {
                this(builder, true);
            }

            private Cache(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.index.cache must be initialized: " + builder.__uninitialized);
                }
                this.size = builder.size == null ? new LongNode(0L) : new LongNode(builder.size.longValue());
            }

            public long size() {
                return this.size.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Cache newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("cache");
                changes.compare((Node)this.size, (Node)newConfig.size, "size", "How much memory is set aside for caching.\nNow only used for caching of dictionary lookups.");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long size = null;

                public Builder() {
                }

                public Builder(Cache config) {
                    this.size(config.size());
                }

                private Builder override(Builder __superior) {
                    if (__superior.size != null) {
                        this.size(__superior.size);
                    }
                    return this;
                }

                public Builder size(long __value) {
                    this.size = __value;
                    return this;
                }

                private Builder size(String __value) {
                    return this.size(Long.valueOf(__value));
                }

                public Cache build() {
                    return new Cache(this);
                }
            }
        }

        public static final class Warmup
        extends InnerNode {
            private final DoubleNode time;
            private final BooleanNode unpack;

            public Warmup(Builder builder) {
                this(builder, true);
            }

            private Warmup(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.index.warmup must be initialized: " + builder.__uninitialized);
                }
                this.time = builder.time == null ? new DoubleNode(0.0) : new DoubleNode(builder.time.doubleValue());
                this.unpack = builder.unpack == null ? new BooleanNode(false) : new BooleanNode(builder.unpack.booleanValue());
            }

            public double time() {
                return this.time.value();
            }

            public boolean unpack() {
                return this.unpack.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Warmup newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("warmup");
                changes.compare((Node)this.time, (Node)newConfig.time, "time", "How long a freshly loaded index shall be warmed up\nbefore being used for serving");
                changes.compare((Node)this.unpack, (Node)newConfig.unpack, "unpack", "Indicate if we also want warm up with full unpack, instead of only cheaper seek.");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double time = null;
                private Boolean unpack = null;

                public Builder() {
                }

                public Builder(Warmup config) {
                    this.time(config.time());
                    this.unpack(config.unpack());
                }

                private Builder override(Builder __superior) {
                    if (__superior.time != null) {
                        this.time(__superior.time);
                    }
                    if (__superior.unpack != null) {
                        this.unpack(__superior.unpack);
                    }
                    return this;
                }

                public Builder time(double __value) {
                    this.time = __value;
                    return this;
                }

                private Builder time(String __value) {
                    return this.time(Double.valueOf(__value));
                }

                public Builder unpack(boolean __value) {
                    this.unpack = __value;
                    return this;
                }

                private Builder unpack(String __value) {
                    return this.unpack(Boolean.valueOf(__value));
                }

                public Warmup build() {
                    return new Warmup(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Warmup.Builder warmup = new Warmup.Builder();
            private Integer maxflushed = null;
            private Integer maxflushedretired = null;
            public Cache.Builder cache = new Cache.Builder();

            public Builder() {
            }

            public Builder(Index config) {
                this.warmup(new Warmup.Builder(config.warmup()));
                this.maxflushed(config.maxflushed());
                this.maxflushedretired(config.maxflushedretired());
                this.cache(new Cache.Builder(config.cache()));
            }

            private Builder override(Builder __superior) {
                this.warmup(this.warmup.override(__superior.warmup));
                if (__superior.maxflushed != null) {
                    this.maxflushed(__superior.maxflushed);
                }
                if (__superior.maxflushedretired != null) {
                    this.maxflushedretired(__superior.maxflushedretired);
                }
                this.cache(this.cache.override(__superior.cache));
                return this;
            }

            public Builder warmup(Warmup.Builder __builder) {
                this.warmup = __builder;
                return this;
            }

            public Builder warmup(Consumer<Warmup.Builder> __func) {
                Warmup.Builder __inner = new Warmup.Builder();
                __func.accept(__inner);
                this.warmup = __inner;
                return this;
            }

            public Builder maxflushed(int __value) {
                this.maxflushed = __value;
                return this;
            }

            private Builder maxflushed(String __value) {
                return this.maxflushed(Integer.valueOf(__value));
            }

            public Builder maxflushedretired(int __value) {
                this.maxflushedretired = __value;
                return this;
            }

            private Builder maxflushedretired(String __value) {
                return this.maxflushedretired(Integer.valueOf(__value));
            }

            public Builder cache(Cache.Builder __builder) {
                this.cache = __builder;
                return this;
            }

            public Builder cache(Consumer<Cache.Builder> __func) {
                Cache.Builder __inner = new Cache.Builder();
                __func.accept(__inner);
                this.cache = __inner;
                return this;
            }

            public Index build() {
                return new Index(this);
            }
        }
    }

    public static final class Indexing
    extends InnerNode {
        private final Write write;
        private final Read read;
        private final IntegerNode threads;
        private final Optimize optimize;
        private final IntegerNode tasklimit;
        private final IntegerNode semiunboundtasklimit;
        private final IntegerNode kind_of_watermark;
        private final DoubleNode reactiontime;

        public Indexing(Builder builder) {
            this(builder, true);
        }

        private Indexing(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.indexing must be initialized: " + builder.__uninitialized);
            }
            this.write = new Write(builder.write, throwIfUninitialized);
            this.read = new Read(builder.read, throwIfUninitialized);
            this.threads = builder.threads == null ? new IntegerNode(1) : new IntegerNode(builder.threads.intValue());
            this.optimize = builder.optimize == null ? new Optimize(Optimize.THROUGHPUT) : new Optimize(builder.optimize);
            this.tasklimit = builder.tasklimit == null ? new IntegerNode(1000) : new IntegerNode(builder.tasklimit.intValue());
            this.semiunboundtasklimit = builder.semiunboundtasklimit == null ? new IntegerNode(1000) : new IntegerNode(builder.semiunboundtasklimit.intValue());
            this.kind_of_watermark = builder.kind_of_watermark == null ? new IntegerNode(0) : new IntegerNode(builder.kind_of_watermark.intValue());
            this.reactiontime = builder.reactiontime == null ? new DoubleNode(0.001) : new DoubleNode(builder.reactiontime.doubleValue());
        }

        public Write write() {
            return this.write;
        }

        public Read read() {
            return this.read;
        }

        public int threads() {
            return this.threads.value();
        }

        public Optimize.Enum optimize() {
            return (Optimize.Enum)((Object)this.optimize.value());
        }

        public int tasklimit() {
            return this.tasklimit.value();
        }

        public int semiunboundtasklimit() {
            return this.semiunboundtasklimit.value();
        }

        public int kind_of_watermark() {
            return this.kind_of_watermark.value();
        }

        public double reactiontime() {
            return this.reactiontime.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Indexing newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("indexing");
            changes.mergeChanges("write", this.write.getChangesRequiringRestart(newConfig.write));
            changes.mergeChanges("read", this.read.getChangesRequiringRestart(newConfig.read));
            changes.compare((Node)this.threads, (Node)newConfig.threads, "threads", "Control number of threads used for indexing");
            changes.compare((Node)this.optimize, (Node)newConfig.optimize, "optimize", "Option to specify what is most important during indexing.\nThis is experimental and will most likely be temporary.");
            changes.compare((Node)this.kind_of_watermark, (Node)newConfig.kind_of_watermark, "kind_of_watermark", "Kind of watermark for when to activate extra manpower\nUtilized if optimize is set to either THROUGHPUT or ADAPTIVE");
            changes.compare((Node)this.reactiontime, (Node)newConfig.reactiontime, "reactiontime", "Controls minimum reaction time in seconds if using THROUGHPUT");
            return changes;
        }

        public static final class Optimize
        extends EnumNode<Enum> {
            public static final Enum LATENCY = Enum.LATENCY;
            public static final Enum THROUGHPUT = Enum.THROUGHPUT;
            public static final Enum ADAPTIVE = Enum.ADAPTIVE;

            public Optimize() {
                this.value = null;
            }

            public Optimize(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                LATENCY,
                THROUGHPUT,
                ADAPTIVE;

            }
        }

        public static final class Read
        extends InnerNode {
            private final Io io;

            public Read(Builder builder) {
                this(builder, true);
            }

            private Read(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.indexing.read must be initialized: " + builder.__uninitialized);
                }
                this.io = builder.io == null ? new Io(Io.DIRECTIO) : new Io(builder.io);
            }

            public Io.Enum io() {
                return (Io.Enum)((Object)this.io.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Read newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("read");
                changes.compare((Node)this.io, (Node)newConfig.io, "io", "Control io options during read both under dump and fusion.");
                return changes;
            }

            public static final class Io
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum DIRECTIO = Enum.DIRECTIO;

                public Io() {
                    this.value = null;
                }

                public Io(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    DIRECTIO;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Io.Enum io = null;

                public Builder() {
                }

                public Builder(Read config) {
                    this.io(config.io());
                }

                private Builder override(Builder __superior) {
                    if (__superior.io != null) {
                        this.io(__superior.io);
                    }
                    return this;
                }

                public Builder io(Io.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.io = __value;
                    return this;
                }

                private Builder io(String __value) {
                    return this.io(Io.Enum.valueOf(__value));
                }

                public Read build() {
                    return new Read(this);
                }
            }
        }

        public static final class Write
        extends InnerNode {
            private final Io io;

            public Write(Builder builder) {
                this(builder, true);
            }

            private Write(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.indexing.write must be initialized: " + builder.__uninitialized);
                }
                this.io = builder.io == null ? new Io(Io.DIRECTIO) : new Io(builder.io);
            }

            public Io.Enum io() {
                return (Io.Enum)((Object)this.io.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Write newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("write");
                changes.compare((Node)this.io, (Node)newConfig.io, "io", "Control io options during write both under dump and fusion.");
                return changes;
            }

            public static final class Io
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum OSYNC = Enum.OSYNC;
                public static final Enum DIRECTIO = Enum.DIRECTIO;

                public Io() {
                    this.value = null;
                }

                public Io(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    OSYNC,
                    DIRECTIO;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Io.Enum io = null;

                public Builder() {
                }

                public Builder(Write config) {
                    this.io(config.io());
                }

                private Builder override(Builder __superior) {
                    if (__superior.io != null) {
                        this.io(__superior.io);
                    }
                    return this;
                }

                public Builder io(Io.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.io = __value;
                    return this;
                }

                private Builder io(String __value) {
                    return this.io(Io.Enum.valueOf(__value));
                }

                public Write build() {
                    return new Write(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public Write.Builder write = new Write.Builder();
            public Read.Builder read = new Read.Builder();
            private Integer threads = null;
            private Optimize.Enum optimize = null;
            private Integer tasklimit = null;
            private Integer semiunboundtasklimit = null;
            private Integer kind_of_watermark = null;
            private Double reactiontime = null;

            public Builder() {
            }

            public Builder(Indexing config) {
                this.write(new Write.Builder(config.write()));
                this.read(new Read.Builder(config.read()));
                this.threads(config.threads());
                this.optimize(config.optimize());
                this.tasklimit(config.tasklimit());
                this.semiunboundtasklimit(config.semiunboundtasklimit());
                this.kind_of_watermark(config.kind_of_watermark());
                this.reactiontime(config.reactiontime());
            }

            private Builder override(Builder __superior) {
                this.write(this.write.override(__superior.write));
                this.read(this.read.override(__superior.read));
                if (__superior.threads != null) {
                    this.threads(__superior.threads);
                }
                if (__superior.optimize != null) {
                    this.optimize(__superior.optimize);
                }
                if (__superior.tasklimit != null) {
                    this.tasklimit(__superior.tasklimit);
                }
                if (__superior.semiunboundtasklimit != null) {
                    this.semiunboundtasklimit(__superior.semiunboundtasklimit);
                }
                if (__superior.kind_of_watermark != null) {
                    this.kind_of_watermark(__superior.kind_of_watermark);
                }
                if (__superior.reactiontime != null) {
                    this.reactiontime(__superior.reactiontime);
                }
                return this;
            }

            public Builder write(Write.Builder __builder) {
                this.write = __builder;
                return this;
            }

            public Builder write(Consumer<Write.Builder> __func) {
                Write.Builder __inner = new Write.Builder();
                __func.accept(__inner);
                this.write = __inner;
                return this;
            }

            public Builder read(Read.Builder __builder) {
                this.read = __builder;
                return this;
            }

            public Builder read(Consumer<Read.Builder> __func) {
                Read.Builder __inner = new Read.Builder();
                __func.accept(__inner);
                this.read = __inner;
                return this;
            }

            public Builder threads(int __value) {
                this.threads = __value;
                return this;
            }

            private Builder threads(String __value) {
                return this.threads(Integer.valueOf(__value));
            }

            public Builder optimize(Optimize.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.optimize = __value;
                return this;
            }

            private Builder optimize(String __value) {
                return this.optimize(Optimize.Enum.valueOf(__value));
            }

            public Builder tasklimit(int __value) {
                this.tasklimit = __value;
                return this;
            }

            private Builder tasklimit(String __value) {
                return this.tasklimit(Integer.valueOf(__value));
            }

            public Builder semiunboundtasklimit(int __value) {
                this.semiunboundtasklimit = __value;
                return this;
            }

            private Builder semiunboundtasklimit(String __value) {
                return this.semiunboundtasklimit(Integer.valueOf(__value));
            }

            public Builder kind_of_watermark(int __value) {
                this.kind_of_watermark = __value;
                return this;
            }

            private Builder kind_of_watermark(String __value) {
                return this.kind_of_watermark(Integer.valueOf(__value));
            }

            public Builder reactiontime(double __value) {
                this.reactiontime = __value;
                return this;
            }

            private Builder reactiontime(String __value) {
                return this.reactiontime(Double.valueOf(__value));
            }

            public Indexing build() {
                return new Indexing(this);
            }
        }
    }

    public static final class Flush
    extends InnerNode {
        private final IntegerNode maxconcurrent;
        private final DoubleNode idleinterval;
        private final Strategy strategy;
        private final Memory memory;
        private final Preparerestart preparerestart;

        public Flush(Builder builder) {
            this(builder, true);
        }

        private Flush(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.flush must be initialized: " + builder.__uninitialized);
            }
            this.maxconcurrent = builder.maxconcurrent == null ? new IntegerNode(2) : new IntegerNode(builder.maxconcurrent.intValue());
            this.idleinterval = builder.idleinterval == null ? new DoubleNode(10.0) : new DoubleNode(builder.idleinterval.doubleValue());
            this.strategy = builder.strategy == null ? new Strategy(Strategy.MEMORY) : new Strategy(builder.strategy);
            this.memory = new Memory(builder.memory, throwIfUninitialized);
            this.preparerestart = new Preparerestart(builder.preparerestart, throwIfUninitialized);
        }

        public int maxconcurrent() {
            return this.maxconcurrent.value();
        }

        public double idleinterval() {
            return this.idleinterval.value();
        }

        public Strategy.Enum strategy() {
            return (Strategy.Enum)((Object)this.strategy.value());
        }

        public Memory memory() {
            return this.memory;
        }

        public Preparerestart preparerestart() {
            return this.preparerestart;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Flush newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("flush");
            changes.compare((Node)this.maxconcurrent, (Node)newConfig.maxconcurrent, "maxconcurrent", "Maximum number of concurrent flushes outstanding.");
            changes.compare((Node)this.idleinterval, (Node)newConfig.idleinterval, "idleinterval", "Number of seconds between checking for stuff to flush when the system is idling.");
            changes.compare((Node)this.strategy, (Node)newConfig.strategy, "strategy", "Which flushstrategy to use.");
            return changes;
        }

        public static final class Preparerestart
        extends InnerNode {
            private final DoubleNode replaycost;
            private final DoubleNode replayoperationcost;
            private final DoubleNode writecost;

            public Preparerestart(Builder builder) {
                this(builder, true);
            }

            private Preparerestart(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.flush.preparerestart must be initialized: " + builder.__uninitialized);
                }
                this.replaycost = builder.replaycost == null ? new DoubleNode(8.0) : new DoubleNode(builder.replaycost.doubleValue());
                this.replayoperationcost = builder.replayoperationcost == null ? new DoubleNode(3000.0) : new DoubleNode(builder.replayoperationcost.doubleValue());
                this.writecost = builder.writecost == null ? new DoubleNode(1.0) : new DoubleNode(builder.writecost.doubleValue());
            }

            public double replaycost() {
                return this.replaycost.value();
            }

            public double replayoperationcost() {
                return this.replayoperationcost.value();
            }

            public double writecost() {
                return this.writecost.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Preparerestart newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("preparerestart");
                return changes;
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Double replaycost = null;
                private Double replayoperationcost = null;
                private Double writecost = null;

                public Builder() {
                }

                public Builder(Preparerestart config) {
                    this.replaycost(config.replaycost());
                    this.replayoperationcost(config.replayoperationcost());
                    this.writecost(config.writecost());
                }

                private Builder override(Builder __superior) {
                    if (__superior.replaycost != null) {
                        this.replaycost(__superior.replaycost);
                    }
                    if (__superior.replayoperationcost != null) {
                        this.replayoperationcost(__superior.replayoperationcost);
                    }
                    if (__superior.writecost != null) {
                        this.writecost(__superior.writecost);
                    }
                    return this;
                }

                public Builder replaycost(double __value) {
                    this.replaycost = __value;
                    return this;
                }

                private Builder replaycost(String __value) {
                    return this.replaycost(Double.valueOf(__value));
                }

                public Builder replayoperationcost(double __value) {
                    this.replayoperationcost = __value;
                    return this;
                }

                private Builder replayoperationcost(String __value) {
                    return this.replayoperationcost(Double.valueOf(__value));
                }

                public Builder writecost(double __value) {
                    this.writecost = __value;
                    return this;
                }

                private Builder writecost(String __value) {
                    return this.writecost(Double.valueOf(__value));
                }

                public Preparerestart build() {
                    return new Preparerestart(this);
                }
            }
        }

        public static final class Memory
        extends InnerNode {
            private final LongNode maxmemory;
            private final DoubleNode diskbloatfactor;
            private final LongNode maxtlssize;
            private final Each each;
            private final Maxage maxage;
            private final Conservative conservative;

            public Memory(Builder builder) {
                this(builder, true);
            }

            private Memory(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.flush.memory must be initialized: " + builder.__uninitialized);
                }
                this.maxmemory = builder.maxmemory == null ? new LongNode(0x100000000L) : new LongNode(builder.maxmemory.longValue());
                this.diskbloatfactor = builder.diskbloatfactor == null ? new DoubleNode(0.25) : new DoubleNode(builder.diskbloatfactor.doubleValue());
                this.maxtlssize = builder.maxtlssize == null ? new LongNode(0x500000000L) : new LongNode(builder.maxtlssize.longValue());
                this.each = new Each(builder.each, throwIfUninitialized);
                this.maxage = new Maxage(builder.maxage, throwIfUninitialized);
                this.conservative = new Conservative(builder.conservative, throwIfUninitialized);
            }

            public long maxmemory() {
                return this.maxmemory.value();
            }

            public double diskbloatfactor() {
                return this.diskbloatfactor.value();
            }

            public long maxtlssize() {
                return this.maxtlssize.value();
            }

            public Each each() {
                return this.each;
            }

            public Maxage maxage() {
                return this.maxage;
            }

            public Conservative conservative() {
                return this.conservative;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
                return changes;
            }

            public static final class Conservative
            extends InnerNode {
                private final DoubleNode memorylimitfactor;
                private final DoubleNode disklimitfactor;
                private final DoubleNode highwatermarkfactor;
                private final DoubleNode lowwatermarkfactor;

                public Conservative(Builder builder) {
                    this(builder, true);
                }

                private Conservative(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.flush.memory.conservative must be initialized: " + builder.__uninitialized);
                    }
                    this.memorylimitfactor = builder.memorylimitfactor == null ? new DoubleNode(0.5) : new DoubleNode(builder.memorylimitfactor.doubleValue());
                    this.disklimitfactor = builder.disklimitfactor == null ? new DoubleNode(0.5) : new DoubleNode(builder.disklimitfactor.doubleValue());
                    this.highwatermarkfactor = builder.highwatermarkfactor == null ? new DoubleNode(0.95) : new DoubleNode(builder.highwatermarkfactor.doubleValue());
                    this.lowwatermarkfactor = builder.lowwatermarkfactor == null ? new DoubleNode(0.9) : new DoubleNode(builder.lowwatermarkfactor.doubleValue());
                }

                public double memorylimitfactor() {
                    return this.memorylimitfactor.value();
                }

                public double disklimitfactor() {
                    return this.disklimitfactor.value();
                }

                public double highwatermarkfactor() {
                    return this.highwatermarkfactor.value();
                }

                public double lowwatermarkfactor() {
                    return this.lowwatermarkfactor.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Conservative newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("conservative");
                    return changes;
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Double memorylimitfactor = null;
                    private Double disklimitfactor = null;
                    private Double highwatermarkfactor = null;
                    private Double lowwatermarkfactor = null;

                    public Builder() {
                    }

                    public Builder(Conservative config) {
                        this.memorylimitfactor(config.memorylimitfactor());
                        this.disklimitfactor(config.disklimitfactor());
                        this.highwatermarkfactor(config.highwatermarkfactor());
                        this.lowwatermarkfactor(config.lowwatermarkfactor());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.memorylimitfactor != null) {
                            this.memorylimitfactor(__superior.memorylimitfactor);
                        }
                        if (__superior.disklimitfactor != null) {
                            this.disklimitfactor(__superior.disklimitfactor);
                        }
                        if (__superior.highwatermarkfactor != null) {
                            this.highwatermarkfactor(__superior.highwatermarkfactor);
                        }
                        if (__superior.lowwatermarkfactor != null) {
                            this.lowwatermarkfactor(__superior.lowwatermarkfactor);
                        }
                        return this;
                    }

                    public Builder memorylimitfactor(double __value) {
                        this.memorylimitfactor = __value;
                        return this;
                    }

                    private Builder memorylimitfactor(String __value) {
                        return this.memorylimitfactor(Double.valueOf(__value));
                    }

                    public Builder disklimitfactor(double __value) {
                        this.disklimitfactor = __value;
                        return this;
                    }

                    private Builder disklimitfactor(String __value) {
                        return this.disklimitfactor(Double.valueOf(__value));
                    }

                    public Builder highwatermarkfactor(double __value) {
                        this.highwatermarkfactor = __value;
                        return this;
                    }

                    private Builder highwatermarkfactor(String __value) {
                        return this.highwatermarkfactor(Double.valueOf(__value));
                    }

                    public Builder lowwatermarkfactor(double __value) {
                        this.lowwatermarkfactor = __value;
                        return this;
                    }

                    private Builder lowwatermarkfactor(String __value) {
                        return this.lowwatermarkfactor(Double.valueOf(__value));
                    }

                    public Conservative build() {
                        return new Conservative(this);
                    }
                }
            }

            public static final class Maxage
            extends InnerNode {
                private final DoubleNode time;

                public Maxage(Builder builder) {
                    this(builder, true);
                }

                private Maxage(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.flush.memory.maxage must be initialized: " + builder.__uninitialized);
                    }
                    this.time = builder.time == null ? new DoubleNode(111600.0) : new DoubleNode(builder.time.doubleValue());
                }

                public double time() {
                    return this.time.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Maxage newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("maxage");
                    return changes;
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Double time = null;

                    public Builder() {
                    }

                    public Builder(Maxage config) {
                        this.time(config.time());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.time != null) {
                            this.time(__superior.time);
                        }
                        return this;
                    }

                    public Builder time(double __value) {
                        this.time = __value;
                        return this;
                    }

                    private Builder time(String __value) {
                        return this.time(Double.valueOf(__value));
                    }

                    public Maxage build() {
                        return new Maxage(this);
                    }
                }
            }

            public static final class Each
            extends InnerNode {
                private final LongNode maxmemory;
                private final DoubleNode diskbloatfactor;

                public Each(Builder builder) {
                    this(builder, true);
                }

                private Each(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.flush.memory.each must be initialized: " + builder.__uninitialized);
                    }
                    this.maxmemory = builder.maxmemory == null ? new LongNode(0x40000000L) : new LongNode(builder.maxmemory.longValue());
                    this.diskbloatfactor = builder.diskbloatfactor == null ? new DoubleNode(0.25) : new DoubleNode(builder.diskbloatfactor.doubleValue());
                }

                public long maxmemory() {
                    return this.maxmemory.value();
                }

                public double diskbloatfactor() {
                    return this.diskbloatfactor.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Each newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("each");
                    return changes;
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Long maxmemory = null;
                    private Double diskbloatfactor = null;

                    public Builder() {
                    }

                    public Builder(Each config) {
                        this.maxmemory(config.maxmemory());
                        this.diskbloatfactor(config.diskbloatfactor());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.maxmemory != null) {
                            this.maxmemory(__superior.maxmemory);
                        }
                        if (__superior.diskbloatfactor != null) {
                            this.diskbloatfactor(__superior.diskbloatfactor);
                        }
                        return this;
                    }

                    public Builder maxmemory(long __value) {
                        this.maxmemory = __value;
                        return this;
                    }

                    private Builder maxmemory(String __value) {
                        return this.maxmemory(Long.valueOf(__value));
                    }

                    public Builder diskbloatfactor(double __value) {
                        this.diskbloatfactor = __value;
                        return this;
                    }

                    private Builder diskbloatfactor(String __value) {
                        return this.diskbloatfactor(Double.valueOf(__value));
                    }

                    public Each build() {
                        return new Each(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                private Long maxmemory = null;
                private Double diskbloatfactor = null;
                private Long maxtlssize = null;
                public Each.Builder each = new Each.Builder();
                public Maxage.Builder maxage = new Maxage.Builder();
                public Conservative.Builder conservative = new Conservative.Builder();

                public Builder() {
                }

                public Builder(Memory config) {
                    this.maxmemory(config.maxmemory());
                    this.diskbloatfactor(config.diskbloatfactor());
                    this.maxtlssize(config.maxtlssize());
                    this.each(new Each.Builder(config.each()));
                    this.maxage(new Maxage.Builder(config.maxage()));
                    this.conservative(new Conservative.Builder(config.conservative()));
                }

                private Builder override(Builder __superior) {
                    if (__superior.maxmemory != null) {
                        this.maxmemory(__superior.maxmemory);
                    }
                    if (__superior.diskbloatfactor != null) {
                        this.diskbloatfactor(__superior.diskbloatfactor);
                    }
                    if (__superior.maxtlssize != null) {
                        this.maxtlssize(__superior.maxtlssize);
                    }
                    this.each(this.each.override(__superior.each));
                    this.maxage(this.maxage.override(__superior.maxage));
                    this.conservative(this.conservative.override(__superior.conservative));
                    return this;
                }

                public Builder maxmemory(long __value) {
                    this.maxmemory = __value;
                    return this;
                }

                private Builder maxmemory(String __value) {
                    return this.maxmemory(Long.valueOf(__value));
                }

                public Builder diskbloatfactor(double __value) {
                    this.diskbloatfactor = __value;
                    return this;
                }

                private Builder diskbloatfactor(String __value) {
                    return this.diskbloatfactor(Double.valueOf(__value));
                }

                public Builder maxtlssize(long __value) {
                    this.maxtlssize = __value;
                    return this;
                }

                private Builder maxtlssize(String __value) {
                    return this.maxtlssize(Long.valueOf(__value));
                }

                public Builder each(Each.Builder __builder) {
                    this.each = __builder;
                    return this;
                }

                public Builder each(Consumer<Each.Builder> __func) {
                    Each.Builder __inner = new Each.Builder();
                    __func.accept(__inner);
                    this.each = __inner;
                    return this;
                }

                public Builder maxage(Maxage.Builder __builder) {
                    this.maxage = __builder;
                    return this;
                }

                public Builder maxage(Consumer<Maxage.Builder> __func) {
                    Maxage.Builder __inner = new Maxage.Builder();
                    __func.accept(__inner);
                    this.maxage = __inner;
                    return this;
                }

                public Builder conservative(Conservative.Builder __builder) {
                    this.conservative = __builder;
                    return this;
                }

                public Builder conservative(Consumer<Conservative.Builder> __func) {
                    Conservative.Builder __inner = new Conservative.Builder();
                    __func.accept(__inner);
                    this.conservative = __inner;
                    return this;
                }

                public Memory build() {
                    return new Memory(this);
                }
            }
        }

        public static final class Strategy
        extends EnumNode<Enum> {
            public static final Enum SIMPLE = Enum.SIMPLE;
            public static final Enum MEMORY = Enum.MEMORY;

            public Strategy() {
                this.value = null;
            }

            public Strategy(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                SIMPLE,
                MEMORY;

            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer maxconcurrent = null;
            private Double idleinterval = null;
            private Strategy.Enum strategy = null;
            public Memory.Builder memory = new Memory.Builder();
            public Preparerestart.Builder preparerestart = new Preparerestart.Builder();

            public Builder() {
            }

            public Builder(Flush config) {
                this.maxconcurrent(config.maxconcurrent());
                this.idleinterval(config.idleinterval());
                this.strategy(config.strategy());
                this.memory(new Memory.Builder(config.memory()));
                this.preparerestart(new Preparerestart.Builder(config.preparerestart()));
            }

            private Builder override(Builder __superior) {
                if (__superior.maxconcurrent != null) {
                    this.maxconcurrent(__superior.maxconcurrent);
                }
                if (__superior.idleinterval != null) {
                    this.idleinterval(__superior.idleinterval);
                }
                if (__superior.strategy != null) {
                    this.strategy(__superior.strategy);
                }
                this.memory(this.memory.override(__superior.memory));
                this.preparerestart(this.preparerestart.override(__superior.preparerestart));
                return this;
            }

            public Builder maxconcurrent(int __value) {
                this.maxconcurrent = __value;
                return this;
            }

            private Builder maxconcurrent(String __value) {
                return this.maxconcurrent(Integer.valueOf(__value));
            }

            public Builder idleinterval(double __value) {
                this.idleinterval = __value;
                return this;
            }

            private Builder idleinterval(String __value) {
                return this.idleinterval(Double.valueOf(__value));
            }

            public Builder strategy(Strategy.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.strategy = __value;
                return this;
            }

            private Builder strategy(String __value) {
                return this.strategy(Strategy.Enum.valueOf(__value));
            }

            public Builder memory(Memory.Builder __builder) {
                this.memory = __builder;
                return this;
            }

            public Builder memory(Consumer<Memory.Builder> __func) {
                Memory.Builder __inner = new Memory.Builder();
                __func.accept(__inner);
                this.memory = __inner;
                return this;
            }

            public Builder preparerestart(Preparerestart.Builder __builder) {
                this.preparerestart = __builder;
                return this;
            }

            public Builder preparerestart(Consumer<Preparerestart.Builder> __func) {
                Preparerestart.Builder __inner = new Preparerestart.Builder();
                __func.accept(__inner);
                this.preparerestart = __inner;
                return this;
            }

            public Flush build() {
                return new Flush(this);
            }
        }
    }

    public static final class Validate_and_sanitize_docstore
    extends EnumNode<Enum> {
        public static final Enum NO = Enum.NO;
        public static final Enum YES = Enum.YES;

        public Validate_and_sanitize_docstore() {
            this.value = null;
        }

        public Validate_and_sanitize_docstore(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            NO,
            YES;

        }
    }

    public static final class Docsum
    extends InnerNode {
        private final BooleanNode async;

        public Docsum(Builder builder) {
            this(builder, true);
        }

        private Docsum(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.docsum must be initialized: " + builder.__uninitialized);
            }
            this.async = builder.async == null ? new BooleanNode(true) : new BooleanNode(builder.async.booleanValue());
        }

        public boolean async() {
            return this.async.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Docsum newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("docsum");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean async = null;

            public Builder() {
            }

            public Builder(Docsum config) {
                this.async(config.async());
            }

            private Builder override(Builder __superior) {
                if (__superior.async != null) {
                    this.async(__superior.async);
                }
                return this;
            }

            public Builder async(boolean __value) {
                this.async = __value;
                return this;
            }

            private Builder async(String __value) {
                return this.async(Boolean.valueOf(__value));
            }

            public Docsum build() {
                return new Docsum(this);
            }
        }
    }

    public static final class Search
    extends InnerNode {
        private final BooleanNode async;
        private final Mmap mmap;
        private final Memory memory;

        public Search(Builder builder) {
            this(builder, true);
        }

        private Search(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.search must be initialized: " + builder.__uninitialized);
            }
            this.async = builder.async == null ? new BooleanNode(true) : new BooleanNode(builder.async.booleanValue());
            this.mmap = new Mmap(builder.mmap, throwIfUninitialized);
            this.memory = new Memory(builder.memory, throwIfUninitialized);
        }

        public boolean async() {
            return this.async.value();
        }

        public Mmap mmap() {
            return this.mmap;
        }

        public Memory memory() {
            return this.memory;
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Search newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("search");
            changes.mergeChanges("mmap", this.mmap.getChangesRequiringRestart(newConfig.mmap));
            return changes;
        }

        public static final class Memory
        extends InnerNode {
            private final Limiter limiter;

            public Memory(Builder builder) {
                this(builder, true);
            }

            private Memory(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.search.memory must be initialized: " + builder.__uninitialized);
                }
                this.limiter = new Limiter(builder.limiter, throwIfUninitialized);
            }

            public Limiter limiter() {
                return this.limiter;
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Memory newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("memory");
                return changes;
            }

            public static final class Limiter
            extends InnerNode {
                private final IntegerNode maxthreads;
                private final DoubleNode mincoverage;
                private final IntegerNode minhits;

                public Limiter(Builder builder) {
                    this(builder, true);
                }

                private Limiter(Builder builder, boolean throwIfUninitialized) {
                    if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                        throw new IllegalArgumentException("The following builder parameters for proton.search.memory.limiter must be initialized: " + builder.__uninitialized);
                    }
                    this.maxthreads = builder.maxthreads == null ? new IntegerNode(0) : new IntegerNode(builder.maxthreads.intValue());
                    this.mincoverage = builder.mincoverage == null ? new DoubleNode(1.0) : new DoubleNode(builder.mincoverage.doubleValue());
                    this.minhits = builder.minhits == null ? new IntegerNode(1000000) : new IntegerNode(builder.minhits.intValue());
                }

                public int maxthreads() {
                    return this.maxthreads.value();
                }

                public double mincoverage() {
                    return this.mincoverage.value();
                }

                public int minhits() {
                    return this.minhits.value();
                }

                private ChangesRequiringRestart getChangesRequiringRestart(Limiter newConfig) {
                    ChangesRequiringRestart changes = new ChangesRequiringRestart("limiter");
                    return changes;
                }

                public static class Builder
                implements ConfigBuilder {
                    private Set<String> __uninitialized = new HashSet<String>();
                    private Integer maxthreads = null;
                    private Double mincoverage = null;
                    private Integer minhits = null;

                    public Builder() {
                    }

                    public Builder(Limiter config) {
                        this.maxthreads(config.maxthreads());
                        this.mincoverage(config.mincoverage());
                        this.minhits(config.minhits());
                    }

                    private Builder override(Builder __superior) {
                        if (__superior.maxthreads != null) {
                            this.maxthreads(__superior.maxthreads);
                        }
                        if (__superior.mincoverage != null) {
                            this.mincoverage(__superior.mincoverage);
                        }
                        if (__superior.minhits != null) {
                            this.minhits(__superior.minhits);
                        }
                        return this;
                    }

                    public Builder maxthreads(int __value) {
                        this.maxthreads = __value;
                        return this;
                    }

                    private Builder maxthreads(String __value) {
                        return this.maxthreads(Integer.valueOf(__value));
                    }

                    public Builder mincoverage(double __value) {
                        this.mincoverage = __value;
                        return this;
                    }

                    private Builder mincoverage(String __value) {
                        return this.mincoverage(Double.valueOf(__value));
                    }

                    public Builder minhits(int __value) {
                        this.minhits = __value;
                        return this;
                    }

                    private Builder minhits(String __value) {
                        return this.minhits(Integer.valueOf(__value));
                    }

                    public Limiter build() {
                        return new Limiter(this);
                    }
                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public Limiter.Builder limiter = new Limiter.Builder();

                public Builder() {
                }

                public Builder(Memory config) {
                    this.limiter(new Limiter.Builder(config.limiter()));
                }

                private Builder override(Builder __superior) {
                    this.limiter(this.limiter.override(__superior.limiter));
                    return this;
                }

                public Builder limiter(Limiter.Builder __builder) {
                    this.limiter = __builder;
                    return this;
                }

                public Builder limiter(Consumer<Limiter.Builder> __func) {
                    Limiter.Builder __inner = new Limiter.Builder();
                    __func.accept(__inner);
                    this.limiter = __inner;
                    return this;
                }

                public Memory build() {
                    return new Memory(this);
                }
            }
        }

        public static final class Mmap
        extends InnerNode {
            private final LeafNodeVector<Options.Enum, Options> options;
            private final Advise advise;

            public Mmap(Builder builder) {
                this(builder, true);
            }

            private Mmap(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for proton.search.mmap must be initialized: " + builder.__uninitialized);
                }
                this.options = new LeafNodeVector(builder.options, (LeafNode)new Options());
                this.advise = builder.advise == null ? new Advise(Advise.NORMAL) : new Advise(builder.advise);
            }

            public List<Options.Enum> options() {
                return this.options.asList();
            }

            public Options.Enum options(int i) {
                return (Options.Enum)((Object)((Options)((Object)this.options.get(i))).value());
            }

            public Advise.Enum advise() {
                return (Advise.Enum)((Object)this.advise.value());
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Mmap newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("mmap");
                changes.compareArray(this.options, newConfig.options, "options", "Multiple optional options for use with mmap", (a, b) -> new ChangesRequiringRestart("options").compare(a, b, ProtonConfig.CONFIG_DEF_VERSION, "Multiple optional options for use with mmap"));
                changes.compare((Node)this.advise, (Node)newConfig.advise, "advise", "Advise to give to os when mapping memory.");
                return changes;
            }

            public static final class Advise
            extends EnumNode<Enum> {
                public static final Enum NORMAL = Enum.NORMAL;
                public static final Enum RANDOM = Enum.RANDOM;
                public static final Enum SEQUENTIAL = Enum.SEQUENTIAL;

                public Advise() {
                    this.value = null;
                }

                public Advise(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    NORMAL,
                    RANDOM,
                    SEQUENTIAL;

                }
            }

            public static final class Options
            extends EnumNode<Enum> {
                public static final Enum POPULATE = Enum.POPULATE;
                public static final Enum HUGETLB = Enum.HUGETLB;

                public Options() {
                    this.value = null;
                }

                public Options(Enum enumValue) {
                    super(enumValue != null);
                    this.value = enumValue;
                }

                protected boolean doSetValue(String name) {
                    try {
                        this.value = Enum.valueOf(name);
                        return true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return false;
                    }
                }

                public static enum Enum {
                    POPULATE,
                    HUGETLB;

                }
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>();
                public List<Options.Enum> options = new ArrayList<Options.Enum>();
                private Advise.Enum advise = null;

                public Builder() {
                }

                public Builder(Mmap config) {
                    this.options(config.options());
                    this.advise(config.advise());
                }

                private Builder override(Builder __superior) {
                    if (!__superior.options.isEmpty()) {
                        this.options.addAll(__superior.options);
                    }
                    if (__superior.advise != null) {
                        this.advise(__superior.advise);
                    }
                    return this;
                }

                public Builder options(Options.Enum __value) {
                    this.options.add(__value);
                    return this;
                }

                public Builder options(Collection<Options.Enum> __values) {
                    this.options.addAll(__values);
                    return this;
                }

                private Builder options(String __value) {
                    return this.options(Options.Enum.valueOf(__value));
                }

                public Builder advise(Advise.Enum __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.advise = __value;
                    return this;
                }

                private Builder advise(String __value) {
                    return this.advise(Advise.Enum.valueOf(__value));
                }

                public Mmap build() {
                    return new Mmap(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Boolean async = null;
            public Mmap.Builder mmap = new Mmap.Builder();
            public Memory.Builder memory = new Memory.Builder();

            public Builder() {
            }

            public Builder(Search config) {
                this.async(config.async());
                this.mmap(new Mmap.Builder(config.mmap()));
                this.memory(new Memory.Builder(config.memory()));
            }

            private Builder override(Builder __superior) {
                if (__superior.async != null) {
                    this.async(__superior.async);
                }
                this.mmap(this.mmap.override(__superior.mmap));
                this.memory(this.memory.override(__superior.memory));
                return this;
            }

            public Builder async(boolean __value) {
                this.async = __value;
                return this;
            }

            private Builder async(String __value) {
                return this.async(Boolean.valueOf(__value));
            }

            public Builder mmap(Mmap.Builder __builder) {
                this.mmap = __builder;
                return this;
            }

            public Builder mmap(Consumer<Mmap.Builder> __func) {
                Mmap.Builder __inner = new Mmap.Builder();
                __func.accept(__inner);
                this.mmap = __inner;
                return this;
            }

            public Builder memory(Memory.Builder __builder) {
                this.memory = __builder;
                return this;
            }

            public Builder memory(Consumer<Memory.Builder> __func) {
                Memory.Builder __inner = new Memory.Builder();
                __func.accept(__inner);
                this.memory = __inner;
                return this;
            }

            public Search build() {
                return new Search(this);
            }
        }
    }

    public static final class Rpc
    extends InnerNode {
        private final IntegerNode transportthreads;

        public Rpc(Builder builder) {
            this(builder, true);
        }

        private Rpc(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for proton.rpc must be initialized: " + builder.__uninitialized);
            }
            this.transportthreads = builder.transportthreads == null ? new IntegerNode(0) : new IntegerNode(builder.transportthreads.intValue());
        }

        public int transportthreads() {
            return this.transportthreads.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Rpc newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("rpc");
            changes.compare((Node)this.transportthreads, (Node)newConfig.transportthreads, "transportthreads", "Number of threads used for rpc transport threads\nA zero value will make the backend smart about the number.");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer transportthreads = null;

            public Builder() {
            }

            public Builder(Rpc config) {
                this.transportthreads(config.transportthreads());
            }

            private Builder override(Builder __superior) {
                if (__superior.transportthreads != null) {
                    this.transportthreads(__superior.transportthreads);
                }
                return this;
            }

            public Builder transportthreads(int __value) {
                this.transportthreads = __value;
                return this;
            }

            private Builder transportthreads(String __value) {
                return this.transportthreads(Integer.valueOf(__value));
            }

            public Rpc build() {
                return new Rpc(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String basedir = null;
        private Integer rpcport = null;
        private Integer httpport = null;
        private String clustername = null;
        private Integer distributionkey = null;
        public Rpc.Builder rpc = new Rpc.Builder();
        public Search.Builder search = new Search.Builder();
        public Docsum.Builder docsum = new Docsum.Builder();
        private Integer numsearcherthreads = null;
        private Integer numthreadspersearch = null;
        private Integer numsummarythreads = null;
        private Validate_and_sanitize_docstore.Enum validate_and_sanitize_docstore = null;
        public Flush.Builder flush = new Flush.Builder();
        public Indexing.Builder indexing = new Indexing.Builder();
        public Index.Builder index = new Index.Builder();
        public Attribute.Builder attribute = new Attribute.Builder();
        public Grouping.Builder grouping = new Grouping.Builder();
        public Distribution.Builder distribution = new Distribution.Builder();
        public Summary.Builder summary = new Summary.Builder();
        public List<Documentdb.Builder> documentdb = new ArrayList<Documentdb.Builder>();
        public Periodic.Builder periodic = new Periodic.Builder();
        private String tlsspec = null;
        private String tlsconfigid = null;
        private String slobrokconfigid = null;
        private String routingconfigid = null;
        public Filedistributor.Builder filedistributor = new Filedistributor.Builder();
        private Double pruneremoveddocumentsinterval = null;
        private Double pruneremoveddocumentsage = null;
        private Integer packetcompresslimit = null;
        private Integer packetcompresslevel = null;
        private Packetcompresstype.Enum packetcompresstype = null;
        public Lidspacecompaction.Builder lidspacecompaction = new Lidspacecompaction.Builder();
        public Bucketmove.Builder bucketmove = new Bucketmove.Builder();
        private Double maxvisibilitydelay = null;
        public Visit.Builder visit = new Visit.Builder();
        public Initialize.Builder initialize = new Initialize.Builder();
        public Writefilter.Builder writefilter = new Writefilter.Builder();
        public Hwinfo.Builder hwinfo = new Hwinfo.Builder();
        public Feeding.Builder feeding = new Feeding.Builder();
        public Maintenancejobs.Builder maintenancejobs = new Maintenancejobs.Builder();
        public Bucketdb.Builder bucketdb = new Bucketdb.Builder();
        private Tensor_implementation.Enum tensor_implementation = null;
        private Boolean forward_issues = null;
        public Replay_throttling_policy.Builder replay_throttling_policy = new Replay_throttling_policy.Builder();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ProtonConfig config) {
            this.basedir(config.basedir());
            this.rpcport(config.rpcport());
            this.httpport(config.httpport());
            this.clustername(config.clustername());
            this.distributionkey(config.distributionkey());
            this.rpc(new Rpc.Builder(config.rpc()));
            this.search(new Search.Builder(config.search()));
            this.docsum(new Docsum.Builder(config.docsum()));
            this.numsearcherthreads(config.numsearcherthreads());
            this.numthreadspersearch(config.numthreadspersearch());
            this.numsummarythreads(config.numsummarythreads());
            this.validate_and_sanitize_docstore(config.validate_and_sanitize_docstore());
            this.flush(new Flush.Builder(config.flush()));
            this.indexing(new Indexing.Builder(config.indexing()));
            this.index(new Index.Builder(config.index()));
            this.attribute(new Attribute.Builder(config.attribute()));
            this.grouping(new Grouping.Builder(config.grouping()));
            this.distribution(new Distribution.Builder(config.distribution()));
            this.summary(new Summary.Builder(config.summary()));
            for (Documentdb d : config.documentdb()) {
                this.documentdb(new Documentdb.Builder(d));
            }
            this.periodic(new Periodic.Builder(config.periodic()));
            this.tlsspec(config.tlsspec());
            this.tlsconfigid(config.tlsconfigid());
            this.slobrokconfigid(config.slobrokconfigid());
            this.routingconfigid(config.routingconfigid());
            this.filedistributor(new Filedistributor.Builder(config.filedistributor()));
            this.pruneremoveddocumentsinterval(config.pruneremoveddocumentsinterval());
            this.pruneremoveddocumentsage(config.pruneremoveddocumentsage());
            this.packetcompresslimit(config.packetcompresslimit());
            this.packetcompresslevel(config.packetcompresslevel());
            this.packetcompresstype(config.packetcompresstype());
            this.lidspacecompaction(new Lidspacecompaction.Builder(config.lidspacecompaction()));
            this.bucketmove(new Bucketmove.Builder(config.bucketmove()));
            this.maxvisibilitydelay(config.maxvisibilitydelay());
            this.visit(new Visit.Builder(config.visit()));
            this.initialize(new Initialize.Builder(config.initialize()));
            this.writefilter(new Writefilter.Builder(config.writefilter()));
            this.hwinfo(new Hwinfo.Builder(config.hwinfo()));
            this.feeding(new Feeding.Builder(config.feeding()));
            this.maintenancejobs(new Maintenancejobs.Builder(config.maintenancejobs()));
            this.bucketdb(new Bucketdb.Builder(config.bucketdb()));
            this.tensor_implementation(config.tensor_implementation());
            this.forward_issues(config.forward_issues());
            this.replay_throttling_policy(new Replay_throttling_policy.Builder(config.replay_throttling_policy()));
        }

        private Builder override(Builder __superior) {
            if (__superior.basedir != null) {
                this.basedir(__superior.basedir);
            }
            if (__superior.rpcport != null) {
                this.rpcport(__superior.rpcport);
            }
            if (__superior.httpport != null) {
                this.httpport(__superior.httpport);
            }
            if (__superior.clustername != null) {
                this.clustername(__superior.clustername);
            }
            if (__superior.distributionkey != null) {
                this.distributionkey(__superior.distributionkey);
            }
            this.rpc(this.rpc.override(__superior.rpc));
            this.search(this.search.override(__superior.search));
            this.docsum(this.docsum.override(__superior.docsum));
            if (__superior.numsearcherthreads != null) {
                this.numsearcherthreads(__superior.numsearcherthreads);
            }
            if (__superior.numthreadspersearch != null) {
                this.numthreadspersearch(__superior.numthreadspersearch);
            }
            if (__superior.numsummarythreads != null) {
                this.numsummarythreads(__superior.numsummarythreads);
            }
            if (__superior.validate_and_sanitize_docstore != null) {
                this.validate_and_sanitize_docstore(__superior.validate_and_sanitize_docstore);
            }
            this.flush(this.flush.override(__superior.flush));
            this.indexing(this.indexing.override(__superior.indexing));
            this.index(this.index.override(__superior.index));
            this.attribute(this.attribute.override(__superior.attribute));
            this.grouping(this.grouping.override(__superior.grouping));
            this.distribution(this.distribution.override(__superior.distribution));
            this.summary(this.summary.override(__superior.summary));
            if (!__superior.documentdb.isEmpty()) {
                this.documentdb.addAll(__superior.documentdb);
            }
            this.periodic(this.periodic.override(__superior.periodic));
            if (__superior.tlsspec != null) {
                this.tlsspec(__superior.tlsspec);
            }
            if (__superior.tlsconfigid != null) {
                this.tlsconfigid(__superior.tlsconfigid);
            }
            if (__superior.slobrokconfigid != null) {
                this.slobrokconfigid(__superior.slobrokconfigid);
            }
            if (__superior.routingconfigid != null) {
                this.routingconfigid(__superior.routingconfigid);
            }
            this.filedistributor(this.filedistributor.override(__superior.filedistributor));
            if (__superior.pruneremoveddocumentsinterval != null) {
                this.pruneremoveddocumentsinterval(__superior.pruneremoveddocumentsinterval);
            }
            if (__superior.pruneremoveddocumentsage != null) {
                this.pruneremoveddocumentsage(__superior.pruneremoveddocumentsage);
            }
            if (__superior.packetcompresslimit != null) {
                this.packetcompresslimit(__superior.packetcompresslimit);
            }
            if (__superior.packetcompresslevel != null) {
                this.packetcompresslevel(__superior.packetcompresslevel);
            }
            if (__superior.packetcompresstype != null) {
                this.packetcompresstype(__superior.packetcompresstype);
            }
            this.lidspacecompaction(this.lidspacecompaction.override(__superior.lidspacecompaction));
            this.bucketmove(this.bucketmove.override(__superior.bucketmove));
            if (__superior.maxvisibilitydelay != null) {
                this.maxvisibilitydelay(__superior.maxvisibilitydelay);
            }
            this.visit(this.visit.override(__superior.visit));
            this.initialize(this.initialize.override(__superior.initialize));
            this.writefilter(this.writefilter.override(__superior.writefilter));
            this.hwinfo(this.hwinfo.override(__superior.hwinfo));
            this.feeding(this.feeding.override(__superior.feeding));
            this.maintenancejobs(this.maintenancejobs.override(__superior.maintenancejobs));
            this.bucketdb(this.bucketdb.override(__superior.bucketdb));
            if (__superior.tensor_implementation != null) {
                this.tensor_implementation(__superior.tensor_implementation);
            }
            if (__superior.forward_issues != null) {
                this.forward_issues(__superior.forward_issues);
            }
            this.replay_throttling_policy(this.replay_throttling_policy.override(__superior.replay_throttling_policy));
            return this;
        }

        public Builder basedir(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.basedir = __value;
            return this;
        }

        public Builder rpcport(int __value) {
            this.rpcport = __value;
            return this;
        }

        private Builder rpcport(String __value) {
            return this.rpcport(Integer.valueOf(__value));
        }

        public Builder httpport(int __value) {
            this.httpport = __value;
            return this;
        }

        private Builder httpport(String __value) {
            return this.httpport(Integer.valueOf(__value));
        }

        public Builder clustername(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.clustername = __value;
            return this;
        }

        public Builder distributionkey(int __value) {
            this.distributionkey = __value;
            return this;
        }

        private Builder distributionkey(String __value) {
            return this.distributionkey(Integer.valueOf(__value));
        }

        public Builder rpc(Rpc.Builder __builder) {
            this.rpc = __builder;
            return this;
        }

        public Builder rpc(Consumer<Rpc.Builder> __func) {
            Rpc.Builder __inner = new Rpc.Builder();
            __func.accept(__inner);
            this.rpc = __inner;
            return this;
        }

        public Builder search(Search.Builder __builder) {
            this.search = __builder;
            return this;
        }

        public Builder search(Consumer<Search.Builder> __func) {
            Search.Builder __inner = new Search.Builder();
            __func.accept(__inner);
            this.search = __inner;
            return this;
        }

        public Builder docsum(Docsum.Builder __builder) {
            this.docsum = __builder;
            return this;
        }

        public Builder docsum(Consumer<Docsum.Builder> __func) {
            Docsum.Builder __inner = new Docsum.Builder();
            __func.accept(__inner);
            this.docsum = __inner;
            return this;
        }

        public Builder numsearcherthreads(int __value) {
            this.numsearcherthreads = __value;
            return this;
        }

        private Builder numsearcherthreads(String __value) {
            return this.numsearcherthreads(Integer.valueOf(__value));
        }

        public Builder numthreadspersearch(int __value) {
            this.numthreadspersearch = __value;
            return this;
        }

        private Builder numthreadspersearch(String __value) {
            return this.numthreadspersearch(Integer.valueOf(__value));
        }

        public Builder numsummarythreads(int __value) {
            this.numsummarythreads = __value;
            return this;
        }

        private Builder numsummarythreads(String __value) {
            return this.numsummarythreads(Integer.valueOf(__value));
        }

        public Builder validate_and_sanitize_docstore(Validate_and_sanitize_docstore.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.validate_and_sanitize_docstore = __value;
            return this;
        }

        private Builder validate_and_sanitize_docstore(String __value) {
            return this.validate_and_sanitize_docstore(Validate_and_sanitize_docstore.Enum.valueOf(__value));
        }

        public Builder flush(Flush.Builder __builder) {
            this.flush = __builder;
            return this;
        }

        public Builder flush(Consumer<Flush.Builder> __func) {
            Flush.Builder __inner = new Flush.Builder();
            __func.accept(__inner);
            this.flush = __inner;
            return this;
        }

        public Builder indexing(Indexing.Builder __builder) {
            this.indexing = __builder;
            return this;
        }

        public Builder indexing(Consumer<Indexing.Builder> __func) {
            Indexing.Builder __inner = new Indexing.Builder();
            __func.accept(__inner);
            this.indexing = __inner;
            return this;
        }

        public Builder index(Index.Builder __builder) {
            this.index = __builder;
            return this;
        }

        public Builder index(Consumer<Index.Builder> __func) {
            Index.Builder __inner = new Index.Builder();
            __func.accept(__inner);
            this.index = __inner;
            return this;
        }

        public Builder attribute(Attribute.Builder __builder) {
            this.attribute = __builder;
            return this;
        }

        public Builder attribute(Consumer<Attribute.Builder> __func) {
            Attribute.Builder __inner = new Attribute.Builder();
            __func.accept(__inner);
            this.attribute = __inner;
            return this;
        }

        public Builder grouping(Grouping.Builder __builder) {
            this.grouping = __builder;
            return this;
        }

        public Builder grouping(Consumer<Grouping.Builder> __func) {
            Grouping.Builder __inner = new Grouping.Builder();
            __func.accept(__inner);
            this.grouping = __inner;
            return this;
        }

        public Builder distribution(Distribution.Builder __builder) {
            this.distribution = __builder;
            return this;
        }

        public Builder distribution(Consumer<Distribution.Builder> __func) {
            Distribution.Builder __inner = new Distribution.Builder();
            __func.accept(__inner);
            this.distribution = __inner;
            return this;
        }

        public Builder summary(Summary.Builder __builder) {
            this.summary = __builder;
            return this;
        }

        public Builder summary(Consumer<Summary.Builder> __func) {
            Summary.Builder __inner = new Summary.Builder();
            __func.accept(__inner);
            this.summary = __inner;
            return this;
        }

        public Builder documentdb(Documentdb.Builder __builder) {
            this.documentdb.add(__builder);
            return this;
        }

        public Builder documentdb(Consumer<Documentdb.Builder> __func) {
            Documentdb.Builder __inner = new Documentdb.Builder();
            __func.accept(__inner);
            this.documentdb.add(__inner);
            return this;
        }

        public Builder documentdb(List<Documentdb.Builder> __builders) {
            this.documentdb = __builders;
            return this;
        }

        public Builder periodic(Periodic.Builder __builder) {
            this.periodic = __builder;
            return this;
        }

        public Builder periodic(Consumer<Periodic.Builder> __func) {
            Periodic.Builder __inner = new Periodic.Builder();
            __func.accept(__inner);
            this.periodic = __inner;
            return this;
        }

        public Builder tlsspec(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tlsspec = __value;
            return this;
        }

        public Builder tlsconfigid(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tlsconfigid = __value;
            return this;
        }

        public Builder slobrokconfigid(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.slobrokconfigid = __value;
            return this;
        }

        public Builder routingconfigid(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.routingconfigid = __value;
            return this;
        }

        public Builder filedistributor(Filedistributor.Builder __builder) {
            this.filedistributor = __builder;
            return this;
        }

        public Builder filedistributor(Consumer<Filedistributor.Builder> __func) {
            Filedistributor.Builder __inner = new Filedistributor.Builder();
            __func.accept(__inner);
            this.filedistributor = __inner;
            return this;
        }

        public Builder pruneremoveddocumentsinterval(double __value) {
            this.pruneremoveddocumentsinterval = __value;
            return this;
        }

        private Builder pruneremoveddocumentsinterval(String __value) {
            return this.pruneremoveddocumentsinterval(Double.valueOf(__value));
        }

        public Builder pruneremoveddocumentsage(double __value) {
            this.pruneremoveddocumentsage = __value;
            return this;
        }

        private Builder pruneremoveddocumentsage(String __value) {
            return this.pruneremoveddocumentsage(Double.valueOf(__value));
        }

        public Builder packetcompresslimit(int __value) {
            this.packetcompresslimit = __value;
            return this;
        }

        private Builder packetcompresslimit(String __value) {
            return this.packetcompresslimit(Integer.valueOf(__value));
        }

        public Builder packetcompresslevel(int __value) {
            this.packetcompresslevel = __value;
            return this;
        }

        private Builder packetcompresslevel(String __value) {
            return this.packetcompresslevel(Integer.valueOf(__value));
        }

        public Builder packetcompresstype(Packetcompresstype.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.packetcompresstype = __value;
            return this;
        }

        private Builder packetcompresstype(String __value) {
            return this.packetcompresstype(Packetcompresstype.Enum.valueOf(__value));
        }

        public Builder lidspacecompaction(Lidspacecompaction.Builder __builder) {
            this.lidspacecompaction = __builder;
            return this;
        }

        public Builder lidspacecompaction(Consumer<Lidspacecompaction.Builder> __func) {
            Lidspacecompaction.Builder __inner = new Lidspacecompaction.Builder();
            __func.accept(__inner);
            this.lidspacecompaction = __inner;
            return this;
        }

        public Builder bucketmove(Bucketmove.Builder __builder) {
            this.bucketmove = __builder;
            return this;
        }

        public Builder bucketmove(Consumer<Bucketmove.Builder> __func) {
            Bucketmove.Builder __inner = new Bucketmove.Builder();
            __func.accept(__inner);
            this.bucketmove = __inner;
            return this;
        }

        public Builder maxvisibilitydelay(double __value) {
            this.maxvisibilitydelay = __value;
            return this;
        }

        private Builder maxvisibilitydelay(String __value) {
            return this.maxvisibilitydelay(Double.valueOf(__value));
        }

        public Builder visit(Visit.Builder __builder) {
            this.visit = __builder;
            return this;
        }

        public Builder visit(Consumer<Visit.Builder> __func) {
            Visit.Builder __inner = new Visit.Builder();
            __func.accept(__inner);
            this.visit = __inner;
            return this;
        }

        public Builder initialize(Initialize.Builder __builder) {
            this.initialize = __builder;
            return this;
        }

        public Builder initialize(Consumer<Initialize.Builder> __func) {
            Initialize.Builder __inner = new Initialize.Builder();
            __func.accept(__inner);
            this.initialize = __inner;
            return this;
        }

        public Builder writefilter(Writefilter.Builder __builder) {
            this.writefilter = __builder;
            return this;
        }

        public Builder writefilter(Consumer<Writefilter.Builder> __func) {
            Writefilter.Builder __inner = new Writefilter.Builder();
            __func.accept(__inner);
            this.writefilter = __inner;
            return this;
        }

        public Builder hwinfo(Hwinfo.Builder __builder) {
            this.hwinfo = __builder;
            return this;
        }

        public Builder hwinfo(Consumer<Hwinfo.Builder> __func) {
            Hwinfo.Builder __inner = new Hwinfo.Builder();
            __func.accept(__inner);
            this.hwinfo = __inner;
            return this;
        }

        public Builder feeding(Feeding.Builder __builder) {
            this.feeding = __builder;
            return this;
        }

        public Builder feeding(Consumer<Feeding.Builder> __func) {
            Feeding.Builder __inner = new Feeding.Builder();
            __func.accept(__inner);
            this.feeding = __inner;
            return this;
        }

        public Builder maintenancejobs(Maintenancejobs.Builder __builder) {
            this.maintenancejobs = __builder;
            return this;
        }

        public Builder maintenancejobs(Consumer<Maintenancejobs.Builder> __func) {
            Maintenancejobs.Builder __inner = new Maintenancejobs.Builder();
            __func.accept(__inner);
            this.maintenancejobs = __inner;
            return this;
        }

        public Builder bucketdb(Bucketdb.Builder __builder) {
            this.bucketdb = __builder;
            return this;
        }

        public Builder bucketdb(Consumer<Bucketdb.Builder> __func) {
            Bucketdb.Builder __inner = new Bucketdb.Builder();
            __func.accept(__inner);
            this.bucketdb = __inner;
            return this;
        }

        public Builder tensor_implementation(Tensor_implementation.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.tensor_implementation = __value;
            return this;
        }

        private Builder tensor_implementation(String __value) {
            return this.tensor_implementation(Tensor_implementation.Enum.valueOf(__value));
        }

        public Builder forward_issues(boolean __value) {
            this.forward_issues = __value;
            return this;
        }

        private Builder forward_issues(String __value) {
            return this.forward_issues(Boolean.valueOf(__value));
        }

        public Builder replay_throttling_policy(Replay_throttling_policy.Builder __builder) {
            this.replay_throttling_policy = __builder;
            return this;
        }

        public Builder replay_throttling_policy(Consumer<Replay_throttling_policy.Builder> __func) {
            Replay_throttling_policy.Builder __inner = new Replay_throttling_policy.Builder();
            __func.accept(__inner);
            this.replay_throttling_policy = __inner;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ProtonConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ProtonConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ProtonConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ProtonConfig build() {
            return new ProtonConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

