/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LongNode;
import com.yahoo.config.StringNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PartitionsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "32f3ed6a7fe24550f40a370d57f036ab";
    public static final String CONFIG_DEF_NAME = "partitions";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "dataset[].id int", "dataset[].refcost int default=0", "dataset[].searchablecopies long default=1", "dataset[].partbits int default=8", "dataset[].rowbits int default=0", "dataset[].numparts int default=0", "dataset[].firstpart int default=0", "dataset[].minpartitions int default=0", "dataset[].mpp int default=1", "dataset[].maxnodesdownperfixedrow int default=0", "dataset[].useroundrobinforfixedrow bool default=false", "dataset[].engine[].name_and_port string", "dataset[].engine[].partid int default=0", "dataset[].engine[].rowid int default=0", "dataset[].engine[].subdatasetid int default=0", "dataset[].engine[].refcost int default=1", "dataset[].engine[].overridepartids bool default=true", "dataset[].maxhitspernode int default=2147483647", "dataset[].estparts int default=0", "dataset[].estpartcutoff int default=0", "dataset[].minactive int default=500", "dataset[].maxactive int default=500", "dataset[].cutoffactive int default=1000", "dataset[].minestactive int default=500", "dataset[].maxestactive int default=1000", "dataset[].cutoffestactive int default=1000", "dataset[].queuedrainrate double default=400", "dataset[].queuedrainmax double default=40", "dataset[].slowquerylimitfactor double default=0.0", "dataset[].slowquerylimitbias double default=100.0", "dataset[].slowdocsumlimitfactor double default=0", "dataset[].slowdocsumlimitbias double default=100.0", "dataset[].monitorinterval double default=1.0", "dataset[].higher_coverage_maxsearchwait double default=1.0", "dataset[].higher_coverage_minsearchwait double default=0.0", "dataset[].higher_coverage_basesearchwait double default=0.1", "dataset[].minimal_searchcoverage double default=100.0", "dataset[].higher_coverage_maxdocsumwait double default=0.3", "dataset[].higher_coverage_mindocsumwait double default=0.1", "dataset[].higher_coverage_basedocsumwait double default=0.1", "dataset[].minimal_docsumcoverage double default=100.0", "dataset[].querydistribution enum { RANDOM, AUTOMATIC, FIXEDROW } default=AUTOMATIC", "dataset[].min_group_coverage double default=100", "dataset[].min_activedocs_coverage double default=97.0", "dataset[].latency_decay_rate double default=1000"};
    private final InnerNodeVector<Dataset> dataset;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public PartitionsConfig(Builder builder) {
        this(builder, true);
    }

    private PartitionsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for partitions must be initialized: " + builder.__uninitialized);
        }
        this.dataset = Dataset.createVector(builder.dataset);
    }

    public List<Dataset> dataset() {
        return this.dataset;
    }

    public Dataset dataset(int i) {
        return (Dataset)((Object)this.dataset.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(PartitionsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Dataset
    extends InnerNode {
        private final IntegerNode id;
        private final IntegerNode refcost;
        private final LongNode searchablecopies;
        private final IntegerNode partbits;
        private final IntegerNode rowbits;
        private final IntegerNode numparts;
        private final IntegerNode firstpart;
        private final IntegerNode minpartitions;
        private final IntegerNode mpp;
        private final IntegerNode maxnodesdownperfixedrow;
        private final BooleanNode useroundrobinforfixedrow;
        private final InnerNodeVector<Engine> engine;
        private final IntegerNode maxhitspernode;
        private final IntegerNode estparts;
        private final IntegerNode estpartcutoff;
        private final IntegerNode minactive;
        private final IntegerNode maxactive;
        private final IntegerNode cutoffactive;
        private final IntegerNode minestactive;
        private final IntegerNode maxestactive;
        private final IntegerNode cutoffestactive;
        private final DoubleNode queuedrainrate;
        private final DoubleNode queuedrainmax;
        private final DoubleNode slowquerylimitfactor;
        private final DoubleNode slowquerylimitbias;
        private final DoubleNode slowdocsumlimitfactor;
        private final DoubleNode slowdocsumlimitbias;
        private final DoubleNode monitorinterval;
        private final DoubleNode higher_coverage_maxsearchwait;
        private final DoubleNode higher_coverage_minsearchwait;
        private final DoubleNode higher_coverage_basesearchwait;
        private final DoubleNode minimal_searchcoverage;
        private final DoubleNode higher_coverage_maxdocsumwait;
        private final DoubleNode higher_coverage_mindocsumwait;
        private final DoubleNode higher_coverage_basedocsumwait;
        private final DoubleNode minimal_docsumcoverage;
        private final Querydistribution querydistribution;
        private final DoubleNode min_group_coverage;
        private final DoubleNode min_activedocs_coverage;
        private final DoubleNode latency_decay_rate;

        public Dataset(Builder builder) {
            this(builder, true);
        }

        private Dataset(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for partitions.dataset[] must be initialized: " + builder.__uninitialized);
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.refcost = builder.refcost == null ? new IntegerNode(0) : new IntegerNode(builder.refcost.intValue());
            this.searchablecopies = builder.searchablecopies == null ? new LongNode(1L) : new LongNode(builder.searchablecopies.longValue());
            this.partbits = builder.partbits == null ? new IntegerNode(8) : new IntegerNode(builder.partbits.intValue());
            this.rowbits = builder.rowbits == null ? new IntegerNode(0) : new IntegerNode(builder.rowbits.intValue());
            this.numparts = builder.numparts == null ? new IntegerNode(0) : new IntegerNode(builder.numparts.intValue());
            this.firstpart = builder.firstpart == null ? new IntegerNode(0) : new IntegerNode(builder.firstpart.intValue());
            this.minpartitions = builder.minpartitions == null ? new IntegerNode(0) : new IntegerNode(builder.minpartitions.intValue());
            this.mpp = builder.mpp == null ? new IntegerNode(1) : new IntegerNode(builder.mpp.intValue());
            this.maxnodesdownperfixedrow = builder.maxnodesdownperfixedrow == null ? new IntegerNode(0) : new IntegerNode(builder.maxnodesdownperfixedrow.intValue());
            this.useroundrobinforfixedrow = builder.useroundrobinforfixedrow == null ? new BooleanNode(false) : new BooleanNode(builder.useroundrobinforfixedrow.booleanValue());
            this.engine = Engine.createVector(builder.engine);
            this.maxhitspernode = builder.maxhitspernode == null ? new IntegerNode(Integer.MAX_VALUE) : new IntegerNode(builder.maxhitspernode.intValue());
            this.estparts = builder.estparts == null ? new IntegerNode(0) : new IntegerNode(builder.estparts.intValue());
            this.estpartcutoff = builder.estpartcutoff == null ? new IntegerNode(0) : new IntegerNode(builder.estpartcutoff.intValue());
            this.minactive = builder.minactive == null ? new IntegerNode(500) : new IntegerNode(builder.minactive.intValue());
            this.maxactive = builder.maxactive == null ? new IntegerNode(500) : new IntegerNode(builder.maxactive.intValue());
            this.cutoffactive = builder.cutoffactive == null ? new IntegerNode(1000) : new IntegerNode(builder.cutoffactive.intValue());
            this.minestactive = builder.minestactive == null ? new IntegerNode(500) : new IntegerNode(builder.minestactive.intValue());
            this.maxestactive = builder.maxestactive == null ? new IntegerNode(1000) : new IntegerNode(builder.maxestactive.intValue());
            this.cutoffestactive = builder.cutoffestactive == null ? new IntegerNode(1000) : new IntegerNode(builder.cutoffestactive.intValue());
            this.queuedrainrate = builder.queuedrainrate == null ? new DoubleNode(400.0) : new DoubleNode(builder.queuedrainrate.doubleValue());
            this.queuedrainmax = builder.queuedrainmax == null ? new DoubleNode(40.0) : new DoubleNode(builder.queuedrainmax.doubleValue());
            this.slowquerylimitfactor = builder.slowquerylimitfactor == null ? new DoubleNode(0.0) : new DoubleNode(builder.slowquerylimitfactor.doubleValue());
            this.slowquerylimitbias = builder.slowquerylimitbias == null ? new DoubleNode(100.0) : new DoubleNode(builder.slowquerylimitbias.doubleValue());
            this.slowdocsumlimitfactor = builder.slowdocsumlimitfactor == null ? new DoubleNode(0.0) : new DoubleNode(builder.slowdocsumlimitfactor.doubleValue());
            this.slowdocsumlimitbias = builder.slowdocsumlimitbias == null ? new DoubleNode(100.0) : new DoubleNode(builder.slowdocsumlimitbias.doubleValue());
            this.monitorinterval = builder.monitorinterval == null ? new DoubleNode(1.0) : new DoubleNode(builder.monitorinterval.doubleValue());
            this.higher_coverage_maxsearchwait = builder.higher_coverage_maxsearchwait == null ? new DoubleNode(1.0) : new DoubleNode(builder.higher_coverage_maxsearchwait.doubleValue());
            this.higher_coverage_minsearchwait = builder.higher_coverage_minsearchwait == null ? new DoubleNode(0.0) : new DoubleNode(builder.higher_coverage_minsearchwait.doubleValue());
            this.higher_coverage_basesearchwait = builder.higher_coverage_basesearchwait == null ? new DoubleNode(0.1) : new DoubleNode(builder.higher_coverage_basesearchwait.doubleValue());
            this.minimal_searchcoverage = builder.minimal_searchcoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minimal_searchcoverage.doubleValue());
            this.higher_coverage_maxdocsumwait = builder.higher_coverage_maxdocsumwait == null ? new DoubleNode(0.3) : new DoubleNode(builder.higher_coverage_maxdocsumwait.doubleValue());
            this.higher_coverage_mindocsumwait = builder.higher_coverage_mindocsumwait == null ? new DoubleNode(0.1) : new DoubleNode(builder.higher_coverage_mindocsumwait.doubleValue());
            this.higher_coverage_basedocsumwait = builder.higher_coverage_basedocsumwait == null ? new DoubleNode(0.1) : new DoubleNode(builder.higher_coverage_basedocsumwait.doubleValue());
            this.minimal_docsumcoverage = builder.minimal_docsumcoverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.minimal_docsumcoverage.doubleValue());
            this.querydistribution = builder.querydistribution == null ? new Querydistribution(Querydistribution.AUTOMATIC) : new Querydistribution(builder.querydistribution);
            this.min_group_coverage = builder.min_group_coverage == null ? new DoubleNode(100.0) : new DoubleNode(builder.min_group_coverage.doubleValue());
            this.min_activedocs_coverage = builder.min_activedocs_coverage == null ? new DoubleNode(97.0) : new DoubleNode(builder.min_activedocs_coverage.doubleValue());
            this.latency_decay_rate = builder.latency_decay_rate == null ? new DoubleNode(1000.0) : new DoubleNode(builder.latency_decay_rate.doubleValue());
        }

        public int id() {
            return this.id.value();
        }

        public int refcost() {
            return this.refcost.value();
        }

        public long searchablecopies() {
            return this.searchablecopies.value();
        }

        public int partbits() {
            return this.partbits.value();
        }

        public int rowbits() {
            return this.rowbits.value();
        }

        public int numparts() {
            return this.numparts.value();
        }

        public int firstpart() {
            return this.firstpart.value();
        }

        public int minpartitions() {
            return this.minpartitions.value();
        }

        public int mpp() {
            return this.mpp.value();
        }

        public int maxnodesdownperfixedrow() {
            return this.maxnodesdownperfixedrow.value();
        }

        public boolean useroundrobinforfixedrow() {
            return this.useroundrobinforfixedrow.value();
        }

        public List<Engine> engine() {
            return this.engine;
        }

        public Engine engine(int i) {
            return (Engine)((Object)this.engine.get(i));
        }

        public int maxhitspernode() {
            return this.maxhitspernode.value();
        }

        public int estparts() {
            return this.estparts.value();
        }

        public int estpartcutoff() {
            return this.estpartcutoff.value();
        }

        public int minactive() {
            return this.minactive.value();
        }

        public int maxactive() {
            return this.maxactive.value();
        }

        public int cutoffactive() {
            return this.cutoffactive.value();
        }

        public int minestactive() {
            return this.minestactive.value();
        }

        public int maxestactive() {
            return this.maxestactive.value();
        }

        public int cutoffestactive() {
            return this.cutoffestactive.value();
        }

        public double queuedrainrate() {
            return this.queuedrainrate.value();
        }

        public double queuedrainmax() {
            return this.queuedrainmax.value();
        }

        public double slowquerylimitfactor() {
            return this.slowquerylimitfactor.value();
        }

        public double slowquerylimitbias() {
            return this.slowquerylimitbias.value();
        }

        public double slowdocsumlimitfactor() {
            return this.slowdocsumlimitfactor.value();
        }

        public double slowdocsumlimitbias() {
            return this.slowdocsumlimitbias.value();
        }

        public double monitorinterval() {
            return this.monitorinterval.value();
        }

        public double higher_coverage_maxsearchwait() {
            return this.higher_coverage_maxsearchwait.value();
        }

        public double higher_coverage_minsearchwait() {
            return this.higher_coverage_minsearchwait.value();
        }

        public double higher_coverage_basesearchwait() {
            return this.higher_coverage_basesearchwait.value();
        }

        public double minimal_searchcoverage() {
            return this.minimal_searchcoverage.value();
        }

        public double higher_coverage_maxdocsumwait() {
            return this.higher_coverage_maxdocsumwait.value();
        }

        public double higher_coverage_mindocsumwait() {
            return this.higher_coverage_mindocsumwait.value();
        }

        public double higher_coverage_basedocsumwait() {
            return this.higher_coverage_basedocsumwait.value();
        }

        public double minimal_docsumcoverage() {
            return this.minimal_docsumcoverage.value();
        }

        public Querydistribution.Enum querydistribution() {
            return (Querydistribution.Enum)((Object)this.querydistribution.value());
        }

        public double min_group_coverage() {
            return this.min_group_coverage.value();
        }

        public double min_activedocs_coverage() {
            return this.min_activedocs_coverage.value();
        }

        public double latency_decay_rate() {
            return this.latency_decay_rate.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Dataset newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("dataset");
            return changes;
        }

        private static InnerNodeVector<Dataset> createVector(List<Builder> builders) {
            ArrayList<Dataset> elems = new ArrayList<Dataset>();
            for (Builder b : builders) {
                elems.add(new Dataset(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Querydistribution
        extends EnumNode<Enum> {
            public static final Enum RANDOM = Enum.RANDOM;
            public static final Enum AUTOMATIC = Enum.AUTOMATIC;
            public static final Enum FIXEDROW = Enum.FIXEDROW;

            public Querydistribution() {
                this.value = null;
            }

            public Querydistribution(Enum enumValue) {
                super(enumValue != null);
                this.value = enumValue;
            }

            protected boolean doSetValue(@NonNull String name) {
                try {
                    this.value = Enum.valueOf(name);
                    return true;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }

            public static enum Enum {
                RANDOM,
                AUTOMATIC,
                FIXEDROW;

            }
        }

        public static final class Engine
        extends InnerNode {
            private final StringNode name_and_port;
            private final IntegerNode partid;
            private final IntegerNode rowid;
            private final IntegerNode subdatasetid;
            private final IntegerNode refcost;
            private final BooleanNode overridepartids;

            public Engine(Builder builder) {
                this(builder, true);
            }

            private Engine(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for partitions.dataset[].engine[] must be initialized: " + builder.__uninitialized);
                }
                this.name_and_port = builder.name_and_port == null ? new StringNode() : new StringNode(builder.name_and_port);
                this.partid = builder.partid == null ? new IntegerNode(0) : new IntegerNode(builder.partid.intValue());
                this.rowid = builder.rowid == null ? new IntegerNode(0) : new IntegerNode(builder.rowid.intValue());
                this.subdatasetid = builder.subdatasetid == null ? new IntegerNode(0) : new IntegerNode(builder.subdatasetid.intValue());
                this.refcost = builder.refcost == null ? new IntegerNode(1) : new IntegerNode(builder.refcost.intValue());
                this.overridepartids = builder.overridepartids == null ? new BooleanNode(true) : new BooleanNode(builder.overridepartids.booleanValue());
            }

            public String name_and_port() {
                return this.name_and_port.value();
            }

            public int partid() {
                return this.partid.value();
            }

            public int rowid() {
                return this.rowid.value();
            }

            public int subdatasetid() {
                return this.subdatasetid.value();
            }

            public int refcost() {
                return this.refcost.value();
            }

            public boolean overridepartids() {
                return this.overridepartids.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Engine newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("engine");
                return changes;
            }

            private static InnerNodeVector<Engine> createVector(List<Builder> builders) {
                ArrayList<Engine> elems = new ArrayList<Engine>();
                for (Builder b : builders) {
                    elems.add(new Engine(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name_and_port"));
                private String name_and_port = null;
                private Integer partid = null;
                private Integer rowid = null;
                private Integer subdatasetid = null;
                private Integer refcost = null;
                private Boolean overridepartids = null;

                public Builder() {
                }

                public Builder(Engine config) {
                    this.name_and_port(config.name_and_port());
                    this.partid(config.partid());
                    this.rowid(config.rowid());
                    this.subdatasetid(config.subdatasetid());
                    this.refcost(config.refcost());
                    this.overridepartids(config.overridepartids());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name_and_port != null) {
                        this.name_and_port(__superior.name_and_port);
                    }
                    if (__superior.partid != null) {
                        this.partid(__superior.partid);
                    }
                    if (__superior.rowid != null) {
                        this.rowid(__superior.rowid);
                    }
                    if (__superior.subdatasetid != null) {
                        this.subdatasetid(__superior.subdatasetid);
                    }
                    if (__superior.refcost != null) {
                        this.refcost(__superior.refcost);
                    }
                    if (__superior.overridepartids != null) {
                        this.overridepartids(__superior.overridepartids);
                    }
                    return this;
                }

                public Builder name_and_port(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name_and_port = __value;
                    this.__uninitialized.remove("name_and_port");
                    return this;
                }

                public Builder partid(int __value) {
                    this.partid = __value;
                    return this;
                }

                private Builder partid(String __value) {
                    return this.partid(Integer.valueOf(__value));
                }

                public Builder rowid(int __value) {
                    this.rowid = __value;
                    return this;
                }

                private Builder rowid(String __value) {
                    return this.rowid(Integer.valueOf(__value));
                }

                public Builder subdatasetid(int __value) {
                    this.subdatasetid = __value;
                    return this;
                }

                private Builder subdatasetid(String __value) {
                    return this.subdatasetid(Integer.valueOf(__value));
                }

                public Builder refcost(int __value) {
                    this.refcost = __value;
                    return this;
                }

                private Builder refcost(String __value) {
                    return this.refcost(Integer.valueOf(__value));
                }

                public Builder overridepartids(boolean __value) {
                    this.overridepartids = __value;
                    return this;
                }

                private Builder overridepartids(String __value) {
                    return this.overridepartids(Boolean.valueOf(__value));
                }

                public Engine build() {
                    return new Engine(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("id"));
            private Integer id = null;
            private Integer refcost = null;
            private Long searchablecopies = null;
            private Integer partbits = null;
            private Integer rowbits = null;
            private Integer numparts = null;
            private Integer firstpart = null;
            private Integer minpartitions = null;
            private Integer mpp = null;
            private Integer maxnodesdownperfixedrow = null;
            private Boolean useroundrobinforfixedrow = null;
            public List<Engine.Builder> engine = new ArrayList<Engine.Builder>();
            private Integer maxhitspernode = null;
            private Integer estparts = null;
            private Integer estpartcutoff = null;
            private Integer minactive = null;
            private Integer maxactive = null;
            private Integer cutoffactive = null;
            private Integer minestactive = null;
            private Integer maxestactive = null;
            private Integer cutoffestactive = null;
            private Double queuedrainrate = null;
            private Double queuedrainmax = null;
            private Double slowquerylimitfactor = null;
            private Double slowquerylimitbias = null;
            private Double slowdocsumlimitfactor = null;
            private Double slowdocsumlimitbias = null;
            private Double monitorinterval = null;
            private Double higher_coverage_maxsearchwait = null;
            private Double higher_coverage_minsearchwait = null;
            private Double higher_coverage_basesearchwait = null;
            private Double minimal_searchcoverage = null;
            private Double higher_coverage_maxdocsumwait = null;
            private Double higher_coverage_mindocsumwait = null;
            private Double higher_coverage_basedocsumwait = null;
            private Double minimal_docsumcoverage = null;
            private Querydistribution.Enum querydistribution = null;
            private Double min_group_coverage = null;
            private Double min_activedocs_coverage = null;
            private Double latency_decay_rate = null;

            public Builder() {
            }

            public Builder(Dataset config) {
                this.id(config.id());
                this.refcost(config.refcost());
                this.searchablecopies(config.searchablecopies());
                this.partbits(config.partbits());
                this.rowbits(config.rowbits());
                this.numparts(config.numparts());
                this.firstpart(config.firstpart());
                this.minpartitions(config.minpartitions());
                this.mpp(config.mpp());
                this.maxnodesdownperfixedrow(config.maxnodesdownperfixedrow());
                this.useroundrobinforfixedrow(config.useroundrobinforfixedrow());
                for (Engine e : config.engine()) {
                    this.engine(new Engine.Builder(e));
                }
                this.maxhitspernode(config.maxhitspernode());
                this.estparts(config.estparts());
                this.estpartcutoff(config.estpartcutoff());
                this.minactive(config.minactive());
                this.maxactive(config.maxactive());
                this.cutoffactive(config.cutoffactive());
                this.minestactive(config.minestactive());
                this.maxestactive(config.maxestactive());
                this.cutoffestactive(config.cutoffestactive());
                this.queuedrainrate(config.queuedrainrate());
                this.queuedrainmax(config.queuedrainmax());
                this.slowquerylimitfactor(config.slowquerylimitfactor());
                this.slowquerylimitbias(config.slowquerylimitbias());
                this.slowdocsumlimitfactor(config.slowdocsumlimitfactor());
                this.slowdocsumlimitbias(config.slowdocsumlimitbias());
                this.monitorinterval(config.monitorinterval());
                this.higher_coverage_maxsearchwait(config.higher_coverage_maxsearchwait());
                this.higher_coverage_minsearchwait(config.higher_coverage_minsearchwait());
                this.higher_coverage_basesearchwait(config.higher_coverage_basesearchwait());
                this.minimal_searchcoverage(config.minimal_searchcoverage());
                this.higher_coverage_maxdocsumwait(config.higher_coverage_maxdocsumwait());
                this.higher_coverage_mindocsumwait(config.higher_coverage_mindocsumwait());
                this.higher_coverage_basedocsumwait(config.higher_coverage_basedocsumwait());
                this.minimal_docsumcoverage(config.minimal_docsumcoverage());
                this.querydistribution(config.querydistribution());
                this.min_group_coverage(config.min_group_coverage());
                this.min_activedocs_coverage(config.min_activedocs_coverage());
                this.latency_decay_rate(config.latency_decay_rate());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.refcost != null) {
                    this.refcost(__superior.refcost);
                }
                if (__superior.searchablecopies != null) {
                    this.searchablecopies(__superior.searchablecopies);
                }
                if (__superior.partbits != null) {
                    this.partbits(__superior.partbits);
                }
                if (__superior.rowbits != null) {
                    this.rowbits(__superior.rowbits);
                }
                if (__superior.numparts != null) {
                    this.numparts(__superior.numparts);
                }
                if (__superior.firstpart != null) {
                    this.firstpart(__superior.firstpart);
                }
                if (__superior.minpartitions != null) {
                    this.minpartitions(__superior.minpartitions);
                }
                if (__superior.mpp != null) {
                    this.mpp(__superior.mpp);
                }
                if (__superior.maxnodesdownperfixedrow != null) {
                    this.maxnodesdownperfixedrow(__superior.maxnodesdownperfixedrow);
                }
                if (__superior.useroundrobinforfixedrow != null) {
                    this.useroundrobinforfixedrow(__superior.useroundrobinforfixedrow);
                }
                if (!__superior.engine.isEmpty()) {
                    this.engine.addAll(__superior.engine);
                }
                if (__superior.maxhitspernode != null) {
                    this.maxhitspernode(__superior.maxhitspernode);
                }
                if (__superior.estparts != null) {
                    this.estparts(__superior.estparts);
                }
                if (__superior.estpartcutoff != null) {
                    this.estpartcutoff(__superior.estpartcutoff);
                }
                if (__superior.minactive != null) {
                    this.minactive(__superior.minactive);
                }
                if (__superior.maxactive != null) {
                    this.maxactive(__superior.maxactive);
                }
                if (__superior.cutoffactive != null) {
                    this.cutoffactive(__superior.cutoffactive);
                }
                if (__superior.minestactive != null) {
                    this.minestactive(__superior.minestactive);
                }
                if (__superior.maxestactive != null) {
                    this.maxestactive(__superior.maxestactive);
                }
                if (__superior.cutoffestactive != null) {
                    this.cutoffestactive(__superior.cutoffestactive);
                }
                if (__superior.queuedrainrate != null) {
                    this.queuedrainrate(__superior.queuedrainrate);
                }
                if (__superior.queuedrainmax != null) {
                    this.queuedrainmax(__superior.queuedrainmax);
                }
                if (__superior.slowquerylimitfactor != null) {
                    this.slowquerylimitfactor(__superior.slowquerylimitfactor);
                }
                if (__superior.slowquerylimitbias != null) {
                    this.slowquerylimitbias(__superior.slowquerylimitbias);
                }
                if (__superior.slowdocsumlimitfactor != null) {
                    this.slowdocsumlimitfactor(__superior.slowdocsumlimitfactor);
                }
                if (__superior.slowdocsumlimitbias != null) {
                    this.slowdocsumlimitbias(__superior.slowdocsumlimitbias);
                }
                if (__superior.monitorinterval != null) {
                    this.monitorinterval(__superior.monitorinterval);
                }
                if (__superior.higher_coverage_maxsearchwait != null) {
                    this.higher_coverage_maxsearchwait(__superior.higher_coverage_maxsearchwait);
                }
                if (__superior.higher_coverage_minsearchwait != null) {
                    this.higher_coverage_minsearchwait(__superior.higher_coverage_minsearchwait);
                }
                if (__superior.higher_coverage_basesearchwait != null) {
                    this.higher_coverage_basesearchwait(__superior.higher_coverage_basesearchwait);
                }
                if (__superior.minimal_searchcoverage != null) {
                    this.minimal_searchcoverage(__superior.minimal_searchcoverage);
                }
                if (__superior.higher_coverage_maxdocsumwait != null) {
                    this.higher_coverage_maxdocsumwait(__superior.higher_coverage_maxdocsumwait);
                }
                if (__superior.higher_coverage_mindocsumwait != null) {
                    this.higher_coverage_mindocsumwait(__superior.higher_coverage_mindocsumwait);
                }
                if (__superior.higher_coverage_basedocsumwait != null) {
                    this.higher_coverage_basedocsumwait(__superior.higher_coverage_basedocsumwait);
                }
                if (__superior.minimal_docsumcoverage != null) {
                    this.minimal_docsumcoverage(__superior.minimal_docsumcoverage);
                }
                if (__superior.querydistribution != null) {
                    this.querydistribution(__superior.querydistribution);
                }
                if (__superior.min_group_coverage != null) {
                    this.min_group_coverage(__superior.min_group_coverage);
                }
                if (__superior.min_activedocs_coverage != null) {
                    this.min_activedocs_coverage(__superior.min_activedocs_coverage);
                }
                if (__superior.latency_decay_rate != null) {
                    this.latency_decay_rate(__superior.latency_decay_rate);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder refcost(int __value) {
                this.refcost = __value;
                return this;
            }

            private Builder refcost(String __value) {
                return this.refcost(Integer.valueOf(__value));
            }

            public Builder searchablecopies(long __value) {
                this.searchablecopies = __value;
                return this;
            }

            private Builder searchablecopies(String __value) {
                return this.searchablecopies(Long.valueOf(__value));
            }

            public Builder partbits(int __value) {
                this.partbits = __value;
                return this;
            }

            private Builder partbits(String __value) {
                return this.partbits(Integer.valueOf(__value));
            }

            public Builder rowbits(int __value) {
                this.rowbits = __value;
                return this;
            }

            private Builder rowbits(String __value) {
                return this.rowbits(Integer.valueOf(__value));
            }

            public Builder numparts(int __value) {
                this.numparts = __value;
                return this;
            }

            private Builder numparts(String __value) {
                return this.numparts(Integer.valueOf(__value));
            }

            public Builder firstpart(int __value) {
                this.firstpart = __value;
                return this;
            }

            private Builder firstpart(String __value) {
                return this.firstpart(Integer.valueOf(__value));
            }

            public Builder minpartitions(int __value) {
                this.minpartitions = __value;
                return this;
            }

            private Builder minpartitions(String __value) {
                return this.minpartitions(Integer.valueOf(__value));
            }

            public Builder mpp(int __value) {
                this.mpp = __value;
                return this;
            }

            private Builder mpp(String __value) {
                return this.mpp(Integer.valueOf(__value));
            }

            public Builder maxnodesdownperfixedrow(int __value) {
                this.maxnodesdownperfixedrow = __value;
                return this;
            }

            private Builder maxnodesdownperfixedrow(String __value) {
                return this.maxnodesdownperfixedrow(Integer.valueOf(__value));
            }

            public Builder useroundrobinforfixedrow(boolean __value) {
                this.useroundrobinforfixedrow = __value;
                return this;
            }

            private Builder useroundrobinforfixedrow(String __value) {
                return this.useroundrobinforfixedrow(Boolean.valueOf(__value));
            }

            public Builder engine(Engine.Builder __builder) {
                this.engine.add(__builder);
                return this;
            }

            public Builder engine(List<Engine.Builder> __builders) {
                this.engine = __builders;
                return this;
            }

            public Builder maxhitspernode(int __value) {
                this.maxhitspernode = __value;
                return this;
            }

            private Builder maxhitspernode(String __value) {
                return this.maxhitspernode(Integer.valueOf(__value));
            }

            public Builder estparts(int __value) {
                this.estparts = __value;
                return this;
            }

            private Builder estparts(String __value) {
                return this.estparts(Integer.valueOf(__value));
            }

            public Builder estpartcutoff(int __value) {
                this.estpartcutoff = __value;
                return this;
            }

            private Builder estpartcutoff(String __value) {
                return this.estpartcutoff(Integer.valueOf(__value));
            }

            public Builder minactive(int __value) {
                this.minactive = __value;
                return this;
            }

            private Builder minactive(String __value) {
                return this.minactive(Integer.valueOf(__value));
            }

            public Builder maxactive(int __value) {
                this.maxactive = __value;
                return this;
            }

            private Builder maxactive(String __value) {
                return this.maxactive(Integer.valueOf(__value));
            }

            public Builder cutoffactive(int __value) {
                this.cutoffactive = __value;
                return this;
            }

            private Builder cutoffactive(String __value) {
                return this.cutoffactive(Integer.valueOf(__value));
            }

            public Builder minestactive(int __value) {
                this.minestactive = __value;
                return this;
            }

            private Builder minestactive(String __value) {
                return this.minestactive(Integer.valueOf(__value));
            }

            public Builder maxestactive(int __value) {
                this.maxestactive = __value;
                return this;
            }

            private Builder maxestactive(String __value) {
                return this.maxestactive(Integer.valueOf(__value));
            }

            public Builder cutoffestactive(int __value) {
                this.cutoffestactive = __value;
                return this;
            }

            private Builder cutoffestactive(String __value) {
                return this.cutoffestactive(Integer.valueOf(__value));
            }

            public Builder queuedrainrate(double __value) {
                this.queuedrainrate = __value;
                return this;
            }

            private Builder queuedrainrate(String __value) {
                return this.queuedrainrate(Double.valueOf(__value));
            }

            public Builder queuedrainmax(double __value) {
                this.queuedrainmax = __value;
                return this;
            }

            private Builder queuedrainmax(String __value) {
                return this.queuedrainmax(Double.valueOf(__value));
            }

            public Builder slowquerylimitfactor(double __value) {
                this.slowquerylimitfactor = __value;
                return this;
            }

            private Builder slowquerylimitfactor(String __value) {
                return this.slowquerylimitfactor(Double.valueOf(__value));
            }

            public Builder slowquerylimitbias(double __value) {
                this.slowquerylimitbias = __value;
                return this;
            }

            private Builder slowquerylimitbias(String __value) {
                return this.slowquerylimitbias(Double.valueOf(__value));
            }

            public Builder slowdocsumlimitfactor(double __value) {
                this.slowdocsumlimitfactor = __value;
                return this;
            }

            private Builder slowdocsumlimitfactor(String __value) {
                return this.slowdocsumlimitfactor(Double.valueOf(__value));
            }

            public Builder slowdocsumlimitbias(double __value) {
                this.slowdocsumlimitbias = __value;
                return this;
            }

            private Builder slowdocsumlimitbias(String __value) {
                return this.slowdocsumlimitbias(Double.valueOf(__value));
            }

            public Builder monitorinterval(double __value) {
                this.monitorinterval = __value;
                return this;
            }

            private Builder monitorinterval(String __value) {
                return this.monitorinterval(Double.valueOf(__value));
            }

            public Builder higher_coverage_maxsearchwait(double __value) {
                this.higher_coverage_maxsearchwait = __value;
                return this;
            }

            private Builder higher_coverage_maxsearchwait(String __value) {
                return this.higher_coverage_maxsearchwait(Double.valueOf(__value));
            }

            public Builder higher_coverage_minsearchwait(double __value) {
                this.higher_coverage_minsearchwait = __value;
                return this;
            }

            private Builder higher_coverage_minsearchwait(String __value) {
                return this.higher_coverage_minsearchwait(Double.valueOf(__value));
            }

            public Builder higher_coverage_basesearchwait(double __value) {
                this.higher_coverage_basesearchwait = __value;
                return this;
            }

            private Builder higher_coverage_basesearchwait(String __value) {
                return this.higher_coverage_basesearchwait(Double.valueOf(__value));
            }

            public Builder minimal_searchcoverage(double __value) {
                this.minimal_searchcoverage = __value;
                return this;
            }

            private Builder minimal_searchcoverage(String __value) {
                return this.minimal_searchcoverage(Double.valueOf(__value));
            }

            public Builder higher_coverage_maxdocsumwait(double __value) {
                this.higher_coverage_maxdocsumwait = __value;
                return this;
            }

            private Builder higher_coverage_maxdocsumwait(String __value) {
                return this.higher_coverage_maxdocsumwait(Double.valueOf(__value));
            }

            public Builder higher_coverage_mindocsumwait(double __value) {
                this.higher_coverage_mindocsumwait = __value;
                return this;
            }

            private Builder higher_coverage_mindocsumwait(String __value) {
                return this.higher_coverage_mindocsumwait(Double.valueOf(__value));
            }

            public Builder higher_coverage_basedocsumwait(double __value) {
                this.higher_coverage_basedocsumwait = __value;
                return this;
            }

            private Builder higher_coverage_basedocsumwait(String __value) {
                return this.higher_coverage_basedocsumwait(Double.valueOf(__value));
            }

            public Builder minimal_docsumcoverage(double __value) {
                this.minimal_docsumcoverage = __value;
                return this;
            }

            private Builder minimal_docsumcoverage(String __value) {
                return this.minimal_docsumcoverage(Double.valueOf(__value));
            }

            public Builder querydistribution(Querydistribution.Enum __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.querydistribution = __value;
                return this;
            }

            private Builder querydistribution(String __value) {
                return this.querydistribution(Querydistribution.Enum.valueOf(__value));
            }

            public Builder min_group_coverage(double __value) {
                this.min_group_coverage = __value;
                return this;
            }

            private Builder min_group_coverage(String __value) {
                return this.min_group_coverage(Double.valueOf(__value));
            }

            public Builder min_activedocs_coverage(double __value) {
                this.min_activedocs_coverage = __value;
                return this;
            }

            private Builder min_activedocs_coverage(String __value) {
                return this.min_activedocs_coverage(Double.valueOf(__value));
            }

            public Builder latency_decay_rate(double __value) {
                this.latency_decay_rate = __value;
                return this;
            }

            private Builder latency_decay_rate(String __value) {
                return this.latency_decay_rate(Double.valueOf(__value));
            }

            public Dataset build() {
                return new Dataset(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Dataset.Builder> dataset = new ArrayList<Dataset.Builder>();

        public Builder() {
        }

        public Builder(PartitionsConfig config) {
            for (Dataset d : config.dataset()) {
                this.dataset(new Dataset.Builder(d));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.dataset.isEmpty()) {
                this.dataset.addAll(__superior.dataset);
            }
            return this;
        }

        public Builder dataset(Dataset.Builder __builder) {
            this.dataset.add(__builder);
            return this;
        }

        public Builder dataset(List<Dataset.Builder> __builders) {
            this.dataset = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return PartitionsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return PartitionsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return PartitionsConfig.CONFIG_DEF_NAMESPACE;
        }

        public PartitionsConfig build() {
            return new PartitionsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

