/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class OnnxModelsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "6a898bcab0e61c58813a593d1f1ffa79";
    public static final String CONFIG_DEF_NAME = "onnx-models";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "model[].name string", "model[].fileref file", "model[].input[].name string", "model[].input[].source string", "model[].output[].name string", "model[].output[].as string"};
    private final InnerNodeVector<Model> model;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public OnnxModelsConfig(Builder builder) {
        this(builder, true);
    }

    private OnnxModelsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for onnx-models must be initialized: " + builder.__uninitialized);
        }
        this.model = Model.createVector(builder.model);
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OnnxModelsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Model
    extends InnerNode {
        private final StringNode name;
        private final FileNode fileref;
        private final InnerNodeVector<Input> input;
        private final InnerNodeVector<Output> output;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for onnx-models.model[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.fileref = builder.fileref == null ? new FileNode() : new FileNode(builder.fileref);
            this.input = Input.createVector(builder.input);
            this.output = Output.createVector(builder.output);
        }

        public String name() {
            return this.name.value();
        }

        public FileReference fileref() {
            return this.fileref.value();
        }

        public List<Input> input() {
            return this.input;
        }

        public Input input(int i) {
            return (Input)((Object)this.input.get(i));
        }

        public List<Output> output() {
            return this.output;
        }

        public Output output(int i) {
            return (Output)((Object)this.output.get(i));
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Output
        extends InnerNode {
            private final StringNode name;
            private final StringNode as;

            public Output(Builder builder) {
                this(builder, true);
            }

            private Output(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for onnx-models.model[].output[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.as = builder.as == null ? new StringNode() : new StringNode(builder.as);
            }

            public String name() {
                return this.name.value();
            }

            public String as() {
                return this.as.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Output newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("output");
                return changes;
            }

            private static InnerNodeVector<Output> createVector(List<Builder> builders) {
                ArrayList<Output> elems = new ArrayList<Output>();
                for (Builder b : builders) {
                    elems.add(new Output(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "as"));
                private String name = null;
                private String as = null;

                public Builder() {
                }

                public Builder(Output config) {
                    this.name(config.name());
                    this.as(config.as());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.as != null) {
                        this.as(__superior.as);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder as(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.as = __value;
                    this.__uninitialized.remove("as");
                    return this;
                }

                public Output build() {
                    return new Output(this);
                }
            }
        }

        public static final class Input
        extends InnerNode {
            private final StringNode name;
            private final StringNode source;

            public Input(Builder builder) {
                this(builder, true);
            }

            private Input(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for onnx-models.model[].input[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.source = builder.source == null ? new StringNode() : new StringNode(builder.source);
            }

            public String name() {
                return this.name.value();
            }

            public String source() {
                return this.source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Input newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("input");
                return changes;
            }

            private static InnerNodeVector<Input> createVector(List<Builder> builders) {
                ArrayList<Input> elems = new ArrayList<Input>();
                for (Builder b : builders) {
                    elems.add(new Input(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "source"));
                private String name = null;
                private String source = null;

                public Builder() {
                }

                public Builder(Input config) {
                    this.name(config.name());
                    this.source(config.source());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.source != null) {
                        this.source(__superior.source);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder source(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.source = __value;
                    this.__uninitialized.remove("source");
                    return this;
                }

                public Input build() {
                    return new Input(this);
                }
            }
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "fileref"));
            private String name = null;
            private String fileref = null;
            public List<Input.Builder> input = new ArrayList<Input.Builder>();
            public List<Output.Builder> output = new ArrayList<Output.Builder>();

            public Builder() {
            }

            public Builder(Model config) {
                this.name(config.name());
                this.fileref(config.fileref().value());
                for (Input i : config.input()) {
                    this.input(new Input.Builder(i));
                }
                for (Output o : config.output()) {
                    this.output(new Output.Builder(o));
                }
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.fileref != null) {
                    this.fileref(__superior.fileref);
                }
                if (!__superior.input.isEmpty()) {
                    this.input.addAll(__superior.input);
                }
                if (!__superior.output.isEmpty()) {
                    this.output.addAll(__superior.output);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder fileref(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileref = __value;
                this.__uninitialized.remove("fileref");
                return this;
            }

            public Builder input(Input.Builder __builder) {
                this.input.add(__builder);
                return this;
            }

            public Builder input(List<Input.Builder> __builders) {
                this.input = __builders;
                return this;
            }

            public Builder output(Output.Builder __builder) {
                this.output.add(__builder);
                return this;
            }

            public Builder output(List<Output.Builder> __builders) {
                this.output = __builders;
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Model.Builder> model = new ArrayList<Model.Builder>();

        public Builder() {
        }

        public Builder(OnnxModelsConfig config) {
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OnnxModelsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OnnxModelsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OnnxModelsConfig.CONFIG_DEF_NAMESPACE;
        }

        public OnnxModelsConfig build() {
            return new OnnxModelsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

