/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class FdispatchrcConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "00e5f99a6f94068b943368961e7335bb";
    public static final String CONFIG_DEF_NAME = "fdispatchrc";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "defaultslowdocsumlimitbias double default=1.0 restart", "defaultslowdocsumlimitfactor double default=2.0 restart", "defaultslowquerylimitbias double default=1.0 restart", "defaultslowquerylimitfactor double default=2.0 restart", "frtport int default=0 restart", "healthport int default=0 restart", "maxsocksilent double default=5.0 restart", "maxthreads int default=150 restart", "transportthreads int default=1 restart", "partition int default=0 restart", "ptport int default=0 restart", "transport string default=\"\"", "transportnodelay bool default=true restart", "packetcompresslimit int default = 1024 restart", "packetcompresslevel int default = 3 restart", "packetcompresstype enum {NONE, LZ4} default=LZ4 restart", "dispatchlevel int default=0 restart"};
    private final DoubleNode defaultslowdocsumlimitbias;
    private final DoubleNode defaultslowdocsumlimitfactor;
    private final DoubleNode defaultslowquerylimitbias;
    private final DoubleNode defaultslowquerylimitfactor;
    private final IntegerNode frtport;
    private final IntegerNode healthport;
    private final DoubleNode maxsocksilent;
    private final IntegerNode maxthreads;
    private final IntegerNode transportthreads;
    private final IntegerNode partition;
    private final IntegerNode ptport;
    private final StringNode transport;
    private final BooleanNode transportnodelay;
    private final IntegerNode packetcompresslimit;
    private final IntegerNode packetcompresslevel;
    private final Packetcompresstype packetcompresstype;
    private final IntegerNode dispatchlevel;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public FdispatchrcConfig(Builder builder) {
        this(builder, true);
    }

    private FdispatchrcConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for fdispatchrc must be initialized: " + builder.__uninitialized);
        }
        this.defaultslowdocsumlimitbias = builder.defaultslowdocsumlimitbias == null ? new DoubleNode(1.0) : new DoubleNode(builder.defaultslowdocsumlimitbias.doubleValue());
        this.defaultslowdocsumlimitfactor = builder.defaultslowdocsumlimitfactor == null ? new DoubleNode(2.0) : new DoubleNode(builder.defaultslowdocsumlimitfactor.doubleValue());
        this.defaultslowquerylimitbias = builder.defaultslowquerylimitbias == null ? new DoubleNode(1.0) : new DoubleNode(builder.defaultslowquerylimitbias.doubleValue());
        this.defaultslowquerylimitfactor = builder.defaultslowquerylimitfactor == null ? new DoubleNode(2.0) : new DoubleNode(builder.defaultslowquerylimitfactor.doubleValue());
        this.frtport = builder.frtport == null ? new IntegerNode(0) : new IntegerNode(builder.frtport.intValue());
        this.healthport = builder.healthport == null ? new IntegerNode(0) : new IntegerNode(builder.healthport.intValue());
        this.maxsocksilent = builder.maxsocksilent == null ? new DoubleNode(5.0) : new DoubleNode(builder.maxsocksilent.doubleValue());
        this.maxthreads = builder.maxthreads == null ? new IntegerNode(150) : new IntegerNode(builder.maxthreads.intValue());
        this.transportthreads = builder.transportthreads == null ? new IntegerNode(1) : new IntegerNode(builder.transportthreads.intValue());
        this.partition = builder.partition == null ? new IntegerNode(0) : new IntegerNode(builder.partition.intValue());
        this.ptport = builder.ptport == null ? new IntegerNode(0) : new IntegerNode(builder.ptport.intValue());
        this.transport = builder.transport == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.transport);
        this.transportnodelay = builder.transportnodelay == null ? new BooleanNode(true) : new BooleanNode(builder.transportnodelay.booleanValue());
        this.packetcompresslimit = builder.packetcompresslimit == null ? new IntegerNode(1024) : new IntegerNode(builder.packetcompresslimit.intValue());
        this.packetcompresslevel = builder.packetcompresslevel == null ? new IntegerNode(3) : new IntegerNode(builder.packetcompresslevel.intValue());
        this.packetcompresstype = builder.packetcompresstype == null ? new Packetcompresstype(Packetcompresstype.LZ4) : new Packetcompresstype(builder.packetcompresstype);
        this.dispatchlevel = builder.dispatchlevel == null ? new IntegerNode(0) : new IntegerNode(builder.dispatchlevel.intValue());
    }

    public double defaultslowdocsumlimitbias() {
        return this.defaultslowdocsumlimitbias.value();
    }

    public double defaultslowdocsumlimitfactor() {
        return this.defaultslowdocsumlimitfactor.value();
    }

    public double defaultslowquerylimitbias() {
        return this.defaultslowquerylimitbias.value();
    }

    public double defaultslowquerylimitfactor() {
        return this.defaultslowquerylimitfactor.value();
    }

    public int frtport() {
        return this.frtport.value();
    }

    public int healthport() {
        return this.healthport.value();
    }

    public double maxsocksilent() {
        return this.maxsocksilent.value();
    }

    public int maxthreads() {
        return this.maxthreads.value();
    }

    public int transportthreads() {
        return this.transportthreads.value();
    }

    public int partition() {
        return this.partition.value();
    }

    public int ptport() {
        return this.ptport.value();
    }

    public String transport() {
        return this.transport.value();
    }

    public boolean transportnodelay() {
        return this.transportnodelay.value();
    }

    public int packetcompresslimit() {
        return this.packetcompresslimit.value();
    }

    public int packetcompresslevel() {
        return this.packetcompresslevel.value();
    }

    public Packetcompresstype.Enum packetcompresstype() {
        return (Packetcompresstype.Enum)((Object)this.packetcompresstype.value());
    }

    public int dispatchlevel() {
        return this.dispatchlevel.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FdispatchrcConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compare((Node)this.defaultslowdocsumlimitbias, (Node)newConfig.defaultslowdocsumlimitbias, "defaultslowdocsumlimitbias", "Default bias used when calculating docsum slowness limit. The\nformula used is: factor * Average Docsum Time + bias. If a node\nuses more time than this limit, it is considered slow. This config\nvalue may be overridden per dataset by using the slowdocsumlimitbias\nkeyword in the partitions file.");
        changes.compare((Node)this.defaultslowdocsumlimitfactor, (Node)newConfig.defaultslowdocsumlimitfactor, "defaultslowdocsumlimitfactor", "Default factor used when calculating docsum slowness limit. The\nformula used is: factor * Average Docsum Time + bias. If a node\nuses more time than this limit, it is considered slow. This config\nvalue may be overridden per dataset by using the slowdocsumlimitfactor\nkeyword in the partitions file.");
        changes.compare((Node)this.defaultslowquerylimitbias, (Node)newConfig.defaultslowquerylimitbias, "defaultslowquerylimitbias", "Default bias used when calculating query slowness limit. The\nformula used is: factor * Average Search Time + bias. If a node\nuses more time than this limit, it is considered slow. This config\nvalue may be overridden per dataset by using the slowquerylimitbias\nkeyword in the partitions file.");
        changes.compare((Node)this.defaultslowquerylimitfactor, (Node)newConfig.defaultslowquerylimitfactor, "defaultslowquerylimitfactor", "Default factor used when calculating query slowness limit. The\nformula used is: factor * Average Search Time + bias. If a node\nuses more time than this limit, it is considered slow. This config\nvalue may be overridden per dataset by using the slowquerylimitfactor\nkeyword in the partitions file.");
        changes.compare((Node)this.frtport, (Node)newConfig.frtport, "frtport", "The port where FNET Remote Tools RPC service should be made available.\nIf 0, fdispatch will not offer RPC service.");
        changes.compare((Node)this.healthport, (Node)newConfig.healthport, "healthport", "Port for health reporting");
        changes.compare((Node)this.maxsocksilent, (Node)newConfig.maxsocksilent, "maxsocksilent", "The maximum time between successful reads on a socket before timeout.");
        changes.compare((Node)this.maxthreads, (Node)newConfig.maxthreads, "maxthreads", "The maximum number of threads used. 0 means no limit.");
        changes.compare((Node)this.transportthreads, (Node)newConfig.transportthreads, "transportthreads", "The number of transport threads used when talking to search nodes.");
        changes.compare((Node)this.partition, (Node)newConfig.partition, "partition", "specifies the partition we provide upwards in a multi-level dispatch system.");
        changes.compare((Node)this.ptport, (Node)newConfig.ptport, "ptport", "specifies the port number for the persistent internal transport\nprotocol provided for a multi-level dispatch system. If this value\nis 0, MLD service is not provided, and this process cannot be used\nby other fdispatch processes.");
        changes.compare((Node)this.transportnodelay, (Node)newConfig.transportnodelay, "transportnodelay", "If present, the TCP_NODELAY option is set on the persistent\ntransport connections. This causes non-full packets to be sent even\nthough previously sent data has not yet been acknowledged (e.g. due\nto the delayed ack feature present on various tcp stacks).");
        changes.compare((Node)this.packetcompresslimit, (Node)newConfig.packetcompresslimit, "packetcompresslimit", "Minimum size of packets to compress (0 means no compression)\n ");
        changes.compare((Node)this.packetcompresslevel, (Node)newConfig.packetcompresslevel, "packetcompresslevel", "Compression level for packets\n \nDefault value is 3");
        changes.compare((Node)this.packetcompresstype, (Node)newConfig.packetcompresstype, "packetcompresstype", "Compression type for packets\n \nDefault is LZ4");
        changes.compare((Node)this.dispatchlevel, (Node)newConfig.dispatchlevel, "dispatchlevel", "Specifies at which level this dispatcher is in a multi-level dispatch system.\nThe top-level dispatcher is at level 0.");
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Packetcompresstype
    extends EnumNode<Enum> {
        public static final Enum NONE = Enum.NONE;
        public static final Enum LZ4 = Enum.LZ4;

        public Packetcompresstype() {
            this.value = null;
        }

        public Packetcompresstype(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            NONE,
            LZ4;

        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Double defaultslowdocsumlimitbias = null;
        private Double defaultslowdocsumlimitfactor = null;
        private Double defaultslowquerylimitbias = null;
        private Double defaultslowquerylimitfactor = null;
        private Integer frtport = null;
        private Integer healthport = null;
        private Double maxsocksilent = null;
        private Integer maxthreads = null;
        private Integer transportthreads = null;
        private Integer partition = null;
        private Integer ptport = null;
        private String transport = null;
        private Boolean transportnodelay = null;
        private Integer packetcompresslimit = null;
        private Integer packetcompresslevel = null;
        private Packetcompresstype.Enum packetcompresstype = null;
        private Integer dispatchlevel = null;

        public Builder() {
        }

        public Builder(FdispatchrcConfig config) {
            this.defaultslowdocsumlimitbias(config.defaultslowdocsumlimitbias());
            this.defaultslowdocsumlimitfactor(config.defaultslowdocsumlimitfactor());
            this.defaultslowquerylimitbias(config.defaultslowquerylimitbias());
            this.defaultslowquerylimitfactor(config.defaultslowquerylimitfactor());
            this.frtport(config.frtport());
            this.healthport(config.healthport());
            this.maxsocksilent(config.maxsocksilent());
            this.maxthreads(config.maxthreads());
            this.transportthreads(config.transportthreads());
            this.partition(config.partition());
            this.ptport(config.ptport());
            this.transport(config.transport());
            this.transportnodelay(config.transportnodelay());
            this.packetcompresslimit(config.packetcompresslimit());
            this.packetcompresslevel(config.packetcompresslevel());
            this.packetcompresstype(config.packetcompresstype());
            this.dispatchlevel(config.dispatchlevel());
        }

        private Builder override(Builder __superior) {
            if (__superior.defaultslowdocsumlimitbias != null) {
                this.defaultslowdocsumlimitbias(__superior.defaultslowdocsumlimitbias);
            }
            if (__superior.defaultslowdocsumlimitfactor != null) {
                this.defaultslowdocsumlimitfactor(__superior.defaultslowdocsumlimitfactor);
            }
            if (__superior.defaultslowquerylimitbias != null) {
                this.defaultslowquerylimitbias(__superior.defaultslowquerylimitbias);
            }
            if (__superior.defaultslowquerylimitfactor != null) {
                this.defaultslowquerylimitfactor(__superior.defaultslowquerylimitfactor);
            }
            if (__superior.frtport != null) {
                this.frtport(__superior.frtport);
            }
            if (__superior.healthport != null) {
                this.healthport(__superior.healthport);
            }
            if (__superior.maxsocksilent != null) {
                this.maxsocksilent(__superior.maxsocksilent);
            }
            if (__superior.maxthreads != null) {
                this.maxthreads(__superior.maxthreads);
            }
            if (__superior.transportthreads != null) {
                this.transportthreads(__superior.transportthreads);
            }
            if (__superior.partition != null) {
                this.partition(__superior.partition);
            }
            if (__superior.ptport != null) {
                this.ptport(__superior.ptport);
            }
            if (__superior.transport != null) {
                this.transport(__superior.transport);
            }
            if (__superior.transportnodelay != null) {
                this.transportnodelay(__superior.transportnodelay);
            }
            if (__superior.packetcompresslimit != null) {
                this.packetcompresslimit(__superior.packetcompresslimit);
            }
            if (__superior.packetcompresslevel != null) {
                this.packetcompresslevel(__superior.packetcompresslevel);
            }
            if (__superior.packetcompresstype != null) {
                this.packetcompresstype(__superior.packetcompresstype);
            }
            if (__superior.dispatchlevel != null) {
                this.dispatchlevel(__superior.dispatchlevel);
            }
            return this;
        }

        public Builder defaultslowdocsumlimitbias(double __value) {
            this.defaultslowdocsumlimitbias = __value;
            return this;
        }

        private Builder defaultslowdocsumlimitbias(String __value) {
            return this.defaultslowdocsumlimitbias(Double.valueOf(__value));
        }

        public Builder defaultslowdocsumlimitfactor(double __value) {
            this.defaultslowdocsumlimitfactor = __value;
            return this;
        }

        private Builder defaultslowdocsumlimitfactor(String __value) {
            return this.defaultslowdocsumlimitfactor(Double.valueOf(__value));
        }

        public Builder defaultslowquerylimitbias(double __value) {
            this.defaultslowquerylimitbias = __value;
            return this;
        }

        private Builder defaultslowquerylimitbias(String __value) {
            return this.defaultslowquerylimitbias(Double.valueOf(__value));
        }

        public Builder defaultslowquerylimitfactor(double __value) {
            this.defaultslowquerylimitfactor = __value;
            return this;
        }

        private Builder defaultslowquerylimitfactor(String __value) {
            return this.defaultslowquerylimitfactor(Double.valueOf(__value));
        }

        public Builder frtport(int __value) {
            this.frtport = __value;
            return this;
        }

        private Builder frtport(String __value) {
            return this.frtport(Integer.valueOf(__value));
        }

        public Builder healthport(int __value) {
            this.healthport = __value;
            return this;
        }

        private Builder healthport(String __value) {
            return this.healthport(Integer.valueOf(__value));
        }

        public Builder maxsocksilent(double __value) {
            this.maxsocksilent = __value;
            return this;
        }

        private Builder maxsocksilent(String __value) {
            return this.maxsocksilent(Double.valueOf(__value));
        }

        public Builder maxthreads(int __value) {
            this.maxthreads = __value;
            return this;
        }

        private Builder maxthreads(String __value) {
            return this.maxthreads(Integer.valueOf(__value));
        }

        public Builder transportthreads(int __value) {
            this.transportthreads = __value;
            return this;
        }

        private Builder transportthreads(String __value) {
            return this.transportthreads(Integer.valueOf(__value));
        }

        public Builder partition(int __value) {
            this.partition = __value;
            return this;
        }

        private Builder partition(String __value) {
            return this.partition(Integer.valueOf(__value));
        }

        public Builder ptport(int __value) {
            this.ptport = __value;
            return this;
        }

        private Builder ptport(String __value) {
            return this.ptport(Integer.valueOf(__value));
        }

        public Builder transport(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.transport = __value;
            return this;
        }

        public Builder transportnodelay(boolean __value) {
            this.transportnodelay = __value;
            return this;
        }

        private Builder transportnodelay(String __value) {
            return this.transportnodelay(Boolean.valueOf(__value));
        }

        public Builder packetcompresslimit(int __value) {
            this.packetcompresslimit = __value;
            return this;
        }

        private Builder packetcompresslimit(String __value) {
            return this.packetcompresslimit(Integer.valueOf(__value));
        }

        public Builder packetcompresslevel(int __value) {
            this.packetcompresslevel = __value;
            return this;
        }

        private Builder packetcompresslevel(String __value) {
            return this.packetcompresslevel(Integer.valueOf(__value));
        }

        public Builder packetcompresstype(Packetcompresstype.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.packetcompresstype = __value;
            return this;
        }

        private Builder packetcompresstype(String __value) {
            return this.packetcompresstype(Packetcompresstype.Enum.valueOf(__value));
        }

        public Builder dispatchlevel(int __value) {
            this.dispatchlevel = __value;
            return this;
        }

        private Builder dispatchlevel(String __value) {
            return this.dispatchlevel(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return FdispatchrcConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return FdispatchrcConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return FdispatchrcConfig.CONFIG_DEF_NAMESPACE;
        }

        public FdispatchrcConfig build() {
            return new FdispatchrcConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

