/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class RankingConstantsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "c285ed1fda604d6dd53e814bae81a008";
    public static final String CONFIG_DEF_NAME = "ranking-constants";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "constant[].name string", "constant[].fileref file", "constant[].type string"};
    private final InnerNodeVector<Constant> constant;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public RankingConstantsConfig(Builder builder) {
        this(builder, true);
    }

    private RankingConstantsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for ranking-constants must be initialized: " + builder.__uninitialized);
        }
        this.constant = Constant.createVector(builder.constant);
    }

    public List<Constant> constant() {
        return this.constant;
    }

    public Constant constant(int i) {
        return (Constant)((Object)this.constant.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(RankingConstantsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Constant
    extends InnerNode {
        private final StringNode name;
        private final FileNode fileref;
        private final StringNode type;

        public Constant(Builder builder) {
            this(builder, true);
        }

        private Constant(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for ranking-constants.constant[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.fileref = builder.fileref == null ? new FileNode() : new FileNode(builder.fileref);
            this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
        }

        public String name() {
            return this.name.value();
        }

        public FileReference fileref() {
            return this.fileref.value();
        }

        public String type() {
            return this.type.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Constant newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("constant");
            return changes;
        }

        private static InnerNodeVector<Constant> createVector(List<Builder> builders) {
            ArrayList<Constant> elems = new ArrayList<Constant>();
            for (Builder b : builders) {
                elems.add(new Constant(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "fileref", "type"));
            private String name = null;
            private String fileref = null;
            private String type = null;

            public Builder() {
            }

            public Builder(Constant config) {
                this.name(config.name());
                this.fileref(config.fileref().value());
                this.type(config.type());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.fileref != null) {
                    this.fileref(__superior.fileref);
                }
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder fileref(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileref = __value;
                this.__uninitialized.remove("fileref");
                return this;
            }

            public Builder type(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                this.__uninitialized.remove("type");
                return this;
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Constant.Builder> constant = new ArrayList<Constant.Builder>();

        public Builder() {
        }

        public Builder(RankingConstantsConfig config) {
            for (Constant c : config.constant()) {
                this.constant(new Constant.Builder(c));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.constant.isEmpty()) {
                this.constant.addAll(__superior.constant);
            }
            return this;
        }

        public Builder constant(Constant.Builder __builder) {
            this.constant.add(__builder);
            return this;
        }

        public Builder constant(List<Constant.Builder> __builders) {
            this.constant = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return RankingConstantsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return RankingConstantsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return RankingConstantsConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

