/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.common.command.CommandUtils;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import ai.vespa.schemals.tree.Node;
import java.util.List;
import java.util.Optional;

public class GetSchemaFields
implements SchemaCommand {
    private String schemaName;

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        Optional<String> argument2 = CommandUtils.getStringArgument(arguments2.get(0));
        if (argument2.isEmpty()) {
            return false;
        }
        this.schemaName = argument2.get();
        return true;
    }

    public String fieldSymbolTypeText(EventExecuteCommandContext context, Symbol fieldSymbol) {
        Optional<Node> typeNode = context.schemaIndex.fieldIndex().getFieldDataTypeNode(fieldSymbol);
        if (typeNode.isPresent()) {
            return typeNode.get().getText();
        }
        return "";
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        if (this.schemaName == null) {
            return List.of();
        }
        Optional<Symbol> schemaSymbol = context.schemaIndex.findSymbol(null, Symbol.SymbolType.SCHEMA, this.schemaName);
        if (schemaSymbol.isEmpty()) {
            return List.of();
        }
        return context.schemaIndex.listSymbolsInScope(schemaSymbol.get(), Symbol.SymbolType.FIELD).stream().map(symbol -> List.of(symbol.getShortIdentifier(), this.fieldSymbolTypeText(context, (Symbol)symbol))).toList();
    }
}

