/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.documentation;

import ai.vespa.schemals.documentation.ContentFetcher;
import com.vladsch.flexmark.html2md.converter.FlexmarkHtmlConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class RankFeatureDocumentationFetcher
extends ContentFetcher {
    RankFeatureDocumentationFetcher(String relativeFileUrl) {
        super(relativeFileUrl);
    }

    @Override
    Map<String, String> getMarkdownContent() throws IOException {
        Document document = Jsoup.connect((String)("https://docs.vespa.ai/" + this.fileUrl)).followRedirects(true).get();
        Element tableElement = document.selectFirst("table.table");
        Elements trs = tableElement.select("tr:has(> td:nth-child(3)):not(:has(> td:nth-child(4)))");
        HashMap<String, String> result = new HashMap<String, String>();
        FlexmarkHtmlConverter converter = this.getHtmlParser();
        for (Element tr : trs) {
            String name = tr.child(0).text();
            name = name.replaceAll(", ", ",").replaceAll("input_1,input_2,...", "input,...");
            Object content = converter.convert(tr.child(2).html());
            content = (String)content + "\nDefault: " + tr.child(1).text();
            result.put(name, (String)content);
        }
        return result;
    }
}

