/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.common.FileUtils;
import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.SchemaParser;
import ai.vespa.schemals.parser.SubLanguageData;
import ai.vespa.schemals.parser.ast.indexingElm;
import ai.vespa.schemals.parser.ast.indexingOperationElm;
import ai.vespa.schemals.parser.indexinglanguage.IndexingParser;
import ai.vespa.schemals.parser.indexinglanguage.ParseException;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import ai.vespa.schemals.schemadocument.SchemaRankingExpressionParser;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.schemadocument.resolvers.DocumentReferenceResolver;
import ai.vespa.schemals.schemadocument.resolvers.FieldArgumentResolver;
import ai.vespa.schemals.schemadocument.resolvers.InheritanceResolver;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.FieldArgument;
import ai.vespa.schemals.schemadocument.resolvers.ResolverTraversal;
import ai.vespa.schemals.schemadocument.resolvers.StructFieldDefinitionResolver;
import ai.vespa.schemals.schemadocument.resolvers.TypeNodeResolver;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQLNode;
import ai.vespa.schemals.tree.indexinglanguage.ILUtils;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

public class SchemaDocument
implements DocumentManager {
    private ClientLogger logger;
    private SchemaDiagnosticsHandler diagnosticsHandler;
    private SchemaIndex schemaIndex;
    private SchemaDocumentScheduler scheduler;
    private String fileURI = "";
    private Integer version;
    private boolean isOpen = false;
    private String content = "";
    private String schemaDocumentIdentifier = null;
    private SchemaNode CST;
    private SchemaDocumentLexer lexer = new SchemaDocumentLexer();

    public SchemaDocument(ClientLogger logger, SchemaDiagnosticsHandler diagnosticsHandler, SchemaIndex schemaIndex, SchemaDocumentScheduler scheduler, String fileURI) {
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
        this.schemaIndex = schemaIndex;
        this.fileURI = fileURI;
        this.scheduler = scheduler;
    }

    @Override
    public ParseContext getParseContext() {
        ParseContext context = new ParseContext(this.content, this.logger, this.fileURI, this.schemaIndex, this.scheduler);
        context.useGeneralIdentifers();
        context.useDocumentIdentifiers();
        return context;
    }

    @Override
    public void reparseContent() {
        if (this.content != null) {
            this.updateFileContent(this.content, this.version);
        }
    }

    @Override
    public void updateFileContent(String content, Integer version) {
        this.version = version;
        this.updateFileContent(content);
    }

    @Override
    public void updateFileContent(String content) {
        this.content = content;
        this.schemaIndex.clearDocument(this.fileURI);
        this.logger.info("Parsing: " + this.fileURI);
        ParseContext context = this.getParseContext();
        ParseResult parsingResult = SchemaDocument.parseContent(context);
        parsingResult.diagnostics().addAll(this.verifyFileName());
        this.diagnosticsHandler.publishDiagnostics(this.fileURI, parsingResult.diagnostics());
        if (parsingResult.CST().isPresent()) {
            this.CST = parsingResult.CST().get();
            this.lexer.setCST(this.CST);
        }
    }

    private List<Diagnostic> verifyFileName() {
        ArrayList<Diagnostic> ret = new ArrayList<Diagnostic>();
        List<Symbol> schemaSymbols = this.schemaIndex.getSymbolsByType(Symbol.SymbolType.SCHEMA);
        Symbol schemaIdentifier = null;
        for (Symbol symbol : schemaSymbols) {
            if (!symbol.getFileURI().equals(this.fileURI)) continue;
            schemaIdentifier = symbol;
            break;
        }
        if (schemaIdentifier != null) {
            this.schemaDocumentIdentifier = schemaIdentifier.getShortIdentifier();
            if (!this.getFileName().equals(this.schemaDocumentIdentifier + ".sd")) {
                ret.add(new SchemaDiagnostic.Builder().setRange(schemaIdentifier.getNode().getRange()).setMessage("Schema " + this.schemaDocumentIdentifier + " should be defined in a file with the name: " + this.schemaDocumentIdentifier + ".sd. File name is: " + this.getFileName()).setCode(SchemaDiagnostic.DiagnosticCode.SCHEMA_NAME_SAME_AS_FILE).setSeverity(DiagnosticSeverity.Error).build());
            }
        }
        return ret;
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    @Override
    public void setIsOpen(boolean value2) {
        this.isOpen = value2;
    }

    public String getSchemaIdentifier() {
        return this.schemaDocumentIdentifier;
    }

    @Override
    public String getFileURI() {
        return this.fileURI;
    }

    public Integer getVersion() {
        return this.version;
    }

    @Override
    public VersionedTextDocumentIdentifier getVersionedTextDocumentIdentifier() {
        return new VersionedTextDocumentIdentifier(this.fileURI, null);
    }

    public String getFilePath() {
        int splitPos = this.fileURI.lastIndexOf(47);
        return this.fileURI.substring(0, splitPos + 1);
    }

    public String getFileName() {
        return FileUtils.fileNameFromPath(this.fileURI);
    }

    @Override
    public SchemaNode getRootNode() {
        return this.CST;
    }

    @Override
    public YQLNode getRootYQLNode() {
        return null;
    }

    public static ParseResult parseContent(ParseContext context) {
        String sequence = context.content();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        SchemaParser parserFaultTolerant = new SchemaParser(context.fileURI(), sequence);
        try {
            parserFaultTolerant.Root();
        }
        catch (ai.vespa.schemals.parser.ParseException parseException) {
        }
        catch (IllegalArgumentException e) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(new Range(new Position(0, 0), new Position((int)context.content().lines().count() - 1, 0))).setMessage(e.getMessage()).setSeverity(DiagnosticSeverity.Error).build());
        }
        Node node = parserFaultTolerant.rootNode();
        ParseResult tolerantResult = SchemaDocument.parseCST(node, context);
        diagnostics.addAll(InheritanceResolver.resolveInheritances(context));
        for (SchemaNode typeNode : context.unresolvedTypeNodes()) {
            TypeNodeResolver.resolveType(context, typeNode.getSymbol());
        }
        context.clearUnresolvedTypeNodes();
        if (tolerantResult.CST().isPresent()) {
            diagnostics.addAll(StructFieldDefinitionResolver.resolve(context, tolerantResult.CST().get()));
            diagnostics.addAll(ResolverTraversal.traverse(context, tolerantResult.CST().get()));
            for (FieldArgument.UnresolvedFieldArgument fieldArg : context.unresolvedFieldArguments()) {
                Optional<Diagnostic> diagnostic = FieldArgumentResolver.resolveFieldArgument(context, fieldArg);
                if (!diagnostic.isPresent()) continue;
                diagnostics.add(diagnostic.get());
            }
            diagnostics.addAll(DocumentReferenceResolver.resolveDocumentReferences(context));
        }
        diagnostics.addAll(tolerantResult.diagnostics());
        return new ParseResult(diagnostics, tolerantResult.CST());
    }

    private static void traverseCST(SchemaNode node, ParseContext context, List<Diagnostic> diagnostics) {
        if (node.containsOtherLanguageData(Node.LanguageType.INDEXING)) {
            SchemaNode indexingRoot;
            if (node.get(node.size() - 1).isASTInstance(indexingOperationElm.class)) {
                node.removeChild(node.size() - 1);
            }
            if ((indexingRoot = SchemaDocument.parseIndexingScript(node, context, diagnostics)) != null) {
                node.addChild(indexingRoot);
            }
        }
        if (node.containsOtherLanguageData(Node.LanguageType.RANK_EXPRESSION)) {
            SchemaRankingExpressionParser.embedCST(context, node, diagnostics);
        }
        for (Identifier<SchemaNode> identifier : context.schemaIdentifiers()) {
            identifier.identify(node, diagnostics);
        }
        for (Identifier<ai.vespa.schemals.tree.Node> identifier : context.generalIdentifiers()) {
            identifier.identify(node, diagnostics);
        }
        for (ai.vespa.schemals.tree.Node node2 : node) {
            SchemaDocument.traverseCST(node2.getSchemaNode(), context, diagnostics);
        }
    }

    public static ParseResult parseCST(Node node, ParseContext context) {
        if (node == null) {
            return ParseResult.parsingFailed(new ArrayList<Diagnostic>());
        }
        SchemaNode CST = new SchemaNode(node);
        ArrayList<Diagnostic> errors = new ArrayList<Diagnostic>();
        try {
            SchemaDocument.traverseCST(CST, context, errors);
        }
        catch (Exception ex) {
            context.logger().error(ex);
        }
        return new ParseResult(errors, Optional.of(CST));
    }

    private static SchemaNode parseIndexingScript(SchemaNode indexingElmNode, ParseContext context, List<Diagnostic> diagnostics) {
        SubLanguageData script2 = indexingElmNode.getILScript();
        if (script2 == null) {
            return null;
        }
        Position indexingStart = indexingElmNode.getRange().getStart();
        String sequence = script2.content();
        IndexingParser parser = new IndexingParser(context.fileURI(), sequence);
        parser.setParserTolerant(false);
        Position scriptStart = new Position(indexingStart.getLine(), indexingStart.getCharacter() + script2.leadingStripped());
        try {
            Expression expression2;
            ((indexingElm)indexingElmNode.getOriginalSchemaNode()).expression = expression2 = parser.root();
            return new SchemaNode(parser.rootNode(), scriptStart);
        }
        catch (ParseException pe) {
            try {
                Range range = ILUtils.getNodeRange(pe.getToken());
                range.setStart(CSTUtils.addPositions(scriptStart, range.getStart()));
                range.setEnd(CSTUtils.addPositions(scriptStart, range.getEnd()));
                diagnostics.add(new SchemaDiagnostic.Builder().setRange(range).setMessage(pe.getMessage()).setSeverity(DiagnosticSeverity.Error).build());
            }
            catch (Exception exception) {}
        }
        catch (IllegalArgumentException ex) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(indexingElmNode.getRange()).setMessage(ex.getMessage()).setSeverity(DiagnosticSeverity.Error).build());
        }
        return null;
    }

    public String toString() {
        String openString = this.getIsOpen() ? " [OPEN]" : "";
        return this.getFileURI() + openString;
    }

    @Override
    public String getCurrentContent() {
        return this.content;
    }

    @Override
    public SchemaDocumentLexer lexer() {
        return this.lexer;
    }

    @Override
    public DocumentManager.DocumentType getDocumentType() {
        return DocumentManager.DocumentType.SCHEMA;
    }

    public record ParseResult(ArrayList<Diagnostic> diagnostics, Optional<SchemaNode> CST) {
        public static ParseResult parsingFailed(ArrayList<Diagnostic> diagnostics) {
            return new ParseResult(diagnostics, Optional.empty());
        }
    }
}

