/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.indexinglanguage;

import ai.vespa.schemals.parser.indexinglanguage.InvalidToken;
import ai.vespa.schemals.parser.indexinglanguage.Token;
import ai.vespa.schemals.parser.indexinglanguage.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;

public class IndexingParserLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = null;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public static EnumSet<Token.TokenType> getRegularTokens() {
        return EnumSet.copyOf(regularTokens);
    }

    public IndexingParserLexer(CharSequence input) {
        this("input", input);
    }

    public IndexingParserLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public IndexingParserLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(623);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(623);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(623);
        BitSet nextStates = new BitSet(623);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = IndexingParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = IndexingParserLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.NL, Token.TokenType.ADD, Token.TokenType.SUB, Token.TokenType.MUL, Token.TokenType.DIV, Token.TokenType.MOD, Token.TokenType.EQ, Token.TokenType.NE, Token.TokenType.LT, Token.TokenType.LE, Token.TokenType.GT, Token.TokenType.GE, Token.TokenType.CHOICE, Token.TokenType.PIPE, Token.TokenType.LCURLY, Token.TokenType.RCURLY, Token.TokenType.LPAREN, Token.TokenType.RPAREN, Token.TokenType.DOT, Token.TokenType.COMMA, Token.TokenType.COLON, Token.TokenType.SCOLON, Token.TokenType.ATTRIBUTE, Token.TokenType.BASE64_DECODE, Token.TokenType.BASE64_ENCODE, Token.TokenType.BINARIZE, Token.TokenType.BUSY_WAIT, Token.TokenType.CASE, Token.TokenType.CASE_DEFAULT, Token.TokenType.CHUNK, Token.TokenType.CLEAR_STATE, Token.TokenType.CREATE_IF_NON_EXISTENT, Token.TokenType.ECHO, Token.TokenType.ELSE, Token.TokenType.EMBED, Token.TokenType.EXACT, Token.TokenType.FLATTEN, Token.TokenType.FOR_EACH, Token.TokenType.GENERATE, Token.TokenType.GET_FIELD, Token.TokenType.GET_LANGUAGE, Token.TokenType.GET_VALUE, Token.TokenType.GET_VAR, Token.TokenType.GUARD, Token.TokenType.HASH, Token.TokenType.HEX_DECODE, Token.TokenType.HEX_ENCODE, Token.TokenType.HOST_NAME, Token.TokenType.IF, Token.TokenType.INDEX, Token.TokenType.INPUT, Token.TokenType.JOIN, Token.TokenType.KEEP_CASE, Token.TokenType.LOWER_CASE, Token.TokenType.MAX_LENGTH, Token.TokenType.MAX_OCCURRENCES, Token.TokenType.MAX_TOKEN_LENGTH, Token.TokenType.NGRAM, Token.TokenType.NORMALIZE, Token.TokenType.NOW, Token.TokenType.OPTIMIZE_PREDICATE, Token.TokenType.PACK_BITS, Token.TokenType.PASSTHROUGH, Token.TokenType.RANDOM, Token.TokenType.REMOVE_IF_ZERO, Token.TokenType.SELECT_INPUT, Token.TokenType.SET_LANGUAGE, Token.TokenType.SET_VAR, Token.TokenType.SLEEP, Token.TokenType.SPLIT, Token.TokenType.STEM, Token.TokenType.SUBSTRING, Token.TokenType.SUMMARY, Token.TokenType.SWITCH, Token.TokenType.THIS, Token.TokenType.TOKENIZE, Token.TokenType.TO_ARRAY, Token.TokenType.TO_BOOL, Token.TokenType.TO_BYTE, Token.TokenType.TO_DOUBLE, Token.TokenType.TO_EPOCH_SECOND, Token.TokenType.TO_FLOAT, Token.TokenType.TO_INT, Token.TokenType.TO_LONG, Token.TokenType.TO_POS, Token.TokenType.TO_STRING, Token.TokenType.TO_URI, Token.TokenType.TO_WSET, Token.TokenType.TRIM, Token.TokenType.ZCURVE, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.UNDERSCORE, Token.TokenType.INTEGER, Token.TokenType.LONG, Token.TokenType.DOUBLE, Token.TokenType.FLOAT, Token.TokenType.STRING, Token.TokenType.IDENTIFIER});
        unparsedTokens = EnumSet.of(Token.TokenType.COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NE)) {
                    nextStates.set(66);
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(78);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(79);
                }
            } else if (ch == 48) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG)) {
                    nextStates.set(412);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(495);
                }
            }
            if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT)) {
                    nextStates.set(7);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG)) {
                    nextStates.set(19);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LE)) {
                    nextStates.set(54);
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EQ)) {
                    nextStates.set(35);
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GE)) {
                    nextStates.set(30);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ATTRIBUTE)) {
                    nextStates.set(158);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BASE64_ENCODE)) {
                    nextStates.set(111);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BINARIZE)) {
                    nextStates.set(179);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BUSY_WAIT)) {
                    nextStates.set(322);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.BASE64_DECODE)) {
                    nextStates.set(436);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CASE)) {
                    nextStates.set(177);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CHUNK)) {
                    nextStates.set(235);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CLEAR_STATE)) {
                    nextStates.set(286);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CREATE_IF_NON_EXISTENT)) {
                    nextStates.set(343);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.CASE_DEFAULT)) {
                    nextStates.set(363);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXACT)) {
                    nextStates.set(171);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ELSE)) {
                    nextStates.set(188);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ECHO)) {
                    nextStates.set(315);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EMBED)) {
                    nextStates.set(414);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FLATTEN)) {
                    nextStates.set(317);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(396);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FOR_EACH)) {
                    nextStates.set(460);
                }
            } else if (ch == 103) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GUARD)) {
                    nextStates.set(216);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GET_VALUE)) {
                    nextStates.set(228);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GET_LANGUAGE)) {
                    nextStates.set(333);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GET_FIELD)) {
                    nextStates.set(382);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GET_VAR)) {
                    nextStates.set(424);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.GENERATE)) {
                    nextStates.set(446);
                }
            } else if (ch == 104) {
                if (validTypes == null || validTypes.contains(Token.TokenType.HASH)) {
                    nextStates.set(200);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HEX_ENCODE)) {
                    nextStates.set(202);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HOST_NAME)) {
                    nextStates.set(238);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.HEX_DECODE)) {
                    nextStates.set(389);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IF)) {
                    nextStates.set(6);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INDEX)) {
                    nextStates.set(174);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INPUT)) {
                    nextStates.set(185);
                }
            } else if (ch == 106) {
                if (validTypes == null || validTypes.contains(Token.TokenType.JOIN)) {
                    nextStates.set(271);
                }
            } else if (ch == 107) {
                if (validTypes == null || validTypes.contains(Token.TokenType.KEEP_CASE)) {
                    nextStates.set(417);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LOWER_CASE)) {
                    nextStates.set(190);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_TOKEN_LENGTH)) {
                    nextStates.set(257);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_OCCURRENCES)) {
                    nextStates.set(273);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.MAX_LENGTH)) {
                    nextStates.set(452);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NGRAM)) {
                    nextStates.set(165);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOW)) {
                    nextStates.set(199);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NORMALIZE)) {
                    nextStates.set(399);
                }
            } else if (ch == 111) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OPTIMIZE_PREDICATE)) {
                    nextStates.set(299);
                }
            } else if (ch == 112) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PASSTHROUGH)) {
                    nextStates.set(368);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.PACK_BITS)) {
                    nextStates.set(429);
                }
            } else if (ch == 114) {
                if (validTypes == null || validTypes.contains(Token.TokenType.REMOVE_IF_ZERO)) {
                    nextStates.set(134);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.RANDOM)) {
                    nextStates.set(329);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SELECT_INPUT)) {
                    nextStates.set(91);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SET_VAR)) {
                    nextStates.set(121);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SET_LANGUAGE)) {
                    nextStates.set(146);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SLEEP)) {
                    nextStates.set(168);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.STEM)) {
                    nextStates.set(197);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SWITCH)) {
                    nextStates.set(295);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUBSTRING)) {
                    nextStates.set(468);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SUMMARY)) {
                    nextStates.set(475);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SPLIT)) {
                    nextStates.set(496);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_ARRAY)) {
                    nextStates.set(101);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_FLOAT)) {
                    nextStates.set(128);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.THIS)) {
                    nextStates.set(156);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_STRING)) {
                    nextStates.set(209);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_INT)) {
                    nextStates.set(219);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_WSET)) {
                    nextStates.set(223);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_EPOCH_SECOND)) {
                    nextStates.set(244);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_BOOL)) {
                    nextStates.set(377);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TOKENIZE)) {
                    nextStates.set(406);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_URI)) {
                    nextStates.set(480);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_LONG)) {
                    nextStates.set(484);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TRIM)) {
                    nextStates.set(489);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_POS)) {
                    nextStates.set(491);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_BYTE)) {
                    nextStates.set(499);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TO_DOUBLE)) {
                    nextStates.set(504);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(511);
                }
            } else if (ch == 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ZCURVE)) {
                    nextStates.set(107);
                }
            } else if (ch == 124 && (validTypes == null || validTypes.contains(Token.TokenType.CHOICE))) {
                nextStates.set(22);
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    nextStates.set(40);
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOUBLE)) {
                    nextStates.set(26);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.INTEGER)) {
                    nextStates.set(77);
                    type = Token.TokenType.INTEGER;
                }
            } else if (ch == 35 && (validTypes == null || validTypes.contains(Token.TokenType.COMMENT))) {
                nextStates.set(64);
                type = Token.TokenType.COMMENT;
            }
            if (ch == 95) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNDERSCORE)) {
                    type = Token.TokenType.UNDERSCORE;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SCOLON)) {
                    type = Token.TokenType.SCOLON;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RPAREN)) {
                    type = Token.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LPAREN)) {
                    type = Token.TokenType.LPAREN;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RCURLY)) {
                    type = Token.TokenType.RCURLY;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LCURLY)) {
                    type = Token.TokenType.LCURLY;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PIPE)) {
                    type = Token.TokenType.PIPE;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GT)) {
                    type = Token.TokenType.GT;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LT)) {
                    type = Token.TokenType.LT;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MOD)) {
                    type = Token.TokenType.MOD;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DIV)) {
                    type = Token.TokenType.DIV;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MUL)) {
                    type = Token.TokenType.MUL;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SUB)) {
                    type = Token.TokenType.SUB;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.ADD)) {
                    type = Token.TokenType.ADD;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NL)) {
                    type = Token.TokenType.NL;
                }
            } else if (ch == 12) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.SELECT_INPUT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.TO_ARRAY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ZCURVE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.BASE64_ENCODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.SET_VAR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                return Token.TokenType.IF;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 46) {
                nextStates.set(9);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(7);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(126);
            } else if (ch == 70 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(8);
            } else if (ch == 70 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            } else if (ch == 69 || ch == 101) {
                nextStates.set(126);
            } else if (ch == 70 || ch == 102) {
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TO_FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.REMOVE_IF_ZERO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.SET_LANGUAGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.THIS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ATTRIBUTE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.NGRAM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                return Token.TokenType.SLEEP;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.EXACT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                return Token.TokenType.INDEX;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(19);
            } else if (ch == 76 || ch == 108) {
                type = Token.TokenType.LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.CASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.BINARIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 124) {
                return Token.TokenType.CHOICE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.INPUT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.ELSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LOWER_CASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(27);
            } else if (ch == 46) {
                nextStates.set(29);
                type = Token.TokenType.DOUBLE;
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                type = Token.TokenType.DOUBLE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43 || ch == 45) {
                nextStates.set(28);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
                type = Token.TokenType.DOUBLE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(28);
                return Token.TokenType.DOUBLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69 || ch == 101) {
                nextStates.set(27);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(29);
                type = Token.TokenType.DOUBLE;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.GE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.STEM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                return Token.TokenType.NOW;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.HASH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.HEX_ENCODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.EQ;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.TO_STRING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.GUARD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TO_INT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TO_WSET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(40);
                return Token.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GET_VALUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                return Token.TokenType.CHUNK;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.HOST_NAME;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.TO_EPOCH_SECOND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.MAX_TOKEN_LENGTH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.JOIN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MAX_OCCURRENCES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.CLEAR_STATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.SWITCH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.OPTIMIZE_PREDICATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                return Token.TokenType.ECHO;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.FLATTEN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.BUSY_WAIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.LE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.RANDOM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GET_LANGUAGE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CREATE_IF_NON_EXISTENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.CASE_DEFAULT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.PASSTHROUGH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.TO_BOOL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.GET_FIELD;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.HEX_DECODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14) {
                nextStates.set(64);
                return Token.TokenType.COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.NORMALIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.NE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TOKENIZE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(68);
            } else if (ch == 76 || ch == 108) {
                type = Token.TokenType.LONG;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.EMBED;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.KEEP_CASE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.GET_VAR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.PACK_BITS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.BASE64_DECODE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.GENERATE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.MAX_LENGTH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.FOR_EACH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(77);
                return Token.TokenType.INTEGER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35) {
                nextStates.set(78);
            }
            if (ch == 92) {
                nextStates.set(466);
            } else if (ch == 34) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40) {
                nextStates.set(79);
            }
            if (ch == 92) {
                nextStates.set(467);
            } else if (ch == 39) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.SUBSTRING;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.SUMMARY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                return Token.TokenType.TO_URI;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                return Token.TokenType.TO_LONG;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.TRIM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.TO_POS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(86);
                return Token.TokenType.INTEGER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.SPLIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TO_BYTE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TO_DOUBLE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(92);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(93);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(95);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(96);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(97);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(100);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(105);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(106);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(109);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(110);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(113);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 54) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 52) {
                nextStates.set(116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(118);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(119);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(4);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(122);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(123);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(124);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(125);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(5);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 43 || ch == 45) {
                nextStates.set(127);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(129);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(130);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(131);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(132);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(133);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(10);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(135);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(136);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(137);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(139);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(140);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(141);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(142);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(143);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(145);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(11);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(148);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(151);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(153);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(154);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(12);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(157);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(13);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(160);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(161);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(162);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(163);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(164);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(166);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(15);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(170);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(16);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(175);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(176);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(178);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(180);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(182);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(183);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(21);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(186);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex186(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(187);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex187(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(23);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex188(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(189);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex189(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(24);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex190(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(191);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex191(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(192);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex192(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(193);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex193(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(194);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex194(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(195);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex195(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(196);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex196(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex197(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(198);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex198(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex199(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex200(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(201);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex201(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex202(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(203);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex203(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(204);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex204(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(205);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex205(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(206);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex206(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(207);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex207(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(208);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex208(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(34);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex209(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(210);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex210(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(211);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex211(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(212);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex212(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(213);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex213(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(214);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex214(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(215);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex215(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(36);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex216(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(217);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex217(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(218);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex218(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(37);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex219(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(220);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex220(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(221);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex221(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(222);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex222(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(38);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex223(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(224);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex224(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(225);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex225(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(226);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex226(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(227);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex227(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(39);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex228(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(229);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex229(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(230);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex230(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(231);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex231(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(232);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex232(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(233);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex233(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(234);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex234(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(41);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex235(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(236);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex236(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(237);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex237(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(42);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex238(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(239);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex239(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(240);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex240(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(241);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex241(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(242);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex242(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(243);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex243(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex244(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(245);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex245(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(246);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex246(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(247);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex247(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(248);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex248(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(249);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex249(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(250);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex250(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(251);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex251(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(252);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex252(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(253);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex253(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(254);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex254(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(255);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex255(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(256);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex256(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex257(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(258);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex258(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(259);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex259(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(260);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex260(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(261);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex261(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(262);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex262(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(263);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex263(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(264);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex264(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(265);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex265(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(266);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex266(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(267);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex267(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(268);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex268(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(269);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex269(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(270);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex270(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(45);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex271(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(272);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex272(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(46);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex273(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(274);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex274(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(275);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex275(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(276);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex276(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(277);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex277(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(278);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex278(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(279);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex279(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(280);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex280(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(281);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex281(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(282);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex282(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(283);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex283(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(284);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex284(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(285);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex285(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex286(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(287);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex287(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(288);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex288(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(289);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex289(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(290);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex290(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(291);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex291(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(292);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex292(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(293);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex293(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(294);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex294(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex295(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(296);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex296(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(297);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex297(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(298);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex298(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex299(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(300);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex300(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(301);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex301(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(302);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex302(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(303);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex303(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(304);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex304(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(305);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex305(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(306);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex306(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(307);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex307(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(308);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex308(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(309);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex309(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(310);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex310(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(311);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex311(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(312);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex312(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(313);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex313(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(314);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex314(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(50);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex315(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(316);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex316(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex317(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(318);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex318(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(319);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex319(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(320);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex320(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(321);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex321(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex322(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(323);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex323(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(324);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex324(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(325);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex325(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(326);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex326(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 119) {
                nextStates.set(327);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex327(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(328);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex328(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex329(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(330);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex330(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(331);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex331(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(332);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex332(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(55);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex333(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(334);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex334(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(335);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex335(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(336);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex336(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(337);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex337(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(338);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex338(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(339);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex339(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(340);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex340(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(341);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex341(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(342);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex342(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex343(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(344);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex344(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(345);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex345(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(346);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex346(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(347);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex347(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(348);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex348(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(349);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex349(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(350);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex350(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(351);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex351(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(352);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex352(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(353);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex353(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(354);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex354(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(355);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex355(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(356);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex356(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(357);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex357(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(358);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex358(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(359);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex359(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(360);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex360(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(361);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex361(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(362);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex362(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(57);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex363(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(364);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex364(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(365);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex365(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(366);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex366(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(367);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex367(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(58);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex368(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(369);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex369(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(370);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex370(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(371);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex371(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(372);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex372(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(373);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex373(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(374);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex374(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(375);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex375(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(376);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex376(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(59);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex377(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(378);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex378(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(379);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex379(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(380);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex380(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(381);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex381(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex382(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(383);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex383(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(384);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex384(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(385);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex385(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(386);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex386(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(387);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex387(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(388);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex388(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(61);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex389(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(390);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex390(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(391);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex391(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(392);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex392(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(393);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex393(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(394);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex394(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(395);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex395(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(62);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex396(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(397);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex397(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(398);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex398(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex399(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(400);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex400(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(401);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex401(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(402);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex402(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(403);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex403(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(404);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex404(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(405);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex405(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(65);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex406(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(407);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex407(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(408);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex408(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(409);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex409(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(410);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex410(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(411);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex411(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 122) {
                nextStates.set(67);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex412(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(413);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex413(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex414(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(415);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex415(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(416);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex416(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(69);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex417(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(418);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex418(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(419);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex419(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(420);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex420(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(421);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex421(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(422);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex422(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(423);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex423(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex424(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(425);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex425(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(426);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex426(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(427);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex427(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 118) {
                nextStates.set(428);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex428(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(71);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex429(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(430);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex430(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(431);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex431(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(432);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex432(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(433);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex433(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(434);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex434(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(435);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex435(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex436(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(437);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex437(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(438);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex438(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(439);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex439(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 54) {
                nextStates.set(440);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex440(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 52) {
                nextStates.set(441);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex441(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(442);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex442(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(443);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex443(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(444);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex444(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(445);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex445(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex446(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(447);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex447(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(448);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex448(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(449);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex449(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(450);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex450(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(451);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex451(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(74);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex452(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(453);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex453(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 120) {
                nextStates.set(454);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex454(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45) {
                nextStates.set(455);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex455(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(456);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex456(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(457);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex457(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(458);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex458(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 103) {
                nextStates.set(459);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex459(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex460(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(461);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex461(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(462);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex462(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(463);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex463(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(464);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex464(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(465);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex465(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex466(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(78);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex467(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 39) {
                nextStates.set(79);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex468(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(469);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex469(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(470);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex470(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(471);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex471(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(472);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex472(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(473);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex473(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(474);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex474(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(80);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex475(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(476);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex476(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(477);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex477(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(478);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex478(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(479);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex479(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex480(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(481);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex481(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(482);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex482(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(483);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex483(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(82);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex484(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(485);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex485(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(486);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex486(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(487);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex487(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(488);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex488(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(83);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex489(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(490);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex490(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(84);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex491(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(492);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex492(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(493);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex493(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(494);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex494(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(85);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex495(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 88 || ch == 120) {
                nextStates.set(86);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex496(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(497);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex497(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(498);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex498(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(87);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex499(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(500);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex500(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(501);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex501(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(502);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex502(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                nextStates.set(503);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex503(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(88);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex504(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(505);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex505(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 95) {
                nextStates.set(506);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex506(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(507);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex507(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(508);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex508(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(509);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex509(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(510);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex510(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(89);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex511(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(512);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex512(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(90);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103, DEFAULT::getNfaIndex104, DEFAULT::getNfaIndex105, DEFAULT::getNfaIndex106, DEFAULT::getNfaIndex107, DEFAULT::getNfaIndex108, DEFAULT::getNfaIndex109, DEFAULT::getNfaIndex110, DEFAULT::getNfaIndex111, DEFAULT::getNfaIndex112, DEFAULT::getNfaIndex113, DEFAULT::getNfaIndex114, DEFAULT::getNfaIndex115, DEFAULT::getNfaIndex116, DEFAULT::getNfaIndex117, DEFAULT::getNfaIndex118, DEFAULT::getNfaIndex119, DEFAULT::getNfaIndex120, DEFAULT::getNfaIndex121, DEFAULT::getNfaIndex122, DEFAULT::getNfaIndex123, DEFAULT::getNfaIndex124, DEFAULT::getNfaIndex125, DEFAULT::getNfaIndex126, DEFAULT::getNfaIndex127, DEFAULT::getNfaIndex128, DEFAULT::getNfaIndex129, DEFAULT::getNfaIndex130, DEFAULT::getNfaIndex131, DEFAULT::getNfaIndex132, DEFAULT::getNfaIndex133, DEFAULT::getNfaIndex134, DEFAULT::getNfaIndex135, DEFAULT::getNfaIndex136, DEFAULT::getNfaIndex137, DEFAULT::getNfaIndex138, DEFAULT::getNfaIndex139, DEFAULT::getNfaIndex140, DEFAULT::getNfaIndex141, DEFAULT::getNfaIndex142, DEFAULT::getNfaIndex143, DEFAULT::getNfaIndex144, DEFAULT::getNfaIndex145, DEFAULT::getNfaIndex146, DEFAULT::getNfaIndex147, DEFAULT::getNfaIndex148, DEFAULT::getNfaIndex149, DEFAULT::getNfaIndex150, DEFAULT::getNfaIndex151, DEFAULT::getNfaIndex152, DEFAULT::getNfaIndex153, DEFAULT::getNfaIndex154, DEFAULT::getNfaIndex155, DEFAULT::getNfaIndex156, DEFAULT::getNfaIndex157, DEFAULT::getNfaIndex158, DEFAULT::getNfaIndex159, DEFAULT::getNfaIndex160, DEFAULT::getNfaIndex161, DEFAULT::getNfaIndex162, DEFAULT::getNfaIndex163, DEFAULT::getNfaIndex164, DEFAULT::getNfaIndex165, DEFAULT::getNfaIndex166, DEFAULT::getNfaIndex167, DEFAULT::getNfaIndex168, DEFAULT::getNfaIndex169, DEFAULT::getNfaIndex170, DEFAULT::getNfaIndex171, DEFAULT::getNfaIndex172, DEFAULT::getNfaIndex173, DEFAULT::getNfaIndex174, DEFAULT::getNfaIndex175, DEFAULT::getNfaIndex176, DEFAULT::getNfaIndex177, DEFAULT::getNfaIndex178, DEFAULT::getNfaIndex179, DEFAULT::getNfaIndex180, DEFAULT::getNfaIndex181, DEFAULT::getNfaIndex182, DEFAULT::getNfaIndex183, DEFAULT::getNfaIndex184, DEFAULT::getNfaIndex185, DEFAULT::getNfaIndex186, DEFAULT::getNfaIndex187, DEFAULT::getNfaIndex188, DEFAULT::getNfaIndex189, DEFAULT::getNfaIndex190, DEFAULT::getNfaIndex191, DEFAULT::getNfaIndex192, DEFAULT::getNfaIndex193, DEFAULT::getNfaIndex194, DEFAULT::getNfaIndex195, DEFAULT::getNfaIndex196, DEFAULT::getNfaIndex197, DEFAULT::getNfaIndex198, DEFAULT::getNfaIndex199, DEFAULT::getNfaIndex200, DEFAULT::getNfaIndex201, DEFAULT::getNfaIndex202, DEFAULT::getNfaIndex203, DEFAULT::getNfaIndex204, DEFAULT::getNfaIndex205, DEFAULT::getNfaIndex206, DEFAULT::getNfaIndex207, DEFAULT::getNfaIndex208, DEFAULT::getNfaIndex209, DEFAULT::getNfaIndex210, DEFAULT::getNfaIndex211, DEFAULT::getNfaIndex212, DEFAULT::getNfaIndex213, DEFAULT::getNfaIndex214, DEFAULT::getNfaIndex215, DEFAULT::getNfaIndex216, DEFAULT::getNfaIndex217, DEFAULT::getNfaIndex218, DEFAULT::getNfaIndex219, DEFAULT::getNfaIndex220, DEFAULT::getNfaIndex221, DEFAULT::getNfaIndex222, DEFAULT::getNfaIndex223, DEFAULT::getNfaIndex224, DEFAULT::getNfaIndex225, DEFAULT::getNfaIndex226, DEFAULT::getNfaIndex227, DEFAULT::getNfaIndex228, DEFAULT::getNfaIndex229, DEFAULT::getNfaIndex230, DEFAULT::getNfaIndex231, DEFAULT::getNfaIndex232, DEFAULT::getNfaIndex233, DEFAULT::getNfaIndex234, DEFAULT::getNfaIndex235, DEFAULT::getNfaIndex236, DEFAULT::getNfaIndex237, DEFAULT::getNfaIndex238, DEFAULT::getNfaIndex239, DEFAULT::getNfaIndex240, DEFAULT::getNfaIndex241, DEFAULT::getNfaIndex242, DEFAULT::getNfaIndex243, DEFAULT::getNfaIndex244, DEFAULT::getNfaIndex245, DEFAULT::getNfaIndex246, DEFAULT::getNfaIndex247, DEFAULT::getNfaIndex248, DEFAULT::getNfaIndex249, DEFAULT::getNfaIndex250, DEFAULT::getNfaIndex251, DEFAULT::getNfaIndex252, DEFAULT::getNfaIndex253, DEFAULT::getNfaIndex254, DEFAULT::getNfaIndex255, DEFAULT::getNfaIndex256, DEFAULT::getNfaIndex257, DEFAULT::getNfaIndex258, DEFAULT::getNfaIndex259, DEFAULT::getNfaIndex260, DEFAULT::getNfaIndex261, DEFAULT::getNfaIndex262, DEFAULT::getNfaIndex263, DEFAULT::getNfaIndex264, DEFAULT::getNfaIndex265, DEFAULT::getNfaIndex266, DEFAULT::getNfaIndex267, DEFAULT::getNfaIndex268, DEFAULT::getNfaIndex269, DEFAULT::getNfaIndex270, DEFAULT::getNfaIndex271, DEFAULT::getNfaIndex272, DEFAULT::getNfaIndex273, DEFAULT::getNfaIndex274, DEFAULT::getNfaIndex275, DEFAULT::getNfaIndex276, DEFAULT::getNfaIndex277, DEFAULT::getNfaIndex278, DEFAULT::getNfaIndex279, DEFAULT::getNfaIndex280, DEFAULT::getNfaIndex281, DEFAULT::getNfaIndex282, DEFAULT::getNfaIndex283, DEFAULT::getNfaIndex284, DEFAULT::getNfaIndex285, DEFAULT::getNfaIndex286, DEFAULT::getNfaIndex287, DEFAULT::getNfaIndex288, DEFAULT::getNfaIndex289, DEFAULT::getNfaIndex290, DEFAULT::getNfaIndex291, DEFAULT::getNfaIndex292, DEFAULT::getNfaIndex293, DEFAULT::getNfaIndex294, DEFAULT::getNfaIndex295, DEFAULT::getNfaIndex296, DEFAULT::getNfaIndex297, DEFAULT::getNfaIndex298, DEFAULT::getNfaIndex299, DEFAULT::getNfaIndex300, DEFAULT::getNfaIndex301, DEFAULT::getNfaIndex302, DEFAULT::getNfaIndex303, DEFAULT::getNfaIndex304, DEFAULT::getNfaIndex305, DEFAULT::getNfaIndex306, DEFAULT::getNfaIndex307, DEFAULT::getNfaIndex308, DEFAULT::getNfaIndex309, DEFAULT::getNfaIndex310, DEFAULT::getNfaIndex311, DEFAULT::getNfaIndex312, DEFAULT::getNfaIndex313, DEFAULT::getNfaIndex314, DEFAULT::getNfaIndex315, DEFAULT::getNfaIndex316, DEFAULT::getNfaIndex317, DEFAULT::getNfaIndex318, DEFAULT::getNfaIndex319, DEFAULT::getNfaIndex320, DEFAULT::getNfaIndex321, DEFAULT::getNfaIndex322, DEFAULT::getNfaIndex323, DEFAULT::getNfaIndex324, DEFAULT::getNfaIndex325, DEFAULT::getNfaIndex326, DEFAULT::getNfaIndex327, DEFAULT::getNfaIndex328, DEFAULT::getNfaIndex329, DEFAULT::getNfaIndex330, DEFAULT::getNfaIndex331, DEFAULT::getNfaIndex332, DEFAULT::getNfaIndex333, DEFAULT::getNfaIndex334, DEFAULT::getNfaIndex335, DEFAULT::getNfaIndex336, DEFAULT::getNfaIndex337, DEFAULT::getNfaIndex338, DEFAULT::getNfaIndex339, DEFAULT::getNfaIndex340, DEFAULT::getNfaIndex341, DEFAULT::getNfaIndex342, DEFAULT::getNfaIndex343, DEFAULT::getNfaIndex344, DEFAULT::getNfaIndex345, DEFAULT::getNfaIndex346, DEFAULT::getNfaIndex347, DEFAULT::getNfaIndex348, DEFAULT::getNfaIndex349, DEFAULT::getNfaIndex350, DEFAULT::getNfaIndex351, DEFAULT::getNfaIndex352, DEFAULT::getNfaIndex353, DEFAULT::getNfaIndex354, DEFAULT::getNfaIndex355, DEFAULT::getNfaIndex356, DEFAULT::getNfaIndex357, DEFAULT::getNfaIndex358, DEFAULT::getNfaIndex359, DEFAULT::getNfaIndex360, DEFAULT::getNfaIndex361, DEFAULT::getNfaIndex362, DEFAULT::getNfaIndex363, DEFAULT::getNfaIndex364, DEFAULT::getNfaIndex365, DEFAULT::getNfaIndex366, DEFAULT::getNfaIndex367, DEFAULT::getNfaIndex368, DEFAULT::getNfaIndex369, DEFAULT::getNfaIndex370, DEFAULT::getNfaIndex371, DEFAULT::getNfaIndex372, DEFAULT::getNfaIndex373, DEFAULT::getNfaIndex374, DEFAULT::getNfaIndex375, DEFAULT::getNfaIndex376, DEFAULT::getNfaIndex377, DEFAULT::getNfaIndex378, DEFAULT::getNfaIndex379, DEFAULT::getNfaIndex380, DEFAULT::getNfaIndex381, DEFAULT::getNfaIndex382, DEFAULT::getNfaIndex383, DEFAULT::getNfaIndex384, DEFAULT::getNfaIndex385, DEFAULT::getNfaIndex386, DEFAULT::getNfaIndex387, DEFAULT::getNfaIndex388, DEFAULT::getNfaIndex389, DEFAULT::getNfaIndex390, DEFAULT::getNfaIndex391, DEFAULT::getNfaIndex392, DEFAULT::getNfaIndex393, DEFAULT::getNfaIndex394, DEFAULT::getNfaIndex395, DEFAULT::getNfaIndex396, DEFAULT::getNfaIndex397, DEFAULT::getNfaIndex398, DEFAULT::getNfaIndex399, DEFAULT::getNfaIndex400, DEFAULT::getNfaIndex401, DEFAULT::getNfaIndex402, DEFAULT::getNfaIndex403, DEFAULT::getNfaIndex404, DEFAULT::getNfaIndex405, DEFAULT::getNfaIndex406, DEFAULT::getNfaIndex407, DEFAULT::getNfaIndex408, DEFAULT::getNfaIndex409, DEFAULT::getNfaIndex410, DEFAULT::getNfaIndex411, DEFAULT::getNfaIndex412, DEFAULT::getNfaIndex413, DEFAULT::getNfaIndex414, DEFAULT::getNfaIndex415, DEFAULT::getNfaIndex416, DEFAULT::getNfaIndex417, DEFAULT::getNfaIndex418, DEFAULT::getNfaIndex419, DEFAULT::getNfaIndex420, DEFAULT::getNfaIndex421, DEFAULT::getNfaIndex422, DEFAULT::getNfaIndex423, DEFAULT::getNfaIndex424, DEFAULT::getNfaIndex425, DEFAULT::getNfaIndex426, DEFAULT::getNfaIndex427, DEFAULT::getNfaIndex428, DEFAULT::getNfaIndex429, DEFAULT::getNfaIndex430, DEFAULT::getNfaIndex431, DEFAULT::getNfaIndex432, DEFAULT::getNfaIndex433, DEFAULT::getNfaIndex434, DEFAULT::getNfaIndex435, DEFAULT::getNfaIndex436, DEFAULT::getNfaIndex437, DEFAULT::getNfaIndex438, DEFAULT::getNfaIndex439, DEFAULT::getNfaIndex440, DEFAULT::getNfaIndex441, DEFAULT::getNfaIndex442, DEFAULT::getNfaIndex443, DEFAULT::getNfaIndex444, DEFAULT::getNfaIndex445, DEFAULT::getNfaIndex446, DEFAULT::getNfaIndex447, DEFAULT::getNfaIndex448, DEFAULT::getNfaIndex449, DEFAULT::getNfaIndex450, DEFAULT::getNfaIndex451, DEFAULT::getNfaIndex452, DEFAULT::getNfaIndex453, DEFAULT::getNfaIndex454, DEFAULT::getNfaIndex455, DEFAULT::getNfaIndex456, DEFAULT::getNfaIndex457, DEFAULT::getNfaIndex458, DEFAULT::getNfaIndex459, DEFAULT::getNfaIndex460, DEFAULT::getNfaIndex461, DEFAULT::getNfaIndex462, DEFAULT::getNfaIndex463, DEFAULT::getNfaIndex464, DEFAULT::getNfaIndex465, DEFAULT::getNfaIndex466, DEFAULT::getNfaIndex467, DEFAULT::getNfaIndex468, DEFAULT::getNfaIndex469, DEFAULT::getNfaIndex470, DEFAULT::getNfaIndex471, DEFAULT::getNfaIndex472, DEFAULT::getNfaIndex473, DEFAULT::getNfaIndex474, DEFAULT::getNfaIndex475, DEFAULT::getNfaIndex476, DEFAULT::getNfaIndex477, DEFAULT::getNfaIndex478, DEFAULT::getNfaIndex479, DEFAULT::getNfaIndex480, DEFAULT::getNfaIndex481, DEFAULT::getNfaIndex482, DEFAULT::getNfaIndex483, DEFAULT::getNfaIndex484, DEFAULT::getNfaIndex485, DEFAULT::getNfaIndex486, DEFAULT::getNfaIndex487, DEFAULT::getNfaIndex488, DEFAULT::getNfaIndex489, DEFAULT::getNfaIndex490, DEFAULT::getNfaIndex491, DEFAULT::getNfaIndex492, DEFAULT::getNfaIndex493, DEFAULT::getNfaIndex494, DEFAULT::getNfaIndex495, DEFAULT::getNfaIndex496, DEFAULT::getNfaIndex497, DEFAULT::getNfaIndex498, DEFAULT::getNfaIndex499, DEFAULT::getNfaIndex500, DEFAULT::getNfaIndex501, DEFAULT::getNfaIndex502, DEFAULT::getNfaIndex503, DEFAULT::getNfaIndex504, DEFAULT::getNfaIndex505, DEFAULT::getNfaIndex506, DEFAULT::getNfaIndex507, DEFAULT::getNfaIndex508, DEFAULT::getNfaIndex509, DEFAULT::getNfaIndex510, DEFAULT::getNfaIndex511, DEFAULT::getNfaIndex512};
        }
    }
}

