/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.common.editbuilder.WorkspaceEditBuilder;
import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.CommandUtils;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class CreateSchemaFile
implements SchemaCommand {
    private String schemaName;

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        assert (arguments2.size() == this.getArity());
        Optional<String> argument2 = CommandUtils.getStringArgument(arguments2.get(0));
        if (argument2.isEmpty()) {
            return false;
        }
        this.schemaName = argument2.get();
        return true;
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        if (context.scheduler.getWorkspaceURI() == null) {
            return false;
        }
        if (context.schemaIndex.getSchemaDefinition(this.schemaName).isPresent()) {
            context.logger.warning("Cannot create schema " + this.schemaName + " because it already exists.");
            return false;
        }
        Path writePath = Paths.get(URI.create(context.scheduler.getWorkspaceURI())).resolve(this.schemaName + ".sd");
        String writeUri = writePath.toUri().toString();
        String schemaText = "schema " + this.schemaName + " {\n" + ("    document " + this.schemaName + " {\n") + "        \n" + "    }\n" + "}";
        Range insertRange = new Range(new Position(0, 0), new Position(0, 0));
        WorkspaceEdit edit = new WorkspaceEditBuilder().addResourceOperation((ResourceOperation)new CreateFile(writeUri, new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)))).addTextEdit(writeUri, new TextEdit(insertRange, schemaText)).build();
        ApplyWorkspaceEditResponse result = context.messageHandler.applyEdit(new ApplyWorkspaceEditParams(edit)).join();
        context.logger.info(result);
        return true;
    }
}

