/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.indexingElm;
import ai.vespa.schemals.parser.indexinglanguage.ast.ATTRIBUTE;
import ai.vespa.schemals.parser.indexinglanguage.ast.DOT;
import ai.vespa.schemals.parser.indexinglanguage.ast.INDEX;
import ai.vespa.schemals.parser.indexinglanguage.ast.SUMMARY;
import ai.vespa.schemals.parser.indexinglanguage.ast.fieldName;
import ai.vespa.schemals.parser.indexinglanguage.ast.inputExp;
import ai.vespa.schemals.parser.indexinglanguage.ast.script;
import ai.vespa.schemals.parser.indexinglanguage.ast.statement;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.vespa.indexinglanguage.expressions.Expression;
import com.yahoo.vespa.indexinglanguage.expressions.StatementExpression;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class IndexingLanguageResolver {
    private ParseContext context;
    private Symbol containingFieldDefinition;

    public static void resolveIndexingLanguage(ParseContext context, SchemaNode indexingLanguageNode, List<Diagnostic> diagnostics) {
        Expression expression2;
        Optional<Symbol> definition;
        Node fieldDefinitionNode = indexingLanguageNode.getParent().getParent().get(1);
        while (fieldDefinitionNode.getNextSibling() != null && fieldDefinitionNode.getNextSibling().getASTClass() == identifierStr.class && fieldDefinitionNode.getNextSibling().hasSymbol()) {
            fieldDefinitionNode = fieldDefinitionNode.getNextSibling();
        }
        Symbol fieldDefinitionSymbol = fieldDefinitionNode.getSymbol();
        if (fieldDefinitionSymbol.getStatus() == Symbol.SymbolStatus.REFERENCE && (definition = context.schemaIndex().getSymbolDefinition(fieldDefinitionSymbol)).isPresent()) {
            fieldDefinitionSymbol = definition.get();
        }
        if (fieldDefinitionSymbol.getStatus() != Symbol.SymbolStatus.DEFINITION || fieldDefinitionSymbol.getType() != Symbol.SymbolType.FIELD) {
            return;
        }
        if (indexingLanguageNode.isASTInstance(indexingElm.class) && (expression2 = ((indexingElm)indexingLanguageNode.getOriginalSchemaNode()).expression) != null && expression2.requiresInput() && !context.fieldIndex().getIsInsideDoc(fieldDefinitionSymbol)) {
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(indexingLanguageNode.get(0).getRange()).setMessage("Fields defined outside the document must start with an expression creating a value (e.g 'input <field>')").setSeverity(DiagnosticSeverity.Error).build());
        }
        IndexingLanguageResolver instance = new IndexingLanguageResolver(context, fieldDefinitionSymbol);
        instance.traverse(indexingLanguageNode, diagnostics);
    }

    private IndexingLanguageResolver(ParseContext context, Symbol containingFieldDefinition) {
        this.context = context;
        this.containingFieldDefinition = containingFieldDefinition;
    }

    private void traverse(SchemaNode node, List<Diagnostic> diagnostics) {
        Optional<Symbol> scope;
        if (node.isASTInstance(ATTRIBUTE.class)) {
            this.context.fieldIndex().addFieldIndexingType(this.containingFieldDefinition, FieldIndex.IndexingType.ATTRIBUTE);
        }
        if (node.isASTInstance(INDEX.class)) {
            this.context.fieldIndex().addFieldIndexingType(this.containingFieldDefinition, FieldIndex.IndexingType.INDEX);
        }
        if (node.isASTInstance(SUMMARY.class)) {
            this.context.fieldIndex().addFieldIndexingType(this.containingFieldDefinition, FieldIndex.IndexingType.SUMMARY);
        }
        if (node.isASTInstance(ai.vespa.schemals.parser.indexinglanguage.ast.identifierStr.class) && node.getParent().getASTClass() == inputExp.class && (scope = CSTUtils.findScope(node)).isPresent()) {
            Optional<Symbol> fieldDefinition = this.context.schemaIndex().findSymbol(scope.get(), Symbol.SymbolType.FIELD, node.getText());
            if (fieldDefinition.isPresent()) {
                if (!this.context.fieldIndex().getIsInsideDoc(fieldDefinition.get())) {
                    diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Input references field " + node.getText() + " which is not a document field").setSeverity(DiagnosticSeverity.Error).build());
                }
                node.setSymbol(Symbol.SymbolType.FIELD, this.context.fileURI(), scope.get());
                node.setSymbolStatus(Symbol.SymbolStatus.REFERENCE);
                this.context.schemaIndex().insertSymbolReference(fieldDefinition.get(), node.getSymbol());
            } else {
                diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Undefined symbol " + node.getText()).setSeverity(DiagnosticSeverity.Error).build());
            }
        }
        if (node.isASTInstance(statement.class) && (node.getParent().isASTInstance(indexingElm.class) || node.getParent().isASTInstance(script.class))) {
            statement originalNode = (statement)node.getOriginalIndexingNode();
            StatementExpression expression2 = originalNode.expression;
            if (expression2 != null && expression2.requiresInput() && !this.context.fieldIndex().getIsInsideDoc(this.containingFieldDefinition)) {
                diagnostics.add(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("Fields defined outside the document must start with an expression creating a value (e.g 'input <field>')").setSeverity(DiagnosticSeverity.Error).build());
            }
        }
        if (node.getParent().isASTInstance(fieldName.class) && node.isASTInstance(ai.vespa.schemals.parser.indexinglanguage.ast.identifierStr.class)) {
            scope = CSTUtils.findScope(node);
            Symbol.SymbolType type = Symbol.SymbolType.FIELD;
            if (node.getPreviousSibling() != null && node.getPreviousSibling().isASTInstance(DOT.class)) {
                type = Symbol.SymbolType.SUBFIELD;
            }
            if (scope.isPresent()) {
                node.setSymbol(type, this.context.fileURI(), scope.get());
            } else {
                node.setSymbol(type, this.context.fileURI());
            }
            node.setSymbolStatus(Symbol.SymbolStatus.UNRESOLVED);
        }
        for (Node child : node) {
            this.traverse(child.getSchemaNode(), diagnostics);
        }
    }
}

