/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.command.commandtypes;

import ai.vespa.schemals.common.editbuilder.WorkspaceEditBuilder;
import ai.vespa.schemals.context.EventExecuteCommandContext;
import ai.vespa.schemals.lsp.common.command.CommandUtils;
import ai.vespa.schemals.lsp.common.command.commandtypes.SchemaCommand;
import java.net.URI;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;

public class WriteYQLQuery
implements SchemaCommand {
    private String filePath;
    private String query;

    @Override
    public int getArity() {
        return 2;
    }

    @Override
    public boolean setArguments(List<Object> arguments2) {
        Optional<String> fileName = CommandUtils.getStringArgument(arguments2.get(0));
        Optional<String> query = CommandUtils.getStringArgument(arguments2.get(1));
        if (fileName.isEmpty() || query.isEmpty()) {
            return false;
        }
        this.filePath = fileName.get();
        this.query = query.get();
        return true;
    }

    @Override
    public Object execute(EventExecuteCommandContext context) {
        if (context.scheduler.getWorkspaceURI() == null) {
            return null;
        }
        URI fileURI = Paths.get(this.filePath, new String[0]).toUri();
        Range insertRange = new Range(new Position(0, 0), new Position(0, 0));
        WorkspaceEdit edit = new WorkspaceEditBuilder().addResourceOperation((ResourceOperation)new CreateFile(fileURI.toString(), new CreateFileOptions(Boolean.valueOf(true), Boolean.valueOf(false)))).addTextEdit(fileURI.toString(), new TextEdit(insertRange, this.query)).build();
        context.messageHandler.applyEdit(new ApplyWorkspaceEditParams(edit)).join();
        return null;
    }
}

