/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.ParseException;
import ai.vespa.schemals.parser.SchemaParser;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import ai.vespa.schemals.schemadocument.resolvers.InheritanceResolver;
import ai.vespa.schemals.schemadocument.resolvers.ResolverTraversal;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQLNode;
import java.util.Optional;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

public class RankProfileDocument
implements DocumentManager {
    private ClientLogger logger;
    private SchemaDiagnosticsHandler diagnosticsHandler;
    private SchemaIndex schemaIndex;
    private SchemaDocumentScheduler scheduler;
    private SchemaDocumentLexer lexer = new SchemaDocumentLexer();
    private String fileURI;
    private String content = null;
    private Integer version;
    private boolean isOpen = false;
    private SchemaNode CST = null;

    public RankProfileDocument(ClientLogger logger, SchemaDiagnosticsHandler diagnosticsHandler, SchemaIndex schemaIndex, SchemaDocumentScheduler scheduler, String fileURI) {
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
        this.schemaIndex = schemaIndex;
        this.scheduler = scheduler;
        this.fileURI = fileURI;
    }

    @Override
    public void updateFileContent(String content, Integer version) {
        this.version = version;
        this.updateFileContent(content);
    }

    @Override
    public void updateFileContent(String content) {
        this.content = content;
        this.schemaIndex.clearDocument(this.fileURI);
        SchemaDocument.ParseResult result = RankProfileDocument.parseContent(this.getParseContext());
        this.diagnosticsHandler.publishDiagnostics(this.fileURI, result.diagnostics());
        if (result.CST().isPresent()) {
            this.CST = result.CST().get();
            this.lexer.setCST(this.CST);
        }
    }

    @Override
    public ParseContext getParseContext() {
        ParseContext context = new ParseContext(this.content, this.logger, this.fileURI, this.schemaIndex, this.scheduler);
        context.useGeneralIdentifers();
        context.useRankProfileIdentifiers();
        return context;
    }

    public static SchemaDocument.ParseResult parseContent(ParseContext context) {
        String sequence = context.content();
        SchemaParser parserFaultTolerant = new SchemaParser(context.fileURI(), sequence);
        parserFaultTolerant.setParserTolerant(true);
        try {
            parserFaultTolerant.RootRankProfile();
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Node node = parserFaultTolerant.rootNode();
        SchemaDocument.ParseResult tolerantResult = SchemaDocument.parseCST(node, context);
        tolerantResult.diagnostics().addAll(InheritanceResolver.resolveInheritances(context));
        if (tolerantResult.CST().isPresent()) {
            tolerantResult.diagnostics().addAll(ResolverTraversal.traverse(context, tolerantResult.CST().get()));
        }
        return tolerantResult;
    }

    public Optional<Symbol> schemaSymbol() {
        if (this.CST == null || this.CST.size() == 0) {
            return Optional.empty();
        }
        try {
            Symbol rankProfileDefinition = this.CST.get(0).get(1).getSymbol();
            return this.schemaIndex.getFirstSymbolDefinition(rankProfileDefinition.getScope());
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }

    @Override
    public String getFileURI() {
        return this.fileURI;
    }

    @Override
    public void reparseContent() {
        if (this.content != null) {
            this.updateFileContent(this.content);
        }
    }

    @Override
    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    @Override
    public SchemaNode getRootNode() {
        return this.CST;
    }

    @Override
    public YQLNode getRootYQLNode() {
        return null;
    }

    @Override
    public String getCurrentContent() {
        return this.content;
    }

    @Override
    public VersionedTextDocumentIdentifier getVersionedTextDocumentIdentifier() {
        return new VersionedTextDocumentIdentifier(this.fileURI, null);
    }

    @Override
    public SchemaDocumentLexer lexer() {
        return this.lexer;
    }

    @Override
    public DocumentManager.DocumentType getDocumentType() {
        return DocumentManager.DocumentType.PROFILE;
    }
}

