/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.rankingexpression.ast.rankPropertyFeature;
import ai.vespa.schemals.parser.rankingexpression.ast.unaryFunctionName;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.BuiltInFunctions;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.GenericFunction;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;

public class RankExpressionSymbolResolver {
    public static final Set<Class<?>> builtInTokenizedFunctions = new HashSet<Class<?>>(){
        {
            this.add(unaryFunctionName.class);
        }
    };
    private static final List<Symbol.SymbolType> possibleTypes = new ArrayList<Symbol.SymbolType>(){
        {
            this.add(Symbol.SymbolType.FUNCTION);
            this.add(Symbol.SymbolType.RANK_CONSTANT);
            this.add(Symbol.SymbolType.TENSOR_DIMENSION_MAPPED);
            this.add(Symbol.SymbolType.TENSOR_DIMENSION_INDEXED);
        }
    };

    public static void resolveRankExpressionReferences(SchemaNode node, ParseContext context, List<Diagnostic> diagnostics) {
        if (node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION) {
            RankExpressionSymbolResolver.resolveRankExpression(node, context, diagnostics);
        } else {
            for (Node child : node) {
                RankExpressionSymbolResolver.resolveRankExpressionReferences(child.getSchemaNode(), context, diagnostics);
            }
        }
    }

    public static void resolveRankExpression(SchemaNode schemaNode, ParseContext context, List<Diagnostic> diagnostics) {
        List<RankNode> rankNodes = RankNode.createTree(schemaNode);
        for (RankNode node : rankNodes) {
            RankExpressionSymbolResolver.traverseRankExpressionTree(node, context, diagnostics);
        }
    }

    private static void traverseRankExpressionTree(RankNode node, ParseContext context, List<Diagnostic> diagnostics) {
        for (RankNode child : node) {
            RankExpressionSymbolResolver.traverseRankExpressionTree(child, context, diagnostics);
        }
        if (node.hasSymbol()) {
            if (node.getSymbolStatus() == Symbol.SymbolStatus.UNRESOLVED) {
                RankExpressionSymbolResolver.resolveReference(node, context, diagnostics);
            }
            if (node.getSymbolStatus() == Symbol.SymbolStatus.UNRESOLVED) {
                RankExpressionSymbolResolver.findBuiltInTensorFunction(node);
            }
            if (node.getSymbolStatus() == Symbol.SymbolStatus.UNRESOLVED) {
                if (node.getSchemaNode().getParent().isASTInstance(rankPropertyFeature.class)) {
                    RankExpressionSymbolResolver.findRankPropertyFeature(node, context, diagnostics);
                } else {
                    RankExpressionSymbolResolver.findBuiltInFunction(node, context, diagnostics);
                }
            }
        }
    }

    private static void findBuiltInTensorFunction(RankNode node) {
        if (node.getType() == RankNode.RankNodeType.BUILT_IN_FUNCTION) {
            Symbol symbol = node.getSymbol();
            symbol.setType(Symbol.SymbolType.FUNCTION);
            symbol.setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        }
    }

    private static void removeSymbolFromIndex(ParseContext context, SchemaNode node) {
        while (true) {
            if (node.hasSymbol()) {
                Symbol symbol = node.getSymbol();
                if (symbol.getStatus() == Symbol.SymbolStatus.REFERENCE) {
                    context.schemaIndex().deleteSymbolReference(symbol);
                }
                node.removeSymbol();
                return;
            }
            if (node.size() <= 0) break;
            node = node.get(0).getSchemaNode();
        }
    }

    private static void findBuiltInFunction(RankNode node, ParseContext context, List<Diagnostic> diagnostics) {
        if (node.getType() != RankNode.RankNodeType.FEATURE) {
            return;
        }
        if (node.getSchemaNode().getParent().isASTInstance(rankPropertyFeature.class)) {
            return;
        }
        String identifier = node.getSymbol().getShortIdentifier();
        GenericFunction functionHandler = BuiltInFunctions.rankExpressionBuiltInFunctions.get(identifier);
        if (functionHandler == null) {
            return;
        }
        node.getSymbol().setType(Symbol.SymbolType.FUNCTION);
        node.getSymbol().setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        Optional<SchemaNode> functionProperty = node.getProperty();
        functionProperty.ifPresent(property -> RankExpressionSymbolResolver.removeSymbolFromIndex(context, property));
        diagnostics.addAll(functionHandler.handleArgumentList(context, node, false));
    }

    private static void findRankPropertyFeature(RankNode node, ParseContext context, List<Diagnostic> diagnostics) {
        String identifier = node.getSymbol().getShortIdentifier();
        GenericFunction functionHandler = BuiltInFunctions.rankExpressionBuiltInFunctions.get(identifier);
        if (functionHandler == null) {
            RankExpressionSymbolResolver.removeSymbolFromIndex(context, node.getSchemaNode());
            Range range = node.getRange();
            if (node.getSchemaNode().size() > 0) {
                range = node.getSchemaNode().get(0).getRange();
            }
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(range).setMessage("No feature with the name " + identifier + " was found. Property has no effect.").setSeverity(DiagnosticSeverity.Warning).build());
            return;
        }
        node.getSymbol().setType(Symbol.SymbolType.FUNCTION);
        node.getSymbol().setStatus(Symbol.SymbolStatus.BUILTIN_REFERENCE);
        Optional<SchemaNode> functionProperty = node.getProperty();
        functionProperty.ifPresent(property -> RankExpressionSymbolResolver.removeSymbolFromIndex(context, property));
        diagnostics.addAll(functionHandler.handleArgumentList(context, node, true));
    }

    private static void resolveReference(RankNode referenceNode, ParseContext context, List<Diagnostic> diagnostics) {
        if (referenceNode.getSymbolType() != Symbol.SymbolType.TYPE_UNKNOWN) {
            return;
        }
        if (referenceNode.getInsideLambdaFunction()) {
            RankExpressionSymbolResolver.resolveReferenceInsideLambda(referenceNode, context, diagnostics);
            return;
        }
        Symbol reference = referenceNode.getSymbol();
        Optional<Object> definition = Optional.empty();
        if (!referenceNode.getArgumentListExists()) {
            definition = context.schemaIndex().findSymbol(reference.getScope(), Symbol.SymbolType.PARAMETER, reference.getShortIdentifier());
        }
        if (definition.isEmpty()) {
            for (Symbol.SymbolType possibleType : possibleTypes) {
                definition = context.schemaIndex().findSymbol(reference.getScope(), possibleType, reference.getShortIdentifier());
                if (!definition.isPresent()) continue;
                break;
            }
        }
        if (definition.isEmpty()) {
            return;
        }
        reference.setType(((Symbol)definition.get()).getType());
        reference.setStatus(Symbol.SymbolStatus.REFERENCE);
        context.schemaIndex().insertSymbolReference((Symbol)definition.get(), reference);
    }

    private static void resolveReferenceInsideLambda(RankNode node, ParseContext context, List<Diagnostic> diagnostics) {
        Symbol symbol = node.getSymbol();
        List<Symbol> possibleDefinition = context.schemaIndex().findSymbolsInScope(symbol.getScope(), Symbol.SymbolType.PARAMETER, symbol.getShortIdentifier());
        if (possibleDefinition.size() == 0) {
            return;
        }
        if (possibleDefinition.size() > 1) {
            return;
        }
        symbol.setType(Symbol.SymbolType.PARAMETER);
        symbol.setStatus(Symbol.SymbolStatus.REFERENCE);
        context.schemaIndex().insertSymbolReference(possibleDefinition.get(0), symbol);
    }
}

