/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.context;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.index.FieldIndex;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.schemadocument.parser.IdentifyDirtyNodes;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyDeprecatedToken;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyDirtySchemaNodes;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyDocumentInheritance;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyDocumentSummaryInheritance;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyDocumentlessSchema;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyNamedDocument;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyRankProfileInheritance;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyRankProperties;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifySchemaInheritance;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyStructInheritance;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifySymbolDefinition;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifySymbolReferences;
import ai.vespa.schemals.schemadocument.parser.schema.IdentifyType;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.FieldArgument;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQLNode;
import java.util.ArrayList;
import java.util.List;

public class ParseContext {
    private String content;
    private String fileURI;
    private ClientLogger logger;
    private List<Identifier<SchemaNode>> identifiers;
    private List<Identifier<YQLNode>> YQLIdentifiers;
    private List<SchemaNode> unresolvedInheritanceNodes;
    private List<SchemaNode> unresolvedTypeNodes;
    private List<SchemaNode> unresolvedDocumentReferenceNodes;
    private List<FieldArgument.UnresolvedFieldArgument> unresolvedFieldArgumentNodes;
    private SchemaIndex schemaIndex;
    private SchemaNode inheritsSchemaNode;
    private SchemaDocumentScheduler scheduler;

    public ParseContext(String content, ClientLogger logger, String fileURI, SchemaIndex schemaIndex, SchemaDocumentScheduler scheduler) {
        this.content = content;
        this.logger = logger;
        this.fileURI = fileURI;
        this.schemaIndex = schemaIndex;
        this.unresolvedInheritanceNodes = new ArrayList<SchemaNode>();
        this.unresolvedTypeNodes = new ArrayList<SchemaNode>();
        this.unresolvedDocumentReferenceNodes = new ArrayList<SchemaNode>();
        this.unresolvedFieldArgumentNodes = new ArrayList<FieldArgument.UnresolvedFieldArgument>();
        this.inheritsSchemaNode = null;
        this.identifiers = new ArrayList<Identifier<SchemaNode>>();
        this.YQLIdentifiers = new ArrayList<Identifier<YQLNode>>();
        this.scheduler = scheduler;
    }

    public void useDocumentIdentifiers() {
        final ParseContext context = this;
        this.identifiers = new ArrayList<Identifier<SchemaNode>>(){
            {
                this.add(new IdentifyType(context));
                this.add(new IdentifySymbolDefinition(context));
                this.add(new IdentifySymbolReferences(context));
                this.add(new IdentifySchemaInheritance(context));
                this.add(new IdentifyDocumentInheritance(context));
                this.add(new IdentifyStructInheritance(context));
                this.add(new IdentifyRankProfileInheritance(context));
                this.add(new IdentifyDocumentSummaryInheritance(context));
                this.add(new IdentifyDeprecatedToken(context));
                this.add(new IdentifyDirtySchemaNodes(context));
                this.add(new IdentifyDocumentlessSchema(context));
                this.add(new IdentifyNamedDocument(context));
                this.add(new IdentifyRankProperties(context));
            }
        };
    }

    public void useRankProfileIdentifiers() {
        final ParseContext context = this;
        this.identifiers = new ArrayList<Identifier<SchemaNode>>(){
            {
                this.add(new IdentifySymbolDefinition(context));
                this.add(new IdentifySymbolReferences(context));
                this.add(new IdentifyRankProfileInheritance(context));
                this.add(new IdentifyDirtySchemaNodes(context));
                this.add(new IdentifyRankProperties(context));
            }
        };
    }

    public void useVespaGroupingIdentifiers() {
        final ParseContext context = this;
        this.YQLIdentifiers = new ArrayList<Identifier<YQLNode>>(){
            {
                this.add(new IdentifyDirtyNodes(context));
            }
        };
    }

    public String content() {
        return this.content;
    }

    public ClientLogger logger() {
        return this.logger;
    }

    public String fileURI() {
        return this.fileURI;
    }

    public List<Identifier<SchemaNode>> identifiers() {
        return this.identifiers;
    }

    public List<Identifier<YQLNode>> YQLIdentifiers() {
        return this.YQLIdentifiers;
    }

    public List<SchemaNode> unresolvedInheritanceNodes() {
        return this.unresolvedInheritanceNodes;
    }

    public List<SchemaNode> unresolvedTypeNodes() {
        return this.unresolvedTypeNodes;
    }

    public List<SchemaNode> unresolvedDocumentReferenceNodes() {
        return this.unresolvedDocumentReferenceNodes;
    }

    public List<FieldArgument.UnresolvedFieldArgument> unresolvedFieldArguments() {
        return this.unresolvedFieldArgumentNodes;
    }

    public SchemaIndex schemaIndex() {
        return this.schemaIndex;
    }

    public FieldIndex fieldIndex() {
        return this.schemaIndex.fieldIndex();
    }

    public SchemaDocumentScheduler scheduler() {
        return this.scheduler;
    }

    public void addIdentifier(Identifier<SchemaNode> identifier) {
        this.identifiers.add(identifier);
    }

    public void addUnresolvedTypeNode(SchemaNode node) {
        this.unresolvedTypeNodes.add(node);
    }

    public void addUnresolvedInheritanceNode(SchemaNode nameNode) {
        this.unresolvedInheritanceNodes.add(nameNode);
    }

    public void addUnresolvedDocumentReferenceNode(SchemaNode node) {
        this.unresolvedDocumentReferenceNodes.add(node);
    }

    public void addUnresolvedFieldArgument(FieldArgument.UnresolvedFieldArgument node) {
        this.unresolvedFieldArgumentNodes.add(node);
    }

    public void clearUnresolvedTypeNodes() {
        this.unresolvedTypeNodes.clear();
    }

    public void clearUnresolvedInheritanceNodes() {
        this.unresolvedInheritanceNodes.clear();
    }

    public void clearUnresolvedDocumentReferenceNodes() {
        this.unresolvedDocumentReferenceNodes.clear();
    }

    public void clearUnresolvedFieldArguments() {
        this.unresolvedFieldArgumentNodes.clear();
    }

    public SchemaNode inheritsSchemaNode() {
        return this.inheritsSchemaNode;
    }

    public void setInheritsSchemaNode(SchemaNode schemaNode) {
        this.inheritsSchemaNode = schemaNode;
    }
}

