/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.parser.ast.consumedExpressionElm;
import ai.vespa.schemals.parser.rankingexpression.ParseException;
import ai.vespa.schemals.parser.rankingexpression.RankingExpressionParser;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.CompositeNode;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.io.PrintStream;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;

public class SchemaRankExpressionParser {
    static void printExpressionTree(PrintStream logger, ExpressionNode node, int indent) {
        String[] classList = node.getClass().toString().split("[.]");
        String className = classList[classList.length - 1];
        String msg = node.toString() + " (" + className + ")";
        if (node instanceof ReferenceNode) {
            Reference ref = ((ReferenceNode)node).reference();
            msg = msg + " [REF: " + ref.name() + "]";
            if (ref.isIdentifier()) {
                msg = msg + " [IDENTIFIER]";
            }
            if (ref.output() != null) {
                msg = msg + " [OUTPUT: " + ref.output() + "]";
            }
        }
        logger.println(new String(new char[indent]).replaceAll("\u0000", "\t") + msg);
        if (node instanceof CompositeNode) {
            for (ExpressionNode child : ((CompositeNode)node).children()) {
                SchemaRankExpressionParser.printExpressionTree(logger, child, indent + 1);
            }
        }
    }

    static SchemaNode parseRankingExpression(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        String expressionString = node.getRankExpressionString();
        Position expressionStart = node.getRange().getStart();
        if (expressionString == null) {
            return null;
        }
        String sequence = expressionString;
        RankingExpressionParser tolerantParser = new RankingExpressionParser(context.fileURI(), sequence);
        tolerantParser.setParserTolerant(true);
        try {
            if (node.isASTInstance(consumedExpressionElm.class)) {
                tolerantParser.expression();
            } else {
                tolerantParser.featureList();
            }
        }
        catch (ParseException parseException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (tolerantParser.rootNode() == null) {
            return null;
        }
        return new SchemaNode(tolerantParser.rootNode(), expressionStart);
    }

    static void embedCST(ParseContext context, SchemaNode node, List<Diagnostic> diagnostics) {
        if (!node.containsOtherLanguageData(Node.LanguageType.RANK_EXPRESSION)) {
            return;
        }
        if (CSTUtils.rangeIsEmpty(node.getRange())) {
            return;
        }
        node.addChild(SchemaRankExpressionParser.parseRankingExpression(context, node, diagnostics));
    }
}

