/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.common.completion;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.CompletionItemLabelDetails;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.InsertTextMode;

public class CompletionUtils {
    public static CompletionItem constructSnippet(String label2, String snippet, String detail) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label2);
        item.setKind(CompletionItemKind.Snippet);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setInsertText(snippet);
        item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        item.setDetail(detail);
        return item;
    }

    public static CompletionItem constructSnippet(String label2, String snippet) {
        return CompletionUtils.constructSnippet(label2, snippet, "");
    }

    public static CompletionItem constructType(String label2) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label2);
        item.setKind(CompletionItemKind.TypeParameter);
        return item;
    }

    public static CompletionItem constructBasic(String label2) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label2);
        return item;
    }

    public static CompletionItem constructBasic(String label2, String detail) {
        CompletionItem item = new CompletionItem();
        item.setLabel(label2);
        item.setDetail(detail);
        return item;
    }

    public static CompletionItem constructBasicDeprecated(String label2) {
        CompletionItem item = CompletionUtils.constructBasic(label2);
        item.setTags(List.of(CompletionItemTag.Deprecated));
        return item;
    }

    public static CompletionItem constructSnippetDeprecated(String label2, String snippet, String detail) {
        CompletionItem item = CompletionUtils.constructSnippet(label2, snippet, detail);
        item.setTags(List.of(CompletionItemTag.Deprecated));
        return item;
    }

    public static CompletionItem withSortingPrefix(String prefix, CompletionItem item) {
        item.setSortText(prefix + item.getLabel());
        return item;
    }

    public static CompletionItem constructFunction(String name, String signature, String longIdentifier) {
        CompletionItem item = new CompletionItem(name);
        item.setKind(CompletionItemKind.Function);
        CompletionItemLabelDetails labelDetails = new CompletionItemLabelDetails();
        labelDetails.setDetail((String)signature);
        labelDetails.setDescription(longIdentifier);
        item.setLabelDetails(labelDetails);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setInsertTextMode(InsertTextMode.AdjustIndentation);
        signature = ((String)signature).trim();
        if (((String)signature).length() > 2 && ((String)signature).startsWith("(") && ((String)signature).endsWith(")")) {
            String[] args2 = ((String)signature).substring(1, ((String)signature).length() - 1).split(",");
            ArrayList<CallSite> snippetTemplates = new ArrayList<CallSite>();
            for (int i = 0; i < args2.length; ++i) {
                snippetTemplates.add((CallSite)((Object)("${" + (i + 1) + ":" + args2[i] + "}")));
            }
            signature = "(" + String.join((CharSequence)", ", snippetTemplates) + ")";
        }
        item.setInsertText(name + (String)signature);
        return item;
    }
}

