/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree;

import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.SubLanguageData;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.parser.ast.consumedExpressionElm;
import ai.vespa.schemals.parser.ast.consumedFeatureListElm;
import ai.vespa.schemals.parser.ast.indexingElm;
import ai.vespa.schemals.parser.indexinglanguage.Token;
import ai.vespa.schemals.parser.rankingexpression.Token;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.indexinglanguage.ILUtils;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import ai.vespa.schemals.tree.rankingexpression.RankingExpressionUtils;
import java.util.Optional;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class SchemaNode
extends Node {
    private String identifierString;
    private ai.vespa.schemals.parser.Node originalSchemaNode;
    private ai.vespa.schemals.parser.indexinglanguage.Node originalIndexingNode;
    private ai.vespa.schemals.parser.rankingexpression.Node originalRankExpressionNode;
    private String contentString;
    private Class<? extends ai.vespa.schemals.parser.Node> simulatedSchemaClass;
    private Token.TokenType schemaType;
    private Token.TokenType rankExpressionType;
    private Token.TokenType indexinglanguageType;
    private Optional<RankNode> rankNode = Optional.empty();

    private SchemaNode(Node.LanguageType language, Range range, String identifierString, boolean isDirty) {
        super(language, range, isDirty);
        this.identifierString = identifierString;
    }

    public SchemaNode(Range range, String contentString, String identifierString) {
        this(Node.LanguageType.CUSTOM, range, identifierString, false);
        this.contentString = contentString;
    }

    public SchemaNode(ai.vespa.schemals.parser.Node node) {
        this(Node.LanguageType.SCHEMA, CSTUtils.getNodeRange(node), node.getClass().getName(), node.isDirty());
        this.originalSchemaNode = node;
        this.schemaType = this.calculateSchemaType();
        for (ai.vespa.schemals.parser.Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child);
            this.addChild(newNode);
        }
    }

    public SchemaNode(ai.vespa.schemals.parser.indexinglanguage.Node node, Position rangeOffset) {
        this(Node.LanguageType.INDEXING, CSTUtils.addPositionToRange(rangeOffset, ILUtils.getNodeRange(node)), node.getClass().getName(), node.isDirty());
        this.originalIndexingNode = node;
        if (node instanceof Token) {
            this.indexinglanguageType = (Token.TokenType)node.getType();
        }
        for (ai.vespa.schemals.parser.indexinglanguage.Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child, rangeOffset);
            this.addChild(newNode);
        }
    }

    public SchemaNode(ai.vespa.schemals.parser.rankingexpression.Node node, Position rangeOffset) {
        this(Node.LanguageType.RANK_EXPRESSION, CSTUtils.addPositionToRange(rangeOffset, RankingExpressionUtils.getNodeRange(node)), node.getClass().getName(), node.isDirty());
        this.originalRankExpressionNode = node;
        if (node instanceof ai.vespa.schemals.parser.rankingexpression.Token) {
            this.rankExpressionType = (Token.TokenType)node.getType();
        }
        for (ai.vespa.schemals.parser.rankingexpression.Node child : node) {
            if (child == null) continue;
            SchemaNode newNode = new SchemaNode(child, rangeOffset);
            this.addChild(newNode);
        }
    }

    private Token.TokenType calculateSchemaType() {
        if (this.language != Node.LanguageType.SCHEMA) {
            return null;
        }
        if (this.isDirty) {
            return null;
        }
        Node.NodeType nodeType = this.originalSchemaNode.getType();
        if (!(nodeType instanceof Token.TokenType)) {
            return null;
        }
        return (Token.TokenType)nodeType;
    }

    public Token.TokenType getSchemaType() {
        return this.schemaType;
    }

    public Token.TokenType getRankExpressionType() {
        return this.rankExpressionType;
    }

    public Token.TokenType getIndexingLanguageType() {
        return this.indexinglanguageType;
    }

    public Token.TokenType getDirtyType() {
        if (this.language != Node.LanguageType.SCHEMA) {
            return null;
        }
        Node.NodeType originalType = this.originalSchemaNode.getType();
        if (originalType instanceof Token.TokenType) {
            return (Token.TokenType)originalType;
        }
        return null;
    }

    public Token.TokenType setSchemaType(Token.TokenType type) {
        if (this.language != Node.LanguageType.SCHEMA && this.language != Node.LanguageType.CUSTOM) {
            return null;
        }
        this.schemaType = type;
        return type;
    }

    public void setSymbolType(Symbol.SymbolType newType) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbol.setType(newType);
    }

    public void setSymbolStatus(Symbol.SymbolStatus newStatus) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbol.setStatus(newStatus);
    }

    public void setSymbolScope(Symbol newScope) {
        if (!this.hasSymbol()) {
            return;
        }
        this.symbol.setScope(newScope);
    }

    public boolean containsOtherLanguageData(Node.LanguageType language) {
        if (this.language != Node.LanguageType.SCHEMA) {
            return false;
        }
        return language == Node.LanguageType.INDEXING && this.originalSchemaNode instanceof indexingElm || language == Node.LanguageType.RANK_EXPRESSION && (this.originalSchemaNode instanceof consumedExpressionElm || this.originalSchemaNode instanceof consumedFeatureListElm);
    }

    public SubLanguageData getILScript() {
        if (!this.containsOtherLanguageData(Node.LanguageType.INDEXING)) {
            return null;
        }
        indexingElm elmNode = (indexingElm)this.originalSchemaNode;
        return elmNode.getILScript();
    }

    public String getRankExpressionString() {
        if (!this.containsOtherLanguageData(Node.LanguageType.RANK_EXPRESSION)) {
            return null;
        }
        if (this.originalSchemaNode instanceof consumedExpressionElm) {
            consumedExpressionElm expressionNode = (consumedExpressionElm)this.originalSchemaNode;
            return expressionNode.getRankingExpression();
        }
        if (this.originalSchemaNode instanceof consumedFeatureListElm) {
            consumedFeatureListElm featureListNode = (consumedFeatureListElm)this.originalSchemaNode;
            return featureListNode.getFeatureList();
        }
        return null;
    }

    public boolean hasIndexingNode() {
        return false;
    }

    public boolean hasRankExpressionNode() {
        return false;
    }

    public ai.vespa.schemals.parser.Node getOriginalSchemaNode() {
        return this.originalSchemaNode;
    }

    public ai.vespa.schemals.parser.indexinglanguage.Node getOriginalIndexingNode() {
        return this.originalIndexingNode;
    }

    public ai.vespa.schemals.parser.rankingexpression.Node getOriginalRankExpressionNode() {
        return this.originalRankExpressionNode;
    }

    public void setSimulatedASTClass(Class<? extends ai.vespa.schemals.parser.Node> astClass) {
        if (this.language != Node.LanguageType.CUSTOM) {
            throw new IllegalArgumentException("Cannot set Simulated AST Class on a Schema node of type other than Custom");
        }
        this.simulatedSchemaClass = astClass;
    }

    @Override
    public boolean isASTInstance(Class<?> astClass) {
        if (this.language == Node.LanguageType.CUSTOM && astClass == this.simulatedSchemaClass) {
            return true;
        }
        if (this.language == Node.LanguageType.SCHEMA) {
            return astClass.isInstance(this.originalSchemaNode);
        }
        if (this.language == Node.LanguageType.RANK_EXPRESSION) {
            return astClass.isInstance(this.originalRankExpressionNode);
        }
        if (this.language == Node.LanguageType.INDEXING) {
            return astClass.isInstance(this.originalIndexingNode);
        }
        return false;
    }

    public boolean isSchemaASTInstance(Class<? extends ai.vespa.schemals.parser.Node> astClass) {
        if (this.language == Node.LanguageType.CUSTOM) {
            return astClass.equals(this.simulatedSchemaClass);
        }
        return astClass.isInstance(this.originalSchemaNode);
    }

    public boolean isRankExpressionASTInstance(Class<? extends ai.vespa.schemals.parser.rankingexpression.Node> astClass) {
        return astClass.isInstance(this.originalRankExpressionNode);
    }

    @Override
    public Class<?> getASTClass() {
        if (this.language == Node.LanguageType.CUSTOM) {
            return this.simulatedSchemaClass;
        }
        if (this.language == Node.LanguageType.SCHEMA && this.originalSchemaNode != null) {
            return this.originalSchemaNode.getClass();
        }
        if (this.language == Node.LanguageType.RANK_EXPRESSION && this.originalRankExpressionNode != null) {
            return this.originalRankExpressionNode.getClass();
        }
        if (this.language == Node.LanguageType.INDEXING && this.originalIndexingNode != null) {
            return this.originalIndexingNode.getClass();
        }
        return null;
    }

    public String getIdentifierString() {
        return this.identifierString;
    }

    public void setNewStartCharacter(int startCharacter) {
        if (this.originalSchemaNode == null) {
            return;
        }
        int currentOffset = this.originalSchemaNode.getBeginOffset();
        int characterDelta = startCharacter - this.range.getStart().getCharacter();
        this.originalSchemaNode.setBeginOffset(currentOffset + characterDelta);
        this.range = CSTUtils.getNodeRange(this.originalSchemaNode);
    }

    public void setNewEndCharacter(int endCharacter) {
        if (this.originalSchemaNode == null) {
            return;
        }
        int currentOffset = this.originalSchemaNode.getEndOffset();
        int characterDelta = endCharacter - this.range.getEnd().getCharacter();
        this.originalSchemaNode.setEndOffset(currentOffset + characterDelta);
        this.range = CSTUtils.getNodeRange(this.originalSchemaNode);
    }

    @Override
    public int getBeginOffset() {
        switch (this.language) {
            case SCHEMA: {
                if (this.originalSchemaNode == null) {
                    return -1;
                }
                return this.originalSchemaNode.getBeginOffset();
            }
            case INDEXING: {
                if (this.originalIndexingNode == null) {
                    return -1;
                }
                return this.originalIndexingNode.getBeginOffset();
            }
            case RANK_EXPRESSION: {
                if (this.originalRankExpressionNode == null) {
                    return -1;
                }
                return this.originalRankExpressionNode.getBeginOffset();
            }
        }
        return -1;
    }

    @Override
    public int getEndOffset() {
        switch (this.language) {
            case SCHEMA: {
                if (this.originalSchemaNode == null) {
                    return -1;
                }
                return this.originalSchemaNode.getEndOffset();
            }
            case INDEXING: {
                if (this.originalIndexingNode == null) {
                    return -1;
                }
                return this.originalIndexingNode.getEndOffset();
            }
            case RANK_EXPRESSION: {
                if (this.originalRankExpressionNode == null) {
                    return -1;
                }
                return this.originalRankExpressionNode.getEndOffset();
            }
        }
        return -1;
    }

    public String getClassLeafIdentifierString() {
        if (this.language == Node.LanguageType.CUSTOM && this.getASTClass() != null) {
            return this.getASTClass().getSimpleName();
        }
        int lastIndex = this.identifierString.lastIndexOf(46);
        return this.identifierString.substring(lastIndex + 1);
    }

    @Override
    public String getText() {
        if (this.language == Node.LanguageType.SCHEMA) {
            return this.originalSchemaNode.getSource();
        }
        if (this.language == Node.LanguageType.INDEXING) {
            return this.originalIndexingNode.getSource();
        }
        if (this.language == Node.LanguageType.RANK_EXPRESSION) {
            return this.originalRankExpressionNode.getSource();
        }
        if (this.language == Node.LanguageType.CUSTOM) {
            return this.contentString;
        }
        return null;
    }

    public SchemaNode findFirstLeaf() {
        Node ret = this;
        while (ret.size() > 0) {
            ret = ret.get(0);
        }
        return ((Node)ret).getSchemaNode();
    }

    public IllegalArgumentException getIllegalArgumentException() {
        if (this.language == Node.LanguageType.SCHEMA && this.originalSchemaNode instanceof ai.vespa.schemals.parser.Token) {
            return ((ai.vespa.schemals.parser.Token)this.originalSchemaNode).getIllegalArguemntException();
        }
        return null;
    }

    public Token.ParseExceptionSource getParseExceptionSource() {
        if (this.language == Node.LanguageType.SCHEMA && this.originalSchemaNode instanceof ai.vespa.schemals.parser.Token) {
            return ((ai.vespa.schemals.parser.Token)this.originalSchemaNode).getParseExceptionSource();
        }
        return null;
    }

    public TokenSource getTokenSource() {
        if (this.language == Node.LanguageType.SCHEMA) {
            return this.originalSchemaNode.getTokenSource();
        }
        return null;
    }

    public void setRankNode(RankNode node) {
        this.rankNode = Optional.of(node);
    }

    public Optional<RankNode> getRankNode() {
        return this.rankNode;
    }

    @Override
    public boolean isSchemaNode() {
        return true;
    }

    @Override
    public SchemaNode getSchemaNode() {
        return this;
    }

    public String toString() {
        Position pos = this.getRange().getStart();
        String astClassStr = this.getASTClass() == null ? "AST_NULL" : this.getASTClass().toString();
        astClassStr = astClassStr.substring(astClassStr.lastIndexOf(46) + 1);
        String ret = "Node('" + this.getText() + "', [" + astClassStr + "] at " + pos.getLine() + ":" + pos.getCharacter();
        if (this.hasSymbol()) {
            ret = ret + " [SYMBOL " + this.getSymbol().getType().toString() + " " + this.getSymbol().getStatus().toString() + ": " + this.getSymbol().getLongIdentifier() + "]";
        }
        ret = ret + ")";
        return ret;
    }
}

