/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument;

import ai.vespa.schemals.SchemaDiagnosticsHandler;
import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.common.StringUtils;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.parser.yqlplus.ParseException;
import ai.vespa.schemals.parser.yqlplus.YQLPlusParser;
import ai.vespa.schemals.schemadocument.DocumentManager;
import ai.vespa.schemals.schemadocument.SchemaDocumentLexer;
import ai.vespa.schemals.schemadocument.SchemaDocumentScheduler;
import ai.vespa.schemals.schemadocument.VespaGroupingParser;
import ai.vespa.schemals.schemadocument.parser.Identifier;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.YQLNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;

public class YQLDocument
implements DocumentManager {
    boolean isOpen = false;
    String fileURI;
    String fileContent = "";
    ClientLogger logger;
    private SchemaDiagnosticsHandler diagnosticsHandler;
    private SchemaIndex schemaIndex;
    private SchemaDocumentScheduler scheduler;
    private YQLNode CST;

    YQLDocument(ClientLogger logger, SchemaDiagnosticsHandler diagnosticsHandler, SchemaIndex schemaIndex, SchemaDocumentScheduler scheduler, String fileURI) {
        this.fileURI = fileURI;
        this.logger = logger;
        this.diagnosticsHandler = diagnosticsHandler;
        this.schemaIndex = schemaIndex;
        this.scheduler = scheduler;
    }

    @Override
    public ParseContext getParseContext() {
        ParseContext context = new ParseContext(this.fileContent, this.logger, this.fileURI, this.schemaIndex, this.scheduler);
        context.useVespaGroupingIdentifiers();
        return context;
    }

    @Override
    public void updateFileContent(String content) {
        this.fileContent = content;
        ParseContext context = this.getParseContext();
        ParseResult parseResult = YQLDocument.parseContent(context);
        this.diagnosticsHandler.publishDiagnostics(this.fileURI, parseResult.diagnostics());
        if (parseResult.CST.isPresent()) {
            this.CST = parseResult.CST.get();
        }
    }

    @Override
    public void updateFileContent(String content, Integer version) {
        this.updateFileContent(content);
    }

    private static YQLPartParseResult parseYQLPart(String content, ClientLogger logger, Position offset, int charOffset) {
        YQLPlusParser parser = new YQLPlusParser(content.toLowerCase());
        try {
            parser.statement();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        int charsRead = parser.getToken(0).getEndOffset();
        if (charsRead == 0) {
            return new YQLPartParseResult(List.of(), Optional.empty(), charsRead);
        }
        ai.vespa.schemals.parser.yqlplus.Node node = parser.rootNode();
        YQLNode retNode = new YQLNode(node, offset, charOffset, content);
        return new YQLPartParseResult(List.of(), Optional.of(retNode), charsRead);
    }

    private static boolean detectContinuation(String inputString) {
        for (int i = 0; i < inputString.length(); ++i) {
            if (inputString.charAt(i) == ' ') continue;
            return inputString.charAt(i) == '{';
        }
        return false;
    }

    private static YQLPartParseResult parseContinuation(String inputString, Position offset, int charOffset) {
        YQLPlusParser parser = new YQLPlusParser(inputString);
        try {
            parser.map_expression();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        ai.vespa.schemals.parser.yqlplus.Node node = parser.rootNode();
        YQLNode retNode = new YQLNode(node, offset, charOffset);
        int charsRead = parser.getToken(0).getEndOffset();
        return new YQLPartParseResult(List.of(), Optional.of(retNode), charsRead);
    }

    private static YQLPartParseResult parseYQLQuery(ParseContext context, String queryString, Position offset, int charOffset) {
        String charsBeforePipe;
        YQLNode ret = new YQLNode(new Range(offset, offset));
        int pipeIndex = queryString.indexOf(124);
        String YQLString = pipeIndex == -1 ? queryString : queryString.substring(0, pipeIndex);
        YQLPartParseResult YQLResult = YQLDocument.parseYQLPart(YQLString, context.logger(), offset, charOffset);
        if (YQLResult.CST.isEmpty()) {
            return YQLResult;
        }
        ret.addChild((Node)YQLResult.CST.get());
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>(YQLResult.diagnostics());
        int charsRead = YQLResult.charsRead();
        if (pipeIndex != -1 && pipeIndex + 1 < queryString.length() && (charsBeforePipe = queryString.substring(charsRead, pipeIndex)).strip().length() == 0) {
            String groupingString = queryString.substring(pipeIndex + 1);
            charsRead = pipeIndex + 1;
            Position YQLStringPosition = StringUtils.getStringPosition(YQLString);
            Position groupOffsetWithoutPipe = CSTUtils.addPositions(offset, YQLStringPosition);
            Position groupOffset = CSTUtils.addPositions(groupOffsetWithoutPipe, new Position(0, 1));
            ret.addChild(new YQLNode(new Range(groupOffsetWithoutPipe, groupOffset), "|", charOffset + pipeIndex));
            boolean continuationDetected = YQLDocument.detectContinuation(groupingString);
            if (continuationDetected) {
                YQLPartParseResult continuationResults = YQLDocument.parseContinuation(groupingString, groupOffset, charOffset + charsRead);
                diagnostics.addAll(continuationResults.diagnostics());
                if (continuationResults.CST().isPresent()) {
                    ret.addChild(continuationResults.CST().get());
                }
                charsRead += continuationResults.charsRead();
                String continuationString = groupingString.substring(0, continuationResults.charsRead());
                Position continuationPosition = StringUtils.getStringPosition(continuationString);
                groupingString = groupingString.substring(continuationResults.charsRead());
                groupOffset = CSTUtils.addPositions(groupOffset, continuationPosition);
            }
            if (groupingString.length() > 0 && groupingString.strip().length() > 0) {
                YQLPartParseResult groupingResult = VespaGroupingParser.parseVespaGrouping(groupingString, context.logger(), groupOffset, charOffset + charsRead);
                if (groupingResult.CST.isPresent()) {
                    ret.addChild((Node)groupingResult.CST.get());
                }
                diagnostics.addAll(groupingResult.diagnostics());
                charsRead += groupingResult.charsRead();
            }
        }
        Range newRange = StringUtils.getStringRange(queryString.substring(0, charsRead));
        ret.setRange(CSTUtils.addPositionToRange(offset, newRange));
        YQLDocument.traverseCST(ret, context, diagnostics);
        return new YQLPartParseResult(diagnostics, Optional.of(ret), charsRead);
    }

    public static ParseResult parseContent(ParseContext context) {
        String toParser;
        String content = context.content();
        YQLNode ret = new YQLNode(StringUtils.getStringRange(content));
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (content.trim().length() == 0) {
            return new ParseResult(diagnostics, Optional.of(ret));
        }
        int charsRead = 0;
        int linesRead = 0;
        while (charsRead < content.length() && (toParser = content.substring(charsRead)).strip().length() != 0) {
            int newOffset;
            YQLPartParseResult result = YQLDocument.parseYQLQuery(context, toParser, new Position(linesRead, 0), charsRead);
            diagnostics.addAll(result.diagnostics());
            if (result.CST().isPresent()) {
                ret.addChild(result.CST().get());
            }
            if (result.charsRead() == 0) {
                ++result.charsRead;
            }
            if ((newOffset = content.indexOf(10, charsRead + result.charsRead())) == -1) {
                newOffset = content.length();
            }
            String substr = content.substring(charsRead, newOffset);
            linesRead += StringUtils.countNewLines(substr);
            charsRead = newOffset;
        }
        return new ParseResult(diagnostics, Optional.of(ret));
    }

    private static void traverseCST(YQLNode node, ParseContext context, ArrayList<Diagnostic> diagnostics) {
        for (Identifier<YQLNode> identifier : context.YQLIdentifiers()) {
            diagnostics.addAll(identifier.identify(node));
        }
        for (Node child : node) {
            YQLDocument.traverseCST(child.getYQLNode(), context, diagnostics);
        }
    }

    @Override
    public void reparseContent() {
        if (this.fileContent != null) {
            this.updateFileContent(this.fileContent);
        }
    }

    @Override
    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public boolean getIsOpen() {
        return this.isOpen;
    }

    @Override
    public SchemaNode getRootNode() {
        return null;
    }

    @Override
    public YQLNode getRootYQLNode() {
        return this.CST;
    }

    @Override
    public SchemaDocumentLexer lexer() {
        throw new UnsupportedOperationException("Getting the lexer from a YQLDocument is not implemented");
    }

    @Override
    public String getFileURI() {
        return this.fileURI;
    }

    @Override
    public String getCurrentContent() {
        return this.fileContent;
    }

    @Override
    public VersionedTextDocumentIdentifier getVersionedTextDocumentIdentifier() {
        return new VersionedTextDocumentIdentifier(this.fileURI, Integer.valueOf(0));
    }

    @Override
    public DocumentManager.DocumentType getDocumentType() {
        return DocumentManager.DocumentType.YQL;
    }

    public static class ParseResult {
        public List<Diagnostic> diagnostics;
        public Optional<YQLNode> CST;

        ParseResult(List<Diagnostic> diagnostics, Optional<YQLNode> CST) {
            this.diagnostics = diagnostics;
            this.CST = CST;
        }

        public List<Diagnostic> diagnostics() {
            return this.diagnostics;
        }

        public Optional<YQLNode> CST() {
            return this.CST;
        }
    }

    static class YQLPartParseResult
    extends ParseResult {
        public int charsRead;

        YQLPartParseResult(List<Diagnostic> diagnostics, Optional<YQLNode> CST, int charsRead) {
            super(diagnostics, CST);
            this.charsRead = charsRead;
        }

        public int charsRead() {
            return this.charsRead;
        }
    }
}

