/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.grouping;

import ai.vespa.schemals.parser.grouping.Node;
import ai.vespa.schemals.parser.grouping.NonTerminalCall;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ParseException
extends RuntimeException {
    private Node.TerminalNode token;
    private Set<? extends Node.NodeType> expectedTypes;
    private List<NonTerminalCall> callStack;
    private boolean alreadyAdjusted;

    private void setInfo(Node.TerminalNode token, Set<? extends Node.NodeType> expectedTypes, List<NonTerminalCall> callStack) {
        if (token != null && !token.getType().isEOF() && token.getNext() != null) {
            token = token.getNext();
        }
        this.token = token;
        this.expectedTypes = expectedTypes;
        this.callStack = new ArrayList<NonTerminalCall>(callStack);
    }

    public boolean hitEOF() {
        return this.token != null && this.token.getType().isEOF();
    }

    public ParseException(Node.TerminalNode token, Set<? extends Node.NodeType> expectedTypes, List<NonTerminalCall> callStack) {
        this.setInfo(token, expectedTypes, callStack);
    }

    public ParseException(Node.TerminalNode token) {
        this.token = token;
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, List<NonTerminalCall> callStack) {
        super(message);
        this.callStack = callStack;
    }

    public ParseException(String message, Node.TerminalNode token, List<NonTerminalCall> callStack) {
        super(message);
        this.token = token;
        this.callStack = callStack;
    }

    @Override
    public String getMessage() {
        Object content;
        String msg = super.getMessage();
        if (this.token == null && this.expectedTypes == null) {
            return msg;
        }
        StringBuilder buf = new StringBuilder();
        if (msg != null) {
            buf.append(msg);
        }
        String location = this.token != null ? this.token.getLocation() : "";
        buf.append("\nEncountered an error at (or somewhere around) " + location);
        if (this.expectedTypes != null && this.token != null && this.expectedTypes.contains(this.token.getType())) {
            return buf.toString();
        }
        if (this.expectedTypes != null) {
            buf.append("\nWas expecting one of the following:\n");
            boolean isFirst = true;
            for (Node.NodeType nodeType : this.expectedTypes) {
                if (!isFirst) {
                    buf.append(", ");
                }
                isFirst = false;
                buf.append(nodeType);
            }
        }
        if ((content = this.token.toString()) == null) {
            content = "";
        }
        if (((String)content).length() > 32) {
            content = ((String)content).substring(0, 32) + "...";
        }
        buf.append("\nFound string \"" + ParseException.addEscapes((String)content) + "\" of type " + String.valueOf(this.token.getType()));
        return buf.toString();
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        this.adjustStackTrace();
        return super.getStackTrace();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.adjustStackTrace();
        super.printStackTrace(s);
    }

    public Node.TerminalNode getToken() {
        return this.token;
    }

    private void adjustStackTrace() {
        StackTraceElement[] jvmCallStack;
        if (this.alreadyAdjusted || this.callStack == null || this.callStack.isEmpty()) {
            return;
        }
        ArrayList<StackTraceElement> fullTrace = new ArrayList<StackTraceElement>();
        ArrayList<StackTraceElement> ourCallStack = new ArrayList<StackTraceElement>();
        for (NonTerminalCall nonTerminalCall : this.callStack) {
            ourCallStack.add(nonTerminalCall.createStackTraceElement());
        }
        for (StackTraceElement regularEntry : jvmCallStack = super.getStackTrace()) {
            if (ourCallStack.isEmpty()) break;
            String methodName = regularEntry.getMethodName();
            StackTraceElement ourEntry = this.lastElementWithName(ourCallStack, methodName);
            if (ourEntry != null) {
                fullTrace.add(ourEntry);
            }
            fullTrace.add(regularEntry);
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[fullTrace.size()];
        this.setStackTrace(fullTrace.toArray(stackTraceElementArray));
        this.alreadyAdjusted = true;
    }

    private StackTraceElement lastElementWithName(List<StackTraceElement> elements, String methodName) {
        ListIterator<StackTraceElement> it = elements.listIterator(elements.size());
        while (it.hasPrevious()) {
            StackTraceElement elem = it.previous();
            if (!elem.getMethodName().equals(methodName)) continue;
            it.remove();
            return elem;
        }
        return null;
    }

    private static String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }
}

