/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.yqlplus.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.lsp.common.completion.CompletionProvider;
import ai.vespa.schemals.lsp.common.completion.CompletionUtils;
import ai.vespa.schemals.parser.grouping.ast.LBRACE;
import ai.vespa.schemals.parser.grouping.ast.RBRACE;
import ai.vespa.schemals.parser.grouping.ast.SPACE;
import ai.vespa.schemals.parser.grouping.ast.lbraceElm;
import ai.vespa.schemals.parser.grouping.ast.operation;
import ai.vespa.schemals.parser.grouping.ast.operationBody;
import ai.vespa.schemals.parser.grouping.ast.rbraceElm;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class GroupOperationCompletion
implements CompletionProvider {
    private static final List<CompletionItem> completionItems = new ArrayList<CompletionItem>(){
        {
            this.add(CompletionUtils.constructSnippet("accuracy", "accuracy(${1:number})$0"));
            this.add(CompletionUtils.constructSnippet("alias", "alias(${1:identifier}, ${2:expression})$0"));
            this.add(CompletionUtils.constructSnippet("hint", "hint(${1:identifier})$0"));
            this.add(CompletionUtils.constructSnippet("max", "max(${1:number})$0"));
            this.add(CompletionUtils.constructSnippet("order", "order($1)$0"));
            this.add(CompletionUtils.constructSnippet("output", "output($1)$0"));
            this.add(CompletionUtils.constructSnippet("precision", "precision(${1:number})$0"));
            this.add(CompletionUtils.constructSnippet("where", "where($1)$0"));
            this.add(CompletionUtils.constructSnippet("filter", "filter(regex(\"$1\", $2))$0"));
        }
    };
    private static final List<CompletionItem> allEachCompletionItems = new ArrayList<CompletionItem>(){
        {
            this.add(CompletionUtils.constructSnippet("all", "all($1)$0"));
            this.add(CompletionUtils.constructSnippet("each", "each($1)$0"));
        }
    };

    private boolean isAllOrEachElement(Node node) {
        return node.getParent().isASTInstance(operation.class);
    }

    private Optional<Node> finOperationBody(Node last) {
        Node sibling;
        Node possiblyOperationBody;
        Node grandParent;
        if (last.isASTInstance(LBRACE.class) && this.isAllOrEachElement(grandParent = last.getParent(2))) {
            return Optional.of(last.getParent().getNextSibling());
        }
        if (last.isASTInstance(SPACE.class)) {
            grandParent = last.getParent(2);
            if (grandParent.isASTInstance(lbraceElm.class)) {
                if (this.isAllOrEachElement(grandParent.getParent())) {
                    return Optional.of(grandParent.getNextSibling());
                }
            } else if (grandParent.isASTInstance(rbraceElm.class)) {
                if (grandParent.getParent().isASTInstance(operationBody.class)) {
                    return Optional.of(grandParent.getParent());
                }
                if (this.isAllOrEachElement(grandParent.getParent()) && (possiblyOperationBody = grandParent.getParent(3)).isASTInstance(operationBody.class)) {
                    return Optional.of(possiblyOperationBody);
                }
            }
        }
        if (last.isASTInstance(RBRACE.class)) {
            grandParent = last.getParent(2);
            if (grandParent.isASTInstance(operationBody.class)) {
                return Optional.of(grandParent);
            }
            if (this.isAllOrEachElement(grandParent) && (possiblyOperationBody = grandParent.getParent(2)).isASTInstance(operationBody.class)) {
                return Optional.of(possiblyOperationBody);
            }
        }
        if (last.isASTInstance(rbraceElm.class) && (sibling = last.getPreviousSibling()) != null && sibling.isASTInstance(operationBody.class)) {
            return Optional.of(sibling);
        }
        return Optional.empty();
    }

    private List<Node> getBodyElements(Node operationBody2) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node child : operationBody2) {
            if (!child.isLeaf() && !child.isASTInstance(operation.class)) continue;
            ret.add(child);
        }
        return ret;
    }

    private Optional<Integer> getPreviosNode(Position position, List<Node> nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            if (CSTUtils.positionInRange(nodes.get(i).getRange(), position)) {
                return Optional.empty();
            }
            if (!CSTUtils.positionLT(position, nodes.get(i).getRange().getEnd())) continue;
            return Optional.of(i);
        }
        return Optional.of(nodes.size());
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
        Node last = CSTUtils.getLastCleanNode(context.document.getRootYQLNode(), CSTUtils.subtractOneChar(context.position));
        if (last == null) {
            return ret;
        }
        if (!last.isYQLNode()) {
            throw new IllegalArgumentException("Unexpected node type, expected a YQLNode");
        }
        if (last.getLanguageType() == Node.LanguageType.YQLPlus) {
            return ret;
        }
        Optional<Node> operationBody2 = this.finOperationBody(last);
        if (operationBody2.isEmpty()) {
            return ret;
        }
        List<Node> operationNodes = this.getBodyElements(operationBody2.get());
        Optional<Integer> indexOfCursor = this.getPreviosNode(context.position, operationNodes);
        if (indexOfCursor.isEmpty()) {
            return ret;
        }
        if (indexOfCursor.get() == 0) {
            ret.add(CompletionUtils.constructSnippet("group", "group($1)$0"));
        } else {
            Node previousNode = operationNodes.get(indexOfCursor.get() - 1);
            if (previousNode.isASTInstance(operation.class)) {
                return allEachCompletionItems;
            }
        }
        ret.addAll(completionItems);
        ret.addAll(allEachCompletionItems);
        return ret;
    }
}

