/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.indexinglanguage;

import ai.vespa.schemals.parser.indexinglanguage.IndexingParserLexer;
import ai.vespa.schemals.parser.indexinglanguage.InvalidToken;
import ai.vespa.schemals.parser.indexinglanguage.Node;
import ai.vespa.schemals.parser.indexinglanguage.TokenSource;
import ai.vespa.schemals.parser.indexinglanguage.ast.ADD;
import ai.vespa.schemals.parser.indexinglanguage.ast.ATTRIBUTE;
import ai.vespa.schemals.parser.indexinglanguage.ast.BASE64_DECODE;
import ai.vespa.schemals.parser.indexinglanguage.ast.BASE64_ENCODE;
import ai.vespa.schemals.parser.indexinglanguage.ast.BINARIZE;
import ai.vespa.schemals.parser.indexinglanguage.ast.BUSY_WAIT;
import ai.vespa.schemals.parser.indexinglanguage.ast.CASE;
import ai.vespa.schemals.parser.indexinglanguage.ast.CASE_DEFAULT;
import ai.vespa.schemals.parser.indexinglanguage.ast.CHOICE;
import ai.vespa.schemals.parser.indexinglanguage.ast.CHUNK;
import ai.vespa.schemals.parser.indexinglanguage.ast.CLEAR_STATE;
import ai.vespa.schemals.parser.indexinglanguage.ast.COLON;
import ai.vespa.schemals.parser.indexinglanguage.ast.COMMA;
import ai.vespa.schemals.parser.indexinglanguage.ast.COMMENT;
import ai.vespa.schemals.parser.indexinglanguage.ast.CREATE_IF_NON_EXISTENT;
import ai.vespa.schemals.parser.indexinglanguage.ast.DIV;
import ai.vespa.schemals.parser.indexinglanguage.ast.DOT;
import ai.vespa.schemals.parser.indexinglanguage.ast.DOUBLE;
import ai.vespa.schemals.parser.indexinglanguage.ast.ECHO;
import ai.vespa.schemals.parser.indexinglanguage.ast.ELSE;
import ai.vespa.schemals.parser.indexinglanguage.ast.EMBED;
import ai.vespa.schemals.parser.indexinglanguage.ast.EQ;
import ai.vespa.schemals.parser.indexinglanguage.ast.EXACT;
import ai.vespa.schemals.parser.indexinglanguage.ast.FALSE;
import ai.vespa.schemals.parser.indexinglanguage.ast.FLATTEN;
import ai.vespa.schemals.parser.indexinglanguage.ast.FLOAT;
import ai.vespa.schemals.parser.indexinglanguage.ast.FOR_EACH;
import ai.vespa.schemals.parser.indexinglanguage.ast.GE;
import ai.vespa.schemals.parser.indexinglanguage.ast.GENERATE;
import ai.vespa.schemals.parser.indexinglanguage.ast.GET_FIELD;
import ai.vespa.schemals.parser.indexinglanguage.ast.GET_VAR;
import ai.vespa.schemals.parser.indexinglanguage.ast.GT;
import ai.vespa.schemals.parser.indexinglanguage.ast.GUARD;
import ai.vespa.schemals.parser.indexinglanguage.ast.HASH;
import ai.vespa.schemals.parser.indexinglanguage.ast.HEX_DECODE;
import ai.vespa.schemals.parser.indexinglanguage.ast.HEX_ENCODE;
import ai.vespa.schemals.parser.indexinglanguage.ast.HOST_NAME;
import ai.vespa.schemals.parser.indexinglanguage.ast.IDENTIFIER;
import ai.vespa.schemals.parser.indexinglanguage.ast.IF;
import ai.vespa.schemals.parser.indexinglanguage.ast.INDEX;
import ai.vespa.schemals.parser.indexinglanguage.ast.INPUT;
import ai.vespa.schemals.parser.indexinglanguage.ast.INTEGER;
import ai.vespa.schemals.parser.indexinglanguage.ast.JOIN;
import ai.vespa.schemals.parser.indexinglanguage.ast.KEEP_CASE;
import ai.vespa.schemals.parser.indexinglanguage.ast.LCURLY;
import ai.vespa.schemals.parser.indexinglanguage.ast.LE;
import ai.vespa.schemals.parser.indexinglanguage.ast.LONG;
import ai.vespa.schemals.parser.indexinglanguage.ast.LOWER_CASE;
import ai.vespa.schemals.parser.indexinglanguage.ast.LPAREN;
import ai.vespa.schemals.parser.indexinglanguage.ast.LT;
import ai.vespa.schemals.parser.indexinglanguage.ast.MAX_LENGTH;
import ai.vespa.schemals.parser.indexinglanguage.ast.MAX_OCCURRENCES;
import ai.vespa.schemals.parser.indexinglanguage.ast.MAX_TOKEN_LENGTH;
import ai.vespa.schemals.parser.indexinglanguage.ast.MOD;
import ai.vespa.schemals.parser.indexinglanguage.ast.MUL;
import ai.vespa.schemals.parser.indexinglanguage.ast.NE;
import ai.vespa.schemals.parser.indexinglanguage.ast.NGRAM;
import ai.vespa.schemals.parser.indexinglanguage.ast.NL;
import ai.vespa.schemals.parser.indexinglanguage.ast.NORMALIZE;
import ai.vespa.schemals.parser.indexinglanguage.ast.NOW;
import ai.vespa.schemals.parser.indexinglanguage.ast.OPTIMIZE_PREDICATE;
import ai.vespa.schemals.parser.indexinglanguage.ast.PACK_BITS;
import ai.vespa.schemals.parser.indexinglanguage.ast.PASSTHROUGH;
import ai.vespa.schemals.parser.indexinglanguage.ast.PIPE;
import ai.vespa.schemals.parser.indexinglanguage.ast.RANDOM;
import ai.vespa.schemals.parser.indexinglanguage.ast.RCURLY;
import ai.vespa.schemals.parser.indexinglanguage.ast.REMOVE_IF_ZERO;
import ai.vespa.schemals.parser.indexinglanguage.ast.RPAREN;
import ai.vespa.schemals.parser.indexinglanguage.ast.SCOLON;
import ai.vespa.schemals.parser.indexinglanguage.ast.SELECT_INPUT;
import ai.vespa.schemals.parser.indexinglanguage.ast.SET_LANGUAGE;
import ai.vespa.schemals.parser.indexinglanguage.ast.SET_VAR;
import ai.vespa.schemals.parser.indexinglanguage.ast.SLEEP;
import ai.vespa.schemals.parser.indexinglanguage.ast.SPLIT;
import ai.vespa.schemals.parser.indexinglanguage.ast.STEM;
import ai.vespa.schemals.parser.indexinglanguage.ast.STRING;
import ai.vespa.schemals.parser.indexinglanguage.ast.SUB;
import ai.vespa.schemals.parser.indexinglanguage.ast.SUBSTRING;
import ai.vespa.schemals.parser.indexinglanguage.ast.SUMMARY;
import ai.vespa.schemals.parser.indexinglanguage.ast.SWITCH;
import ai.vespa.schemals.parser.indexinglanguage.ast.THIS;
import ai.vespa.schemals.parser.indexinglanguage.ast.TOKENIZE;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_ARRAY;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_BOOL;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_BYTE;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_DOUBLE;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_EPOCH_SECOND;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_FLOAT;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_INT;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_LONG;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_POS;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_STRING;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_URI;
import ai.vespa.schemals.parser.indexinglanguage.ast.TO_WSET;
import ai.vespa.schemals.parser.indexinglanguage.ast.TRIM;
import ai.vespa.schemals.parser.indexinglanguage.ast.TRUE;
import ai.vespa.schemals.parser.indexinglanguage.ast.UNDERSCORE;
import ai.vespa.schemals.parser.indexinglanguage.ast.ZCURVE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token
implements CharSequence,
Node.TerminalNode {
    private IndexingParserLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Node parent;
    private boolean virtual;
    private boolean skipped;
    private boolean dirty;

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    @Override
    public IndexingParserLexer getTokenSource() {
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (IndexingParserLexer)tokenSource;
    }

    public boolean isInvalid() {
        return this.getType().isInvalid();
    }

    @Override
    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.virtual || this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    void setVirtual(boolean virtual) {
        this.virtual = virtual;
        if (virtual) {
            this.dirty = true;
        }
    }

    void setSkipped(boolean skipped) {
        this.skipped = skipped;
        if (skipped) {
            this.dirty = true;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        IndexingParserLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? (Token)tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return (Token)this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    @Override
    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        IndexingParserLexer ts = this.getTokenSource();
        return ts == null ? null : ts.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, IndexingParserLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, IndexingParserLexer tokenSource, int beginOffset, int endOffset) {
        switch (type) {
            case TO_EPOCH_SECOND: {
                return new TO_EPOCH_SECOND(TokenType.TO_EPOCH_SECOND, tokenSource, beginOffset, endOffset);
            }
            case SLEEP: {
                return new SLEEP(TokenType.SLEEP, tokenSource, beginOffset, endOffset);
            }
            case UNDERSCORE: {
                return new UNDERSCORE(TokenType.UNDERSCORE, tokenSource, beginOffset, endOffset);
            }
            case KEEP_CASE: {
                return new KEEP_CASE(TokenType.KEEP_CASE, tokenSource, beginOffset, endOffset);
            }
            case CLEAR_STATE: {
                return new CLEAR_STATE(TokenType.CLEAR_STATE, tokenSource, beginOffset, endOffset);
            }
            case ECHO: {
                return new ECHO(TokenType.ECHO, tokenSource, beginOffset, endOffset);
            }
            case TRIM: {
                return new TRIM(TokenType.TRIM, tokenSource, beginOffset, endOffset);
            }
            case OPTIMIZE_PREDICATE: {
                return new OPTIMIZE_PREDICATE(TokenType.OPTIMIZE_PREDICATE, tokenSource, beginOffset, endOffset);
            }
            case JOIN: {
                return new JOIN(TokenType.JOIN, tokenSource, beginOffset, endOffset);
            }
            case LOWER_CASE: {
                return new LOWER_CASE(TokenType.LOWER_CASE, tokenSource, beginOffset, endOffset);
            }
            case PASSTHROUGH: {
                return new PASSTHROUGH(TokenType.PASSTHROUGH, tokenSource, beginOffset, endOffset);
            }
            case ELSE: {
                return new ELSE(TokenType.ELSE, tokenSource, beginOffset, endOffset);
            }
            case GET_VAR: {
                return new GET_VAR(TokenType.GET_VAR, tokenSource, beginOffset, endOffset);
            }
            case IF: {
                return new IF(TokenType.IF, tokenSource, beginOffset, endOffset);
            }
            case SUB: {
                return new SUB(TokenType.SUB, tokenSource, beginOffset, endOffset);
            }
            case LPAREN: {
                return new LPAREN(TokenType.LPAREN, tokenSource, beginOffset, endOffset);
            }
            case DOT: {
                return new DOT(TokenType.DOT, tokenSource, beginOffset, endOffset);
            }
            case EXACT: {
                return new EXACT(TokenType.EXACT, tokenSource, beginOffset, endOffset);
            }
            case CASE: {
                return new CASE(TokenType.CASE, tokenSource, beginOffset, endOffset);
            }
            case HASH: {
                return new HASH(TokenType.HASH, tokenSource, beginOffset, endOffset);
            }
            case FOR_EACH: {
                return new FOR_EACH(TokenType.FOR_EACH, tokenSource, beginOffset, endOffset);
            }
            case REMOVE_IF_ZERO: {
                return new REMOVE_IF_ZERO(TokenType.REMOVE_IF_ZERO, tokenSource, beginOffset, endOffset);
            }
            case EMBED: {
                return new EMBED(TokenType.EMBED, tokenSource, beginOffset, endOffset);
            }
            case PACK_BITS: {
                return new PACK_BITS(TokenType.PACK_BITS, tokenSource, beginOffset, endOffset);
            }
            case SPLIT: {
                return new SPLIT(TokenType.SPLIT, tokenSource, beginOffset, endOffset);
            }
            case COMMENT: {
                return new COMMENT(TokenType.COMMENT, tokenSource, beginOffset, endOffset);
            }
            case CASE_DEFAULT: {
                return new CASE_DEFAULT(TokenType.CASE_DEFAULT, tokenSource, beginOffset, endOffset);
            }
            case BINARIZE: {
                return new BINARIZE(TokenType.BINARIZE, tokenSource, beginOffset, endOffset);
            }
            case HEX_DECODE: {
                return new HEX_DECODE(TokenType.HEX_DECODE, tokenSource, beginOffset, endOffset);
            }
            case TO_URI: {
                return new TO_URI(TokenType.TO_URI, tokenSource, beginOffset, endOffset);
            }
            case DOUBLE: {
                return new DOUBLE(TokenType.DOUBLE, tokenSource, beginOffset, endOffset);
            }
            case RCURLY: {
                return new RCURLY(TokenType.RCURLY, tokenSource, beginOffset, endOffset);
            }
            case LONG: {
                return new LONG(TokenType.LONG, tokenSource, beginOffset, endOffset);
            }
            case COMMA: {
                return new COMMA(TokenType.COMMA, tokenSource, beginOffset, endOffset);
            }
            case TOKENIZE: {
                return new TOKENIZE(TokenType.TOKENIZE, tokenSource, beginOffset, endOffset);
            }
            case RANDOM: {
                return new RANDOM(TokenType.RANDOM, tokenSource, beginOffset, endOffset);
            }
            case LCURLY: {
                return new LCURLY(TokenType.LCURLY, tokenSource, beginOffset, endOffset);
            }
            case DIV: {
                return new DIV(TokenType.DIV, tokenSource, beginOffset, endOffset);
            }
            case TO_FLOAT: {
                return new TO_FLOAT(TokenType.TO_FLOAT, tokenSource, beginOffset, endOffset);
            }
            case TO_WSET: {
                return new TO_WSET(TokenType.TO_WSET, tokenSource, beginOffset, endOffset);
            }
            case TO_LONG: {
                return new TO_LONG(TokenType.TO_LONG, tokenSource, beginOffset, endOffset);
            }
            case LE: {
                return new LE(TokenType.LE, tokenSource, beginOffset, endOffset);
            }
            case STRING: {
                return new STRING(TokenType.STRING, tokenSource, beginOffset, endOffset);
            }
            case MAX_OCCURRENCES: {
                return new MAX_OCCURRENCES(TokenType.MAX_OCCURRENCES, tokenSource, beginOffset, endOffset);
            }
            case ADD: {
                return new ADD(TokenType.ADD, tokenSource, beginOffset, endOffset);
            }
            case INPUT: {
                return new INPUT(TokenType.INPUT, tokenSource, beginOffset, endOffset);
            }
            case SET_LANGUAGE: {
                return new SET_LANGUAGE(TokenType.SET_LANGUAGE, tokenSource, beginOffset, endOffset);
            }
            case SUBSTRING: {
                return new SUBSTRING(TokenType.SUBSTRING, tokenSource, beginOffset, endOffset);
            }
            case LT: {
                return new LT(TokenType.LT, tokenSource, beginOffset, endOffset);
            }
            case PIPE: {
                return new PIPE(TokenType.PIPE, tokenSource, beginOffset, endOffset);
            }
            case CREATE_IF_NON_EXISTENT: {
                return new CREATE_IF_NON_EXISTENT(TokenType.CREATE_IF_NON_EXISTENT, tokenSource, beginOffset, endOffset);
            }
            case SUMMARY: {
                return new SUMMARY(TokenType.SUMMARY, tokenSource, beginOffset, endOffset);
            }
            case GUARD: {
                return new GUARD(TokenType.GUARD, tokenSource, beginOffset, endOffset);
            }
            case TO_BOOL: {
                return new TO_BOOL(TokenType.TO_BOOL, tokenSource, beginOffset, endOffset);
            }
            case INDEX: {
                return new INDEX(TokenType.INDEX, tokenSource, beginOffset, endOffset);
            }
            case SELECT_INPUT: {
                return new SELECT_INPUT(TokenType.SELECT_INPUT, tokenSource, beginOffset, endOffset);
            }
            case TO_STRING: {
                return new TO_STRING(TokenType.TO_STRING, tokenSource, beginOffset, endOffset);
            }
            case BASE64_ENCODE: {
                return new BASE64_ENCODE(TokenType.BASE64_ENCODE, tokenSource, beginOffset, endOffset);
            }
            case CHUNK: {
                return new CHUNK(TokenType.CHUNK, tokenSource, beginOffset, endOffset);
            }
            case INTEGER: {
                return new INTEGER(TokenType.INTEGER, tokenSource, beginOffset, endOffset);
            }
            case ATTRIBUTE: {
                return new ATTRIBUTE(TokenType.ATTRIBUTE, tokenSource, beginOffset, endOffset);
            }
            case MUL: {
                return new MUL(TokenType.MUL, tokenSource, beginOffset, endOffset);
            }
            case SET_VAR: {
                return new SET_VAR(TokenType.SET_VAR, tokenSource, beginOffset, endOffset);
            }
            case TRUE: {
                return new TRUE(TokenType.TRUE, tokenSource, beginOffset, endOffset);
            }
            case RPAREN: {
                return new RPAREN(TokenType.RPAREN, tokenSource, beginOffset, endOffset);
            }
            case BUSY_WAIT: {
                return new BUSY_WAIT(TokenType.BUSY_WAIT, tokenSource, beginOffset, endOffset);
            }
            case EQ: {
                return new EQ(TokenType.EQ, tokenSource, beginOffset, endOffset);
            }
            case TO_POS: {
                return new TO_POS(TokenType.TO_POS, tokenSource, beginOffset, endOffset);
            }
            case MAX_LENGTH: {
                return new MAX_LENGTH(TokenType.MAX_LENGTH, tokenSource, beginOffset, endOffset);
            }
            case TO_ARRAY: {
                return new TO_ARRAY(TokenType.TO_ARRAY, tokenSource, beginOffset, endOffset);
            }
            case NE: {
                return new NE(TokenType.NE, tokenSource, beginOffset, endOffset);
            }
            case NOW: {
                return new NOW(TokenType.NOW, tokenSource, beginOffset, endOffset);
            }
            case BASE64_DECODE: {
                return new BASE64_DECODE(TokenType.BASE64_DECODE, tokenSource, beginOffset, endOffset);
            }
            case THIS: {
                return new THIS(TokenType.THIS, tokenSource, beginOffset, endOffset);
            }
            case SWITCH: {
                return new SWITCH(TokenType.SWITCH, tokenSource, beginOffset, endOffset);
            }
            case SCOLON: {
                return new SCOLON(TokenType.SCOLON, tokenSource, beginOffset, endOffset);
            }
            case FLATTEN: {
                return new FLATTEN(TokenType.FLATTEN, tokenSource, beginOffset, endOffset);
            }
            case NL: {
                return new NL(TokenType.NL, tokenSource, beginOffset, endOffset);
            }
            case HEX_ENCODE: {
                return new HEX_ENCODE(TokenType.HEX_ENCODE, tokenSource, beginOffset, endOffset);
            }
            case GET_FIELD: {
                return new GET_FIELD(TokenType.GET_FIELD, tokenSource, beginOffset, endOffset);
            }
            case FLOAT: {
                return new FLOAT(TokenType.FLOAT, tokenSource, beginOffset, endOffset);
            }
            case NGRAM: {
                return new NGRAM(TokenType.NGRAM, tokenSource, beginOffset, endOffset);
            }
            case CHOICE: {
                return new CHOICE(TokenType.CHOICE, tokenSource, beginOffset, endOffset);
            }
            case HOST_NAME: {
                return new HOST_NAME(TokenType.HOST_NAME, tokenSource, beginOffset, endOffset);
            }
            case MAX_TOKEN_LENGTH: {
                return new MAX_TOKEN_LENGTH(TokenType.MAX_TOKEN_LENGTH, tokenSource, beginOffset, endOffset);
            }
            case TO_INT: {
                return new TO_INT(TokenType.TO_INT, tokenSource, beginOffset, endOffset);
            }
            case ZCURVE: {
                return new ZCURVE(TokenType.ZCURVE, tokenSource, beginOffset, endOffset);
            }
            case IDENTIFIER: {
                return new IDENTIFIER(TokenType.IDENTIFIER, tokenSource, beginOffset, endOffset);
            }
            case GE: {
                return new GE(TokenType.GE, tokenSource, beginOffset, endOffset);
            }
            case NORMALIZE: {
                return new NORMALIZE(TokenType.NORMALIZE, tokenSource, beginOffset, endOffset);
            }
            case MOD: {
                return new MOD(TokenType.MOD, tokenSource, beginOffset, endOffset);
            }
            case COLON: {
                return new COLON(TokenType.COLON, tokenSource, beginOffset, endOffset);
            }
            case GT: {
                return new GT(TokenType.GT, tokenSource, beginOffset, endOffset);
            }
            case STEM: {
                return new STEM(TokenType.STEM, tokenSource, beginOffset, endOffset);
            }
            case TO_BYTE: {
                return new TO_BYTE(TokenType.TO_BYTE, tokenSource, beginOffset, endOffset);
            }
            case FALSE: {
                return new FALSE(TokenType.FALSE, tokenSource, beginOffset, endOffset);
            }
            case GENERATE: {
                return new GENERATE(TokenType.GENERATE, tokenSource, beginOffset, endOffset);
            }
            case TO_DOUBLE: {
                return new TO_DOUBLE(TokenType.TO_DOUBLE, tokenSource, beginOffset, endOffset);
            }
            case INVALID: {
                return new InvalidToken(tokenSource, beginOffset, endOffset);
            }
        }
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public int length() {
        return this.endOffset - this.beginOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getTokenSource().subSequence(this.beginOffset + start, this.beginOffset + end);
    }

    @Override
    public char charAt(int offset) {
        return this.getTokenSource().charAt(this.beginOffset + offset);
    }

    @Override
    @Deprecated
    public String getImage() {
        return this.getSource();
    }

    @Override
    public String toString() {
        return this.getSource();
    }

    public static enum TokenType implements Node.NodeType
    {
        EOF,
        _TOKEN_1,
        _TOKEN_2,
        _TOKEN_3,
        _TOKEN_4,
        NL,
        ADD,
        SUB,
        MUL,
        DIV,
        MOD,
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE,
        CHOICE,
        PIPE,
        LCURLY,
        RCURLY,
        LPAREN,
        RPAREN,
        DOT,
        COMMA,
        COLON,
        SCOLON,
        ATTRIBUTE,
        BASE64_DECODE,
        BASE64_ENCODE,
        BINARIZE,
        BUSY_WAIT,
        CASE,
        CASE_DEFAULT,
        CHUNK,
        CLEAR_STATE,
        CREATE_IF_NON_EXISTENT,
        ECHO,
        ELSE,
        EMBED,
        EXACT,
        FLATTEN,
        FOR_EACH,
        GENERATE,
        GET_FIELD,
        GET_VAR,
        GUARD,
        HASH,
        HEX_DECODE,
        HEX_ENCODE,
        HOST_NAME,
        IF,
        INDEX,
        INPUT,
        JOIN,
        KEEP_CASE,
        LOWER_CASE,
        MAX_LENGTH,
        MAX_OCCURRENCES,
        MAX_TOKEN_LENGTH,
        NGRAM,
        NORMALIZE,
        NOW,
        OPTIMIZE_PREDICATE,
        PACK_BITS,
        PASSTHROUGH,
        RANDOM,
        REMOVE_IF_ZERO,
        SELECT_INPUT,
        SET_LANGUAGE,
        SET_VAR,
        SLEEP,
        SPLIT,
        STEM,
        SUBSTRING,
        SUMMARY,
        SWITCH,
        THIS,
        TOKENIZE,
        TO_ARRAY,
        TO_BOOL,
        TO_BYTE,
        TO_DOUBLE,
        TO_EPOCH_SECOND,
        TO_FLOAT,
        TO_INT,
        TO_LONG,
        TO_POS,
        TO_STRING,
        TO_URI,
        TO_WSET,
        TRIM,
        ZCURVE,
        TRUE,
        FALSE,
        UNDERSCORE,
        COMMENT,
        INTEGER,
        LONG,
        DOUBLE,
        FLOAT,
        STRING,
        IDENTIFIER,
        DUMMY,
        INVALID;


        @Override
        public boolean isUndefined() {
            return this == DUMMY;
        }

        @Override
        public boolean isInvalid() {
            return this == INVALID;
        }

        @Override
        public boolean isEOF() {
            return this == EOF;
        }
    }
}

