/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.SchemaDocument;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class DocumentReferenceResolver {
    public static List<Diagnostic> resolveDocumentReferences(ParseContext context) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        SchemaDocument document = context.scheduler().getSchemaDocument(context.fileURI());
        if (document == null) {
            return diagnostics;
        }
        Optional<Symbol> myDocumentDefinition = context.schemaIndex().findSymbol(null, Symbol.SymbolType.DOCUMENT, document.getSchemaIdentifier());
        if (myDocumentDefinition.isEmpty()) {
            return diagnostics;
        }
        for (SchemaNode documentReferenceNode : context.unresolvedDocumentReferenceNodes()) {
            Optional<Symbol> referencedDocument;
            if (!documentReferenceNode.hasSymbol() || documentReferenceNode.getSymbol().getStatus() != Symbol.SymbolStatus.REFERENCE || (referencedDocument = context.schemaIndex().getSymbolDefinition(documentReferenceNode.getSymbol())).isEmpty() || context.schemaIndex().tryRegisterDocumentReference(myDocumentDefinition.get(), referencedDocument.get())) continue;
            String message = " because cyclic references are not allowed";
            if (myDocumentDefinition.get().equals(referencedDocument.get())) {
                message = " because self-references are not allowed";
            }
            diagnostics.add(new SchemaDiagnostic.Builder().setRange(documentReferenceNode.getRange()).setMessage("Cannot reference document " + documentReferenceNode.getText() + message).setSeverity(DiagnosticSeverity.Error).build());
        }
        context.clearUnresolvedDocumentReferenceNodes();
        return diagnostics;
    }
}

