/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.parser.yqlplus;

import ai.vespa.schemals.parser.yqlplus.InvalidToken;
import ai.vespa.schemals.parser.yqlplus.Token;
import ai.vespa.schemals.parser.yqlplus.TokenSource;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Objects;

public class YQLPlusLexer
extends TokenSource {
    private static MatcherHook MATCHER_HOOK;
    LexicalState lexicalState = LexicalState.values()[0];
    EnumSet<Token.TokenType> activeTokenTypes = null;
    static final EnumSet<Token.TokenType> regularTokens;
    static final EnumSet<Token.TokenType> unparsedTokens;
    static final EnumSet<Token.TokenType> skippedTokens;
    static final EnumSet<Token.TokenType> moreTokens;
    private static NfaFunction[] nfaFunctions;

    public static EnumSet<Token.TokenType> getRegularTokens() {
        return EnumSet.copyOf(regularTokens);
    }

    public YQLPlusLexer(CharSequence input) {
        this("input", input);
    }

    public YQLPlusLexer(String inputSource, CharSequence input) {
        this(inputSource, input, LexicalState.DEFAULT, 1, 1);
    }

    public YQLPlusLexer(String inputSource, CharSequence input, LexicalState lexState, int startingLine, int startingColumn) {
        super(inputSource, input, startingLine, startingColumn, 1, true, false, false, "");
        if (this.lexicalState != null) {
            this.switchTo(lexState);
        }
    }

    public Token getNextToken(Token tok) {
        return this.getNextToken(tok, this.activeTokenTypes);
    }

    public Token getNextToken(Token tok, EnumSet<Token.TokenType> activeTokenTypes) {
        if (tok == null) {
            tok = this.tokenizeAt(0, null, activeTokenTypes);
            this.cacheToken(tok);
            return tok;
        }
        Token cachedToken = tok.nextCachedToken();
        if (cachedToken != null && activeTokenTypes != null && !activeTokenTypes.contains(cachedToken.getType())) {
            this.reset(tok);
            cachedToken = null;
        }
        if (cachedToken == null) {
            Token token = this.tokenizeAt(tok.getEndOffset(), null, activeTokenTypes);
            this.cacheToken(token);
            return token;
        }
        return cachedToken;
    }

    static MatchInfo getMatchInfo(CharSequence input, int position, EnumSet<Token.TokenType> activeTokenTypes, NfaFunction[] nfaFunctions, BitSet currentStates, BitSet nextStates, MatchInfo matchInfo) {
        if (matchInfo == null) {
            matchInfo = new MatchInfo();
        }
        if (position >= input.length()) {
            matchInfo.matchedType = Token.TokenType.EOF;
            matchInfo.matchLength = 0;
            return matchInfo;
        }
        int start = position;
        int matchLength = 0;
        Token.TokenType matchedType = Token.TokenType.INVALID;
        EnumSet<Token.TokenType> alreadyMatchedTypes = EnumSet.noneOf(Token.TokenType.class);
        if (currentStates == null) {
            currentStates = new BitSet(304);
        } else {
            currentStates.clear();
        }
        if (nextStates == null) {
            nextStates = new BitSet(304);
        } else {
            nextStates.clear();
        }
        do {
            int curChar;
            if (position > start) {
                BitSet temp = currentStates;
                currentStates = nextStates;
                nextStates = temp;
                nextStates.clear();
            } else {
                currentStates.set(0);
            }
            if (position >= input.length()) break;
            if ((curChar = Character.codePointAt(input, position++)) > 65535) {
                ++position;
            }
            int nextActive = currentStates.nextSetBit(0);
            while (nextActive != -1) {
                Token.TokenType returnedType = nfaFunctions[nextActive].apply(curChar, nextStates, activeTokenTypes, alreadyMatchedTypes);
                if (returnedType != null && (position - start > matchLength || returnedType.ordinal() < matchedType.ordinal())) {
                    matchedType = returnedType;
                    matchLength = position - start;
                    alreadyMatchedTypes.add(returnedType);
                }
                nextActive = currentStates.nextSetBit(nextActive + 1);
            }
        } while (position < input.length() && !nextStates.isEmpty());
        matchInfo.matchedType = matchedType;
        matchInfo.matchLength = matchLength;
        return matchInfo;
    }

    final Token tokenizeAt(int position, LexicalState lexicalState, EnumSet<Token.TokenType> activeTokenTypes) {
        if (lexicalState == null) {
            lexicalState = this.lexicalState;
        }
        int tokenBeginOffset = position;
        boolean inMore = false;
        int invalidRegionStart = -1;
        Token matchedToken = null;
        Token.TokenType matchedType = null;
        MatchInfo matchInfo = new MatchInfo();
        BitSet currentStates = new BitSet(304);
        BitSet nextStates = new BitSet(304);
        while (matchedToken == null) {
            if (!inMore) {
                tokenBeginOffset = position;
            }
            if (MATCHER_HOOK != null) {
                if ((matchInfo = MATCHER_HOOK.apply(lexicalState, this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo)) == null) {
                    matchInfo = YQLPlusLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
                }
            } else {
                matchInfo = YQLPlusLexer.getMatchInfo(this, position, activeTokenTypes, nfaFunctions, currentStates, nextStates, matchInfo);
            }
            matchedType = matchInfo.matchedType;
            inMore = moreTokens.contains(matchedType);
            position += matchInfo.matchLength;
            if (matchedType == Token.TokenType.INVALID) {
                if (invalidRegionStart == -1) {
                    invalidRegionStart = tokenBeginOffset;
                }
                int cp = Character.codePointAt(this, position);
                ++position;
                if (cp <= 65535) continue;
                ++position;
                continue;
            }
            if (invalidRegionStart != -1) {
                return new InvalidToken(this, invalidRegionStart, tokenBeginOffset);
            }
            if (skippedTokens.contains(matchedType)) {
                this.skipTokens(tokenBeginOffset, position);
                continue;
            }
            if (!regularTokens.contains(matchedType) && !unparsedTokens.contains(matchedType)) continue;
            matchedToken = Token.newToken(matchedType, this, tokenBeginOffset, position);
            matchedToken.setUnparsed(!regularTokens.contains(matchedType));
        }
        return matchedToken;
    }

    public boolean switchTo(LexicalState lexState) {
        if (this.lexicalState != lexState) {
            this.lexicalState = lexState;
            return true;
        }
        return false;
    }

    void reset(Token t, LexicalState state) {
        this.uncacheTokens(t);
        if (state != null) {
            this.switchTo(state);
        }
    }

    void reset(Token t) {
        this.reset(t, null);
    }

    static {
        regularTokens = EnumSet.of(Token.TokenType.EOF, new Token.TokenType[]{Token.TokenType.SELECT, Token.TokenType.LIMIT, Token.TokenType.OFFSET, Token.TokenType.WHERE, Token.TokenType.BY, Token.TokenType.ORDER, Token.TokenType.DESC, Token.TokenType.ASC, Token.TokenType.FROM, Token.TokenType.SOURCES, Token.TokenType.AS, Token.TokenType.COMMA, Token.TokenType.OUTPUT, Token.TokenType.COUNT, Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.LPAREN, Token.TokenType.RPAREN, Token.TokenType.LBRACKET, Token.TokenType.RBRACKET, Token.TokenType.LBRACE, Token.TokenType.RBRACE, Token.TokenType.COLON, Token.TokenType.PIPE, Token.TokenType.AND, Token.TokenType.OR, Token.TokenType.NOT_IN, Token.TokenType.IN, Token.TokenType.LT, Token.TokenType.GT, Token.TokenType.LTEQ, Token.TokenType.GTEQ, Token.TokenType.NEQ, Token.TokenType.STAR, Token.TokenType.EQ, Token.TokenType.LIKE, Token.TokenType.CONTAINS, Token.TokenType.MATCHES, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.DIV, Token.TokenType.MODULO, Token.TokenType.EXCLAMATION, Token.TokenType.NULL, Token.TokenType.DOT, Token.TokenType.AT, Token.TokenType.SQ, Token.TokenType.DQ, Token.TokenType.SEMI, Token.TokenType.TIMEOUT, Token.TokenType.ALL, Token.TokenType.EACH, Token.TokenType.ORDERBY, Token.TokenType.NOTLIKE, Token.TokenType.NOTMATCHES, Token.TokenType.IS_NULL, Token.TokenType.IS_NOT_NULL, Token.TokenType.IDENTIFIER, Token.TokenType.LONG_INT, Token.TokenType.INT, Token.TokenType.FLOAT, Token.TokenType.EXPONENT, Token.TokenType.LETTER, Token.TokenType.HEX_DIGIT, Token.TokenType.UNICODE_ESC, Token.TokenType.ESC_SEQ, Token.TokenType.STRING});
        unparsedTokens = EnumSet.of(Token.TokenType.COMMENT);
        skippedTokens = EnumSet.of(Token.TokenType._TOKEN_1, Token.TokenType._TOKEN_2, Token.TokenType._TOKEN_3, Token.TokenType._TOKEN_4);
        moreTokens = EnumSet.noneOf(Token.TokenType.class);
        DEFAULT.NFA_FUNCTIONS_init();
    }

    public static enum LexicalState {
        DEFAULT;

    }

    static class MatchInfo {
        Token.TokenType matchedType;
        int matchLength;

        MatchInfo() {
        }

        public int hashCode() {
            return Objects.hash(this.matchLength, this.matchedType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MatchInfo other = (MatchInfo)obj;
            return this.matchLength == other.matchLength && this.matchedType == other.matchedType;
        }
    }

    @FunctionalInterface
    static interface NfaFunction {
        public Token.TokenType apply(int var1, BitSet var2, EnumSet<Token.TokenType> var3, EnumSet<Token.TokenType> var4);
    }

    @FunctionalInterface
    private static interface MatcherHook {
        public MatchInfo apply(LexicalState var1, CharSequence var2, int var3, EnumSet<Token.TokenType> var4, NfaFunction[] var5, BitSet var6, BitSet var7, MatchInfo var8);
    }

    private static class DEFAULT {
        private DEFAULT() {
        }

        private static Token.TokenType getNfaIndex0(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NEQ)) {
                    nextStates.set(27);
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(39);
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STRING)) {
                    nextStates.set(8);
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.INT)) {
                    nextStates.set(13);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG_INT)) {
                    nextStates.set(106);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT)) {
                    nextStates.set(153);
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT)) {
                    nextStates.set(21);
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMENT)) {
                    nextStates.set(107);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMENT)) {
                    nextStates.set(36);
                }
            } else if (ch >= 48 && ch <= 57) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT)) {
                    nextStates.set(9);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LONG_INT)) {
                    nextStates.set(19);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FLOAT)) {
                    nextStates.set(96);
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LTEQ)) {
                    nextStates.set(55);
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GTEQ)) {
                    nextStates.set(50);
                }
            } else if (ch == 69) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXPONENT)) {
                    nextStates.set(41);
                }
            } else if (ch == 92) {
                if (validTypes == null || validTypes.contains(Token.TokenType.UNICODE_ESC)) {
                    nextStates.set(92);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ESC_SEQ)) {
                    nextStates.set(30);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ESC_SEQ)) {
                    nextStates.set(162);
                }
            } else if (ch == 97) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AS)) {
                    nextStates.set(15);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ASC)) {
                    nextStates.set(109);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.AND)) {
                    nextStates.set(161);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ALL)) {
                    nextStates.set(175);
                }
            } else if (ch == 98) {
                if (validTypes == null || validTypes.contains(Token.TokenType.BY)) {
                    nextStates.set(45);
                }
            } else if (ch == 99) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COUNT)) {
                    nextStates.set(119);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.CONTAINS)) {
                    nextStates.set(137);
                }
            } else if (ch == 100) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DESC)) {
                    nextStates.set(65);
                }
            } else if (ch == 101) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EACH)) {
                    nextStates.set(59);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.EXPONENT)) {
                    nextStates.set(41);
                }
            } else if (ch == 102) {
                if (validTypes == null || validTypes.contains(Token.TokenType.FROM)) {
                    nextStates.set(85);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.FALSE)) {
                    nextStates.set(110);
                }
            } else if (ch == 105) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IS_NULL)) {
                    nextStates.set(101);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IN)) {
                    nextStates.set(40);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.IS_NOT_NULL)) {
                    nextStates.set(166);
                }
            } else if (ch == 108) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LIKE)) {
                    nextStates.set(87);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.LIMIT)) {
                    nextStates.set(89);
                }
            } else if (ch == 109) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MATCHES)) {
                    nextStates.set(74);
                }
            } else if (ch == 110) {
                if (validTypes == null || validTypes.contains(Token.TokenType.NULL)) {
                    nextStates.set(67);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOTLIKE)) {
                    nextStates.set(113);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOTMATCHES)) {
                    nextStates.set(128);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.NOT_IN)) {
                    nextStates.set(176);
                }
            } else if (ch == 111) {
                if (validTypes == null || validTypes.contains(Token.TokenType.OUTPUT)) {
                    nextStates.set(61);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.OR)) {
                    nextStates.set(16);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ORDER)) {
                    nextStates.set(143);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.OFFSET)) {
                    nextStates.set(154);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.ORDERBY)) {
                    nextStates.set(180);
                }
            } else if (ch == 115) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SOURCES)) {
                    nextStates.set(69);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.SELECT)) {
                    nextStates.set(97);
                }
            } else if (ch == 116) {
                if (validTypes == null || validTypes.contains(Token.TokenType.TIMEOUT)) {
                    nextStates.set(146);
                }
                if (validTypes == null || validTypes.contains(Token.TokenType.TRUE)) {
                    nextStates.set(151);
                }
            } else if (ch == 119 && (validTypes == null || validTypes.contains(Token.TokenType.WHERE))) {
                nextStates.set(158);
            }
            if ((ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) && (validTypes == null || validTypes.contains(Token.TokenType.HEX_DIGIT))) {
                type = Token.TokenType.HEX_DIGIT;
            }
            if (ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LETTER)) {
                    type = Token.TokenType.LETTER;
                }
            } else if (ch >= 48 && ch <= 57 && (validTypes == null || validTypes.contains(Token.TokenType.INT))) {
                nextStates.set(13);
                type = Token.TokenType.INT;
            }
            if (ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                if (validTypes == null || validTypes.contains(Token.TokenType.IDENTIFIER)) {
                    nextStates.set(5);
                    type = Token.TokenType.IDENTIFIER;
                }
            } else if (ch == 59) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SEMI)) {
                    type = Token.TokenType.SEMI;
                }
            } else if (ch == 34) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DQ)) {
                    type = Token.TokenType.DQ;
                }
            } else if (ch == 39) {
                if (validTypes == null || validTypes.contains(Token.TokenType.SQ)) {
                    type = Token.TokenType.SQ;
                }
            } else if (ch == 64) {
                if (validTypes == null || validTypes.contains(Token.TokenType.AT)) {
                    type = Token.TokenType.AT;
                }
            } else if (ch == 46) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DOT)) {
                    type = Token.TokenType.DOT;
                }
            } else if (ch == 33) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EXCLAMATION)) {
                    type = Token.TokenType.EXCLAMATION;
                }
            } else if (ch == 37) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MODULO)) {
                    type = Token.TokenType.MODULO;
                }
            } else if (ch == 47) {
                if (validTypes == null || validTypes.contains(Token.TokenType.DIV)) {
                    type = Token.TokenType.DIV;
                }
            } else if (ch == 45) {
                if (validTypes == null || validTypes.contains(Token.TokenType.MINUS)) {
                    type = Token.TokenType.MINUS;
                }
            } else if (ch == 43) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PLUS)) {
                    type = Token.TokenType.PLUS;
                }
            } else if (ch == 61) {
                if (validTypes == null || validTypes.contains(Token.TokenType.EQ)) {
                    type = Token.TokenType.EQ;
                }
            } else if (ch == 42) {
                if (validTypes == null || validTypes.contains(Token.TokenType.STAR)) {
                    type = Token.TokenType.STAR;
                }
            } else if (ch == 62) {
                if (validTypes == null || validTypes.contains(Token.TokenType.GT)) {
                    type = Token.TokenType.GT;
                }
            } else if (ch == 60) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LT)) {
                    type = Token.TokenType.LT;
                }
            } else if (ch == 124) {
                if (validTypes == null || validTypes.contains(Token.TokenType.PIPE)) {
                    type = Token.TokenType.PIPE;
                }
            } else if (ch == 58) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COLON)) {
                    type = Token.TokenType.COLON;
                }
            } else if (ch == 125) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACE)) {
                    type = Token.TokenType.RBRACE;
                }
            } else if (ch == 123) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACE)) {
                    type = Token.TokenType.LBRACE;
                }
            } else if (ch == 93) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RBRACKET)) {
                    type = Token.TokenType.RBRACKET;
                }
            } else if (ch == 91) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LBRACKET)) {
                    type = Token.TokenType.LBRACKET;
                }
            } else if (ch == 41) {
                if (validTypes == null || validTypes.contains(Token.TokenType.RPAREN)) {
                    type = Token.TokenType.RPAREN;
                }
            } else if (ch == 40) {
                if (validTypes == null || validTypes.contains(Token.TokenType.LPAREN)) {
                    type = Token.TokenType.LPAREN;
                }
            } else if (ch == 44) {
                if (validTypes == null || validTypes.contains(Token.TokenType.COMMA)) {
                    type = Token.TokenType.COMMA;
                }
            } else if (ch == 10) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_4)) {
                    type = Token.TokenType._TOKEN_4;
                }
            } else if (ch == 13) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_3)) {
                    type = Token.TokenType._TOKEN_3;
                }
            } else if (ch == 9) {
                if (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_2)) {
                    type = Token.TokenType._TOKEN_2;
                }
            } else if (ch == 32 && (validTypes == null || validTypes.contains(Token.TokenType._TOKEN_1))) {
                type = Token.TokenType._TOKEN_1;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex1(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                return Token.TokenType.EACH;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex2(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.OUTPUT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex3(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.DESC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex4(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.NULL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex5(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 45 || ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch == 95 || ch >= 97 && ch <= 122) {
                nextStates.set(5);
                return Token.TokenType.IDENTIFIER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex6(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.SOURCES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex7(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.MATCHES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex8(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 38 || ch >= 40 && ch <= 91 || ch >= 93) {
                nextStates.set(8);
            } else if (ch == 92) {
                nextStates.set(79);
                nextStates.set(80);
            } else if (ch == 39) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex9(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(9);
            } else if (ch == 46) {
                nextStates.set(10);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex10(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(11);
            } else if (ch == 101) {
                nextStates.set(11);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(10);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex11(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(12);
            } else if (ch == 45) {
                nextStates.set(12);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(12);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex12(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(12);
                return Token.TokenType.FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex13(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(13);
                return Token.TokenType.INT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex14(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                return Token.TokenType.FROM;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex15(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.AS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex16(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.OR;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex17(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.LIKE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex18(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.LIMIT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex19(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 48 && ch <= 57) {
                nextStates.set(19);
            } else if (ch == 76) {
                type = Token.TokenType.LONG_INT;
            } else if (ch == 108) {
                type = Token.TokenType.LONG_INT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex20(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                return Token.TokenType.UNICODE_ESC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex21(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(22);
                return Token.TokenType.FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex22(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 69) {
                nextStates.set(23);
            } else if (ch == 101) {
                nextStates.set(23);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(22);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex23(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(24);
            } else if (ch == 45) {
                nextStates.set(24);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(24);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex24(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(24);
                return Token.TokenType.FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex25(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(26);
            } else if (ch == 45) {
                nextStates.set(26);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                type = Token.TokenType.FLOAT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex26(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(26);
                return Token.TokenType.FLOAT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex27(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.NEQ;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex28(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.SELECT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex29(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.IS_NULL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex30(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 34) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 39) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 47) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 92) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 98) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 102) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 110) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 114) {
                type = Token.TokenType.ESC_SEQ;
            } else if (ch == 116) {
                type = Token.TokenType.ESC_SEQ;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex31(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                return Token.TokenType.COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex32(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                return Token.TokenType.ASC;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex33(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.FALSE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex34(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.NOTLIKE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex35(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.COUNT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex36(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 47) {
                nextStates.set(37);
                return Token.TokenType.COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex37(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 9 || ch == 11 || ch == 12 || ch >= 14) {
                nextStates.set(37);
                type = Token.TokenType.COMMENT;
            } else if (ch == 10) {
                type = Token.TokenType.COMMENT;
            } else if (ch == 13) {
                nextStates.set(38);
                type = Token.TokenType.COMMENT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex38(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 10) {
                return Token.TokenType.COMMENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex39(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch >= 0 && ch <= 33 || ch >= 35 && ch <= 91 || ch >= 93) {
                nextStates.set(39);
            } else if (ch == 92) {
                nextStates.set(122);
                nextStates.set(123);
            } else if (ch == 34) {
                type = Token.TokenType.STRING;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex40(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.IN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex41(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            Token.TokenType type = null;
            if (ch == 43) {
                nextStates.set(42);
            } else if (ch == 45) {
                nextStates.set(42);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                type = Token.TokenType.EXPONENT;
            }
            return type;
        }

        private static Token.TokenType getNfaIndex42(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(42);
                return Token.TokenType.EXPONENT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex43(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.NOTMATCHES;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex44(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                return Token.TokenType.CONTAINS;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex45(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.BY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex46(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                return Token.TokenType.ORDER;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex47(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.TIMEOUT;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex48(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.TRUE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex49(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                return Token.TokenType.OFFSET;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex50(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.GTEQ;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex51(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                return Token.TokenType.WHERE;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex52(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                return Token.TokenType.AND;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex53(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                return Token.TokenType.ESC_SEQ;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex54(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.IS_NOT_NULL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex55(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 61) {
                return Token.TokenType.LTEQ;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex56(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                return Token.TokenType.ALL;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex57(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                return Token.TokenType.NOT_IN;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex58(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 121) {
                return Token.TokenType.ORDERBY;
            }
            return null;
        }

        private static Token.TokenType getNfaIndex59(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(60);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex60(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(1);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex61(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(62);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex62(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(63);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex63(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 112) {
                nextStates.set(64);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex64(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(2);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex65(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(66);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex66(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(3);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex67(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(68);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex68(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(4);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex69(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(70);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex70(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(71);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex71(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(72);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex72(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(73);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex73(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(6);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex74(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(75);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex75(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(76);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex76(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(77);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex77(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(78);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex78(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(7);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex79(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(8);
            } else if (ch == 39) {
                nextStates.set(8);
            } else if (ch == 47) {
                nextStates.set(8);
            } else if (ch == 92) {
                nextStates.set(8);
            } else if (ch == 98) {
                nextStates.set(8);
            } else if (ch == 102) {
                nextStates.set(8);
            } else if (ch == 110) {
                nextStates.set(8);
            } else if (ch == 114) {
                nextStates.set(8);
            } else if (ch == 116) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex80(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(81);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex81(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(82);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex82(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(83);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex83(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(84);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex84(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(8);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex85(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(86);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex86(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(14);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex87(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(88);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex88(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(17);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex89(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(90);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex90(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(91);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex91(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(18);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex92(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(93);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex93(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(94);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex94(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(95);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex95(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(20);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex96(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(96);
            } else if (ch == 69) {
                nextStates.set(25);
            } else if (ch == 101) {
                nextStates.set(25);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex97(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(98);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex98(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(99);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex99(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(100);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex100(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(28);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex101(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(102);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex102(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(103);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex103(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(104);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex104(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(105);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex105(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(29);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex106(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57) {
                nextStates.set(19);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex107(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 42) {
                nextStates.set(108);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex108(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 0) {
                nextStates.set(108);
            }
            if (ch == 42) {
                nextStates.set(31);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex109(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(32);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex110(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(111);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex111(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(112);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex112(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(33);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex113(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(114);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex114(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(115);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex115(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(116);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex116(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(117);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex117(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(118);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex118(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 107) {
                nextStates.set(34);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex119(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(120);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex120(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(121);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex121(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(35);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex122(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 34) {
                nextStates.set(39);
            } else if (ch == 39) {
                nextStates.set(39);
            } else if (ch == 47) {
                nextStates.set(39);
            } else if (ch == 92) {
                nextStates.set(39);
            } else if (ch == 98) {
                nextStates.set(39);
            } else if (ch == 102) {
                nextStates.set(39);
            } else if (ch == 110) {
                nextStates.set(39);
            } else if (ch == 114) {
                nextStates.set(39);
            } else if (ch == 116) {
                nextStates.set(39);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex123(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(124);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex124(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(125);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex125(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(126);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex126(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(127);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex127(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(39);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex128(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(129);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex129(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(130);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex130(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(131);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex131(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(132);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex132(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(133);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex133(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(134);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex134(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 99) {
                nextStates.set(135);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex135(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(136);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex136(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(43);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex137(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(138);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex138(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(139);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex139(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(140);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex140(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 97) {
                nextStates.set(141);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex141(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(142);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex142(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(44);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex143(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(144);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex144(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(145);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex145(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(46);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex146(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(147);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex147(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 109) {
                nextStates.set(148);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex148(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(149);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex149(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(150);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex150(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(47);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex151(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(152);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex152(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(48);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex153(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 46) {
                nextStates.set(21);
            } else if (ch >= 48 && ch <= 57) {
                nextStates.set(96);
                nextStates.set(9);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex154(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(155);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex155(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 102) {
                nextStates.set(156);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex156(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(157);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex157(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(49);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex158(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 104) {
                nextStates.set(159);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex159(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(160);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex160(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(51);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex161(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(52);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex162(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(163);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex163(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(164);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex164(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(165);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex165(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102) {
                nextStates.set(53);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex166(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 115) {
                nextStates.set(167);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex167(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(168);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex168(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(169);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex169(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(170);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex170(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(171);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex171(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(172);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex172(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 110) {
                nextStates.set(173);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex173(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 117) {
                nextStates.set(174);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex174(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(54);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex175(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 108) {
                nextStates.set(56);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex176(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 111) {
                nextStates.set(177);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex177(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 116) {
                nextStates.set(178);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex178(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(179);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex179(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 105) {
                nextStates.set(57);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex180(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(181);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex181(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 100) {
                nextStates.set(182);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex182(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 101) {
                nextStates.set(183);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex183(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 114) {
                nextStates.set(184);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex184(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 32) {
                nextStates.set(185);
            }
            return null;
        }

        private static Token.TokenType getNfaIndex185(int ch, BitSet nextStates, EnumSet<Token.TokenType> validTypes, EnumSet<Token.TokenType> alreadyMatchedTypes) {
            if (ch == 98) {
                nextStates.set(58);
            }
            return null;
        }

        private static void NFA_FUNCTIONS_init() {
            nfaFunctions = new NfaFunction[]{DEFAULT::getNfaIndex0, DEFAULT::getNfaIndex1, DEFAULT::getNfaIndex2, DEFAULT::getNfaIndex3, DEFAULT::getNfaIndex4, DEFAULT::getNfaIndex5, DEFAULT::getNfaIndex6, DEFAULT::getNfaIndex7, DEFAULT::getNfaIndex8, DEFAULT::getNfaIndex9, DEFAULT::getNfaIndex10, DEFAULT::getNfaIndex11, DEFAULT::getNfaIndex12, DEFAULT::getNfaIndex13, DEFAULT::getNfaIndex14, DEFAULT::getNfaIndex15, DEFAULT::getNfaIndex16, DEFAULT::getNfaIndex17, DEFAULT::getNfaIndex18, DEFAULT::getNfaIndex19, DEFAULT::getNfaIndex20, DEFAULT::getNfaIndex21, DEFAULT::getNfaIndex22, DEFAULT::getNfaIndex23, DEFAULT::getNfaIndex24, DEFAULT::getNfaIndex25, DEFAULT::getNfaIndex26, DEFAULT::getNfaIndex27, DEFAULT::getNfaIndex28, DEFAULT::getNfaIndex29, DEFAULT::getNfaIndex30, DEFAULT::getNfaIndex31, DEFAULT::getNfaIndex32, DEFAULT::getNfaIndex33, DEFAULT::getNfaIndex34, DEFAULT::getNfaIndex35, DEFAULT::getNfaIndex36, DEFAULT::getNfaIndex37, DEFAULT::getNfaIndex38, DEFAULT::getNfaIndex39, DEFAULT::getNfaIndex40, DEFAULT::getNfaIndex41, DEFAULT::getNfaIndex42, DEFAULT::getNfaIndex43, DEFAULT::getNfaIndex44, DEFAULT::getNfaIndex45, DEFAULT::getNfaIndex46, DEFAULT::getNfaIndex47, DEFAULT::getNfaIndex48, DEFAULT::getNfaIndex49, DEFAULT::getNfaIndex50, DEFAULT::getNfaIndex51, DEFAULT::getNfaIndex52, DEFAULT::getNfaIndex53, DEFAULT::getNfaIndex54, DEFAULT::getNfaIndex55, DEFAULT::getNfaIndex56, DEFAULT::getNfaIndex57, DEFAULT::getNfaIndex58, DEFAULT::getNfaIndex59, DEFAULT::getNfaIndex60, DEFAULT::getNfaIndex61, DEFAULT::getNfaIndex62, DEFAULT::getNfaIndex63, DEFAULT::getNfaIndex64, DEFAULT::getNfaIndex65, DEFAULT::getNfaIndex66, DEFAULT::getNfaIndex67, DEFAULT::getNfaIndex68, DEFAULT::getNfaIndex69, DEFAULT::getNfaIndex70, DEFAULT::getNfaIndex71, DEFAULT::getNfaIndex72, DEFAULT::getNfaIndex73, DEFAULT::getNfaIndex74, DEFAULT::getNfaIndex75, DEFAULT::getNfaIndex76, DEFAULT::getNfaIndex77, DEFAULT::getNfaIndex78, DEFAULT::getNfaIndex79, DEFAULT::getNfaIndex80, DEFAULT::getNfaIndex81, DEFAULT::getNfaIndex82, DEFAULT::getNfaIndex83, DEFAULT::getNfaIndex84, DEFAULT::getNfaIndex85, DEFAULT::getNfaIndex86, DEFAULT::getNfaIndex87, DEFAULT::getNfaIndex88, DEFAULT::getNfaIndex89, DEFAULT::getNfaIndex90, DEFAULT::getNfaIndex91, DEFAULT::getNfaIndex92, DEFAULT::getNfaIndex93, DEFAULT::getNfaIndex94, DEFAULT::getNfaIndex95, DEFAULT::getNfaIndex96, DEFAULT::getNfaIndex97, DEFAULT::getNfaIndex98, DEFAULT::getNfaIndex99, DEFAULT::getNfaIndex100, DEFAULT::getNfaIndex101, DEFAULT::getNfaIndex102, DEFAULT::getNfaIndex103, DEFAULT::getNfaIndex104, DEFAULT::getNfaIndex105, DEFAULT::getNfaIndex106, DEFAULT::getNfaIndex107, DEFAULT::getNfaIndex108, DEFAULT::getNfaIndex109, DEFAULT::getNfaIndex110, DEFAULT::getNfaIndex111, DEFAULT::getNfaIndex112, DEFAULT::getNfaIndex113, DEFAULT::getNfaIndex114, DEFAULT::getNfaIndex115, DEFAULT::getNfaIndex116, DEFAULT::getNfaIndex117, DEFAULT::getNfaIndex118, DEFAULT::getNfaIndex119, DEFAULT::getNfaIndex120, DEFAULT::getNfaIndex121, DEFAULT::getNfaIndex122, DEFAULT::getNfaIndex123, DEFAULT::getNfaIndex124, DEFAULT::getNfaIndex125, DEFAULT::getNfaIndex126, DEFAULT::getNfaIndex127, DEFAULT::getNfaIndex128, DEFAULT::getNfaIndex129, DEFAULT::getNfaIndex130, DEFAULT::getNfaIndex131, DEFAULT::getNfaIndex132, DEFAULT::getNfaIndex133, DEFAULT::getNfaIndex134, DEFAULT::getNfaIndex135, DEFAULT::getNfaIndex136, DEFAULT::getNfaIndex137, DEFAULT::getNfaIndex138, DEFAULT::getNfaIndex139, DEFAULT::getNfaIndex140, DEFAULT::getNfaIndex141, DEFAULT::getNfaIndex142, DEFAULT::getNfaIndex143, DEFAULT::getNfaIndex144, DEFAULT::getNfaIndex145, DEFAULT::getNfaIndex146, DEFAULT::getNfaIndex147, DEFAULT::getNfaIndex148, DEFAULT::getNfaIndex149, DEFAULT::getNfaIndex150, DEFAULT::getNfaIndex151, DEFAULT::getNfaIndex152, DEFAULT::getNfaIndex153, DEFAULT::getNfaIndex154, DEFAULT::getNfaIndex155, DEFAULT::getNfaIndex156, DEFAULT::getNfaIndex157, DEFAULT::getNfaIndex158, DEFAULT::getNfaIndex159, DEFAULT::getNfaIndex160, DEFAULT::getNfaIndex161, DEFAULT::getNfaIndex162, DEFAULT::getNfaIndex163, DEFAULT::getNfaIndex164, DEFAULT::getNfaIndex165, DEFAULT::getNfaIndex166, DEFAULT::getNfaIndex167, DEFAULT::getNfaIndex168, DEFAULT::getNfaIndex169, DEFAULT::getNfaIndex170, DEFAULT::getNfaIndex171, DEFAULT::getNfaIndex172, DEFAULT::getNfaIndex173, DEFAULT::getNfaIndex174, DEFAULT::getNfaIndex175, DEFAULT::getNfaIndex176, DEFAULT::getNfaIndex177, DEFAULT::getNfaIndex178, DEFAULT::getNfaIndex179, DEFAULT::getNfaIndex180, DEFAULT::getNfaIndex181, DEFAULT::getNfaIndex182, DEFAULT::getNfaIndex183, DEFAULT::getNfaIndex184, DEFAULT::getNfaIndex185};
        }
    }
}

