/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.completion.provider;

import ai.vespa.schemals.context.EventCompletionContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.schema.completion.provider.CompletionProvider;
import ai.vespa.schemals.lsp.schema.completion.utils.CompletionUtils;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.ast.COMMA;
import ai.vespa.schemals.parser.ast.IDENTIFIER;
import ai.vespa.schemals.parser.ast.identifierStr;
import ai.vespa.schemals.parser.ast.identifierWithDashStr;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class InheritanceCompletion
implements CompletionProvider {
    private Optional<SchemaNode> match(EventCompletionContext context) {
        Node last;
        Position searchPos = context.startOfWord();
        if (searchPos == null) {
            searchPos = context.position;
        }
        if ((last = CSTUtils.getLastCleanNode(context.document.getRootNode(), searchPos)) == null || !last.isSchemaNode()) {
            return Optional.empty();
        }
        if (last.isASTInstance(IDENTIFIER.class)) {
            last = last.getParent();
        }
        if (last.isASTInstance(COMMA.class)) {
            last = last.getPrevious();
        }
        while (last != null && (last.isASTInstance(identifierStr.class) || last.isASTInstance(identifierWithDashStr.class)) && last.getPrevious() != null && last.getPrevious().getSchemaNode().getSchemaType() == Token.TokenType.COMMA) {
            last = last.getPrevious().getPrevious();
        }
        if (last == null) {
            return Optional.empty();
        }
        searchPos = last.getRange().getStart();
        SchemaNode match = context.document.lexer().matchBackwards(searchPos, 1, false, Token.TokenType.IDENTIFIER, Token.TokenType.INHERITS);
        if (match != null && match.getParent() != null && match.getParent().getParent() != null && match.getParent().getParent().isASTInstance(identifierWithDashStr.class)) {
            match = match.getParent().getSchemaNode();
        }
        if (match != null && match.getRange().getStart().getLine() == context.position.getLine() && match.getParent().hasSymbol()) {
            return Optional.of(match);
        }
        return Optional.empty();
    }

    @Override
    public List<CompletionItem> getCompletionItems(EventCompletionContext context) {
        Optional<SchemaNode> matched = this.match(context);
        if (matched.isEmpty()) {
            return List.of();
        }
        Symbol identifierSymbol = matched.get().getParent().getSymbol();
        ArrayList<CompletionItem> ret = new ArrayList<CompletionItem>();
        boolean defaultSeen = false;
        Symbol scope = identifierSymbol.getType() == Symbol.SymbolType.DOCUMENT || identifierSymbol.getType() == Symbol.SymbolType.SCHEMA || identifierSymbol.getType() == Symbol.SymbolType.RANK_PROFILE ? null : identifierSymbol.getScope();
        for (Symbol symbol : context.schemaIndex.listSymbolsInScope(scope, identifierSymbol.getType())) {
            if (symbol.getShortIdentifier().equals(identifierSymbol.getShortIdentifier())) continue;
            ret.add(CompletionUtils.constructBasic(symbol.getShortIdentifier(), symbol.getLongIdentifier()));
            if (!symbol.getShortIdentifier().equals("default")) continue;
            defaultSeen = true;
        }
        if (identifierSymbol.getType() == Symbol.SymbolType.RANK_PROFILE && !defaultSeen) {
            ret.add(CompletionUtils.constructBasic("default"));
        }
        return ret;
    }
}

