/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.lsp.schema.semantictokens;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.context.EventDocumentContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.lsp.common.semantictokens.CommonSemanticTokens;
import ai.vespa.schemals.lsp.common.semantictokens.SemanticTokenMarker;
import ai.vespa.schemals.lsp.schema.semantictokens.SchemaSemanticTokenConfig;
import ai.vespa.schemals.parser.Token;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.parser.ast.FILTER;
import ai.vespa.schemals.parser.ast.RANK_TYPE;
import ai.vespa.schemals.parser.ast.bool;
import ai.vespa.schemals.parser.ast.dataType;
import ai.vespa.schemals.parser.ast.fieldRankType;
import ai.vespa.schemals.parser.ast.integerElm;
import ai.vespa.schemals.parser.ast.matchItem;
import ai.vespa.schemals.parser.ast.matchType;
import ai.vespa.schemals.parser.ast.quotedString;
import ai.vespa.schemals.parser.ast.rankSettingElm;
import ai.vespa.schemals.parser.ast.rankTypeElm;
import ai.vespa.schemals.parser.ast.summaryItem;
import ai.vespa.schemals.parser.ast.valueType;
import ai.vespa.schemals.parser.indexinglanguage.Token;
import ai.vespa.schemals.parser.rankingexpression.Token;
import ai.vespa.schemals.tree.CSTUtils;
import ai.vespa.schemals.tree.Node;
import ai.vespa.schemals.tree.SchemaNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SemanticTokens;

public class SchemaSemanticTokens {
    private static Map<Symbol.SymbolType, Integer> identifierTypeMap;
    private static Map<Token.TokenType, Integer> schemaTokenTypeMap;
    private static Map<Token.TokenType, Integer> rankExpressionTokenTypeMap;
    private static final Set<Class<?>> enumLikeItems;

    public static void init() {
        int index;
        CommonSemanticTokens.addTokenTypes(SchemaSemanticTokenConfig.manuallyRegisteredLSPNames);
        int keywordIndex = CommonSemanticTokens.addTokenType("keyword");
        identifierTypeMap = new HashMap<Symbol.SymbolType, Integer>();
        for (Map.Entry<Symbol.SymbolType, String> entry : SchemaSemanticTokenConfig.identifierTypeLSPNameMap.entrySet()) {
            index = CommonSemanticTokens.addTokenType(entry.getValue());
            identifierTypeMap.put(entry.getKey(), index);
        }
        schemaTokenTypeMap = new HashMap<Token.TokenType, Integer>();
        for (Map.Entry<Enum, String> entry : SchemaSemanticTokenConfig.schemaTokenTypeLSPNameMap.entrySet()) {
            index = CommonSemanticTokens.addTokenType(entry.getValue());
            schemaTokenTypeMap.put((Token.TokenType)entry.getKey(), index);
        }
        for (Token.TokenType tokenType : SchemaSemanticTokenConfig.keywordTokens) {
            schemaTokenTypeMap.put(tokenType, keywordIndex);
        }
        rankExpressionTokenTypeMap = new HashMap<Token.TokenType, Integer>();
        for (Map.Entry entry : SchemaSemanticTokenConfig.rankingExpressionTokenTypeLSPNameMap.entrySet()) {
            index = CommonSemanticTokens.addTokenType((String)entry.getValue());
            rankExpressionTokenTypeMap.put((Token.TokenType)entry.getKey(), index);
        }
        for (Token.TokenType tokenType : SchemaSemanticTokenConfig.rankingExpressionKeywordTokens) {
            rankExpressionTokenTypeMap.put(tokenType, keywordIndex);
        }
        int operationIndex = CommonSemanticTokens.addTokenType("operator");
        for (Token.TokenType type : SchemaSemanticTokenConfig.rankingExpressionOperationTokens) {
            rankExpressionTokenTypeMap.put(type, operationIndex);
        }
        int n = CommonSemanticTokens.addTokenType("function");
        for (Token.TokenType type : SchemaSemanticTokenConfig.rankingExpressioFunctionTokens) {
            rankExpressionTokenTypeMap.put(type, n);
        }
        CommonSemanticTokens.addTokenModifiers(SchemaSemanticTokenConfig.tokenModifiers);
    }

    private static ArrayList<SemanticTokenMarker> traverseCST(SchemaNode node, ClientLogger logger) {
        ArrayList<SemanticTokenMarker> ret;
        block7: {
            block12: {
                Token.TokenType indexinglanguageType;
                block15: {
                    block14: {
                        block13: {
                            block11: {
                                Token.TokenType rankExpressionType;
                                block10: {
                                    Token.TokenType schemaType;
                                    block9: {
                                        block8: {
                                            block6: {
                                                ret = new ArrayList<SemanticTokenMarker>();
                                                schemaType = node.getSchemaType();
                                                rankExpressionType = node.getRankExpressionType();
                                                indexinglanguageType = node.getIndexingLanguageType();
                                                if (!node.isASTInstance(dataType.class) || node.hasSymbol() && node.getSymbol().getType() != Symbol.SymbolType.MAP_KEY && node.getSymbol().getType() != Symbol.SymbolType.MAP_VALUE) break block6;
                                                Integer tokenType = CommonSemanticTokens.getType("type");
                                                if (tokenType != -1) {
                                                    Range markerRange = node.findFirstLeaf().getRange();
                                                    ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                                                }
                                                for (Node child : node) {
                                                    ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(child.getSchemaNode(), logger);
                                                    ret.addAll(markers);
                                                }
                                                break block7;
                                            }
                                            if (!node.isASTInstance(valueType.class)) break block8;
                                            Integer tokenType = CommonSemanticTokens.getType("type");
                                            if (tokenType == -1) break block7;
                                            ret.add(new SemanticTokenMarker((int)tokenType, node));
                                            break block7;
                                        }
                                        if (!node.hasSymbol()) break block9;
                                        ret.addAll(SchemaSemanticTokens.findSemanticMarkersForSymbol(node));
                                        break block7;
                                    }
                                    if (schemaType == null) break block10;
                                    Integer tokenType = null;
                                    String modifier = null;
                                    if (SchemaSemanticTokens.isEnumLike(node)) {
                                        tokenType = CommonSemanticTokens.getType("property");
                                        modifier = "readonly";
                                    }
                                    if (tokenType == null) {
                                        tokenType = schemaTokenTypeMap.get(schemaType);
                                    }
                                    if (tokenType == null) break block7;
                                    SemanticTokenMarker marker = new SemanticTokenMarker((int)tokenType, node);
                                    if (modifier != null) {
                                        marker.addModifier(modifier);
                                    }
                                    ret.add(marker);
                                    break block7;
                                }
                                if (rankExpressionType == null) break block11;
                                Integer tokenType = rankExpressionTokenTypeMap.get(rankExpressionType);
                                if (tokenType == null) break block7;
                                ret.add(new SemanticTokenMarker((int)tokenType, node));
                                break block7;
                            }
                            if (indexinglanguageType == null) break block12;
                            if (!SchemaSemanticTokenConfig.indexingLanguageOutputs.contains(indexinglanguageType)) break block13;
                            Integer tokenType = CommonSemanticTokens.getType("type");
                            Range markerRange = node.findFirstLeaf().getRange();
                            ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                            break block7;
                        }
                        if (!SchemaSemanticTokenConfig.indexingLanguageKeywords.contains(indexinglanguageType)) break block14;
                        Integer tokenType = CommonSemanticTokens.getType("keyword");
                        Range markerRange = node.findFirstLeaf().getRange();
                        ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                        break block7;
                    }
                    if (!SchemaSemanticTokenConfig.indexingLanguageOperators.contains(indexinglanguageType)) break block15;
                    Integer tokenType = CommonSemanticTokens.getType("function");
                    Range markerRange = node.findFirstLeaf().getRange();
                    ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                    break block7;
                }
                if (indexinglanguageType != Token.TokenType.STRING) break block7;
                Integer tokenType = CommonSemanticTokens.getType("string");
                Range markerRange = node.findFirstLeaf().getRange();
                ret.add(new SemanticTokenMarker((int)tokenType, markerRange));
                break block7;
            }
            for (Node child : node) {
                ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(child.getSchemaNode(), logger);
                ret.addAll(markers);
            }
        }
        return ret;
    }

    private static boolean isEnumLike(SchemaNode node) {
        Node it;
        if (node.getLanguageType() != Node.LanguageType.SCHEMA) {
            return false;
        }
        if (node.getParent() == null) {
            return false;
        }
        if (node.getParent().getASTClass() == integerElm.class || node.getParent().getASTClass() == quotedString.class || node.getParent().getASTClass() == bool.class) {
            return false;
        }
        if (!node.isLeaf()) {
            return false;
        }
        if (node.isASTInstance(FILTER.class)) {
            return true;
        }
        if (node.isASTInstance(RANK_TYPE.class)) {
            return false;
        }
        for (it = node.getParent(); it != null && !enumLikeItems.contains(it.getASTClass()); it = it.getParent()) {
        }
        if (it == null) {
            return false;
        }
        return node.getParent().indexOf(node) == 0;
    }

    private static List<SemanticTokenMarker> findSemanticMarkersForSymbol(SchemaNode node) {
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        if (!node.hasSymbol()) {
            return ret;
        }
        if (SchemaSemanticTokenConfig.userDefinedSymbolTypes.contains((Object)node.getSymbol().getType()) && (node.getSymbol().getStatus() == Symbol.SymbolStatus.REFERENCE || node.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION)) {
            Integer tokenType = identifierTypeMap.get((Object)node.getSymbol().getType());
            if (tokenType != null) {
                SemanticTokenMarker tokenMarker = new SemanticTokenMarker((int)tokenType, node);
                if (node.getSymbol().getStatus() == Symbol.SymbolStatus.DEFINITION) {
                    tokenMarker.addModifier("definition");
                }
                ret.add(tokenMarker);
            }
        } else if (node.hasSymbol() && node.getSymbol().getStatus() == Symbol.SymbolStatus.BUILTIN_REFERENCE) {
            Symbol.SymbolType type = node.getSymbol().getType();
            Integer tokenType = identifierTypeMap.get((Object)type);
            if (type == Symbol.SymbolType.FUNCTION && node.getLanguageType() == Node.LanguageType.RANK_EXPRESSION) {
                tokenType = CommonSemanticTokens.getType("macro");
            }
            if (tokenType != null && tokenType != -1) {
                SemanticTokenMarker tokenMarker = new SemanticTokenMarker((int)tokenType, node);
                tokenMarker.addModifier("defaultLibrary");
                ret.add(tokenMarker);
            }
        }
        return ret;
    }

    private static ArrayList<SemanticTokenMarker> convertCommentRanges(ArrayList<Range> comments) {
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>();
        int tokenType = CommonSemanticTokens.getType("comment");
        for (Range range : comments) {
            ret.add(new SemanticTokenMarker(tokenType, range));
        }
        return ret;
    }

    private static ArrayList<SemanticTokenMarker> findComments(SchemaNode rootNode) {
        TokenSource tokenSource = rootNode.getTokenSource();
        String source = tokenSource.toString();
        ArrayList<Range> ret = new ArrayList<Range>();
        int index = source.indexOf("#");
        while (index >= 0) {
            Position start = CSTUtils.getPositionFromOffset(tokenSource, index);
            if (CSTUtils.getLeafNodeAtPosition(rootNode, start) != null) {
                index = source.indexOf("#", index + 1);
                continue;
            }
            if ((index = source.indexOf("\n", index + 1)) < 0) {
                index = source.length() - 1;
            }
            Position end = CSTUtils.getPositionFromOffset(tokenSource, index);
            ret.add(new Range(start, end));
            index = source.indexOf("#", index + 1);
        }
        return SchemaSemanticTokens.convertCommentRanges(ret);
    }

    private static ArrayList<SemanticTokenMarker> mergeSemanticTokenMarkers(ArrayList<SemanticTokenMarker> lhs, ArrayList<SemanticTokenMarker> rhs) {
        int i;
        ArrayList<SemanticTokenMarker> ret = new ArrayList<SemanticTokenMarker>(lhs.size() + rhs.size());
        int lhsIndex = 0;
        int rhsIndex = 0;
        while (lhsIndex < lhs.size() && rhsIndex < rhs.size()) {
            Position rhsPos = rhs.get(rhsIndex).getRange().getStart();
            Position lhsPos = lhs.get(lhsIndex).getRange().getStart();
            if (CSTUtils.positionLT(lhsPos, rhsPos)) {
                ret.add(lhs.get(lhsIndex));
                ++lhsIndex;
                continue;
            }
            ret.add(rhs.get(rhsIndex));
            ++rhsIndex;
        }
        for (i = lhsIndex; i < lhs.size(); ++i) {
            ret.add(lhs.get(i));
        }
        for (i = rhsIndex; i < rhs.size(); ++i) {
            ret.add(rhs.get(i));
        }
        return ret;
    }

    public static SemanticTokens getSemanticTokens(EventDocumentContext context) {
        if (context.document == null) {
            return new SemanticTokens(new ArrayList());
        }
        SchemaNode node = context.document.getRootNode();
        if (node == null) {
            return new SemanticTokens(new ArrayList());
        }
        ArrayList<SemanticTokenMarker> comments = SchemaSemanticTokens.findComments(context.document.getRootNode());
        ArrayList<SemanticTokenMarker> markers = SchemaSemanticTokens.traverseCST(node, context.logger);
        List<Integer> compactMarkers = SemanticTokenMarker.concatCompactForm(SchemaSemanticTokens.mergeSemanticTokenMarkers(markers, comments));
        return new SemanticTokens(compactMarkers);
    }

    static {
        enumLikeItems = new HashSet<Class<?>>(){
            {
                this.add(matchType.class);
                this.add(matchItem.class);
                this.add(rankSettingElm.class);
                this.add(fieldRankType.class);
                this.add(rankTypeElm.class);
                this.add(summaryItem.class);
            }
        };
    }
}

