## group

Contained in [content](https://docs.vespa.ai/en/reference/services-content.html#content) or [group](https://docs.vespa.ai/en/reference/services-content.html#group) - groups can be nested. Defines the [hierarchical structure](https://docs.vespa.ai/en/elasticity.html#grouped-distribution) of the cluster. Can not be used in conjunction with the [nodes](https://docs.vespa.ai/en/reference/services-content.html#nodes) element. Groups can contain other groups or nodes, but not both.

When using groups in [Open Source Vespa](https://vespa.ai/), [searchable-copies](https://docs.vespa.ai/en/reference/services-content.html#searchable-copies) and [redundancy](https://docs.vespa.ai/en/reference/services-content.html#redundancy) is the *total* replica number, across all leaf groups in the cluster. For groups in Vespa Cloud, see [services in Vespa Cloud](https://cloud.vespa.ai/en/reference/services.html#nodes).

|    Attribute     | Required |  Value  | Default |                                                                                       Description                                                                                       |
|------------------|----------|---------|---------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| distribution-key | required | integer |         | Sets the distribution key of a group. It is not allowed to change this for a given group. Group distribution keys only need to be unique among groups that share the same parent group. |
| name             | required | string  |         | The name of the group, used for access from status pages and the like.                                                                                                                  |

**Important:** There is no deployment-time verification that the distribution key remains unchanged for any given node or group. Consequently, take great care when modifying the set of nodes in a content cluster. Assigning a new distribution key to an existing node is undefined behavior; Best case, the existing data will be temporarily unavailable until the error has been corrected. Worst case, risk crashes or data loss.

See [Vespa Serving Scaling Guide](https://docs.vespa.ai/en/performance/sizing-search.html) for when to consider using grouped distribution and [Examples](https://docs.vespa.ai/en/performance/sizing-examples.html) for example deployments using flat and grouped distribution.
[Read more](https://docs.vespa.ai/en/reference/services-content.html#group)
