## resource-limits

Contained in [tuning](https://docs.vespa.ai/en/reference/services-content.html#tuning). Specifies resource limits used to decide whether external write operations should be blocked in the entire content cluster, based on the reported resource usage by content nodes. See [feed block](https://docs.vespa.ai/en/operations/feed-block.html) for more details.

**Warning:** The content nodes require resource headroom to handle extra documents as part of re-distribution during node failure, and spikes when running [maintenance jobs](https://docs.vespa.ai/en/proton.html#proton-maintenance-jobs). Tuning these limits should be done with extreme care, and setting them too high might lead to permanent data loss. They are best left untouched, using the defaults, and cannot be set in [Vespa Cloud](https://cloud.vespa.ai/).

| Element | Required |     Value      | Default |                                                                                                                             Description                                                                                                                             |
|---------|----------|----------------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| disk    | optional | float \[0, 1\] | 0.75    | Fraction of total space on the disk partition used on a content node before feed is blocked                                                                                                                                                                         |
| memory  | optional | float \[0, 1\] | 0.8     | Fraction of physical memory that can be resident memory in anonymous mapping on a content node before feed is blocked. Total physical memory is sampled as the minimum of `sysconf(_SC_PHYS_PAGES) * sysconf(_SC_PAGESIZE)` and the cgroup (v1 or v2) memory limit. |

Example - in the content tag:


```xml
<tuning>
    <resource-limits>
        <disk>0.78</disk>
        <memory>0.77</memory>
    </resource-limits>
</tuning>

```


[Read more](https://docs.vespa.ai/en/reference/services-content.html#resource-limits)
