## chain

An element for defining a chain of [processors](https://docs.vespa.ai/en/reference/services-processing.html) / [searchers](https://docs.vespa.ai/en/reference/services-search.html) / [document processors](https://docs.vespa.ai/en/reference/services-docproc.html) (i.e. components). A chain is a set ordered by dependencies. Dependencies are expressed through phases, which may depend upon other phases, or components. For an incoming request from the network, the chain named *default* will be invoked. Refer to [Chained components](https://docs.vespa.ai/en/components/chained-components.html) for a guide. Requires one of *id* or *idref*.

Searcher, Document processing and Processing chains can be modified at runtime without restarts. Modification includes adding/removing processors in chains and changing names of chains and processors. Make the change and [deploy](https://docs.vespa.ai/en/application-packages.html#deploy). Some changes require a container restart, refer to [reconfiguring document processing](https://docs.vespa.ai/en/document-processing.html#reconfiguring-document-processing).

|     Attribute      | Required | Value  | Default |                                                                                                                                                                                Description                                                                                                                                                                                |
|--------------------|----------|--------|---------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| idref              |          | string |         | A reference to a defined chain. Mutually exclusive with *id* . If *idref* is used, no other attributes apply.                                                                                                                                                                                                                                                             |
| id                 | required | string |         | The chain ID. Required unless *idref* is used                                                                                                                                                                                                                                                                                                                             |
| inherits           | optional | string |         | A space-separated list of chains this chain should include the contents of - see example below.                                                                                                                                                                                                                                                                           |
| excludes           | optional | string |         | A space-separated list of processors (contained in an inherited chain) this chain should not include. The exclusion is done before any consolidation of component references when inheriting chains. Example: ``` <chain id="demo" inherits="idOfInheritedChain" excludes="idOfProc1 idOfProc2"> <processor id="proc2" class="com.yahoo.test.Proc2"/> </chain> ``` <br /> |
| class              | optional | string |         | <br />                                                                                                                                                                                                                                                                                                                                                                    |
| name               |          |        |         | <br />                                                                                                                                                                                                                                                                                                                                                                    |
| documentprocessors |          |        |         | <br />                                                                                                                                                                                                                                                                                                                                                                    |

[Read more](https://docs.vespa.ai/en/reference/services-processing.html#chain)
