## accesslog

Configures properties of the accesslog. The default type is `json` that will give output in (line-based) [JSON format](https://docs.vespa.ai/en/access-logging.html). See [Access logging](https://docs.vespa.ai/en/access-logging.html) for configuration details. Setting the type to `vespa` gives a classic Apache CLF-like format.

Access logging can be disabled by setting the type to `disabled`.

|    Attribute     |  Required  | Value  |                   Default                   |                          Description                           |
|------------------|------------|--------|---------------------------------------------|----------------------------------------------------------------|
| type             | optional   | string | json                                        | The accesslog type: *json* , *vespa* or *disabled*             |
| fileNamePattern  | required\* | string | JsonAccessLog.\<container id\>.%Y%m%d%H%M%S | File name pattern. \* Note: Optional when *type* is *disabled* |
| symlinkName      | optional   | string | JsonAccessLog.\<container id\>              | Symlink name                                                   |
| rotationInterval | optional   | string | 0 60 ...                                    | Rotation interval                                              |
| rotationScheme   | optional   | string | date                                        | Valid values are *date* or *sequence*                          |

Example:

```
<accesslog fileNamePattern="$VESPA_HOME/logs/vespa/access/JsonAccessLog.<container id>.%Y%m%d%H%M%S"
           symlinkName="JsonAccessLog.<container id>"
           rotationInterval="0 1 ..."
           type="vespa" />
```

[Read more](https://docs.vespa.ai/en/reference/services-container.html#accesslog)
