## node

Contained in [nodes](https://docs.vespa.ai/en/reference/services-content.html#nodes) or [group](https://docs.vespa.ai/en/reference/services-content.html#group). Configures a content node to the cluster.

|    Attribute     | Required |  Value  | Default |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
|------------------|----------|---------|---------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| distribution-key | required | integer |         | Sets the distribution key of a node. It is not recommended changing this for a given node. It is recommended (but not required) that the set of distribution keys in the cluster are contiguous and starting at 0. Example: If the biggest distribution key is 499, then the distribution algorithm needs to calculate 500 random numbers to calculate the correct target. It is hence recommended to not leave too many gaps in the distribution key range. Distribution keys are used to identify nodes and groups for the [distribution algorithm](https://docs.vespa.ai/en/content/idealstate.html). If a node changes distribution key, the distribution algorithm regards it as a new node, so buckets are redistributed. When merging clusters, one might need to change distribution keys - [details](https://docs.vespa.ai/en/operations-selfhosted/admin-procedures.html#add-or-remove-a-content-node). Content nodes need unique node distribution keys across the whole cluster, as the key is also used as a node identifier where group information is not specified. |
| capacity         | optional | double  | 1       | Capacity of this node, relative to other nodes. A node with capacity 2 will get double the data and feed requests of a node with capacity 1. This feature is expert mode only. Don't use if you don't know what you are doing.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      |
| baseport         | optional | integer |         | baseport                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
| hostalias        | optional | string  |         | hostalias                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           |
| preload          | optional | string  |         | preload                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |

[Read more](https://docs.vespa.ai/en/reference/services-content.html#node)
