/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument;

import ai.vespa.schemals.common.SchemaDiagnostic;
import ai.vespa.schemals.context.ParseContext;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.schemadocument.resolvers.RankExpression.argument.Argument;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.rankingexpression.RankNode;
import java.util.Optional;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;

public class SymbolArgument
implements Argument {
    private Symbol.SymbolType symbolType;
    private String displayStr;

    public SymbolArgument(Symbol.SymbolType symbolType, String displayStr) {
        this.symbolType = symbolType;
        this.displayStr = displayStr;
    }

    @Override
    public int getStrictness() {
        return 3;
    }

    protected SchemaNode findSymbolNode(RankNode node) {
        SchemaNode symbolNode = node.getSchemaNode();
        while (!symbolNode.hasSymbol() && symbolNode.size() > 0) {
            symbolNode = symbolNode.get(0);
        }
        return symbolNode;
    }

    @Override
    public boolean validateArgument(RankNode node) {
        SchemaNode symbolNode = this.findSymbolNode(node);
        return symbolNode.hasSymbol();
    }

    @Override
    public Optional<Diagnostic> parseArgument(ParseContext context, RankNode node) {
        SchemaNode symbolNode = this.findSymbolNode(node);
        if (symbolNode.hasSymbol()) {
            Symbol symbol = symbolNode.getSymbol();
            if (symbol.getStatus() == Symbol.SymbolStatus.REFERENCE) {
                symbol.setStatus(Symbol.SymbolStatus.UNRESOLVED);
                context.schemaIndex().deleteSymbolReference(symbol);
            }
            if (symbol.getStatus() == Symbol.SymbolStatus.UNRESOLVED) {
                symbol.setType(this.symbolType);
            }
        } else {
            return Optional.of(new SchemaDiagnostic.Builder().setRange(node.getRange()).setMessage("The argument must be to a symbol of type: " + this.symbolType).setSeverity(DiagnosticSeverity.Error).build());
        }
        return Optional.empty();
    }

    @Override
    public String displayString() {
        return this.displayStr;
    }
}

