/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.schemals.tree;

import ai.vespa.schemals.common.ClientLogger;
import ai.vespa.schemals.index.SchemaIndex;
import ai.vespa.schemals.index.Symbol;
import ai.vespa.schemals.parser.Node;
import ai.vespa.schemals.parser.TokenSource;
import ai.vespa.schemals.parser.ast.documentElm;
import ai.vespa.schemals.parser.ast.functionElm;
import ai.vespa.schemals.parser.rankingexpression.ast.BaseNode;
import ai.vespa.schemals.parser.rankingexpression.ast.lambdaFunction;
import ai.vespa.schemals.parser.rankingexpression.ast.tensorGenerateBody;
import ai.vespa.schemals.tree.SchemaNode;
import ai.vespa.schemals.tree.indexinglanguage.ILUtils;
import ai.vespa.schemals.tree.rankingexpression.RankingExpressionUtils;
import com.yahoo.searchlib.rankingexpression.Reference;
import com.yahoo.searchlib.rankingexpression.rule.ExpressionNode;
import com.yahoo.searchlib.rankingexpression.rule.ReferenceNode;
import java.util.Optional;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class CSTUtils {
    private static final String SPACER = " ";

    public static Position getPositionFromOffset(TokenSource tokenSource, int offset) {
        int line = tokenSource.getLineFromOffset(offset) - 1;
        int startOfLineOffset = tokenSource.getLineStartOffset(line + 1);
        int column = offset - startOfLineOffset;
        return new Position(line, column);
    }

    public static Range getRangeFromOffsets(TokenSource tokenSource, int beginOffset, int endOffset) {
        Position begin = CSTUtils.getPositionFromOffset(tokenSource, beginOffset);
        Position end = CSTUtils.getPositionFromOffset(tokenSource, endOffset);
        return new Range(begin, end);
    }

    public static Range getNodeRange(Node node) {
        TokenSource tokenSource = node.getTokenSource();
        try {
            return CSTUtils.getRangeFromOffsets(tokenSource, node.getBeginOffset(), node.getEndOffset());
        }
        catch (Exception exception) {
            return new Range(new Position(0, 0), new Position(0, 0));
        }
    }

    public static boolean positionLT(Position lhs, Position rhs) {
        return lhs.getLine() < rhs.getLine() || lhs.getLine() == rhs.getLine() && lhs.getCharacter() < rhs.getCharacter();
    }

    public static boolean positionInRange(Range range, Position pos) {
        return CSTUtils.positionLT(pos, range.getEnd()) && (CSTUtils.positionLT(range.getStart(), pos) || range.getStart().equals((Object)pos));
    }

    public static Position addPositions(Position lhs, Position rhs) {
        int line = lhs.getLine() + rhs.getLine();
        int column = rhs.getCharacter();
        if (rhs.getLine() == 0) {
            column += lhs.getCharacter();
        }
        return new Position(line, column);
    }

    public static Range unionRanges(Range a, Range b) {
        Position newStart = CSTUtils.positionLT(a.getStart(), b.getStart()) ? a.getStart() : b.getStart();
        Position newEnd = CSTUtils.positionLT(a.getEnd(), b.getEnd()) ? b.getEnd() : a.getEnd();
        return new Range(newStart, newEnd);
    }

    public static Range addPositionToRange(Position lhs, Range rhs) {
        return new Range(CSTUtils.addPositions(lhs, rhs.getStart()), CSTUtils.addPositions(lhs, rhs.getEnd()));
    }

    public static SchemaNode findFirstLeafChild(SchemaNode node) {
        while (!node.isLeaf()) {
            node = node.get(0);
        }
        return node;
    }

    public static SchemaNode getLastCleanNode(SchemaNode node, Position pos) {
        if (node == null) {
            return null;
        }
        for (int i = node.size() - 1; i >= 0; --i) {
            SchemaNode result = CSTUtils.getLastCleanNode(node.get(i), pos);
            if (result == null) continue;
            return result;
        }
        Range range = node.getRange();
        if (!CSTUtils.positionLT(pos, range.getStart()) && !node.getIsDirty()) {
            return node;
        }
        return null;
    }

    public static SchemaNode getNodeAtOrBeforePosition(SchemaNode CST, Position pos) {
        return CSTUtils.getNodeAtPosition(CST, pos, false, true);
    }

    public static SchemaNode getLeafNodeAtPosition(SchemaNode CST, Position pos) {
        return CSTUtils.getNodeAtPosition(CST, pos, true, false);
    }

    public static SchemaNode getNodeAtPosition(SchemaNode CST, Position pos) {
        return CSTUtils.getNodeAtPosition(CST, pos, false, false);
    }

    public static SchemaNode getSymbolAtPosition(SchemaNode CST, Position pos) {
        SchemaNode node;
        for (node = CSTUtils.getNodeAtPosition(CST, pos); node != null && !node.hasSymbol(); node = node.getParent()) {
        }
        return node;
    }

    public static SchemaNode findASTClassAncestor(SchemaNode node, Class<?> astClass) {
        while (node != null) {
            if (node.isASTInstance(astClass)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    private static SchemaNode getNodeAtPosition(SchemaNode node, Position pos, boolean onlyLeaf, boolean findNearest) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf() && CSTUtils.positionInRange(node.getRange(), pos)) {
            return node;
        }
        if (!CSTUtils.positionInRange(node.getRange(), pos)) {
            if (findNearest && !onlyLeaf) {
                return node;
            }
            return null;
        }
        for (SchemaNode child : node) {
            if (!CSTUtils.positionInRange(child.getRange(), pos)) continue;
            return CSTUtils.getNodeAtPosition(child, pos, onlyLeaf, findNearest);
        }
        if (onlyLeaf) {
            return null;
        }
        return node;
    }

    public static Optional<Symbol> findScope(SchemaNode node) {
        for (SchemaNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            Class<?> astClass = currentNode.getASTClass();
            if (astClass != null && (SchemaIndex.IDENTIFIER_TYPE_MAP.containsKey(astClass) || SchemaIndex.IDENTIFIER_WITH_DASH_TYPE_MAP.containsKey(astClass) || astClass.equals(lambdaFunction.class)) && !astClass.equals(documentElm.class)) {
                SchemaNode potentialDefinition;
                int indexGuess = 1;
                if (currentNode.isASTInstance(functionElm.class)) {
                    indexGuess = 2;
                }
                if (currentNode.isASTInstance(lambdaFunction.class)) {
                    indexGuess = 0;
                }
                if (indexGuess >= currentNode.size() || !(potentialDefinition = currentNode.get(indexGuess)).hasSymbol() || potentialDefinition.getSymbol().getStatus() != Symbol.SymbolStatus.DEFINITION) continue;
                return Optional.of(potentialDefinition.getSymbol());
            }
            if (!currentNode.isASTInstance(tensorGenerateBody.class) || currentNode.getPreviousSibling() == null || !currentNode.getPreviousSibling().hasSymbol() || currentNode.getPreviousSibling().getSymbol().getType() != Symbol.SymbolType.TENSOR) continue;
            return Optional.of(currentNode.getPreviousSibling().getSymbol());
        }
        return Optional.empty();
    }

    public static void printTree(ClientLogger logger, Node node) {
        CSTUtils.printTree(logger, node, (Integer)0);
    }

    public static void printTree(ClientLogger logger, Node node, Integer indent) {
        if (node == null) {
            return;
        }
        Range range = CSTUtils.getNodeRange(node);
        logger.info(new String(new char[indent.intValue()]).replace("\u0000", SPACER) + node.getClass().getName() + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ") - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")");
        for (Node child : node) {
            CSTUtils.printTree(logger, child, (Integer)(indent + 1));
        }
    }

    public static void printTree(ClientLogger logger, SchemaNode node) {
        CSTUtils.printTree(logger, node, (Integer)0);
    }

    public static void printTree(ClientLogger logger, SchemaNode node, Integer indent) {
        if (node == null) {
            return;
        }
        logger.info(new String(new char[indent.intValue()]).replace("\u0000", SPACER) + CSTUtils.schemaNodeString(node));
        for (SchemaNode child : node) {
            CSTUtils.printTree(logger, child, (Integer)(indent + 1));
        }
        if (node.hasIndexingNode()) {
            ILUtils.printTree(logger, node.getOriginalIndexingNode(), indent + 1);
        }
        if (node.hasRankExpressionNode()) {
            RankingExpressionUtils.printTree(logger, node.getOriginalRankExpressionNode(), (Integer)(indent + 1));
        }
    }

    public static void printTreeUpToPosition(ClientLogger logger, Node node, Position pos) {
        CSTUtils.printTreeUpToPosition(logger, node, pos, (Integer)0);
    }

    public static void printTreeUpToPosition(ClientLogger logger, SchemaNode node, Position pos) {
        CSTUtils.printTreeUpToPosition(logger, node, pos, (Integer)0);
    }

    public static void printTreeUpToPosition(ClientLogger logger, Node node, Position pos, Integer indent) {
        Range range = CSTUtils.getNodeRange(node);
        if (!CSTUtils.positionLT(pos, range.getStart())) {
            boolean dirty = node.isDirty();
            logger.info(new String(new char[indent.intValue()]).replace("\u0000", SPACER) + node.getClass().getName() + (dirty ? " [DIRTY]" : "") + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ") - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")");
        }
        for (Node child : node) {
            CSTUtils.printTreeUpToPosition(logger, child, pos, (Integer)(indent + 1));
        }
    }

    public static void printTreeUpToPosition(ClientLogger logger, SchemaNode node, Position pos, Integer indent) {
        Range range = node.getRange();
        if (!CSTUtils.positionLT(pos, range.getStart())) {
            node.getIsDirty();
            logger.info(new String(new char[indent.intValue()]).replace("\u0000", SPACER) + CSTUtils.schemaNodeString(node));
        }
        for (SchemaNode child : node) {
            CSTUtils.printTreeUpToPosition(logger, child, pos, (Integer)(indent + 1));
        }
    }

    private static String schemaNodeString(SchemaNode node) {
        BaseNode originalNode;
        Object ret = node.getClassLeafIdentifierString();
        if (node.getIsDirty()) {
            ret = (String)ret + " [DIRTY]";
        }
        if (node.containsOtherLanguageData(SchemaNode.LanguageType.INDEXING)) {
            ret = (String)ret + " [ILSCRIPT]";
        }
        if (node.containsOtherLanguageData(SchemaNode.LanguageType.RANK_EXPRESSION)) {
            ret = (String)ret + " [RANK_EXPRESSION";
            ret = node.containsExpressionData() ? (String)ret + " (EXPRESSSION)" : (String)ret + " (FEATURE LIST)";
            ret = (String)ret + "]";
        }
        if (node.getLanguageType() == SchemaNode.LanguageType.RANK_EXPRESSION && node.getOriginalRankExpressionNode() instanceof BaseNode && (originalNode = (BaseNode)node.getOriginalRankExpressionNode()) != null && originalNode.expressionNode != null) {
            ExpressionNode expressionNode = originalNode.expressionNode;
            String[] classList = expressionNode.getClass().toString().split("[.]");
            String className = classList[classList.length - 1];
            ret = (String)ret + " (" + className + ")";
            if (expressionNode instanceof ReferenceNode) {
                Reference ref = ((ReferenceNode)expressionNode).reference();
                ret = (String)ret + " [REF: " + ref.name() + "]";
                if (ref.isIdentifier()) {
                    ret = (String)ret + " [IDENTIFIER]";
                }
            }
        }
        if (node.hasSymbol()) {
            ret = (String)ret + " [SYMBOL " + node.getSymbol().getType().toString() + SPACER + node.getSymbol().getStatus().toString() + ": " + node.getSymbol().getLongIdentifier() + "]";
        }
        Range range = node.getRange();
        ret = (String)ret + ": (" + range.getStart().getLine() + ", " + range.getStart().getCharacter() + ")";
        ret = (String)ret + " - (" + range.getEnd().getLine() + ", " + range.getEnd().getCharacter() + ")";
        return ret;
    }
}

