## documents

Contained in [content](https://docs.vespa.ai/en/reference/services-content.html#content). Defines which document types should be routed to this content cluster using the default route, and what documents should be kept in the cluster if the garbage collector runs. Read more on [expiring documents](https://docs.vespa.ai/en/documents.html#document-expiry). Also have some backend specific configuration for whether documents should be searchable or not.

|          Attribute          | Required |    Value     | Default |                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Description                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
|-----------------------------|----------|--------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| selection                   | optional | string       |         | A [document selection](https://docs.vespa.ai/en/reference/document-select-language.html), restricting documents that are routed to this cluster. Defaults to a selection expression matching everything. This selection can be specified to match document identifier specifics that are *independent* of document types. For restrictions that apply only to a *specific* document type, this must be done within that particular document type's [document](https://docs.vespa.ai/en/reference/services-content.html#document) element. Trying to use document type references in this selection makes an error during deployment. The selection given here will be merged with per-document type selections specified within document tags, if any, meaning that any document in the cluster must match *both* selections to be accepted and kept. This feature is primarily used to [expire documents](https://docs.vespa.ai/en/documents.html#document-expiry). |
| garbage-collection          | optional | true / false | false   | If true, regularly verify the documents stored in the cluster to see if they belong in the cluster, and delete them if not. If false, garbage collection is not run.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |
| garbage-collection-interval | optional | integer      | 3600    | Time (in seconds) between garbage collection cycles.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |

Subelements:

* [document](https://docs.vespa.ai/en/reference/services-content.html#document) (required)
* [document-processing](https://docs.vespa.ai/en/reference/services-content.html#document-processing) (optional)

[Read more](https://docs.vespa.ai/en/reference/services-content.html#documents)
